/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.utilities;

import com.ibm.adapter.emd.extension.description.DataDescription;
import com.ibm.adapter.emd.extension.description.J2CParameterDescription;
import com.ibm.adapter.emd.extension.description.ParameterDescription;
import com.ibm.adapter.emd.extension.description.spi.OutboundFunctionDescription;
import com.ibm.adapter.framework.BaseException;
import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.model.IDynamicDeploymentExtension;
import com.ibm.j2c.ui.internal.utilities.J2CCodeParsingUtil;
import com.ibm.j2c.ui.internal.utilities.J2CDeltaUtil;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import commonj.connector.metadata.description.DataFile;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsOp;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class RADUIUtils {
    private static String projectType = "";
    protected static IDynamicDeploymentExtension deployClass;
    protected static IExtensionPoint deployextensionPoint;
    protected static IExtension[] deployextensions;
    public static RADUIUtils instance;

    public static RADUIUtils getInstance() {
        if (instance == null) {
            instance = new RADUIUtils();
        }
        return instance;
    }

    public IDynamicDeploymentExtension getDeployClass() {
        deployClass = RADUIUtils.checkDeploymentExtension();
        return deployClass;
    }

    public static IDynamicDeploymentExtension checkDeploymentExtension() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        deployextensionPoint = pluginRegistry.getExtensionPoint("com.ibm.j2c.ui.DeploymentExtensions");
        deployextensions = deployextensionPoint.getExtensions();
        int r = 0;
        while (r < deployextensions.length) {
            IExtension currentEx = deployextensions[r];
            IConfigurationElement[] configEls = currentEx.getConfigurationElements();
            int y = 0;
            while (y < configEls.length) {
                IConfigurationElement currentConEl = configEls[y];
                try {
                    deployClass = (IDynamicDeploymentExtension)((Object)currentConEl.createExecutableExtension("deployclass"));
                    if (deployClass != null) {
                        return deployClass;
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                ++y;
            }
            ++r;
        }
        return null;
    }

    public static void addUtilityProjectToModule(String utilityProjectName, String moduleName, IVirtualComponent componentParent) {
        if (componentParent == null) {
            return;
        }
        IProject dataProj = ResourceUtils.getWorkspaceRoot().getProject(utilityProjectName);
        IVirtualComponent component1 = ComponentCore.createComponent((IProject)dataProj);
        IVirtualComponent childComponent = ComponentCore.createComponent((IProject)dataProj);
        ArrayList<IVirtualComponent> vList = new ArrayList<IVirtualComponent>();
        vList.add(childComponent);
        if (ResourceUtils.isTrueJavaProject((IProject)dataProj)) {
            IVirtualReference ref;
            JavaProjectMigrationOperation op = J2EEProjectUtilities.createFlexJavaProjectForProjectOperation((IProject)dataProj);
            if (op != null && op.canExecute()) {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            if (ResourceUtils.isDynamicWebProject((IProject)componentParent.getProject())) {
                try {
                    CreateReferenceComponentsOp opp = ComponentUtilities.createWLPReferenceComponentOperation((IVirtualComponent)componentParent, vList);
                    if (opp != null && opp.canExecute()) {
                        opp.execute((IProgressMonitor)new NullProgressMonitor(), null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (J2EEProjectUtilities.isEARProject((IProject)componentParent.getProject()) && !(ref = ComponentCore.createReference((IVirtualComponent)componentParent, (IVirtualComponent)component1)).exists()) {
                RADUIUtils.waitForBuildJobs(3);
                ref.create(0, null);
            }
        } else {
            AddComponentToEnterpriseApplicationDataModelProvider addProv = new AddComponentToEnterpriseApplicationDataModelProvider();
            IDataModel addModel = DataModelFactory.createDataModel((IDataModelProvider)addProv);
            addModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)componentParent);
            addModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", vList);
            try {
                addModel.getDefaultOperation().execute(null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void waitForBuildJobs(int periods) {
        RADUIUtils.waitForBuildJobs(periods, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void waitForBuildJobs(int periods, IProgressMonitor monitor) {
        int j = 0;
        while (j < periods) {
            IJobManager jobManager = Job.getJobManager();
            try {
                jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
            }
            catch (Exception exception) {}
            try {
                jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                jobManager.join(ResourcesPlugin.FAMILY_AUTO_REFRESH, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++j;
        }
    }

    private static IType getDataType(DataDescription dataDefinition) {
        IFile javaFile;
        DataFile[] dataFiles = dataDefinition.getDataFiles();
        URI dataURI = dataFiles[0].getLocation();
        if (dataURI != null && (javaFile = RADUIUtils.resolve(dataURI)) != null && javaFile.exists()) {
            IJavaElement javaElement = JavaCore.create((IFile)javaFile);
            switch (javaElement.getElementType()) {
                case 5: {
                    return ((ICompilationUnit)javaElement).findPrimaryType();
                }
                case 6: {
                    try {
                        return ((IClassFile)javaElement).getType();
                    }
                    catch (Exception exception) {}
                }
            }
            return null;
        }
        return null;
    }

    private static IFile resolve(URI uri) {
        try {
            IFile ifile;
            IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
            String path = URLDecoder.decode(uri.toString(), "UTF-8");
            if (path.startsWith("platform:/resource/")) {
                if ((path = path.substring("platform:/resource/".length())).startsWith("platform:/resource/")) {
                    path = path.substring("platform:/resource/".length());
                }
            } else if (path.startsWith("file:/")) {
                path = path.substring("file:/".length());
            }
            if ((ifile = workspace.getFile((IPath)new Path(path))) != null && ifile.exists()) {
                return ifile;
            }
            File file = new File(path);
            if (file != null && file.exists()) {
                return workspace.getFileForLocation((IPath)new Path(path));
            }
        }
        catch (Exception e) {
            BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public static List modifyMethod(ICompilationUnit cu, OutboundFunctionDescription oldOfd, OutboundFunctionDescription newOfd, boolean isInterface) {
        return RADUIUtils.modifyMethod(cu, oldOfd.getName(), oldOfd.getParameterDescriptions(), newOfd.getName(), newOfd.getParameterDescriptions(), isInterface);
    }

    public static ArrayList getNewMethodSignature(MethodDeclaration foundMethod, Object[] inputPars) {
        ArrayList<String> signatureList = new ArrayList<String>();
        int z = 0;
        while (z < inputPars.length) {
            DataDescription dD;
            foundMethod.getAST().newSingleVariableDeclaration();
            if (inputPars[z] instanceof J2CParameterDescription) {
                J2CParameterDescription j2cp = (J2CParameterDescription)inputPars[z];
                if (j2cp.getStyle() != 2) {
                    signatureList.add(j2cp.getPropertyType().getName());
                }
            } else if (inputPars[z] instanceof DataDescription && (dD = (DataDescription)inputPars[z]).getStyle() != 2) {
                String sN = RADUIUtils.getDataType(dD).getFullyQualifiedName();
                signatureList.add(sN);
            }
            ++z;
        }
        int q = signatureList.size() - 1;
        while (q > -1) {
            --q;
        }
        return signatureList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List modifyMethod(ICompilationUnit cu, String oldName, ParameterDescription[] oldPds, String newName, ParameterDescription[] newPds, boolean isInterface) {
        List<ArrayList> transferList = new ArrayList();
        try {
            if (cu == null) {
                return null;
            }
            if (!cu.isWorkingCopy()) {
                cu = cu.getWorkingCopy(null);
            }
            String source = cu.getSource();
            Document doc = new Document(source);
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(cu);
            AnnotatedClassInfo info = AnnotationUtils.getAnnotatedClassInfo((IJavaElement)cu);
            List alist = AnnotationUtils.getAllAnnotationInfosUtilMethod((AnnotatedClassInfo)info);
            CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
            List l = astCU.types();
            TypeDeclaration td = (TypeDeclaration)l.get(0);
            MethodDeclaration[] msA = td.getMethods();
            List interFaces = td.superInterfaceTypes();
            if (interFaces.size() > 0) {
                Type interType = (Type)interFaces.get(0);
                String typeName = null;
                if (interType.isSimpleType()) {
                    typeName = ((SimpleType)interType).getName().getFullyQualifiedName();
                } else if (interType.isQualifiedType()) {
                    typeName = ((QualifiedType)interType).getName().getFullyQualifiedName();
                }
                if (typeName != null) {
                    IType interIType = J2CCodeParsingUtil.getType(typeName, cu.getJavaProject());
                    RADUIUtils.modifyMethod(interIType.getCompilationUnit(), oldName, oldPds, newName, newPds, true);
                }
            }
            boolean methodFound = false;
            MethodDeclaration foundMethod = null;
            String methodName = oldName;
            int i = 0;
            while (i < msA.length) {
                Object[] pds;
                String tempsS = msA[i].getName().getIdentifier();
                if (tempsS.equals(methodName)) {
                    boolean argumentsAreMatching = true;
                    List params = msA[i].parameters();
                    pds = oldPds;
                    ArrayList<Object> arL = new ArrayList<Object>(5);
                    int y = 0;
                    while (y < pds.length) {
                        if (pds[y].getStyle() != 2) {
                            arL.add(pds[y]);
                        }
                        ++y;
                    }
                    Object[] inputPars = arL.toArray();
                    if (params.size() == inputPars.length) {
                        int y2 = 0;
                        while (y2 < params.size()) {
                            block27: {
                                Class propType;
                                J2CParameterDescription j2cP1;
                                SingleVariableDeclaration svd = (SingleVariableDeclaration)params.get(y2);
                                Type tDec = svd.getType();
                                if (tDec.isPrimitiveType()) {
                                    if (inputPars[y2] instanceof J2CParameterDescription) {
                                        j2cP1 = (J2CParameterDescription)inputPars[y2];
                                        propType = j2cP1.getPropertyType();
                                        if (propType.isPrimitive()) {
                                            PrimitiveType pt1 = (PrimitiveType)tDec;
                                            String sPrimName = propType.getName();
                                            if (sPrimName == null || !sPrimName.equals(pt1.getPrimitiveTypeCode().toString())) {
                                                argumentsAreMatching = false;
                                                break;
                                            }
                                            break block27;
                                        } else {
                                            argumentsAreMatching = false;
                                            break;
                                        }
                                    }
                                    argumentsAreMatching = false;
                                    break;
                                }
                                if (inputPars[y2] instanceof J2CParameterDescription) {
                                    j2cP1 = (J2CParameterDescription)inputPars[y2];
                                    propType = j2cP1.getPropertyType();
                                    String name = null;
                                    if (tDec instanceof SimpleType) {
                                        name = ((SimpleType)tDec).getName().getFullyQualifiedName();
                                    }
                                    if (name == null || name != null && !propType.getName().equals(name)) {
                                        argumentsAreMatching = false;
                                        break;
                                    }
                                }
                            }
                            ++y2;
                        }
                        if (argumentsAreMatching) {
                            foundMethod = msA[i];
                        }
                    }
                }
                if (foundMethod != null) {
                    astCU.recordModifications();
                    methodFound = true;
                    SimpleName sNa = foundMethod.getAST().newSimpleName(newName);
                    foundMethod.setName(sNa);
                    foundMethod.parameters().size();
                    Javadoc jd = foundMethod.getJavadoc();
                    pds = newPds;
                    ArrayList signatureList = null;
                    if (!isInterface) {
                        signatureList = RADUIUtils.getNewMethodSignature(foundMethod, pds);
                        transferList = J2CDeltaUtil.findAnnotations4Method(alist, methodName);
                        List tempList = J2CDeltaUtil.deltaTransferProcess(sNa, jd);
                        if (tempList != null) {
                            transferList.addAll(tempList);
                        }
                        transferList.add(signatureList);
                    }
                    foundMethod.delete();
                    astCU.rewrite((IDocument)doc, null).apply((IDocument)doc);
                    break;
                }
                ++i;
            }
            if (!methodFound) return null;
            cu.getBuffer().setContents(doc.get());
            cu.commitWorkingCopy(true, null);
            return transferList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Vector getConnectorProjectsOnClassPath(IProject project) {
        IClasspathEntry[] classPathEntries = ResourceUtils.getJavaClasspath((IProject)project);
        Vector<IProject> dependentProjects = new Vector<IProject>();
        int i = 0;
        while (classPathEntries.length > i) {
            if (classPathEntries[i].getEntryKind() == 2) {
                IProject depProj;
                String sPath = classPathEntries[i].getPath().toString();
                int indx = sPath.lastIndexOf("/");
                String projectName = sPath;
                if (indx != -1) {
                    projectName = projectName.substring(indx + 1);
                }
                if (!(depProj = ResourceUtils.getWorkspace().getRoot().getProject(projectName)).exists() || ResourceUtils.isJCAProject((IProject)depProj)) {
                    // empty if block
                }
                dependentProjects.add(depProj);
            }
            ++i;
        }
        return dependentProjects;
    }

    public static ElementTreeSelectionDialog getSourceFolderSelectionDialog(Shell shell, IResource rootResource, String projectKind) {
        projectType = projectKind;
        Object provider = new StandardJavaElementContentProvider();
        if (projectType.equals(ResourceUtils.ENTERPRISE_APPLICATION)) {
            ITreeContentProvider earProjectProvider = new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof IWorkspaceRoot) {
                        ArrayList<IProject> al = new ArrayList<IProject>(5);
                        IProject[] projs = ((IWorkspaceRoot)parentElement).getProjects();
                        int r = 0;
                        while (r < projs.length) {
                            if (ResourceUtils.isEARProject((IProject)projs[r])) {
                                al.add(projs[r]);
                            }
                            ++r;
                        }
                        return al.toArray();
                    }
                    return null;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    Object[] obs = this.getChildren(element);
                    return obs != null && (obs == null || obs.length != 0);
                }

                public Object[] getElements(Object inputElement) {
                    return this.getChildren(inputElement);
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
            provider = earProjectProvider;
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(18);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_FSELECTION);
        dialog.setMessage(PropertyUIMessages.PROPERTY_UI_WIZARDS_LABEL_SFOLDER);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IJavaProject) {
                    IJavaProject jproject = (IJavaProject)element;
                    return jproject.exists() && ResourceUtils.isProjectOfKind((IProject)jproject.getProject(), (String)projectType);
                }
                if (element instanceof IProject) {
                    IProject proj = (IProject)element;
                    return proj.exists() && ResourceUtils.isProjectOfKind((IProject)proj, (String)projectType);
                }
                return false;
            }
        });
        if (projectType.equals(ResourceUtils.ENTERPRISE_APPLICATION)) {
            dialog.setInput((Object)ResourceUtils.getWorkspace().getRoot());
        } else if (rootResource == null) {
            dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourceUtils.getWorkspace().getRoot()));
        } else {
            dialog.setInput((Object)JavaCore.create((IResource)rootResource));
        }
        return dialog;
    }
}

