/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.common.writer;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.lang.common.writer.CodegenUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NamingUtils {
    private static final String DOT = ".";
    private static final String XMLSEPARATORS = "-.:\u00b7\u0387\u06dd\u06de\u30fb";
    private static final String XMLSEPARATORS_NODOT = "-:\u00b7\u0387\u06dd\u06de";
    private static final String UNDERSCORE = "_";
    private static HashMap<String, Object> keywordMap = null;

    public static String getPackageNameFromNamespaceURI(String namespaceURI) {
        List<String> segments = NamingUtils.getNamespaceURISegments(namespaceURI);
        StringBuffer packageNameBuffer = new StringBuffer();
        int i = 0;
        while (i < segments.size()) {
            String name;
            if (i == 0) {
                name = NamingUtils.getPackageNameFromXMLName(segments.get(i));
                StringTokenizer tokenizer = new StringTokenizer(name, DOT);
                ArrayList<String> host = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    String nextT = tokenizer.nextToken();
                    host.add(0, nextT);
                }
                StringBuffer buffer = new StringBuffer();
                for (String nextSegment : host) {
                    if (buffer.length() != 0) {
                        buffer.append('.');
                    }
                    if (!UCharacter.isJavaIdentifierStart((int)UTF16.charAt((String)nextSegment, (int)0))) {
                        nextSegment = UNDERSCORE + nextSegment;
                    }
                    if (NamingUtils.isJavaKeyword(nextSegment)) {
                        nextSegment = UNDERSCORE + nextSegment;
                    }
                    buffer.append(nextSegment);
                }
                name = buffer.toString();
            } else {
                name = NamingUtils.getJavaNameFromXMLName(segments.get(i));
            }
            if (name.length() != 0) {
                if (packageNameBuffer.length() != 0) {
                    packageNameBuffer.append('.');
                }
                packageNameBuffer.append(name);
            }
            ++i;
        }
        return packageNameBuffer.toString();
    }

    public static String getJavaNameFromXMLName(String xmlName, String delims) {
        StringTokenizer tokenizer = new StringTokenizer(xmlName, delims);
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
        }
        String result = buffer.toString();
        if (!UCharacter.isJavaIdentifierStart((int)UTF16.charAt((String)result, (int)0))) {
            result = UNDERSCORE + result;
        }
        if (NamingUtils.isJavaKeyword(result)) {
            result = UNDERSCORE + result;
        }
        return result;
    }

    public static String getJavaNameFromXMLName(String xmlName) {
        String s = NamingUtils.getJavaNameFromXMLName(xmlName, XMLSEPARATORS);
        return s;
    }

    public static String getPackageNameFromXMLName(String xmlName) {
        String name = NamingUtils.getJavaNameFromXMLName(xmlName, XMLSEPARATORS_NODOT);
        StringTokenizer tokenizer = new StringTokenizer(name, DOT);
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            if (buffer.length() != 0) {
                buffer.append('.');
            }
            String nextSegment = tokenizer.nextToken();
            buffer.append(nextSegment);
        }
        return buffer.toString();
    }

    public static String getJavaClassNameFromXMLName(String xmlName) {
        String s = NamingUtils.getJavaClassNameFromXMLName(xmlName, XMLSEPARATORS);
        return s;
    }

    public static String getJavaClassNameFromXMLName(String xmlName, String delims) {
        StringTokenizer tokenizer = new StringTokenizer(xmlName, delims);
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String nextSegment = tokenizer.nextToken();
            if (nextSegment.length() > 0) {
                nextSegment = CodegenUtil.getUppercaseName(nextSegment);
            }
            buffer.append(nextSegment);
        }
        String result = buffer.toString();
        if (!UCharacter.isJavaIdentifierStart((int)UTF16.charAt((String)result, (int)0))) {
            result = UNDERSCORE + result;
        }
        if (NamingUtils.isJavaKeyword(result)) {
            return UNDERSCORE + result;
        }
        return result;
    }

    public static String getXSDNamespaceFromPackageName(String packageName) {
        String result = "";
        StringTokenizer tokenizer = new StringTokenizer(packageName, DOT);
        while (tokenizer.hasMoreTokens()) {
            String nextT = tokenizer.nextToken();
            result = String.valueOf(nextT) + DOT + result;
        }
        if (result.endsWith(DOT)) {
            return "http://" + result.substring(0, result.length() - 1) + "/";
        }
        return "http://" + result + "/";
    }

    public static boolean isJavaKeyword(String identifier) {
        if (keywordMap == null) {
            Object value = new Object();
            keywordMap = new HashMap();
            keywordMap.put("abstract", value);
            keywordMap.put("default", value);
            keywordMap.put("if", value);
            keywordMap.put("private", value);
            keywordMap.put("this", value);
            keywordMap.put("boolean", value);
            keywordMap.put("do", value);
            keywordMap.put("implements", value);
            keywordMap.put("protected", value);
            keywordMap.put("throw", value);
            keywordMap.put("break", value);
            keywordMap.put("double", value);
            keywordMap.put("import", value);
            keywordMap.put("public", value);
            keywordMap.put("throws", value);
            keywordMap.put("byte", value);
            keywordMap.put("else", value);
            keywordMap.put("instanceof", value);
            keywordMap.put("return", value);
            keywordMap.put("transient", value);
            keywordMap.put("case", value);
            keywordMap.put("extends", value);
            keywordMap.put("int", value);
            keywordMap.put("short", value);
            keywordMap.put("try", value);
            keywordMap.put("catch", value);
            keywordMap.put("final", value);
            keywordMap.put("interface", value);
            keywordMap.put("static", value);
            keywordMap.put("void", value);
            keywordMap.put("char", value);
            keywordMap.put("finally", value);
            keywordMap.put("long", value);
            keywordMap.put("strictfp", value);
            keywordMap.put("volatile", value);
            keywordMap.put("class", value);
            keywordMap.put("float", value);
            keywordMap.put("native", value);
            keywordMap.put("super", value);
            keywordMap.put("while", value);
            keywordMap.put("const", value);
            keywordMap.put("for", value);
            keywordMap.put("new", value);
            keywordMap.put("switch", value);
            keywordMap.put("continue", value);
            keywordMap.put("goto", value);
            keywordMap.put("package", value);
            keywordMap.put("synchronized", value);
            keywordMap.put("null", value);
            keywordMap.put("true", value);
            keywordMap.put("false", value);
            keywordMap.put("assert", value);
        }
        return keywordMap.containsKey(identifier);
    }

    private static List<String> getNamespaceURISegments(String namespaceURI) {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(namespaceURI, ":/");
        while (tokenizer.hasMoreTokens()) {
            segments.add(tokenizer.nextToken());
        }
        if (!segments.isEmpty()) {
            try {
                URL url = new URL(namespaceURI);
                if (((String)segments.get(0)).equals(url.getProtocol())) {
                    segments.remove(0);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return segments;
    }
}

