/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.common.writer;

import com.ibm.lang.common.writer.LogFacility;
import com.ibm.lang.common.writer.WriterPlugin;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NamespaceUtils {
    protected static String HEX_PREFIX = "%";
    protected static String CHARSET_UTF8 = "UTF-8";
    public static final String SPACE = " ";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String LESS_THAN = "<";
    public static final String GREATER_THAN = ">";
    public static final String POUND = "#";
    public static final String PERCENT = "%";
    public static final String LEFT_CURLY = "{";
    public static final String RIGHT_CURLY = "}";
    public static final String PIPE = "|";
    public static final String BACKSLASH = "\\";
    public static final String CARET = "^";
    public static final String TILDE = "~";
    public static final String LEFT_SQUARE = "[";
    public static final String RIGHT_SQUARE = "]";
    public static final String GRAVE = "`";
    public static final String ESCAPED_SPACE = "%20";
    public static final String ESCAPED_DOUBLE_QUOTE = "%22";
    public static final String ESCAPED_LESS_THAN = "%3C";
    public static final String ESCAPED_GREATER_THAN = "%3E";
    public static final String ESCAPED_POUND = "%23";
    public static final String ESCAPED_PERCENT = "%25";
    public static final String ESCAPED_LEFT_CURLY = "%7B";
    public static final String ESCAPED_RIGHT_CURLY = "%7D";
    public static final String ESCAPED_PIPE = "%7C";
    public static final String ESCAPED_BACKSLASH = "%5C";
    public static final String ESCAPED_CARET = "%5E";
    public static final String ESCAPED_TILDE = "%7E";
    public static final String ESCAPED_LEFT_SQUARE = "%5B";
    public static final String ESCAPED_RIGHT_SQUARE = "%5D";
    public static final String ESCAPED_GRAVE = "%60";
    protected static HashMap<String, String> fCharToEscaped = new HashMap(15);

    static {
        fCharToEscaped.put(SPACE, ESCAPED_SPACE);
        fCharToEscaped.put(DOUBLE_QUOTE, ESCAPED_DOUBLE_QUOTE);
        fCharToEscaped.put(LESS_THAN, ESCAPED_LESS_THAN);
        fCharToEscaped.put(GREATER_THAN, ESCAPED_GREATER_THAN);
        fCharToEscaped.put(POUND, ESCAPED_POUND);
        fCharToEscaped.put(PERCENT, ESCAPED_PERCENT);
        fCharToEscaped.put(LEFT_CURLY, ESCAPED_LEFT_CURLY);
        fCharToEscaped.put(RIGHT_CURLY, ESCAPED_RIGHT_CURLY);
        fCharToEscaped.put(PIPE, ESCAPED_PIPE);
        fCharToEscaped.put(BACKSLASH, ESCAPED_BACKSLASH);
        fCharToEscaped.put(CARET, ESCAPED_CARET);
        fCharToEscaped.put(TILDE, ESCAPED_TILDE);
        fCharToEscaped.put(LEFT_SQUARE, ESCAPED_LEFT_SQUARE);
        fCharToEscaped.put(RIGHT_SQUARE, ESCAPED_RIGHT_SQUARE);
        fCharToEscaped.put(GRAVE, ESCAPED_GRAVE);
    }

    public static String convertUriToNamespace(String uri) {
        if (uri == null || uri.length() < 1) {
            return null;
        }
        String namespace = uri;
        int prevIndex = 0;
        int contiguousIndex = 0;
        Byte hexByte = null;
        ArrayList<Byte> contiguousBytes = null;
        String hexChunk = null;
        int i = uri.indexOf(HEX_PREFIX);
        while (i >= 0) {
            hexByte = NamespaceUtils.getHexByte(uri, i);
            contiguousBytes = new ArrayList<Byte>();
            contiguousIndex = i;
            hexChunk = new String();
            prevIndex = contiguousIndex + 1;
            while (hexByte != null) {
                contiguousBytes.add(hexByte);
                hexChunk = String.valueOf(hexChunk) + uri.substring(contiguousIndex, contiguousIndex + 3);
                prevIndex = contiguousIndex + 1;
                hexByte = NamespaceUtils.getHexByte(uri, contiguousIndex + 3);
                contiguousIndex += 3;
            }
            int n = prevIndex = prevIndex >= uri.length() ? uri.length() - 1 : prevIndex;
            if (contiguousBytes.size() > 0) {
                byte[] cbytes = new byte[contiguousBytes.size()];
                int j = 0;
                while (j < cbytes.length) {
                    cbytes[j] = (Byte)contiguousBytes.get(j);
                    ++j;
                }
                try {
                    String unicode = new String(cbytes, CHARSET_UTF8);
                    int beginIndex = namespace.indexOf(hexChunk);
                    int endIndex = beginIndex + hexChunk.length();
                    int lastIndex = namespace.length();
                    endIndex = endIndex > lastIndex ? lastIndex : endIndex;
                    namespace = String.valueOf(namespace.substring(0, beginIndex)) + unicode + namespace.substring(endIndex);
                }
                catch (UnsupportedEncodingException e) {
                    Status status = new Status(4, WriterPlugin.getPluginID(), 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), (Throwable)e);
                    LogFacility.logInfoMessage((IStatus)status);
                }
            }
            i = uri.indexOf(HEX_PREFIX, prevIndex);
        }
        return namespace;
    }

    protected static Byte getHexByte(String uri, int index) {
        if (uri == null || uri.length() < 1) {
            return null;
        }
        if (index >= uri.length()) {
            return null;
        }
        if (!HEX_PREFIX.equals(String.valueOf(uri.charAt(index)))) {
            return null;
        }
        int endIndex = index + 3;
        int lastIndex = uri.length();
        if (endIndex > lastIndex) {
            endIndex = lastIndex;
        }
        String hexString = uri.substring(index + 1, endIndex);
        byte hexByte = 0;
        try {
            hexByte = Integer.valueOf(hexString, 16).byteValue();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Byte(hexByte);
    }

    public static String convertNamespaceToUri(String namespace) {
        if (namespace == null || namespace.length() < 1) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        namespace = NamespaceUtils.escapeUnsafeCharacters(namespace);
        char[] nsChars = namespace.toCharArray();
        byte[] utf8 = null;
        try {
            int i = 0;
            while (i < nsChars.length) {
                if (nsChars[i] > '\u007f') {
                    utf8 = String.valueOf(nsChars[i]).getBytes(CHARSET_UTF8);
                    int j = 0;
                    while (j < utf8.length) {
                        buffer.append(HEX_PREFIX);
                        buffer.append(Integer.toString(utf8[j] & 0xFF, 16).toUpperCase());
                        ++j;
                    }
                } else {
                    buffer.append(nsChars[i]);
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            Status status = new Status(4, WriterPlugin.getPluginID(), 4, e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), (Throwable)e);
            LogFacility.logInfoMessage((IStatus)status);
        }
        return buffer.toString();
    }

    public static String escapeUnsafeCharacters(String anyURI) {
        if (anyURI == null) {
            return null;
        }
        anyURI = anyURI.replaceAll("\\%", fCharToEscaped.get(PERCENT));
        for (String key : fCharToEscaped.keySet()) {
            if (key.equals(PERCENT)) continue;
            anyURI = anyURI.replaceAll(BACKSLASH + key, fCharToEscaped.get(key));
        }
        return anyURI;
    }
}

