/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.core.internal.utilities;

import com.ibm.adapter.j2ca.Connector;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.internal.ResourceAdapterRegistry;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.j2c.ui.core.data.MCF_RAR_Indentifier;
import com.ibm.j2c.ui.core.internal.utilities.J2CLogUtil;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class ResourceUtils {
    private static IWorkspaceRoot root_ = null;
    private static IWorkspace workspace_ = null;
    public static String DYNAMIC_WEB = "jst.web";
    public static String EJB = "jst.ejb";
    public static String JCA = "jst.connector";
    public static String ENTERPRISE_APPLICATION = "jst.ear";

    public static IWorkspaceRoot getWorkspaceRoot() {
        if (root_ == null) {
            root_ = ResourcesPlugin.getWorkspace().getRoot();
        }
        return root_;
    }

    public static IWorkspace getWorkspace() {
        if (workspace_ == null) {
            if (root_ == null) {
                root_ = ResourcesPlugin.getWorkspace().getRoot();
            }
            workspace_ = root_.getWorkspace();
        }
        return workspace_;
    }

    public static IProject getProjectOf(IPath absolutePath) {
        String projectName;
        if (absolutePath.isAbsolute() && (projectName = absolutePath.segment(0)) != null) {
            return ResourceUtils.getWorkspaceRoot().getProject(projectName);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJavaComponent(IVirtualComponent comp) {
        IProject project = comp.getProject();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            IJavaProject[] projects = javaModel.getJavaProjects();
            int i = 0;
            int length = projects.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                IJavaProject javaProject = projects[i];
                if (project.equals((Object)javaProject.getProject())) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJavaProject(IProject project) {
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            IJavaProject[] projects = javaModel.getJavaProjects();
            int i = 0;
            int length = projects.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                IJavaProject javaProject = projects[i];
                if (project.equals((Object)javaProject.getProject())) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static boolean isTrueJavaProject(IProject project) {
        return ResourceUtils.isJavaProject(project) && !ResourceUtils.isDynamicWebProject(project) && !ResourceUtils.isEJBProject(project) && !ResourceUtils.isJCAProject(project) && !J2EEProjectUtilities.isApplicationClientProject((IProject)project);
    }

    public static String getProjectTypeAsString(IProject project) {
        String defaultRes = "JAVA";
        String type = ResourceUtils.getJ2EEProjectType(project);
        if (type.length() == 0 || type.equals("jst.utility")) {
            return defaultRes;
        }
        return type;
    }

    public static IModule getModule(IProject project) {
        IModule modules = ServerUtil.getModule((IProject)project);
        return modules;
    }

    public static IPath getJavaOutputLocation(IProject project) {
        IPath outputLocation = null;
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                outputLocation = javaProject.getOutputLocation();
            }
        }
        catch (JavaModelException javaModelException) {}
        return outputLocation;
    }

    public static IClasspathEntry[] getJavaClasspath(IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IClasspathEntry[] classpathEntries = javaProject.getRawClasspath();
                return classpathEntries;
            }
        }
        catch (JavaModelException javaModelException) {}
        return new IClasspathEntry[0];
    }

    public static void setJavaClasspath(IProject project, IClasspathEntry[] entries) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                javaProject.setRawClasspath(entries, null);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public static String getJavaResourcePackageName(IPath absolutePath) {
        try {
            IPath javaFolderPath = absolutePath.removeLastSegments(1);
            IProject project = ResourceUtils.getProjectOf(absolutePath);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IPackageFragment fragment = javaProject.findPackageFragment(javaFolderPath);
                if (fragment != null) {
                    return fragment.getElementName();
                }
                IPath outputPath = ResourceUtils.getJavaOutputLocation(project);
                if (outputPath.isPrefixOf(javaFolderPath)) {
                    IPath javaPackagePath = javaFolderPath.removeFirstSegments(outputPath.segmentCount());
                    return javaPackagePath.isEmpty() ? null : javaPackagePath.toString().replace('/', '.');
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IPath getJavaResourcePackagePath(IPath absolutePath) {
        String packageName = ResourceUtils.getJavaResourcePackageName(absolutePath);
        return packageName == null ? null : new Path(packageName.replace('.', '/'));
    }

    public static IPath getJavaResourceRootPath(IPath absolutePath) {
        try {
            IProject project = ResourceUtils.getProjectOf(absolutePath);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IPackageFragmentRoot[] pfrs = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < pfrs.length) {
                    IPath fragmentPath;
                    IResource fragmentRoot = pfrs[i].getCorrespondingResource();
                    if (fragmentRoot != null && (fragmentPath = fragmentRoot.getFullPath()).isPrefixOf(absolutePath)) {
                        return fragmentPath;
                    }
                    ++i;
                }
                IPath outputPath = ResourceUtils.getJavaOutputLocation(project);
                if (outputPath.isPrefixOf(absolutePath)) {
                    return outputPath;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IPath getJavaSourceLocation(IProject project) {
        IPath sourceLocation = null;
        IPackageFragmentRoot[] fragmentRoots = ResourceUtils.getJavaPackageFragmentRoots(project);
        int i = 0;
        while (i < fragmentRoots.length && sourceLocation == null) {
            try {
                IResource fragmentRoot = fragmentRoots[i].getCorrespondingResource();
                if (fragmentRoot != null && fragmentRoot.getProject().equals((Object)project) && fragmentRoot.getType() != 1) {
                    sourceLocation = fragmentRoot.getFullPath();
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        return sourceLocation;
    }

    public static String extractNameFromURI(String sURI) {
        String sT1;
        int ind;
        String res = null;
        String stToken = "platform:/resource/";
        if (sURI.startsWith(stToken) && (ind = (sT1 = sURI.substring(stToken.length())).indexOf("/")) > 0) {
            res = sT1.substring(0, ind);
        }
        return res;
    }

    public static IPackageFragmentRoot[] getJavaPackageFragmentRoots(IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                return packageFragmentRoots;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return new IPackageFragmentRoot[0];
    }

    public static IPath[] getAllJavaSourceLocations(IProject project) {
        Vector<IPath> pathVector = new Vector<IPath>();
        IPackageFragmentRoot[] fragmentRoots = ResourceUtils.getJavaPackageFragmentRoots(project);
        int i = 0;
        while (i < fragmentRoots.length) {
            try {
                IResource fragmentRoot = fragmentRoots[i].getCorrespondingResource();
                if (fragmentRoot != null && fragmentRoot.getProject().equals((Object)project) && fragmentRoot.getType() != 1) {
                    pathVector.add(fragmentRoot.getFullPath());
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        return (IPath[])pathVector.toArray(new Path[pathVector.size()]);
    }

    public static boolean isProjectOfKind(IProject project, String kind) {
        boolean res = false;
        if (project == null) {
            return false;
        }
        String projKind = ResourceUtils.getJ2EEProjectType(project);
        if (projKind.equals(kind)) {
            return true;
        }
        return res;
    }

    public static QName getQNameFromObject(Object ob) {
        return (QName)ob;
    }

    public static String getNamespace(QName name) {
        return name.getNamespaceURI();
    }

    public static String getLocalName(QName name) {
        return name.getLocalPart();
    }

    public static boolean isDynamicWebProject(IProject project) {
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
    }

    public static boolean isEJBProject(IProject project) {
        return JavaEEProjectUtilities.isEJBProject((IProject)project);
    }

    public static boolean isJCAProject(IProject project) {
        return JavaEEProjectUtilities.isJCAProject((IProject)project);
    }

    public static boolean isEARProject(IProject project) {
        return JavaEEProjectUtilities.isEARProject((IProject)project);
    }

    public static String getJ2EEProjectType(IProject currentProject) {
        return JavaEEProjectUtilities.getJ2EEProjectType((IProject)currentProject);
    }

    public static void checkAnnotationBuilder(String projectName) {
        if (projectName == null) {
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null && ResourceUtils.isEJBProject(project)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            EJBArtifactEdit editEJB = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
            try {
                IProject ejbClientProject1;
                if (editEJB.getEJBClientJarModule() != null && project != (ejbClientProject1 = editEJB.getEJBClientJarModule().getProject())) {
                    ResourceUtils.addBuilderToProject(ejbClientProject1, "com.ibm.zcc.ws.rapiddeploy.annotations.core.AnnotationBuilder");
                }
            }
            catch (Exception exception) {}
            editEJB.dispose();
        }
    }

    public static void addBuilderToProject(IProject project, String builderID) {
        try {
            IProjectDescription desc = project.getProject().getDescription();
            ICommand[] commands = desc.getBuildSpec();
            boolean found = false;
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(builderID)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                ICommand command = desc.newCommand();
                command.setBuilderName(builderID);
                ICommand[] newCommands = new ICommand[commands.length + 1];
                System.arraycopy(commands, 0, newCommands, 1, commands.length);
                newCommands[0] = command;
                desc.setBuildSpec(newCommands);
                project.getProject().setDescription(desc, null);
            }
        }
        catch (Exception exception) {}
    }

    public static void removeBuilderFromProject(IProject project, String builderID) {
        try {
            if (project == null) {
                return;
            }
            IProjectDescription desc = project.getProject().getDescription();
            ICommand[] commands = desc.getBuildSpec();
            ArrayList<ICommand> newComs = new ArrayList<ICommand>(2);
            int i = 0;
            i = 0;
            while (i < commands.length) {
                if (!commands[i].getBuilderName().equals(builderID)) {
                    newComs.add(commands[i]);
                }
                ++i;
            }
            ICommand[] newCommands = new ICommand[newComs.size()];
            newComs.toArray(newCommands);
            desc.setBuildSpec(newCommands);
            project.getProject().setDescription(desc, null);
        }
        catch (Exception exception) {}
    }

    public static void updateClassPath(String utilityProjectName, IProject oldProject) {
        IProject dataProj = ResourceUtils.getWorkspaceRoot().getProject(utilityProjectName);
        IClasspathEntry[] classPathEntries = ResourceUtils.getJavaClasspath(oldProject);
        IClasspathEntry[] classPathEntries2 = new IClasspathEntry[classPathEntries.length + 1];
        IPath dataPrPath = dataProj.getFullPath();
        boolean existsInCP = false;
        int i = 0;
        while (classPathEntries.length > i) {
            IPath path = classPathEntries[i].getPath();
            if (path.equals((Object)dataPrPath)) {
                existsInCP = true;
                break;
            }
            classPathEntries2[i] = classPathEntries[i];
            ++i;
        }
        if (!existsInCP) {
            classPathEntries2[classPathEntries2.length - 1] = JavaCore.newProjectEntry((IPath)dataPrPath);
            ResourceUtils.setJavaClasspath(oldProject, classPathEntries2);
        }
    }

    public static void addToClassPath(IClasspathEntry entry, IProject oldProject) {
        IClasspathEntry[] classPathEntries = ResourceUtils.getJavaClasspath(oldProject);
        IClasspathEntry[] classPathEntries2 = new IClasspathEntry[classPathEntries.length + 1];
        boolean existsInCP = false;
        int i = 0;
        while (classPathEntries.length > i) {
            IPath path = classPathEntries[i].getPath();
            if (path.equals((Object)entry.getPath())) {
                existsInCP = true;
                break;
            }
            classPathEntries2[i] = classPathEntries[i];
            ++i;
        }
        if (!existsInCP) {
            classPathEntries2[classPathEntries2.length - 1] = entry;
            ResourceUtils.setJavaClasspath(oldProject, classPathEntries2);
        }
    }

    public static void highlightCreatedResource(IResource res) {
        IWorkbench fWorkbench = PlatformUI.getWorkbench();
        BasicNewResourceWizard.selectAndReveal((IResource)res, (IWorkbenchWindow)fWorkbench.getActiveWorkbenchWindow());
    }

    public static synchronized void copyFile(IProject oldProject, IProject newProject, String sURI, boolean keepCopy) {
        ResourceUtils.copyFile(oldProject, newProject, sURI, keepCopy, false);
    }

    public static synchronized void copyFile(IProject oldProject, IProject newProject, String sURI, boolean keepCopy, boolean overwrite) {
        if (oldProject == null || newProject == null) {
            return;
        }
        String origProjName = oldProject.getName();
        if (sURI.indexOf(origProjName) > 0) {
            try {
                String sPath = sURI.substring(sURI.indexOf(origProjName) + origProjName.length());
                if (!sPath.endsWith(".java")) {
                    return;
                }
                IPath clientSourceFolder = ResourceUtils.getJavaSourceLocation(newProject);
                IFile dataTypeFile = oldProject.getFile(sPath);
                boolean fileExists = dataTypeFile.exists();
                if (fileExists) {
                    ICompilationUnit dataTypeCU = JavaCore.createCompilationUnitFrom((IFile)dataTypeFile);
                    String packageDecl = dataTypeCU.getPackageDeclarations()[0].getElementName();
                    packageDecl = packageDecl.replace('.', '/');
                    IPath newFilePath = clientSourceFolder.append(packageDecl);
                    newFilePath = newFilePath.makeAbsolute();
                    newFilePath = newFilePath.append("/" + dataTypeFile.getName());
                    IResource file1 = ResourceUtils.getWorkspaceRoot().findMember(newFilePath);
                    if (file1 != null && file1.exists() && overwrite) {
                        file1.delete(true, null);
                    }
                    if (file1 == null || !file1.exists()) {
                        String sP = clientSourceFolder.removeFirstSegments(1).toString();
                        StringTokenizer stTok = new StringTokenizer(packageDecl, "/");
                        while (stTok.hasMoreTokens()) {
                            String token = stTok.nextToken();
                            IFolder dataTypeFolder = newProject.getFolder((IPath)new Path(sP = String.valueOf(sP) + "/" + token));
                            if (dataTypeFolder.exists()) continue;
                            dataTypeFolder.create(false, true, null);
                        }
                        if (keepCopy) {
                            dataTypeFile.copy(newFilePath, false, null);
                        } else {
                            dataTypeFile.move(newFilePath, false, null);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void copyFile(IProject oldProject, IProject newProject, QName name, boolean keepCopy) {
        ResourceUtils.copyFile(oldProject, newProject, name, keepCopy, false);
    }

    public static synchronized void copyFile(IProject oldProject, IProject newProject, QName name, boolean keepCopy, boolean overwrite) {
        if (oldProject == null || newProject == null) {
            return;
        }
        try {
            String sPath;
            int dotIndx;
            String packageDecl = name.getNamespaceURI();
            packageDecl = packageDecl.replace('.', '/');
            String fName = name.getLocalPart();
            if (fName.endsWith(".java")) {
                fName = fName.substring(0, fName.length() - 5);
            }
            if ((dotIndx = fName.lastIndexOf(".")) > 0) {
                fName = fName.substring(dotIndx + 1, fName.length());
            }
            if (!(sPath = String.valueOf(ResourceUtils.getJavaSourceLocation(oldProject).removeFirstSegments(1).toString()) + "/" + packageDecl + "/" + fName).endsWith(".java")) {
                sPath = String.valueOf(sPath) + ".java";
            }
            IPath clientSourceFolder = ResourceUtils.getJavaSourceLocation(newProject);
            IFile dataTypeFile = oldProject.getFile(sPath);
            IPath newFilePath = clientSourceFolder.append(packageDecl);
            newFilePath = newFilePath.makeAbsolute();
            newFilePath = newFilePath.append("/" + dataTypeFile.getName());
            IResource file1 = ResourceUtils.getWorkspaceRoot().findMember(newFilePath);
            if (file1 != null && file1.exists() && overwrite) {
                file1.delete(true, null);
            }
            if (file1 == null || !file1.exists()) {
                String sP = clientSourceFolder.removeFirstSegments(1).toString();
                StringTokenizer stTok = new StringTokenizer(packageDecl, "/");
                while (stTok.hasMoreTokens()) {
                    String token = stTok.nextToken();
                    IFolder dataTypeFolder = newProject.getFolder((IPath)new Path(sP = String.valueOf(sP) + "/" + token));
                    if (dataTypeFolder.exists()) continue;
                    dataTypeFolder.create(false, true, null);
                }
                if (keepCopy) {
                    dataTypeFile.copy(newFilePath, false, null);
                } else {
                    dataTypeFile.move(newFilePath, false, null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            J2CLogUtil.log(e.getMessage(), (short)60);
        }
    }

    public static void copySubFolders(IProject origProj, IProject toProj, IPath pathOfFolder) {
        if (origProj == null || toProj == null) {
            return;
        }
        try {
            IWorkspace workspace = ResourceUtils.getWorkspace();
            IFolder parentFolder = workspace.getRoot().getFolder(pathOfFolder);
            IResource[] ress = parentFolder.members();
            int i = 0;
            while (i < ress.length) {
                if (ress[i] instanceof IFolder) {
                    ResourceUtils.copySubFolders(origProj, toProj, ress[i].getFullPath());
                    IFolder subFolder = (IFolder)ress[i];
                    IResource[] files = subFolder.members();
                    int k = 0;
                    while (k < files.length) {
                        if (files[k] instanceof IFile) {
                            IFile file = (IFile)files[k];
                            String sPath = file.getFullPath().toString();
                            if (sPath.startsWith("/")) {
                                sPath = sPath.substring(1);
                            }
                            String sURI = "platform:/resource/" + sPath;
                            ResourceUtils.copyFile(origProj, toProj, sURI, true);
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Object[] quickSort(Object[] sortedCollection, int left, int right) {
        int originalLeft = left;
        int originalRight = right;
        Object mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (ResourceUtils.compare(sortedCollection[left], mid)) {
                ++left;
                continue;
            }
            while (ResourceUtils.compare(mid, sortedCollection[right])) {
                --right;
            }
            if (left <= right) {
                Object tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (originalLeft < right) {
            sortedCollection = ResourceUtils.quickSort(sortedCollection, originalLeft, right);
        }
        if (left < originalRight) {
            sortedCollection = ResourceUtils.quickSort(sortedCollection, left, originalRight);
        }
        return sortedCollection;
    }

    public static Object[] quickSort(Object[] unSortedCollection) {
        int size = unSortedCollection.length;
        Object[] sortedCollection = new Object[size];
        System.arraycopy(unSortedCollection, 0, sortedCollection, 0, size);
        if (size > 1) {
            ResourceUtils.quickSort(sortedCollection, 0, size - 1);
        }
        return sortedCollection;
    }

    private static boolean compare(Object o1, Object o2) {
        boolean res = false;
        String s1 = o1.toString();
        String s2 = o2.toString();
        if (s1 != null && s2 != null && s1.compareToIgnoreCase(s2) < 0) {
            return true;
        }
        return res;
    }

    public static boolean compareJ2CVersion() {
        Bundle b = Platform.getBundle((String)"com.ibm.j2c.ui.core");
        String v = (String)b.getHeaders().get("Bundle-Version");
        return Version.parseVersion((String)v).compareTo(new Version("7.1.0.qualifier")) > 0;
    }

    public static void exportRarFile(IProject connectorProject, String path, IProgressMonitor monitor) {
        ConnectorComponentExportDataModelProvider conExp = new ConnectorComponentExportDataModelProvider();
        IDataModel exportDM = DataModelFactory.createDataModel((IDataModelProvider)conExp);
        if (exportDM == null) {
            return;
        }
        exportDM.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)path);
        exportDM.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)connectorProject.getName());
        IVirtualComponent comps = ComponentCore.createComponent((IProject)connectorProject);
        exportDM.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", (Object)comps);
        try {
            exportDM.getDefaultOperation().execute(monitor, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Vector getConnectorProjectsOnClassPath(IProject project) {
        IClasspathEntry[] classPathEntries = ResourceUtils.getJavaClasspath(project);
        Vector<IProject> dependentProjects = new Vector<IProject>();
        int i = 0;
        while (classPathEntries.length > i) {
            if (classPathEntries[i].getEntryKind() == 2) {
                IProject depProj;
                String sPath = classPathEntries[i].getPath().toString();
                int indx = sPath.lastIndexOf("/");
                String projectName = sPath;
                if (indx != -1) {
                    projectName = projectName.substring(indx + 1);
                }
                if ((depProj = ResourceUtils.getWorkspace().getRoot().getProject(projectName)).exists() && ResourceUtils.isJCAProject(depProj)) {
                    dependentProjects.add(depProj);
                }
            }
            ++i;
        }
        return dependentProjects;
    }

    public static Vector getMCFRarInfosForProject(IProject project) {
        Vector<MCF_RAR_Indentifier> res = null;
        Vector dependentProjects = ResourceUtils.getConnectorProjectsOnClassPath(project);
        if (!dependentProjects.isEmpty()) {
            Vector<MCF_RAR_Indentifier> rarInfos = new Vector<MCF_RAR_Indentifier>();
            int q = 0;
            while (q < dependentProjects.size()) {
                IProject proj = (IProject)dependentProjects.get(q);
                IResourceAdapterDescriptor descriptor = ResourceAdapterRegistry.getRegistry().getResourceAdapterForProject(proj);
                String mcfClassName = descriptor.getManagedConnectionFactoryNames()[0];
                Connector connector = descriptor.getConnector();
                String displayName = connector.getDisplayName();
                String vendorName = connector.getVendorName();
                String version = connector.getVersion();
                MCF_RAR_Indentifier rarInf = new MCF_RAR_Indentifier(mcfClassName, vendorName, version, displayName);
                rarInfos.add(rarInf);
                ++q;
            }
            res = rarInfos;
        }
        return res;
    }
}

