/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.core.internal.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;

public class J2CUIDataTypeHierarchyScope
implements IJavaSearchScope {
    private IType[] searchTypes_;
    private ArrayList<String> elements_;
    private WorkingCopyOwner owner_;
    private boolean needsRefresh_;
    private IPath[] enclosingProjectsAndJars_;
    private IResource[] enclosingProjects_;

    public J2CUIDataTypeHierarchyScope(IType[] types, WorkingCopyOwner owner, IResource[] resources) throws JavaModelException {
        this.searchTypes_ = types;
        this.needsRefresh_ = true;
        this.owner_ = owner;
        this.enclosingProjects_ = resources;
        this.enclosingProjectsAndJars_ = this.computeProjectsAndJars(types);
    }

    protected void initialize() throws JavaModelException {
        if (this.searchTypes_ == null || !this.needsRefresh_) {
            return;
        }
        this.needsRefresh_ = false;
        this.elements_ = new ArrayList();
        HashMap<IResource, IResource> resources = new HashMap<IResource, IResource>();
        HashMap<IPath, IType> paths = new HashMap<IPath, IType>();
        IType[] iTypeArray = this.searchTypes_;
        int n = this.searchTypes_.length;
        int n2 = 0;
        while (n2 < n) {
            IType[] types;
            IType type = iTypeArray[n2];
            ITypeHierarchy hierarchy = this.owner_ == null ? type.newTypeHierarchy(null) : type.newTypeHierarchy(this.owner_, null);
            IType[] iTypeArray2 = types = hierarchy.getAllSubtypes(type);
            int n3 = types.length;
            int n4 = 0;
            while (n4 < n3) {
                IType subType = iTypeArray2[n4];
                IPackageFragmentRoot root = (IPackageFragmentRoot)subType.getPackageFragment().getParent();
                if (root.getKind() == 1) {
                    IResource resource = subType.getResource();
                    if (resource != null && resources.get(resource) == null && this.checkProject(resource.getProject())) {
                        resources.put(resource, resource);
                        this.elements_.add(resource.getFullPath().toString());
                    }
                    paths.put(subType.getJavaProject().getProject().getFullPath(), subType);
                }
                ++n4;
            }
            ++n2;
        }
        this.enclosingProjectsAndJars_ = new IPath[paths.size()];
        int i = 0;
        Iterator iter = paths.keySet().iterator();
        while (iter.hasNext()) {
            this.enclosingProjectsAndJars_[i++] = (IPath)iter.next();
        }
    }

    private IPath[] computeProjectsAndJars(IType[] types) throws JavaModelException {
        ArrayList<IPath> returnPaths = new ArrayList<IPath>();
        int i = 0;
        while (i < types.length) {
            IPath[] paths = this.computeProjectsAndJars(types[i]);
            int j = 0;
            while (j < paths.length) {
                if (returnPaths.indexOf(paths[j]) == -1) {
                    returnPaths.add(paths[j]);
                }
                ++j;
            }
            ++i;
        }
        IPath[] result = new IPath[returnPaths.size()];
        returnPaths.toArray(result);
        return result;
    }

    private IPath[] computeProjectsAndJars(IType type) throws JavaModelException {
        HashSet<IPath> set = new HashSet<IPath>();
        IPackageFragmentRoot root = (IPackageFragmentRoot)type.getPackageFragment().getParent();
        if (root.isArchive()) {
            IPath rootPath = root.getPath();
            HashSet<IJavaProject> visited = new HashSet<IJavaProject>();
            int i = 0;
            while (i < this.enclosingProjects_.length) {
                IJavaProject project = (IJavaProject)JavaCore.create((IResource)this.enclosingProjects_[i]);
                IClasspathEntry[] classpath = project.getResolvedClasspath(true);
                int j = 0;
                while (j < classpath.length) {
                    if (rootPath.equals((Object)classpath[j].getPath())) {
                        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
                        set.add(project.getPath());
                        int k = 0;
                        while (k < roots.length) {
                            IPackageFragmentRoot pkgFragmentRoot = roots[k];
                            if (pkgFragmentRoot.getKind() == 1) {
                                set.add(pkgFragmentRoot.getPath());
                            }
                            ++k;
                        }
                        if (visited.contains(project)) break;
                        this.computeDependents(project, set, visited);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        IPath[] result = new IPath[set.size()];
        set.toArray(result);
        return result;
    }

    private void computeDependents(IJavaProject project, HashSet<IPath> set, HashSet<IJavaProject> visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IProject currentProject = project.getProject();
        IProject[] dependents = currentProject.getReferencingProjects();
        int i = 0;
        while (i < dependents.length) {
            if (!currentProject.equals((Object)dependents[i])) {
                try {
                    IJavaProject dependent = JavaCore.create((IProject)dependents[i]);
                    IPackageFragmentRoot[] roots = dependent.getPackageFragmentRoots();
                    set.add(dependent.getPath());
                    int j = 0;
                    while (j < roots.length) {
                        IPackageFragmentRoot pkgFragmentRoot = roots[j];
                        if (pkgFragmentRoot.isArchive()) {
                            set.add(pkgFragmentRoot.getPath());
                        }
                        ++j;
                    }
                    this.computeDependents(dependent, set, visited);
                }
                catch (JavaModelException javaModelException) {}
            }
            ++i;
        }
    }

    public boolean encloses(String resourcePath) {
        int separatorIndex;
        if (this.needsRefresh_) {
            try {
                this.initialize();
            }
            catch (JavaModelException javaModelException) {}
        }
        return (separatorIndex = resourcePath.indexOf("|")) == -1 && this.elements_.indexOf(resourcePath) != -1;
    }

    public boolean encloses(IJavaElement element) {
        return this.encloses(element.getPath().toString());
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.needsRefresh_) {
            try {
                this.refresh();
            }
            catch (JavaModelException javaModelException) {
                return new IPath[0];
            }
        }
        return this.enclosingProjectsAndJars_;
    }

    protected void refresh() throws JavaModelException {
        this.initialize();
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }

    private boolean checkProject(IProject project) {
        if (project == null) {
            return false;
        }
        if (this.enclosingProjects_ == null) {
            return true;
        }
        int i = 0;
        while (i < this.enclosingProjects_.length) {
            if (project.equals((Object)this.enclosingProjects_[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

