/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.core.internal.utilities;

import com.ibm.j2c.ui.core.internal.utilities.J2CUICoreHelper;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;

public class J2CImplTypeSearchScope
implements IJavaSearchScope {
    private IJavaProject[] searchTypes_;
    private ArrayList elements_;
    private boolean needsRefresh_;
    private IPath[] enclosingProjectsAndJars_;
    private IResource[] enclosingProjects_;

    public J2CImplTypeSearchScope(ArrayList types, IResource[] resources) throws JavaModelException {
        this.searchTypes_ = new IJavaProject[types.size()];
        types.toArray(this.searchTypes_);
        this.needsRefresh_ = true;
        this.enclosingProjects_ = resources;
        this.enclosingProjectsAndJars_ = this.computeProjectsAndJars(types);
        this.initialize();
    }

    private IPath[] computeProjectsAndJars(ArrayList projects) throws JavaModelException {
        ArrayList<IPath> returnPaths = new ArrayList<IPath>();
        int i = 0;
        while (i < projects.size()) {
            IPath[] paths = this.computeProjectsAndJars((IJavaProject)projects.get(i));
            int j = 0;
            while (j < paths.length) {
                if (returnPaths.indexOf(paths[j]) == -1) {
                    returnPaths.add(paths[j]);
                }
                ++j;
            }
            ++i;
        }
        IPath[] result = new IPath[returnPaths.size()];
        returnPaths.toArray(result);
        return result;
    }

    private IPath[] computeProjectsAndJars(IJavaProject project) throws JavaModelException {
        HashSet<IPath> set = new HashSet<IPath>();
        if (ResourceUtils.isJavaProject(project.getProject())) {
            IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot pkgFragmentRoot = roots[i];
                if (pkgFragmentRoot.getKind() == 1) {
                    set.add(pkgFragmentRoot.getParent().getPath());
                }
                ++i;
            }
            this.computeDependents(project, set, new HashSet());
        }
        IPath[] result = new IPath[set.size()];
        set.toArray(result);
        return result;
    }

    private void computeDependents(IJavaProject project, HashSet set, HashSet visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IProject[] dependents = project.getProject().getReferencingProjects();
        int i = 0;
        while (i < dependents.length) {
            try {
                IJavaProject dependent = JavaCore.create((IProject)dependents[i]);
                IPackageFragmentRoot[] roots = dependent.getPackageFragmentRoots();
                set.add(dependent.getPath());
                int j = 0;
                while (j < roots.length) {
                    IPackageFragmentRoot pkgFragmentRoot = roots[j];
                    if (pkgFragmentRoot.isArchive()) {
                        set.add(pkgFragmentRoot.getPath());
                    }
                    ++j;
                }
                this.computeDependents(dependent, set, visited);
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
    }

    public boolean encloses(String resourcePath) {
        int separatorIndex = resourcePath.indexOf("|");
        return separatorIndex == -1 && this.elements_.indexOf(resourcePath) != -1;
    }

    public boolean encloses(IJavaElement element) {
        return true;
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.needsRefresh_) {
            try {
                this.refresh();
            }
            catch (JavaModelException javaModelException) {
                return new IPath[0];
            }
        }
        return this.enclosingProjectsAndJars_;
    }

    protected void initialize() throws JavaModelException {
        if (this.searchTypes_ == null || !this.needsRefresh_) {
            return;
        }
        this.needsRefresh_ = false;
        this.elements_ = new ArrayList();
        int i = 0;
        while (i < this.searchTypes_.length) {
            IPackageFragmentRoot srcPackage = J2CUICoreHelper.getDefault().getSourcePackage(this.searchTypes_[i]);
            IJavaElement[] elements = srcPackage.getChildren();
            HashMap<IResource, IResource> resources = new HashMap<IResource, IResource>();
            int ii = 0;
            while (ii < elements.length) {
                if (elements[ii] instanceof IPackageFragment) {
                    IPackageFragment fragment = (IPackageFragment)elements[ii];
                    ICompilationUnit[] cUs = fragment.getCompilationUnits();
                    int t = 0;
                    while (t < cUs.length) {
                        String strSource = cUs[t].getSource();
                        if (strSource.indexOf("@j2c.") > 0 && strSource.indexOf("@generated") > 0) {
                            IType[] types = cUs[t].getAllTypes();
                            int o = 0;
                            while (o < types.length) {
                                IResource resource = types[o].getResource();
                                if (resource != null && resources.get(resource) == null && this.checkProject(resource.getProject())) {
                                    resources.put(resource, resource);
                                    this.elements_.add(resource.getFullPath().toString());
                                }
                                ++o;
                            }
                        }
                        ++t;
                    }
                }
                ++ii;
            }
            ++i;
        }
    }

    protected void refresh() throws JavaModelException {
        this.initialize();
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }

    private boolean checkProject(IProject project) {
        if (project == null) {
            return false;
        }
        if (this.enclosingProjects_ == null) {
            return true;
        }
        int i = 0;
        while (i < this.enclosingProjects_.length) {
            if (project.equals((Object)this.enclosingProjects_[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

