/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.core.internal.rar;

import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.internal.ResourceAdapterRegistry;
import com.ibm.j2c.ui.core.internal.rar.RARImportManager;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.jca.Connector;
import org.eclipse.jst.javaee.jca.JcaFactory;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.IArchive;

public class RARInfo {
    private boolean isInWorkspace = false;
    private String rarURI;
    private IArchive rarFile = null;
    private com.ibm.adapter.j2ca.Connector connector = null;

    public RARInfo(IArchive rarFile) {
        this.rarFile = rarFile;
        if (rarFile.getPath() != null) {
            this.rarURI = rarFile.getPath().lastSegment();
        }
        this.isInWorkspace = true;
    }

    public RARInfo(String rarURI) {
        this.rarURI = rarURI;
        this.isInWorkspace = false;
    }

    public void dispose() {
        if (this.rarFile != null) {
            JavaEEArchiveUtilities.INSTANCE.closeArchive(this.rarFile);
        }
    }

    public boolean isInWorkspace() {
        return this.isInWorkspace;
    }

    public IArchive getRARFile() {
        if (this.rarFile == null && this.rarURI != null) {
            this.rarFile = RARImportManager.getInstance().getRARFile(this.rarURI);
        }
        return this.rarFile;
    }

    public com.ibm.adapter.j2ca.Connector getConnector() {
        block15: {
            if (this.connector != null) {
                return this.connector;
            }
            IArchive tempRar = this.getRARFile();
            if (tempRar != null) {
                if (tempRar.containsArchiveResource((IPath)new Path("META-INF/ra.xml"))) {
                    try {
                        Object modelObj = tempRar.getModelObject();
                        if (modelObj instanceof Connector) {
                            Connector aConnector = (Connector)modelObj;
                            this.connector = new com.ibm.adapter.j2ca.Connector(aConnector);
                            return this.connector;
                        }
                        if (modelObj instanceof org.eclipse.jst.j2ee.jca.Connector) {
                            org.eclipse.jst.j2ee.jca.Connector aConnector = (org.eclipse.jst.j2ee.jca.Connector)modelObj;
                            this.connector = new com.ibm.adapter.j2ca.Connector(aConnector);
                            return this.connector;
                        }
                        break block15;
                    }
                    catch (ArchiveModelLoadException archiveModelLoadException) {
                        return null;
                    }
                }
                if (this.isInWorkspace) {
                    IProject aConnectorProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.rarURI);
                    IResourceAdapterDescriptor descriptor = ResourceAdapterRegistry.getRegistry().getResourceAdapterForProject(aConnectorProject);
                    if (descriptor != null) {
                        this.connector = descriptor.getConnector();
                    }
                } else {
                    String rarName = tempRar.getPath().removeFileExtension().lastSegment();
                    if (rarName.startsWith("cicseci")) {
                        String version = "unknown";
                        if (rarName.length() > 7) {
                            char[] charArray;
                            version = rarName.substring(7);
                            StringBuffer sb = new StringBuffer();
                            char[] cArray = charArray = version.toCharArray();
                            int n = charArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                char c = cArray[n2];
                                sb.append(c);
                                if (Character.isDigit(c)) {
                                    sb.append('.');
                                }
                                ++n2;
                            }
                            if (sb.charAt(sb.length() - 1) == '.') {
                                sb.deleteCharAt(sb.length() - 1);
                            }
                            version = sb.toString();
                        }
                        Connector conn16 = JcaFactory.eINSTANCE.createConnector();
                        conn16.setEisType("CICS");
                        conn16.setMetadataComplete(false);
                        conn16.setVendorName("IBM");
                        conn16.setVersion("1.6");
                        conn16.setResourceadapterVersion(version);
                        List displayNames = conn16.getDisplayNames();
                        DisplayName dispName = JavaeeFactory.eINSTANCE.createDisplayName();
                        dispName.setValue("ECIResourceAdapter");
                        dispName.setLang("en");
                        displayNames.add(dispName);
                        List descriptions = conn16.getDescriptions();
                        Description desc = JavaeeFactory.eINSTANCE.createDescription();
                        desc.setValue("CICS JEE ECI Resource Adapter");
                        desc.setLang("en");
                        descriptions.add(desc);
                        this.connector = new com.ibm.adapter.j2ca.Connector(conn16);
                    }
                }
                return this.connector;
            }
        }
        return null;
    }

    public void importIfNeeded(IProgressMonitor monitor) {
        if (!this.isInWorkspace() && this.rarURI != null) {
            RARImportManager.getInstance().importIfNeeded(this.rarURI, monitor);
            this.isInWorkspace = true;
        }
    }

    public String getRARURI() {
        if (this.rarURI == null && this.getRARFile() != null) {
            this.rarURI = this.isInWorkspace ? (this.getRARFile().getPath() == null ? null : this.getRARFile().getPath().lastSegment()) : (this.getRARFile().getPath() == null ? null : this.getRARFile().getPath().toPortableString());
        }
        return this.rarURI;
    }

    public void setRARURI(String rarURI) {
        this.rarURI = rarURI;
    }
}

