/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.core.internal.rar;

import com.ibm.adapter.j2ca.Connector;
import com.ibm.j2c.ui.core.CorePlugin;
import com.ibm.j2c.ui.core.internal.rar.RARInfo;
import com.ibm.j2c.ui.core.internal.utilities.J2CUICoreHelper;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentImportDataModelProvider;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class RARImportManager {
    private static RARImportManager importManager;
    private boolean extensionsLoaded = false;
    private List<String> rarDirectories = new ArrayList<String>();
    private List<String> rarURIs = new ArrayList<String>();
    private static FilenameFilter filter;
    private static FileFilter directoryFilter;

    static {
        filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rar");
            }
        };
        directoryFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
    }

    public static RARImportManager getInstance() {
        if (importManager == null) {
            importManager = new RARImportManager();
        }
        return importManager;
    }

    public List getRARURIs() {
        return this.rarURIs;
    }

    public IArchive getRARFile(String rarFileURI) {
        if (!this.rarURIs.contains(rarFileURI)) {
            this.rarURIs.add(rarFileURI);
        }
        try {
            IArchive archive = null;
            Path path = new Path(rarFileURI);
            archive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)path);
            archive.setPath((IPath)path);
            return archive;
        }
        catch (Exception e) {
            Status status = new Status(4, CorePlugin.getDefault().getBundle().getSymbolicName(), e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), (Throwable)e);
            CorePlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    public Connector getConnectorModule(String rarFileURI) {
        IArchive rarFile = this.getRARFile(rarFileURI);
        RARInfo info = new RARInfo(rarFile);
        Connector aConn = info.getConnector();
        info.dispose();
        return aConn;
    }

    public List<RARInfo> getWorkspaceRARInfos() {
        ArrayList<RARInfo> rarInfos = new ArrayList<RARInfo>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IVirtualComponent component = this.isConnectorProject(projects[i]);
            if (component != null) {
                IArchive archive = null;
                try {
                    archive = JavaEEArchiveUtilities.INSTANCE.openArchive(component);
                    archive.setPath(component.getProject().getFullPath());
                    JavaEEQuickPeek jqp = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(archive);
                    RARInfo info = new RARInfo(archive);
                    if (jqp.getJavaEEVersion() != 60 || info.getConnector() != null) {
                        rarInfos.add(info);
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, CorePlugin.getDefault().getBundle().getSymbolicName(), e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage(), (Throwable)e);
                    CorePlugin.getDefault().getLog().log((IStatus)status);
                }
            }
            ++i;
        }
        return rarInfos;
    }

    private IVirtualComponent isConnectorProject(IProject project) {
        if (ResourceUtils.isJCAProject(project)) {
            return ComponentCore.createComponent((IProject)project);
        }
        return null;
    }

    public static boolean isEqual(Connector conn1, Connector conn2) {
        if (conn1.is15Connector() ^ conn2.is15Connector()) {
            return false;
        }
        if (conn1.isMetaDataComplete() ^ conn2.isMetaDataComplete()) {
            return false;
        }
        if (conn1.is15Connector()) {
            try {
                if (conn1.getJca15Connector().getVersionID() != conn2.getJca15Connector().getVersionID()) {
                    return false;
                }
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return conn1.getEisType().equals(conn2.getEisType()) && conn1.getVendorName().equals(conn2.getVendorName()) && conn1.getVersion().equals(conn2.getVersion()) && conn1.getDisplayName().equals(conn2.getDisplayName());
    }

    public List<RARInfo> getRARInfos() {
        ArrayList<RARInfo> rarInfoList = new ArrayList<RARInfo>();
        List<RARInfo> workspaceRARInfos = this.getWorkspaceRARInfos();
        rarInfoList.addAll(workspaceRARInfos);
        List<String> availableRars = this.getAvailableRARs();
        int i = 0;
        while (i < availableRars.size()) {
            String rarURI = availableRars.get(i);
            boolean foundMatch = false;
            RARInfo rarInfo = new RARInfo(rarURI);
            try {
                Connector rarURIConnector = rarInfo.getConnector();
                int j = 0;
                while (j < workspaceRARInfos.size()) {
                    RARInfo workspaceRARInfo = workspaceRARInfos.get(j);
                    if (RARImportManager.isEqual(workspaceRARInfo.getConnector(), rarURIConnector)) {
                        foundMatch = true;
                        workspaceRARInfo.setRARURI(rarURI);
                        break;
                    }
                    ++j;
                }
                if (!foundMatch) {
                    rarInfoList.add(rarInfo);
                } else {
                    rarInfo.dispose();
                }
            }
            catch (Exception exception) {
                rarInfo.dispose();
            }
            ++i;
        }
        return rarInfoList;
    }

    public List<String> getAvailableRARs() {
        ArrayList<String> rarList = new ArrayList<String>();
        if (!this.extensionsLoaded()) {
            this.loadExtensions();
        }
        int i = 0;
        while (i < this.rarDirectories.size()) {
            String dir = this.rarDirectories.get(i);
            Path path = new Path(dir);
            Location lo = Platform.getInstallLocation();
            File fl = new File(lo.getURL().getFile());
            Path eclipsePath = new Path(fl.getPath());
            eclipsePath = (Path)eclipsePath.removeLastSegments(1);
            if (!path.isAbsolute()) {
                path = (Path)eclipsePath.append((IPath)path);
            }
            File dirFile = path.toFile();
            this.getRARNames(dirFile, rarList);
            ++i;
        }
        return rarList;
    }

    private void getRARNames(File dirFile, List<String> rarList) {
        File[] rars = dirFile.listFiles(filter);
        if (rars == null) {
            return;
        }
        int j = 0;
        while (j < rars.length) {
            rarList.add(rars[j].getAbsolutePath());
            ++j;
        }
        File[] directories = dirFile.listFiles(directoryFilter);
        int j2 = 0;
        while (j2 < directories.length) {
            this.getRARNames(directories[j2], rarList);
            ++j2;
        }
    }

    private void loadExtensions() {
        if (!this.extensionsLoaded()) {
            IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] configElements = extRegistry.getConfigurationElementsFor("com.ibm.j2c.ui.core.rardirectory");
            if (configElements != null) {
                int i = 0;
                while (i < configElements.length) {
                    String res;
                    String at2;
                    IConfigurationElement configElement = configElements[i];
                    String attr = configElement.getAttribute("name");
                    if (attr != null) {
                        this.rarDirectories.add(attr);
                    }
                    if ((at2 = configElement.getAttribute("systemvariable")) != null && (res = System.getProperty(at2)) != null) {
                        this.rarDirectories.add(res);
                    }
                    ++i;
                }
            }
            this.extensionsLoaded = true;
        }
    }

    private boolean extensionsLoaded() {
        return this.extensionsLoaded;
    }

    public IArchive importIfNeeded(String rarPath, IProgressMonitor monitor) {
        return this.importIfNeeded(rarPath, monitor, null, null);
    }

    public IArchive importIfNeeded(String rarPath, IProgressMonitor monitor, boolean force7Target, String sCPName) {
        if (force7Target) {
            return this.importIfNeeded(rarPath, monitor, sCPName, "com.ibm.ws.ast.st.runtime.v70");
        }
        return this.importIfNeeded(rarPath, monitor, sCPName, null);
    }

    public IArchive importIfNeeded(String rarPath, IProgressMonitor monitor, String sCPName, String runtimeID) {
        Object archiveFile = this.newImportIfNeeded(rarPath, monitor, sCPName, runtimeID);
        if (archiveFile instanceof IArchive) {
            return (IArchive)archiveFile;
        }
        return null;
    }

    public Object newImportIfNeeded(String rarPath, IProgressMonitor monitor, String sCPName, String runtimeID) {
        IDataModel importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorComponentImportDataModelProvider());
        importDataModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)rarPath);
        if (sCPName != null) {
            importDataModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)sCPName);
        }
        importDataModel.setBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", false);
        J2CUICoreHelper.getDefault().populateModelsTargetRuntime(importDataModel, runtimeID);
        IDataModelOperation runnable = importDataModel.getDefaultOperation();
        try {
            runnable.execute(monitor, null);
            Object archiveFile = importDataModel.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
            importDataModel.dispose();
            return archiveFile;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            importDataModel.dispose();
            return null;
        }
    }

    public String getRarPath(String sName, String sVendorName, String sVersion) {
        String res = null;
        List<String> lRars = this.getAvailableRARs();
        int i = 0;
        while (i < lRars.size()) {
            String sTemp = lRars.get(i);
            Connector con = this.getConnectorModule(sTemp);
            if (con.getVendorName().equals(sVendorName.trim()) && con.getEisType().equals(sName.trim()) && con.getVersion().equals(sVersion.trim())) {
                return sTemp;
            }
            ++i;
        }
        return res;
    }
}

