/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.cobol.spi.properties;

import com.ibm.adapter.cobol.CobolMessageResource;
import com.ibm.adapter.cobol.spi.properties.CobolBaseProperty;
import com.ibm.adapter.cobol.spi.properties.CobolCodepageProperty;
import com.ibm.adapter.cobol.spi.properties.CobolCompilerOptionsPropertyGroup;
import com.ibm.adapter.cobol.spi.properties.CobolEndianPropertyGroup;
import com.ibm.adapter.cobol.spi.properties.CobolExtDecimalSignPropertyGroup;
import com.ibm.adapter.cobol.spi.properties.CobolFloatingPointFormatProperty;
import com.ibm.adapter.cobol.spi.properties.CobolNumprocProperty;
import com.ibm.adapter.cobol.spi.properties.CobolPlatformProperty;
import com.ibm.etools.cobol.plugin.CobolPlugin;
import com.ibm.etools.cobol.preference.ui.common.ICobolUIPreferenceConstants;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;

public class CobolDiscoveryAgentPropertyGroup
extends BasePropertyGroup {
    private IPreferenceStore store = CobolPlugin.getDefault().getPreferenceStore();

    public CobolDiscoveryAgentPropertyGroup() throws CoreException {
        super(CobolMessageResource.COBOL_AGENT_PROP_GROUP_NAME, CobolMessageResource.COBOL_AGENT_PROP_GROUP_DISPLAY_NAME, CobolMessageResource.COBOL_AGENT_PROP_GROUP_DESC);
        this.initializeSearchParameters();
        this.setValuesFromPreferenceStore((IPropertyGroup)this);
    }

    private void initializeSearchParameters() throws CoreException {
        CobolPlatformProperty platform = new CobolPlatformProperty();
        CobolCodepageProperty codepage = new CobolCodepageProperty();
        CobolFloatingPointFormatProperty floatpointformat = new CobolFloatingPointFormatProperty();
        CobolNumprocProperty numproc = new CobolNumprocProperty();
        CobolExtDecimalSignPropertyGroup extdecimalsigngroup = new CobolExtDecimalSignPropertyGroup();
        CobolEndianPropertyGroup endiangroup = new CobolEndianPropertyGroup();
        CobolCompilerOptionsPropertyGroup compileroptionsgroup = new CobolCompilerOptionsPropertyGroup();
        if (platform.getEnvStatus().getSeverity() != 0) {
            throw new CoreException((IStatus)platform.getEnvStatus());
        }
        if (codepage.getEnvStatus().getSeverity() != 0) {
            throw new CoreException((IStatus)codepage.getEnvStatus());
        }
        if (floatpointformat.getEnvStatus().getSeverity() != 0) {
            throw new CoreException((IStatus)floatpointformat.getEnvStatus());
        }
        if (endiangroup.getEnvStatus().getSeverity() != 0) {
            throw new CoreException((IStatus)codepage.getEnvStatus());
        }
        if (extdecimalsigngroup.getEnvStatus().getSeverity() != 0) {
            throw new CoreException((IStatus)codepage.getEnvStatus());
        }
        if (compileroptionsgroup.getEnvStatus().getSeverity() != 0) {
            throw new CoreException((IStatus)codepage.getEnvStatus());
        }
        if (numproc.getEnvStatus().getSeverity() != 0) {
            throw new CoreException((IStatus)numproc.getEnvStatus());
        }
        platform.addPropertyChangeListener((IPropertyChangeListener)codepage);
        platform.addPropertyChangeListener((IPropertyChangeListener)floatpointformat);
        platform.addPropertyChangeListener(extdecimalsigngroup);
        platform.addPropertyChangeListener(endiangroup);
        this.addProperty((IPropertyDescriptor)platform);
        this.addProperty((IPropertyDescriptor)codepage);
        this.addProperty((IPropertyDescriptor)numproc);
        this.addProperty((IPropertyDescriptor)floatpointformat);
        this.addProperty((IPropertyDescriptor)extdecimalsigngroup);
        this.addProperty((IPropertyDescriptor)endiangroup);
        this.addProperty((IPropertyDescriptor)compileroptionsgroup);
    }

    public Object clone() throws CloneNotSupportedException {
        CobolDiscoveryAgentPropertyGroup clone = (CobolDiscoveryAgentPropertyGroup)((Object)super.clone());
        CobolPlatformProperty platform = (CobolPlatformProperty)clone.getProperty(CobolMessageResource.PLATFORM_PROP_NAME);
        CobolCodepageProperty codepage = (CobolCodepageProperty)clone.getProperty(CobolMessageResource.CODEPAGE_PROP_NAME);
        CobolFloatingPointFormatProperty floatpointformat = (CobolFloatingPointFormatProperty)clone.getProperty(CobolMessageResource.FLOATING_POINT_FORMAT_PROP_NAME);
        CobolExtDecimalSignPropertyGroup extdecimalsigngroup = (CobolExtDecimalSignPropertyGroup)clone.getProperty(CobolMessageResource.EXTERNAL_DECIMAL_SIGN_PROP_GROUP_NAME);
        CobolEndianPropertyGroup endiangroup = (CobolEndianPropertyGroup)clone.getProperty(CobolMessageResource.ENDIAN_PROP_GROUP_NAME);
        platform.addVetoablePropertyChangeListener((IVetoableChangeListener)platform);
        platform.addPropertyChangeListener((IPropertyChangeListener)codepage);
        platform.addPropertyChangeListener((IPropertyChangeListener)floatpointformat);
        platform.addPropertyChangeListener(extdecimalsigngroup);
        platform.addPropertyChangeListener(endiangroup);
        return clone;
    }

    private void setValuesFromPreferenceStore(IPropertyGroup group) throws CoreException {
        if (this.store == null) {
            return;
        }
        List<IPropertyDescriptor> list = Arrays.asList(group.getProperties());
        int i = 0;
        while (i < list.size()) {
            CobolBaseProperty property;
            String cobolKey;
            IPropertyDescriptor element = list.get(i);
            if (element instanceof IPropertyGroup) {
                this.setValuesFromPreferenceStore((IPropertyGroup)element);
            } else if (element instanceof CobolBaseProperty && this.store.contains(cobolKey = (property = (CobolBaseProperty)element).getCobolKey())) {
                String cobolValue = null;
                cobolValue = cobolKey.equals("com.ibm.etools.cobol.COBOL_PLATFORM_SELECTION") ? ICobolUIPreferenceConstants.PS_ITEM[this.store.getInt(cobolKey)] : (cobolKey.equals("com.ibm.etools.cobol.COBOL_FLOATING_POINT_FORMAT") ? ICobolUIPreferenceConstants.FPF_ITEM[this.store.getInt(cobolKey)] : this.store.getString(cobolKey));
                if (property.isEnabled()) {
                    property.setValue(cobolValue);
                }
            }
            ++i;
        }
    }
}

