/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.cobol;

import com.ibm.adapter.cobol.CobolDiscoveryAgent;
import com.ibm.adapter.cobol.CobolImportResult;
import com.ibm.adapter.cobol.CobolMessageResource;
import com.ibm.adapter.cobol.MPOCobolDiscoveryAgentMetaData;
import com.ibm.adapter.cobol.MPOCobolImportResult;
import com.ibm.adapter.cobol.spi.properties.CobolFileProperty;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IDiscoveryAgentMetaData;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.ISearchTree;
import com.ibm.adapter.framework.spi.BaseDiscoveryAgent;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.cobol.importer.CobolSourceResource;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class MPOCobolDiscoveryAgent
extends BaseDiscoveryAgent {
    private static String[] FILE_EXT = new String[]{"ccp", "cob", "cbl", "cpy", "java"};
    private URI filePathURI;
    private File filePath;
    private MPOCobolImportResult importResult;
    private CobolDiscoveryAgent discoveryAgent;
    private boolean isJava = false;
    private boolean isInitialized = false;

    public MPOCobolDiscoveryAgent() {
        this.setMetaData((IDiscoveryAgentMetaData)new MPOCobolDiscoveryAgentMetaData());
    }

    public String[] getConfiguration() {
        return new String[]{"SUPPORTS_ITERATION"};
    }

    public IDiscoveryAgent newInstance() {
        return new MPOCobolDiscoveryAgent();
    }

    private void resetState() {
        if (this.discoveryAgent == null) {
            this.discoveryAgent = new CobolDiscoveryAgent();
        }
        this.filePathURI = null;
        this.filePath = null;
        this.isJava = false;
        this.importResult = null;
        this.isInitialized = false;
    }

    public IPropertyGroup getInitializeProperties() throws BaseException {
        this.resetState();
        if (this.initializeProperties == null) {
            try {
                BasePropertyGroup propertyGroup = new BasePropertyGroup(CobolMessageResource.COBOL_FILE_PROP_GROUP_NAME, CobolMessageResource.COBOL_FILE_PROP_GROUP_DISPLAY_NAME, CobolMessageResource.COBOL_FILE_PROP_GROUP_DESC);
                CobolFileProperty fileProperty = new CobolFileProperty(CobolMessageResource.COBOL_FILE_PROP_NAME, CobolMessageResource.MPO_FILE_PROP_DISPLAY_NAME, CobolMessageResource.MPO_FILE_PROP_DESC, propertyGroup, FILE_EXT);
                fileProperty.setRequired(true);
                this.initializeProperties = propertyGroup;
            }
            catch (CoreException e) {
                throw new BaseException(e.getStatus());
            }
        }
        this.discoveryAgent.setInitializeProperties(this.initializeProperties);
        this.isInitialized = true;
        return this.discoveryAgent.getInitializeProperties();
    }

    public void initializeContext(Object[] context) throws BaseException {
        this.importResult = (MPOCobolImportResult)((Object)context[0]);
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
        if (!this.isInitialized) {
            this.throwException();
        }
        CobolFileProperty fileProperty = (CobolFileProperty)initializeProperties.getProperty(CobolMessageResource.COBOL_FILE_PROP_NAME);
        this.filePathURI = (URI)fileProperty.getValue();
        if (this.filePathURI.toString().toLowerCase().endsWith(".java")) {
            if (this.filePathURI.toString().endsWith(".java")) {
                this.filePath = new File(this.filePathURI.toFileString());
                if (!this.filePath.exists()) {
                    String message = NLS.bind((String)CobolMessageResource.FILE_NOT_FOUND, (Object[])new String[]{this.filePathURI.toString()});
                    Status newStatus = new Status(4, "com.ibm.adapter.cobol", 4, message, null);
                    throw new BaseException((IStatus)newStatus);
                }
            }
            this.isJava = true;
        } else {
            this.isJava = false;
        }
        this.discoveryAgent.initialize(environment, initializeProperties);
    }

    public ISearchTree getSearchTree() throws BaseException {
        if (!this.isInitialized) {
            this.throwException();
        }
        return this.discoveryAgent.getSearchTree();
    }

    public IImportResult performImport(IEnvironment environment, IResultNodeSelection selectedNodes) throws BaseException {
        CobolImportResult result;
        if (!this.isInitialized) {
            this.throwException();
        }
        if (this.isJava) {
            result = new CobolImportResult(this.filePathURI);
            result.setImportFile(this.filePath);
        } else {
            result = (CobolImportResult)this.discoveryAgent.performImport(environment, selectedNodes);
        }
        if (this.importResult == null) {
            this.importResult = new MPOCobolImportResult();
        }
        this.checkIfImported(result);
        this.importResult.setImportData((Object)result);
        return this.importResult;
    }

    public void close() throws BaseException {
        this.discoveryAgent = null;
        this.isInitialized = false;
    }

    private void throwException() throws BaseException {
        Status newStatus = new Status(4, "com.ibm.adapter.cobol", 4, CobolMessageResource.INITIALIZATION_REQUIRED, null);
        throw new BaseException((IStatus)newStatus);
    }

    private void checkIfImported(CobolImportResult newResult) throws BaseException {
        Object newImportData = newResult.getImportData();
        ArrayList resultList = (ArrayList)this.importResult.getImportData();
        int i = 0;
        while (i < resultList.size()) {
            File newFile;
            boolean theSameImportFile = false;
            boolean theSameSelectedElement = false;
            CobolImportResult oldResult = (CobolImportResult)((Object)resultList.get(i));
            File oldFile = oldResult.getImportFile();
            if (oldFile.compareTo(newFile = newResult.getImportFile()) == 0) {
                theSameImportFile = true;
            }
            Object oldImportData = oldResult.getImportData();
            if (newImportData instanceof URI && oldImportData instanceof URI) {
                if (theSameImportFile) {
                    String message = NLS.bind((String)CobolMessageResource.RESOURCE_ALREADY_IMPORTED, (Object[])new String[]{oldFile.getName()});
                    Status newStatus = new Status(4, "com.ibm.adapter.cobol", 4, message, null);
                    throw new BaseException((IStatus)newStatus);
                }
            } else if (newImportData instanceof COBOLElement && oldImportData instanceof COBOLElement) {
                String newElementName;
                String oldElementName = CobolSourceResource.getRefId((EObject)((COBOLElement)oldImportData));
                if (oldElementName.equals(newElementName = CobolSourceResource.getRefId((EObject)((COBOLElement)newImportData)))) {
                    theSameSelectedElement = true;
                }
                if (theSameImportFile && theSameSelectedElement) {
                    String message = NLS.bind((String)CobolMessageResource.TYPE_ALREADY_IMPORTED, (Object[])new String[]{oldElementName});
                    Status newStatus = new Status(4, "com.ibm.adapter.cobol", 4, message, null);
                    throw new BaseException((IStatus)newStatus);
                }
            }
            ++i;
        }
    }
}

