/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.pli.writer;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IPublishingSet;
import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.adapter.framework.internal.registry.Classification;
import com.ibm.adapter.framework.spi.BaseResourceWriter;
import com.ibm.adapter.framework.util.QNameHelper;
import com.ibm.adapter.pli.PliDiscoveryAgentPlugin;
import com.ibm.adapter.pli.PliMessageResource;
import com.ibm.adapter.pli.writer.XMIFileProperty;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class PliWorkspaceXMIWriter
extends BaseResourceWriter {
    private static QName outputQname = null;
    private static QName acceptedImportQname = null;
    private static String[] xmiFileExt = new String[]{"xmi", "XMI"};
    private static QName[] accpetedKinds = null;
    private static QName writerQname = null;
    private PLIElement element = null;
    private Classification[] classification = new Classification[]{Classification.UNCLASSIFIED};
    public static final String URI_RESOURCE_PREFIX = "platform:/resource";
    public static final String URI_FILE_PREFIX = "file:";

    public PliWorkspaceXMIWriter() {
        acceptedImportQname = QNameHelper.createQName((String)PliDiscoveryAgentPlugin.getResourceString("PLI_KIND_NAMESPACE"), (String)PliDiscoveryAgentPlugin.getResourceString("PLI_DA_IMPORT_KIND"));
        outputQname = QNameHelper.createQName((String)PliDiscoveryAgentPlugin.getResourceString("PLI_KIND_NAMESPACE"), (String)PliDiscoveryAgentPlugin.getResourceString("XMI_WRW_OUTPUT_KIND"));
        writerQname = QNameHelper.createQName((String)PliDiscoveryAgentPlugin.getResourceString("PLI_KIND_NAMESPACE"), (String)PliDiscoveryAgentPlugin.getResourceString("XMI_WRW_QNAME"));
    }

    public boolean acceptsImportResult(IImportResult result) {
        boolean ret = false;
        return ret;
    }

    public QName getName() {
        return writerQname;
    }

    private IPropertyGroup getWriteProperties() {
        try {
            BasePropertyGroup propertyGroup = new BasePropertyGroup("", null, "");
            new XMIFileProperty(PliMessageResource.XMI_FILE_PROP_NAME, PliMessageResource.XMI_FILE_PROP_DISPLAY_NAME, PliMessageResource.XMI_FILE_PROP_DESC, propertyGroup, xmiFileExt);
            return propertyGroup;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URI writeToWorkspace(IPropertyGroup writeProperties, IEnvironment environment) throws BaseException {
        URI retURI = null;
        try {
            if (this.element == null) {
                Status envStatus = new Status(4, "com.ibm.adapter.pli", 4, "Import Result was not passed in", null);
                throw new BaseException((IStatus)envStatus);
            }
            HashMap options = new HashMap();
            XMIFileProperty outputFileProperty = (XMIFileProperty)writeProperties.getProperty(PliMessageResource.XMI_FILE_PROP_NAME);
            retURI = (URI)outputFileProperty.getValue();
            if (retURI == null) {
                Status envStatus = new Status(4, "com.ibm.adapter.pli", 4, PliMessageResource.ERROR_EMPTY_XMI_FILE, null);
                throw new BaseException((IStatus)envStatus);
            }
            this.element.eResource().setURI(retURI);
            this.element.eResource().save(options);
        }
        catch (Exception e1) {
            Status envStatus = new Status(4, "com.ibm.adapter.pli", 4, PliMessageResource.ERROR_SERIALIZING_MODEL, (Throwable)e1);
            throw new BaseException((IStatus)envStatus);
        }
        return retURI;
    }

    public QName getOutputKind() {
        return outputQname;
    }

    public QName[] getAcceptedImportKinds() {
        if (accpetedKinds == null) {
            accpetedKinds = new QName[]{acceptedImportQname};
        }
        return accpetedKinds;
    }

    public IPropertyGroup initialize(IEnvironment environment, IImportResult importResult) throws BaseException {
        try {
            this.element = (PLIElement)importResult.getImportData();
            return this.getWriteProperties();
        }
        catch (Exception exception) {
            Status envStatus = new Status(4, "com.ibm.adapter.pli", 4, "Import Result was not passed in", null);
            throw new BaseException((IStatus)envStatus);
        }
    }

    public String getDescription() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public IResourceWriter newInstance() throws BaseException {
        return new PliWorkspaceXMIWriter();
    }

    public Classification[] getClassification() {
        return this.classification;
    }

    public void setClassification(Classification[] classification) {
        this.classification = classification;
    }

    public void close() throws BaseException {
    }

    public IPublishingSet createPublishingSet(IImportResult result) throws BaseException {
        return null;
    }

    public IPropertyGroup getInitializeProperties() throws BaseException {
        return null;
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
    }

    public URI performWrite(IEnvironment environment, IPublishingSet publishingSet) throws BaseException {
        return null;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

