/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.pli.spi.properties;

import com.ibm.adapter.pli.PliMessageResource;
import com.ibm.adapter.pli.spi.properties.PliBaseProperty;
import com.ibm.adapter.pli.spi.properties.PliIMSSupportProperty;
import com.ibm.ccl.pli.importer.IPliPreferenceConstants;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class PliCICSVersionProperty
extends PliBaseProperty {
    public static final String copyright = "Licensed Materials - Property of IBM\ncom.ibm.adapter.pli\nCopyright IBM Corporation 2007. All Rights Reserved.\nNote to U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String[] validValues;

    public PliCICSVersionProperty() throws CoreException {
        super(PliCICSVersionProperty.getPropertyName(), PliMessageResource.CICS_VERSION_LABEL_UI_, PliMessageResource.CICS_VERSION_LABEL_UI_);
        this.initializeProperty();
    }

    static String getPropertyName() {
        return PliMessageResource.CICS_VERSION_PROPNAME_UI_;
    }

    private void initializeProperty() {
        this.pliKey = "com.ibm.ccl.pli.PLI_CICS_VERSION";
        this.setExpert(true);
        if (this.validValues == null) {
            this.validValues = new String[]{IPliPreferenceConstants.CICSNONELABEL, IPliPreferenceConstants.CICS31LABEL, IPliPreferenceConstants.CICS32LABEL};
        }
        this.setDefaultValue(IPliPreferenceConstants.CICSNONELABEL);
        try {
            super.setValidValues((Object[])this.validValues);
            this.setValue(IPliPreferenceConstants.CICSNONELABEL);
        }
        catch (CoreException e) {
            this.envStatus = new Status(4, "com.ibm.adapter.pli", 4, e.getMessage(), (Throwable)e);
        }
        this.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String value;
        if (evt.getSource() instanceof PliIMSSupportProperty && (value = (String)evt.getNewValue()) != null) {
            if (value.equals("true")) {
                this.setEnabled(false);
            } else if (value.equals("false")) {
                this.setEnabled(true);
            }
        }
        super.propertyChange(evt);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        boolean valid = false;
        int i = 0;
        while (i < this.validValues.length) {
            if (((String)evt.getNewValue()).equalsIgnoreCase(this.validValues[i])) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            throw new PropertyVetoException(PliMessageResource.INVALID_PROPERTY_VALUE, (java.beans.PropertyChangeEvent)evt);
        }
    }
}

