/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.pli;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IDiscoveryAgentMetaData;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IResultNode;
import com.ibm.adapter.framework.IResultNodeSelection;
import com.ibm.adapter.framework.ISearchTree;
import com.ibm.adapter.framework.spi.BaseDiscoveryAgent;
import com.ibm.adapter.pli.PliDiscoveryAgentMetaData;
import com.ibm.adapter.pli.PliImportResult;
import com.ibm.adapter.pli.PliMessageResource;
import com.ibm.adapter.pli.PliSearchTree;
import com.ibm.adapter.pli.spi.properties.PliFileProperty;
import com.ibm.ccl.pli.PLIElement;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;

public class PliDiscoveryAgent
extends BaseDiscoveryAgent {
    private String pliFilePath = null;
    private URI pliFilePathURI = null;
    private boolean isInitialized = false;
    private Resource importerResource;
    private String[] pliFileExt = new String[]{"pli", "inc", "mac"};

    public PliDiscoveryAgent() {
        this.setMetaData((IDiscoveryAgentMetaData)new PliDiscoveryAgentMetaData());
    }

    public IDiscoveryAgent newInstance() {
        return new PliDiscoveryAgent();
    }

    private void validatePliFile(URI pliFilePathURI) throws BaseException {
        File pliFile;
        if (pliFilePathURI.isFile() && (pliFile = new File(pliFilePathURI.toFileString())).exists()) {
            this.pliFilePath = pliFile.getPath();
            String fileName = pliFile.getName().toLowerCase();
            int i = 0;
            while (i < this.pliFileExt.length) {
                if (fileName.endsWith(this.pliFileExt[i]) && pliFile.canRead() && pliFile.length() != 0L) {
                    return;
                }
                ++i;
            }
        }
        Status newStatus = new Status(4, "com.ibm.adapter.pli", 4, PliMessageResource.INVALID_PLI_FILE, null);
        throw new BaseException((IStatus)newStatus);
    }

    public IPropertyGroup getInitializeProperties() throws BaseException {
        if (this.initializeProperties == null) {
            try {
                BasePropertyGroup propertyGroup = new BasePropertyGroup(PliMessageResource.PLI_FILE_PROP_GROUP_NAME, PliMessageResource.PLI_FILE_PROP_GROUP_DISPLAY_NAME, PliMessageResource.PLI_FILE_PROP_GROUP_DESC);
                PliFileProperty plifile = new PliFileProperty(PliMessageResource.PLI_FILE_PROP_NAME, PliMessageResource.PLI_FILE_PROP_DISPLAY_NAME, PliMessageResource.PLI_FILE_PROP_DESC, propertyGroup, this.pliFileExt);
                plifile.setRequired(true);
                this.initializeProperties = propertyGroup;
            }
            catch (CoreException e) {
                throw new BaseException(e.getStatus());
            }
        }
        return this.initializeProperties;
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
        PliFileProperty pliFileProperty = (PliFileProperty)initializeProperties.getProperty(PliMessageResource.PLI_FILE_PROP_NAME);
        this.pliFilePathURI = (URI)pliFileProperty.getValue();
        this.pliFileExt = pliFileProperty.getFileExtensions();
        this.validatePliFile(this.pliFilePathURI);
        this.isInitialized = true;
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties, IImportResult importResult) throws BaseException {
        Status newStatus = new Status(4, "com.ibm.adapter.pli", 4, PliMessageResource.FUNCTION_NOT_SUPPORTED, null);
        throw new BaseException((IStatus)newStatus);
    }

    public void close() throws BaseException {
        this.isInitialized = false;
    }

    public ISearchTree getSearchTree() throws BaseException {
        if (!this.isInitialized) {
            Status newStatus = new Status(4, "com.ibm.adapter.pli", 4, PliMessageResource.INITIALIZATION_REQUIRED, null);
            throw new BaseException((IStatus)newStatus);
        }
        URI pliFileURI = URI.createFileURI((String)this.pliFilePath);
        Resource.Factory factory = ResourceFactoryRegistryImpl.INSTANCE.getFactory(pliFileURI);
        this.importerResource = factory.createResource(pliFileURI);
        return new PliSearchTree(this.importerResource);
    }

    public IImportResult performImport(IEnvironment environment, IResultNodeSelection selection) throws BaseException {
        if (!this.isInitialized) {
            Status newStatus = new Status(4, "com.ibm.adapter.pli", 4, PliMessageResource.INITIALIZATION_REQUIRED, null);
            throw new BaseException((IStatus)newStatus);
        }
        IResultNode[] selectedNodes = selection.getSelection();
        if (selectedNodes.length == 1) {
            String uriFragment = (String)selectedNodes[0].getData();
            PLIElement pliElement = (PLIElement)this.importerResource.getEObject(uriFragment);
            PliImportResult importResult = new PliImportResult(pliElement);
            importResult.setImportFile(new File(this.pliFilePath));
            return importResult;
        }
        return null;
    }
}

