/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.j2c;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class UIUtils {
    public static boolean closeOpenEditorForCU(final ICompilationUnit unit, final boolean deleteIfCannotClose) {
        final boolean[] success = new boolean[]{true};
        try {
            if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page;
                        IEditorPart ePart = UIUtils.isOpenInEditor(unit);
                        if (ePart != null && (page = UIUtils.getWorkbenchPage()) != null) {
                            success[0] = page.closeEditor(ePart, false);
                            if (!success[0] && deleteIfCannotClose) {
                                try {
                                    unit.delete(true, (IProgressMonitor)new NullProgressMonitor());
                                }
                                catch (JavaModelException javaModelException) {}
                            }
                        }
                    }
                });
            }
        }
        catch (Exception exception) {}
        return success[0];
    }

    public static IEditorPart isOpenInEditor(ICompilationUnit unit) {
        IResource resource = (unit = unit.getPrimary()).getResource();
        if (resource instanceof IFile) {
            FileEditorInput input = new FileEditorInput((IFile)resource);
            IWorkbenchPage page = UIUtils.getWorkbenchPage();
            if (page != null) {
                return page.findEditor((IEditorInput)input);
            }
        }
        return null;
    }

    public static IWorkbenchPage getWorkbenchPage() {
        IWorkbenchPage page = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            page = window.getActivePage();
        }
        return page;
    }
}

