/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.j2c.jet;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.etools.typedescriptor.AggregateInstanceTD;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.record.writer.internal.annotations.BeanAnnotationSerializer;
import com.ibm.record.writer.internal.annotations.TypeDescriptorSerializer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;

public class J2CRecordSkeletonGenerationAdapter {
    private EClass rootClass_ = null;
    private StringBuilder initialValueBuffer_ = new StringBuilder();
    private StringBuilder matchMethodBuffer_ = new StringBuilder();
    private String initializeRecordSize_ = "0";
    private Map<String, String> ODODependentMap_ = null;
    private static Map<String, String> builtInJavaTypeToDefaultValueMap_ = null;
    private BeanAnnotationSerializer baSer_ = null;
    private TypeDescriptorSerializer tdSer_ = null;
    private Map<ENamedElement, InstanceTDBase> EMFNamedElementToTDMap_ = null;
    private EReference classReference_ = null;
    private ICompilationUnit compilationUnit_ = null;
    private List<String> childClasses_ = null;
    private boolean importJavaMath_ = false;
    private String containerName_ = null;
    private String containerType_ = null;
    private static String[] defaultBuiltInJavaTypeToDefaultValueMap = new String[]{"boolean", "false", "float", "0.0F", "double", "0.0D", "long", "0", "int", "0", "short", "0", "byte", "0"};

    public J2CRecordSkeletonGenerationAdapter(ICompilationUnit compilationUnit, EClass rootClass, EReference classReference, Map<ENamedElement, InstanceTDBase> EMFNamedElementToTDMap, Map<String, String> ODODependentMap, List<String> childClasses, String languageType, String containerName, String containerType, IEnvironment environment) {
        this.compilationUnit_ = compilationUnit;
        this.rootClass_ = rootClass;
        this.classReference_ = classReference;
        this.baSer_ = new BeanAnnotationSerializer(environment);
        this.tdSer_ = new TypeDescriptorSerializer(languageType);
        this.EMFNamedElementToTDMap_ = EMFNamedElementToTDMap;
        this.ODODependentMap_ = ODODependentMap;
        this.childClasses_ = childClasses;
        this.containerName_ = containerName;
        this.containerType_ = containerType;
        if (builtInJavaTypeToDefaultValueMap_ == null) {
            HashMap<String, String> defaultValueMap = new HashMap<String, String>();
            int i = 0;
            while (i < defaultBuiltInJavaTypeToDefaultValueMap.length) {
                defaultValueMap.put(defaultBuiltInJavaTypeToDefaultValueMap[i], defaultBuiltInJavaTypeToDefaultValueMap[i + 1]);
                i += 2;
            }
            builtInJavaTypeToDefaultValueMap_ = defaultValueMap;
        }
        this.iterateOverFeaturesForImports(rootClass);
    }

    public void iterateOverFeaturesForImports(EClass rootClass) {
        Iterator sfIterator = rootClass.getEAllStructuralFeatures().iterator();
        while (sfIterator.hasNext() && !this.importJavaMath_) {
            String dataType;
            EStructuralFeature sf = (EStructuralFeature)sfIterator.next();
            if (!(sf instanceof EAttribute) && !(sf instanceof EReference) || !(dataType = this.getDataTypeForFeature(sf)).startsWith("java.math.") && !"BigDecimal".equals(dataType) && !"BigInteger".equals(dataType)) continue;
            this.importJavaMath_ = true;
        }
    }

    public String getPackageName() {
        String packageName = "";
        IJavaElement parent = this.compilationUnit_.getParent();
        if (parent instanceof IPackageFragment) {
            packageName = ((IPackageFragment)parent).getElementName();
        }
        return packageName;
    }

    public String getClassName() {
        String className = this.compilationUnit_.getElementName();
        int index = className.lastIndexOf(".java");
        if (index != -1) {
            className = className.substring(0, index);
        }
        return className;
    }

    public String[] getTypeLevelDoclets() {
        Object namedElem = null;
        namedElem = this.classReference_ == null ? this.rootClass_ : this.classReference_;
        String[] tdDoclets = new String[]{};
        InstanceTDBase tdObject = this.EMFNamedElementToTDMap_.get(namedElem);
        if (tdObject != null) {
            tdDoclets = this.tdSer_.convertToDoclets((AggregateInstanceTD)tdObject, " * @type-descriptor.", "aggregate-instance-td");
        }
        String[] childClassDoclets = new String[this.childClasses_.size()];
        int i = 0;
        while (i < childClassDoclets.length) {
            String doclet;
            String className = this.childClasses_.get(i);
            StringBuilder sb = new StringBuilder();
            sb.append(" * @type-descriptor.");
            sb.append("child-class");
            sb.append(" ");
            sb.append("class-name");
            sb.append("=\"");
            sb.append(className);
            sb.append("\"\n");
            childClassDoclets[i] = doclet = sb.toString();
            ++i;
        }
        String containerDoclet = null;
        if (this.containerName_ != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(" * @type-descriptor.");
            sb.append("CICSContainer");
            sb.append(" ");
            sb.append("class-name");
            sb.append("=\"");
            sb.append(this.getPackageName());
            sb.append(".");
            sb.append(this.getClassName());
            sb.append("\" ");
            sb.append("container-name");
            sb.append("=\"");
            sb.append(this.containerName_);
            sb.append("\" ");
            sb.append("container-type");
            sb.append("=\"");
            sb.append(this.containerType_);
            sb.append("\"\n");
            containerDoclet = sb.toString();
        }
        int docletSize = tdDoclets.length + childClassDoclets.length;
        if (containerDoclet != null) {
            ++docletSize;
        }
        String[] doclets = new String[docletSize];
        System.arraycopy(tdDoclets, 0, doclets, 0, tdDoclets.length);
        if (childClassDoclets.length != 0) {
            System.arraycopy(childClassDoclets, 0, doclets, tdDoclets.length, childClassDoclets.length);
        }
        if (containerDoclet != null) {
            doclets[docletSize - 1] = containerDoclet;
        }
        return doclets;
    }

    public String getGetSizeMethodBody() {
        return "return (0);\n";
    }

    public String getInitialRecordSize() {
        return this.initializeRecordSize_;
    }

    public String getInitialValueBody() {
        return this.initialValueBuffer_.toString();
    }

    public String getMatchMethodBody() {
        return this.matchMethodBuffer_.toString();
    }

    public EClass getRootClass() {
        return this.rootClass_;
    }

    public void setRootClass(EClass rootClass) {
        this.rootClass_ = rootClass;
    }

    public boolean isArray(EStructuralFeature sf) {
        InstanceTDBase tdObject = this.EMFNamedElementToTDMap_.get(sf);
        return !tdObject.getArrayDescr().isEmpty();
    }

    public int getArrayDimensions(EStructuralFeature sf) {
        InstanceTDBase tdObject = this.EMFNamedElementToTDMap_.get(sf);
        if (tdObject == null || tdObject.getArrayDescr().isEmpty()) {
            return 0;
        }
        return tdObject.getArrayDescr().size();
    }

    public String[] getDocletsForFeature(EStructuralFeature sf) throws BaseException {
        int arrayDim = this.getArrayDimensions(sf);
        EStructuralFeature schemaSF = sf;
        if (arrayDim > 1) {
            schemaSF = J2CRecordSkeletonGenerationAdapter.getBaseStructureFeatureForArraySF(sf, arrayDim);
        }
        String[] baDoclets = this.baSer_.convertToDoclets(schemaSF);
        InstanceTDBase tdObject = this.EMFNamedElementToTDMap_.get(sf);
        String[] tdDoclets = new String[]{};
        if (tdObject != null) {
            tdDoclets = tdObject instanceof SimpleInstanceTD ? this.tdSer_.convertToDoclets((SimpleInstanceTD)tdObject) : this.tdSer_.convertToDoclets((AggregateInstanceTD)tdObject, "\t * @type-descriptor.", "aggregate-instance-td-method");
        }
        String[] doclets = new String[baDoclets.length + tdDoclets.length];
        System.arraycopy(baDoclets, 0, doclets, 0, baDoclets.length);
        System.arraycopy(tdDoclets, 0, doclets, baDoclets.length, tdDoclets.length);
        return doclets;
    }

    public String getGetterBodyForDataType(String dataType) {
        String body;
        int index = dataType.lastIndexOf(46);
        if (index != -1) {
            dataType = dataType.substring(index + 1);
        }
        if ((body = builtInJavaTypeToDefaultValueMap_.get(dataType)) == null) {
            return "null";
        }
        return body;
    }

    public String getDataTypeForFeature(EStructuralFeature sf) {
        String dataType = "";
        int arrayDim = this.getArrayDimensions(sf);
        if (arrayDim > 1) {
            return this.getDataTypeForArrayFeature(sf, arrayDim);
        }
        EClassifier cf = sf.getEType();
        if (cf instanceof EDataType) {
            EDataType dt = (EDataType)cf;
            dataType = dt.getInstanceClassName();
        } else if (cf instanceof EClass) {
            EClass cls = (EClass)cf;
            dataType = cls.getName();
        }
        if (dataType.startsWith("java.lang.") || dataType.startsWith("java.math.")) {
            dataType = dataType.substring(dataType.lastIndexOf(46) + 1);
        }
        return dataType;
    }

    public String getDataTypeForArrayFeature(EStructuralFeature sf, int arrayDim) {
        EStructuralFeature baseFeature = J2CRecordSkeletonGenerationAdapter.getBaseStructureFeatureForArraySF(sf, arrayDim);
        return this.getDataTypeForFeature(baseFeature);
    }

    public static EStructuralFeature getBaseStructureFeatureForArraySF(EStructuralFeature sf, int arrayDim) {
        if (arrayDim < 2) {
            return sf;
        }
        EClassifier cf = sf.getEType();
        if (!(cf instanceof EClass)) {
            return sf;
        }
        EClass cls = (EClass)cf;
        EStructuralFeature firstField = (EStructuralFeature)cls.getEStructuralFeatures().get(0);
        return J2CRecordSkeletonGenerationAdapter.getBaseStructureFeatureForArraySF(firstField, arrayDim - 1);
    }

    public String[] getInitializeMethodDoclets() {
        return this.baSer_.convertODODependentMapToDoclets(this.ODODependentMap_);
    }

    public List<String> getLevel88sForFeature(EStructuralFeature sf) {
        return this.baSer_.getLevel88sForFeature(sf);
    }

    public String getLevel88DataType(String dataType) {
        if (dataType.startsWith("java.lang.")) {
            dataType = dataType.substring(dataType.lastIndexOf(46) + 1);
        } else if (dataType.startsWith("java.math.")) {
            dataType = dataType.substring(dataType.lastIndexOf(46) + 1);
        }
        if (builtInJavaTypeToDefaultValueMap_.get(dataType) != null || "String".equals(dataType) || "BigDecimal".equals(dataType) || "BigInteger".equals(dataType)) {
            return dataType;
        }
        return "String";
    }

    public boolean importJavaMath() {
        return this.importJavaMath_;
    }

    public String getRecordName() {
        if (this.containerName_ == null) {
            return "this.getClass().getName()";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(this.containerName_);
        sb.append("\"");
        return sb.toString();
    }
}

