/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.j2c;

import com.ibm.record.writer.internal.j2c.J2CRecordImplementationGenerationAdapter;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class MessageBufferVisitor
extends ASTVisitor {
    J2CRecordImplementationGenerationAdapter adapter_ = null;

    public MessageBufferVisitor(J2CRecordImplementationGenerationAdapter adapter) {
        this.adapter_ = adapter;
    }

    public MessageBufferVisitor(boolean visitDocTags, J2CRecordImplementationGenerationAdapter adapter) {
        super(visitDocTags);
        this.adapter_ = adapter;
    }

    public boolean visit(TypeDeclaration typeDecl) {
        String recIf = "jakarta.resource.cci.Record";
        String streamIf = "jakarta.resource.cci.Streamable";
        String bytesIf = "com.ibm.etools.marshall.RecordBytes";
        boolean recIfFound = false;
        boolean streamIfFound = false;
        boolean bytesIfFound = false;
        List interfaces = typeDecl.superInterfaceTypes();
        for (Type intface : interfaces) {
            String qualifiedName = null;
            if (intface.isSimpleType()) {
                qualifiedName = ((SimpleType)intface).getName().getFullyQualifiedName();
            } else if (intface.isQualifiedType()) {
                qualifiedName = ((QualifiedType)intface).getName().getFullyQualifiedName();
            }
            if (recIf.equals(qualifiedName)) {
                recIfFound = true;
                continue;
            }
            if (streamIf.equals(qualifiedName)) {
                streamIfFound = true;
                continue;
            }
            if (!bytesIf.equals(qualifiedName)) continue;
            bytesIfFound = true;
        }
        if (!recIfFound) {
            Name recName = MessageBufferVisitor.deriveASTName(typeDecl.getAST(), recIf);
            interfaces.add(typeDecl.getAST().newSimpleType(recName));
        }
        if (!streamIfFound) {
            Name streamName = MessageBufferVisitor.deriveASTName(typeDecl.getAST(), streamIf);
            interfaces.add(typeDecl.getAST().newSimpleType(streamName));
        }
        if (!bytesIfFound) {
            Name bytesName = MessageBufferVisitor.deriveASTName(typeDecl.getAST(), bytesIf);
            interfaces.add(typeDecl.getAST().newSimpleType(bytesName));
        }
        boolean fieldFound = false;
        String fieldName = "buffer_";
        FieldDeclaration[] fields = typeDecl.getFields();
        int i = 0;
        while (i < fields.length) {
            Type aType = fields[i].getType();
            if (aType.isArrayType()) {
                aType = ((ArrayType)aType).getElementType();
            }
            if (aType.isPrimitiveType() && ((PrimitiveType)aType).getPrimitiveTypeCode() == PrimitiveType.BYTE) {
                List fragList = fields[i].fragments();
                for (VariableDeclarationFragment vdf : fragList) {
                    SimpleName sn = vdf.getName();
                    if (!fieldName.equals(sn.getFullyQualifiedName()) || vdf.getExtraDimensions() != 0) continue;
                    fieldFound = true;
                }
            }
            ++i;
        }
        if (!fieldFound) {
            List bodyDecls = typeDecl.bodyDeclarations();
            VariableDeclarationFragment vdf = typeDecl.getAST().newVariableDeclarationFragment();
            vdf.setExtraDimensions(0);
            vdf.setInitializer((Expression)typeDecl.getAST().newNullLiteral());
            vdf.setName((SimpleName)MessageBufferVisitor.deriveASTName(typeDecl.getAST(), fieldName));
            FieldDeclaration fd = typeDecl.getAST().newFieldDeclaration(vdf);
            fd.modifiers().add(typeDecl.getAST().newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
            PrimitiveType componentType = typeDecl.getAST().newPrimitiveType(PrimitiveType.BYTE);
            ArrayType at = typeDecl.getAST().newArrayType((Type)componentType);
            fd.setType((Type)at);
            bodyDecls.add(fd);
        }
        return false;
    }

    public static final Name deriveASTName(AST ast, String value) {
        int index = value.lastIndexOf(".");
        Object name = null;
        name = index >= 0 ? ast.newQualifiedName(MessageBufferVisitor.deriveASTName(ast, value.substring(0, index)), ast.newSimpleName(value.substring(index + 1))) : ast.newSimpleName(value);
        return name;
    }
}

