/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.annotations;

import com.ibm.etools.typedescriptor.AccessorValue;
import com.ibm.etools.typedescriptor.ExternalDecimalSignValue;
import com.ibm.etools.typedescriptor.FloatValue;
import com.ibm.etools.typedescriptor.LengthEncodingValue;
import com.ibm.etools.typedescriptor.NumeralShapes;
import com.ibm.etools.typedescriptor.Orientation;
import com.ibm.etools.typedescriptor.SignCodingValue;
import com.ibm.etools.typedescriptor.SignFormatValue;
import com.ibm.etools.typedescriptor.StringJustificationKind;
import com.ibm.etools.typedescriptor.TextShapes;
import com.ibm.etools.typedescriptor.TypeOfText;
import com.ibm.etools.typedescriptor.UnicodeTransformationFormat;
import com.ibm.record.writer.MessageResource;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class ValidationUtils {
    private static String[] trueFalseChoice_ = null;
    private static String[] extDecSignChoice_ = null;
    private static String[] floatValueChoice_ = null;
    private static String[] accessorValueChoice_ = null;
    private static String[] numeralShapesChoice_ = null;
    private static String[] orientationChoice_ = null;
    private static String[] textShapesChoice_ = null;
    private static String[] typeOfTextChoice_ = null;
    private static String[] lengthEncodingValueChoice_ = null;
    private static String[] stringJustificationKindChoice_ = null;
    private static String[] externalDecimalSignValueChoice_ = null;
    private static String[] signFormatValueChoice_ = null;
    private static String[] unicodeSignFormatValueChoice_ = null;
    private static String[] signCodingValueChoice_ = null;
    private static String[] kindChoice_ = null;
    private static String[] languageChoice_ = null;
    private static String[] unicodeTransformationFormatChoice_ = null;

    public static String[] getTrueFalseChoice() {
        if (trueFalseChoice_ == null) {
            trueFalseChoice_ = new String[]{"true", "false"};
        }
        return trueFalseChoice_;
    }

    public static String[] getExtDecSignChoice() {
        if (extDecSignChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (ExternalDecimalSignValue element : ExternalDecimalSignValue.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            extDecSignChoice_ = choices.toArray(new String[choices.size()]);
        }
        return extDecSignChoice_;
    }

    public static String[] getFloatValueChoice() {
        if (floatValueChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (FloatValue element : FloatValue.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            floatValueChoice_ = choices.toArray(new String[choices.size()]);
        }
        return floatValueChoice_;
    }

    public static String[] getAccessorValueChoice() {
        if (accessorValueChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (AccessorValue element : AccessorValue.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            accessorValueChoice_ = choices.toArray(new String[choices.size()]);
        }
        return accessorValueChoice_;
    }

    public static String[] getNumeralShapesChoice() {
        if (numeralShapesChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (NumeralShapes element : NumeralShapes.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            numeralShapesChoice_ = choices.toArray(new String[choices.size()]);
        }
        return numeralShapesChoice_;
    }

    public static String[] getOrientationChoice() {
        if (orientationChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (Orientation element : Orientation.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            orientationChoice_ = choices.toArray(new String[choices.size()]);
        }
        return orientationChoice_;
    }

    public static String[] getTextShapesChoice() {
        if (textShapesChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (TextShapes element : TextShapes.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            textShapesChoice_ = choices.toArray(new String[choices.size()]);
        }
        return textShapesChoice_;
    }

    public static String[] getTypeOfTextChoice() {
        if (typeOfTextChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (TypeOfText element : TypeOfText.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            typeOfTextChoice_ = choices.toArray(new String[choices.size()]);
        }
        return typeOfTextChoice_;
    }

    public static boolean validatePositiveInteger(String value, String attributeName, TagData tagData) {
        boolean isValid = true;
        if (value != null) {
            try {
                int i = Integer.parseInt(value);
                if (i < 0) {
                    tagData.addErr(NLS.bind((String)MessageResource.ERR_TAG_ATTR_POSITIVE_INT, (Object)attributeName));
                    isValid = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                tagData.addErr(NLS.bind((String)MessageResource.ERR_TAG_ATTR_POSITIVE_INT, (Object)attributeName));
                isValid = false;
            }
        }
        return isValid;
    }

    public static boolean validateArrayTD(TagData tagData) {
        String upperBound;
        boolean isValid = true;
        String lowerBound = tagData.get("lowerBound");
        if (lowerBound != null) {
            boolean bl = isValid = isValid && ValidationUtils.validatePositiveInteger(lowerBound, "lowerBound", tagData);
        }
        if ((upperBound = tagData.get("upperBound")) != null) {
            boolean upperValid = upperBound.startsWith("val");
            if (!upperValid) {
                upperValid = ValidationUtils.validatePositiveInteger(upperBound, "upperBound", tagData);
            }
            isValid = isValid && upperValid;
        }
        return isValid;
    }

    public static boolean validateCodepage(String codePage, TagData tagData, String attributeName) {
        boolean isValid = true;
        try {
            byte[] bytes = new byte[]{12, 34};
            new String(bytes, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            tagData.addErr(NLS.bind((String)MessageResource.ERR_TAG_ATTR_INVALID_CODEPAGE, (Object)attributeName));
            isValid = false;
        }
        return isValid;
    }

    public static String[] getLengthEncodingValueChoice() {
        if (lengthEncodingValueChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (LengthEncodingValue element : LengthEncodingValue.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            lengthEncodingValueChoice_ = choices.toArray(new String[choices.size()]);
        }
        return lengthEncodingValueChoice_;
    }

    public static String[] getStringJustificationKindChoice() {
        if (stringJustificationKindChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (StringJustificationKind element : StringJustificationKind.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            stringJustificationKindChoice_ = choices.toArray(new String[choices.size()]);
        }
        return stringJustificationKindChoice_;
    }

    public static String[] getExternalDecimalSignValueChoice() {
        if (externalDecimalSignValueChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (ExternalDecimalSignValue element : ExternalDecimalSignValue.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            externalDecimalSignValueChoice_ = choices.toArray(new String[choices.size()]);
        }
        return externalDecimalSignValueChoice_;
    }

    public static String[] getSignFormatValueChoice() {
        if (signFormatValueChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (SignFormatValue element : SignFormatValue.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            signFormatValueChoice_ = choices.toArray(new String[choices.size()]);
        }
        return signFormatValueChoice_;
    }

    public static String[] getUnicodeSignFormatValueChoice() {
        if (unicodeSignFormatValueChoice_ == null) {
            unicodeSignFormatValueChoice_ = new String[2];
            ValidationUtils.unicodeSignFormatValueChoice_[0] = SignFormatValue.LEADING_SEPARATE_LITERAL.getName();
            ValidationUtils.unicodeSignFormatValueChoice_[1] = SignFormatValue.TRAILING_SEPARATE_LITERAL.getName();
        }
        return unicodeSignFormatValueChoice_;
    }

    public static String[] getUnicodeTransformationFormatChoice() {
        if (unicodeTransformationFormatChoice_ == null) {
            unicodeTransformationFormatChoice_ = new String[3];
            ValidationUtils.unicodeTransformationFormatChoice_[0] = UnicodeTransformationFormat.UTF8_LITERAL.getName();
            ValidationUtils.unicodeTransformationFormatChoice_[1] = UnicodeTransformationFormat.UTF16_LITERAL.getName();
            ValidationUtils.unicodeTransformationFormatChoice_[2] = UnicodeTransformationFormat.UTF32_LITERAL.getName();
        }
        return unicodeTransformationFormatChoice_;
    }

    public static String[] getSignCodingValueChoice() {
        if (signCodingValueChoice_ == null) {
            ArrayList<String> choices = new ArrayList<String>();
            for (SignCodingValue element : SignCodingValue.VALUES) {
                String value = element.getName();
                choices.add(value);
            }
            signCodingValueChoice_ = choices.toArray(new String[choices.size()]);
        }
        return signCodingValueChoice_;
    }

    public static String[] getKindChoice() {
        if (kindChoice_ == null) {
            kindChoice_ = new String[]{"SPACE", "ALL", "quotes", "ZERO", "string_value"};
        }
        return kindChoice_;
    }

    public static String[] getLanguageChoice() {
        if (languageChoice_ == null) {
            languageChoice_ = new String[]{"COBOL", "C", "PLI"};
        }
        return languageChoice_;
    }

    public static boolean validateNumberForType(String number, String returnType, String attributeName, TagData tagData) {
        boolean isValid = true;
        if (returnType == null || returnType.equals("MALFORMED") || returnType.equals("UNKNOWN")) {
            tagData.addErr(NLS.bind((String)MessageResource.ERR_TAG_ATTR_INVALID_NUMERICAL_VALUE, (Object)attributeName));
            return false;
        }
        if (returnType.startsWith("java.lang.") || returnType.startsWith("java.math.")) {
            returnType = returnType.substring(returnType.lastIndexOf(46) + 1);
        }
        try {
            if (returnType.equals("byte")) {
                Byte.parseByte(number);
            }
            if (returnType.equals("short")) {
                Short.parseShort(number);
            }
            if (returnType.equals("int")) {
                Integer.parseInt(number);
            }
            if (returnType.equals("long")) {
                Long.parseLong(number);
            }
            if (returnType.equals("float")) {
                Float.parseFloat(number);
            }
            if (returnType.equals("double")) {
                Double.parseDouble(number);
            }
            if (returnType.equals("BigInteger")) {
                new BigInteger(number);
            }
            if (returnType.equals("BigDecimal")) {
                new BigDecimal(number);
            }
        }
        catch (NumberFormatException numberFormatException) {
            tagData.addErr(NLS.bind((String)MessageResource.ERR_TAG_ATTR_INVALID_VALUE_FOR_DATA_TYPE, (Object)attributeName));
            isValid = false;
        }
        return isValid;
    }

    public static boolean validateLowerLessThanUpperNumberForType(String lowerBound, String upperBound, String returnType, String lowerBoundAttribute, String upperBoundAttribute, TagData tagData) {
        boolean isValid = true;
        if (returnType.startsWith("java.lang.") || returnType.startsWith("java.math.")) {
            returnType = returnType.substring(returnType.lastIndexOf(46) + 1);
        }
        try {
            int upper;
            int lower;
            if (returnType.equals("byte")) {
                lower = Byte.parseByte(lowerBound);
                boolean bl = isValid = lower < (upper = Byte.parseByte(upperBound));
            }
            if (returnType.equals("short")) {
                lower = Short.parseShort(lowerBound);
                boolean bl = isValid = lower < (upper = Short.parseShort(upperBound));
            }
            if (returnType.equals("int")) {
                lower = Integer.parseInt(lowerBound);
                boolean bl = isValid = lower < (upper = Integer.parseInt(upperBound));
            }
            if (returnType.equals("long")) {
                long upper2;
                long lower2 = Long.parseLong(lowerBound);
                boolean bl = isValid = lower2 < (upper2 = Long.parseLong(upperBound));
            }
            if (returnType.equals("float")) {
                float upper3;
                float lower3 = Float.parseFloat(lowerBound);
                boolean bl = isValid = lower3 < (upper3 = Float.parseFloat(upperBound));
            }
            if (returnType.equals("double")) {
                double upper4;
                double lower4 = Double.parseDouble(lowerBound);
                boolean bl = isValid = lower4 < (upper4 = Double.parseDouble(upperBound));
            }
            if (returnType.equals("BigInteger")) {
                BigInteger lower5 = new BigInteger(lowerBound);
                BigInteger upper5 = new BigInteger(upperBound);
                boolean bl = isValid = lower5.compareTo(upper5) == -1;
            }
            if (returnType.equals("BigDecimal")) {
                BigDecimal lower6 = new BigDecimal(lowerBound);
                BigDecimal upper6 = new BigDecimal(upperBound);
                isValid = lower6.compareTo(upper6) == -1;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (!isValid) {
            tagData.addErr(NLS.bind((String)MessageResource.ERR_TAG_ATTR_LOWER_GREATER_THAN_UPPER, (Object)lowerBoundAttribute, (Object)upperBoundAttribute));
            isValid = false;
        }
        return isValid;
    }
}

