/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.annotations;

import com.ibm.etools.marshall.codegen.CodeGenUtils;
import com.ibm.etools.typedescriptor.AccessorValue;
import com.ibm.etools.typedescriptor.AddressTD;
import com.ibm.etools.typedescriptor.AggregateInstanceTD;
import com.ibm.etools.typedescriptor.ArrayTD;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.Bi_DirectionStringTD;
import com.ibm.etools.typedescriptor.BinaryTD;
import com.ibm.etools.typedescriptor.DateTD;
import com.ibm.etools.typedescriptor.ExternalDecimalSignValue;
import com.ibm.etools.typedescriptor.ExternalDecimalTD;
import com.ibm.etools.typedescriptor.FloatTD;
import com.ibm.etools.typedescriptor.FloatValue;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.IntegerTD;
import com.ibm.etools.typedescriptor.LengthEncodingValue;
import com.ibm.etools.typedescriptor.NumeralShapes;
import com.ibm.etools.typedescriptor.Orientation;
import com.ibm.etools.typedescriptor.PackedDecimalTD;
import com.ibm.etools.typedescriptor.PlatformCompilerInfo;
import com.ibm.etools.typedescriptor.SignCodingValue;
import com.ibm.etools.typedescriptor.SignFormatValue;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.etools.typedescriptor.StringJustificationKind;
import com.ibm.etools.typedescriptor.StringTD;
import com.ibm.etools.typedescriptor.TextShapes;
import com.ibm.etools.typedescriptor.TypeOfText;
import com.ibm.etools.typedescriptor.UnicodeExternalDecimalTD;
import com.ibm.etools.typedescriptor.UnicodeTransformationFormat;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;

public class TypeDescriptorSerializer {
    public static final String TYPE_DESCRIPTOR_TAG_SET_NAME = "type-descriptor";
    public static final String START_TYPE_DOCLET_TAG = " * @type-descriptor.";
    public static final String START_METHOD_DOCLET_TAG = "\t * @type-descriptor.";
    public static final String PLATFORM_COMPILER_INFO_TAG_NAME = "platform-compiler-info";
    public static final String PLATFORM_COMPILER_INFO_ATTR_BIG_ENDIAN = "defaultBigEndian";
    public static final String PLATFORM_COMPILER_INFO_ATTR_CODEPAGE = "defaultCodepage";
    public static final String PLATFORM_COMPILER_INFO_ATTR_EXTERNAL_DECIMAL_SIGN = "defaultExternalDecimalSign";
    public static final String PLATFORM_COMPILER_INFO_ATTR_FLOAT_TYPE = "defaultFloatType";
    public static final String PLATFORM_COMPILER_INFO_ATTR_LANGUAGE = "language";
    public static final String PLATFORM_COMPILER_INFO_ATTR_HOST_CODEPAGE = "defaultHostCodepage";
    public static final String AGGREGATE_TD_TAG_NAME = "aggregate-instance-td";
    public static final String AGGREGATE_TD_METHOD_TAG_NAME = "aggregate-instance-td-method";
    public static final String SIMPLE_INSTANCE_TD_TAG_NAME = "simple-instance-td";
    public static final String SIMPLE_INSTANCE_TD_ATTR_FORMAT = "format";
    public static final String INSTANCE_TD_BASE_ATTR_ACCESSOR = "accessor";
    public static final String INSTANCE_TD_BASE_ATTR_CONTENT_SIZE = "contentSize";
    public static final String INSTANCE_TD_BASE_ATTR_OFFSET = "offset";
    public static final String INSTANCE_TD_BASE_ATTR_SIZE = "size";
    public static final String ARRAY_TD_TAG_NAME = "array-td";
    public static final String ARRAY_TD_TYPE_TAG_NAME = "array-td-type";
    public static final String ARRAY_TD_ATTR_LOWER_BOUND = "lowerBound";
    public static final String ARRAY_TD_ATTR_UPPER_BOUND = "upperBound";
    public static final String ARRAY_TD_ATTR_STRIDE = "stride";
    public static final String STRING_TD_TAG_NAME = "string-td";
    public static final String STRING_TD_ATTR_CHARACTER_SIZE = "characterSize";
    public static final String STRING_TD_ATTR_CODEPAGE = "codepage";
    public static final String STRING_TD_ATTR_DBCSONLY = "dBCSOnly";
    public static final String STRING_TD_ATTR_LENGTH_ENCODING = "lengthEncoding";
    public static final String STRING_TD_ATTR_PADDING_CHARACTER = "paddingCharacter";
    public static final String STRING_TD_ATTR_PREFIX_LENGTH = "prefixLength";
    public static final String STRING_TD_ATTR_STRING_JUSTIFICATION = "stringJustification";
    public static final String BIDI_STRING_TD_METHOD_TAG_NAME = "bi-direction-string-td";
    public static final String BIDI_STRING_TD_TYPE_TAG_NAME = "type-bi-direction-string-td";
    public static final String BIDI_STRING_TD_ATTR_NUMERAL_SHAPES = "numeralShapes";
    public static final String BIDI_STRING_TD_ATTR_ORIENTATION = "orientation";
    public static final String BIDI_STRING_TD_ATTR_SYMMETRIC = "symmetric";
    public static final String BIDI_STRING_TD_ATTR_TEXT_SHAPE = "textShape";
    public static final String BIDI_STRING_TD_ATTR_TEXT_TYPE = "orderingScheme";
    public static final String NUMBER_TD_ATTR_BIG_ENDIAN = "bigEndian";
    public static final String NUMBER_TD_ATTR_SIGNED = "signed";
    public static final String NUMBER_TD_ATTR_VIRTUAL_DECIMAL_POINT = "virtualDecimalPoint";
    public static final String EXTERNAL_DECIMAL_TD_TAG_NAME = "external-decimal-td";
    public static final String EXTERNAL_DECIMAL_TD_ATTR_EXTERNAL_DECIMAL_SIGN = "externalDecimalSign";
    public static final String EXTERNAL_DECIMAL_TD_ATTR_SIGN_FORMAT = "signFormat";
    public static final String EXTERNAL_DECIMAL_TD_ATTR_HOST_CODEPAGE = "hostCodepage";
    public static final String UNICODE_EXTERNAL_DECIMAL_TD_TAG_NAME = "unicode-external-decimal-td";
    public static final String UNICODE_EXTERNAL_DECIMAL_TD_ATTR_ENCODING = "encoding";
    public static final String PACKED_DECIMAL_TD_TAG_NAME = "packed-decimal-td";
    public static final String INTEGER_TD_TAG_NAME = "integer-td";
    public static final String INTEGER_TD_ATTR_SIGN_CODING = "signCoding";
    public static final String FLOAT_TD_TAG_NAME = "float-td";
    public static final String FLOAT_TD_ATTR_FLOAT_TYPE = "floatType";
    public static final String BINARY_TD_TAG_NAME = "binary-td";
    public static final String ADDRESS_TD_TAG_NAME = "address-td";
    public static final String DATE_TD_TAG_NAME = "date-td";
    private String languageType_ = null;

    private TypeDescriptorSerializer() {
    }

    public TypeDescriptorSerializer(String languageType) {
        this.languageType_ = languageType;
    }

    public String[] convertToDoclets(PlatformCompilerInfo platformInfo) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(START_TYPE_DOCLET_TAG);
        sb.append(PLATFORM_COMPILER_INFO_TAG_NAME);
        if (!platformInfo.isSetLanguage()) {
            String language = platformInfo.getLanguage();
            if (language == null || language.equals("")) {
                platformInfo.setLanguage(this.languageType_);
            }
        } else {
            platformInfo.setLanguage(this.languageType_);
        }
        sb.append(" ");
        sb.append(PLATFORM_COMPILER_INFO_ATTR_LANGUAGE);
        sb.append("=\"");
        sb.append(platformInfo.getLanguage());
        sb.append("\"");
        if (platformInfo.isSetDefaultBigEndian()) {
            sb.append(" ");
            sb.append(PLATFORM_COMPILER_INFO_ATTR_BIG_ENDIAN);
            sb.append("=\"");
            sb.append(platformInfo.getDefaultBigEndian().toString());
            sb.append("\"");
        }
        if (platformInfo.isSetDefaultCodepage()) {
            sb.append(" ");
            sb.append(PLATFORM_COMPILER_INFO_ATTR_CODEPAGE);
            sb.append("=\"");
            sb.append(platformInfo.getDefaultCodepage());
            sb.append("\"");
        }
        if (platformInfo.isSetDefaultExternalDecimalSign()) {
            sb.append(" ");
            sb.append(PLATFORM_COMPILER_INFO_ATTR_EXTERNAL_DECIMAL_SIGN);
            sb.append("=\"");
            ExternalDecimalSignValue extDecValue = platformInfo.getDefaultExternalDecimalSign();
            sb.append(extDecValue.getName());
            sb.append("\"");
        }
        if (platformInfo.isSetDefaultFloatType()) {
            sb.append(" ");
            sb.append(PLATFORM_COMPILER_INFO_ATTR_FLOAT_TYPE);
            sb.append("=\"");
            FloatValue fv = platformInfo.getDefaultFloatType();
            sb.append(fv.getName());
            sb.append("\"");
        }
        if (platformInfo.isSetDefaultHostCodepage()) {
            sb.append(" ");
            sb.append(PLATFORM_COMPILER_INFO_ATTR_HOST_CODEPAGE);
            sb.append("=\"");
            sb.append(platformInfo.getDefaultHostCodepage());
            sb.append("\"");
        }
        sb.append("\n");
        list.add(sb.toString());
        Bi_DirectionStringTD bidiTD = platformInfo.getBidiAttributes();
        if (bidiTD != null) {
            String[] bidiDoclets = this.convertToDoclets(bidiTD, START_TYPE_DOCLET_TAG, BIDI_STRING_TD_TYPE_TAG_NAME);
            int i = 0;
            while (i < bidiDoclets.length) {
                list.add(bidiDoclets[i]);
                ++i;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] convertToDoclets(AggregateInstanceTD aggregateTD, String docletStartTag, String aggregateDocletTag) {
        PlatformCompilerInfo info;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(docletStartTag);
        sb.append(aggregateDocletTag);
        if (aggregateTD.isSetAttributeInBit() && aggregateTD.getAttributeInBit().booleanValue()) {
            this.fixUpAttributesInBit((InstanceTDBase)aggregateTD);
        }
        if (aggregateTD.isSetAccessor()) {
            sb.append(" ");
            sb.append(INSTANCE_TD_BASE_ATTR_ACCESSOR);
            sb.append("=\"");
            AccessorValue av = aggregateTD.getAccessor();
            sb.append(av.getName());
            sb.append("\"");
        }
        if (aggregateTD.isSetContentSize()) {
            sb.append(" ");
            sb.append(INSTANCE_TD_BASE_ATTR_CONTENT_SIZE);
            sb.append("=\"");
            sb.append(aggregateTD.getContentSize());
            sb.append("\"");
        }
        if (aggregateTD.isSetOffset()) {
            sb.append(" ");
            sb.append(INSTANCE_TD_BASE_ATTR_OFFSET);
            sb.append("=\"");
            sb.append(aggregateTD.getOffset());
            sb.append("\"");
        }
        if (aggregateTD.isSetSize()) {
            sb.append(" ");
            sb.append(INSTANCE_TD_BASE_ATTR_SIZE);
            sb.append("=\"");
            sb.append(aggregateTD.getSize());
            sb.append("\"");
        }
        sb.append("\n");
        list.add(sb.toString());
        if (aggregateDocletTag.equals(AGGREGATE_TD_TAG_NAME) && (info = aggregateTD.getPlatformInfo()) != null) {
            String[] infoDoclets = this.convertToDoclets(info);
            int i = 0;
            while (i < infoDoclets.length) {
                list.add(infoDoclets[i]);
                ++i;
            }
        }
        EList arrayTDList = aggregateTD.getArrayDescr();
        for (ArrayTD arrayTD : arrayTDList) {
            String arrayTDTagName = ARRAY_TD_TAG_NAME;
            if (aggregateDocletTag.equals(AGGREGATE_TD_TAG_NAME)) {
                arrayTDTagName = ARRAY_TD_TYPE_TAG_NAME;
            }
            String[] arrayDoclets = this.convertToDoclets(arrayTD, docletStartTag, arrayTDTagName);
            int i = 0;
            while (i < arrayDoclets.length) {
                list.add(arrayDoclets[i]);
                ++i;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private void fixUpAttributesInBit(InstanceTDBase tdBase) {
        if (!tdBase.isSetAttributeInBit() || !tdBase.getAttributeInBit().booleanValue()) {
            return;
        }
        String contentSizeStr = tdBase.getContentSize();
        String offsetStr = tdBase.getOffset();
        String sizeStr = tdBase.getSize();
        if (CodeGenUtils.isFormula((String)contentSizeStr) || CodeGenUtils.isFormula((String)sizeStr) || CodeGenUtils.isFormula((String)offsetStr)) {
            return;
        }
        int contentSize = Integer.parseInt(contentSizeStr);
        int offset = Integer.parseInt(offsetStr);
        int size = Integer.parseInt(sizeStr);
        int contentSizeRemainder = contentSize % 8;
        contentSize /= 8;
        if (contentSizeRemainder != 0) {
            ++contentSize;
        }
        offset /= 8;
        int sizeRemainder = size % 8;
        size /= 8;
        if (sizeRemainder != 0) {
            ++size;
        }
        tdBase.setContentSize(Integer.toString(contentSize));
        tdBase.setSize(Integer.toString(size));
        tdBase.setOffset(Integer.toString(offset));
        tdBase.setAttributeInBit(Boolean.FALSE);
        tdBase.unsetAttributeInBit();
    }

    public String[] convertToDoclets(SimpleInstanceTD simpleTD) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(SIMPLE_INSTANCE_TD_TAG_NAME);
        if (simpleTD.isSetAttributeInBit() && simpleTD.getAttributeInBit().booleanValue()) {
            this.fixUpAttributesInBit((InstanceTDBase)simpleTD);
        }
        if (simpleTD.isSetAccessor()) {
            sb.append(" ");
            sb.append(INSTANCE_TD_BASE_ATTR_ACCESSOR);
            sb.append("=\"");
            AccessorValue av = simpleTD.getAccessor();
            sb.append(av.getName());
            sb.append("\"");
        }
        if (simpleTD.isSetContentSize()) {
            sb.append(" ");
            sb.append(INSTANCE_TD_BASE_ATTR_CONTENT_SIZE);
            sb.append("=\"");
            sb.append(simpleTD.getContentSize());
            sb.append("\"");
        }
        if (simpleTD.isSetFormat()) {
            sb.append(" ");
            sb.append(SIMPLE_INSTANCE_TD_ATTR_FORMAT);
            sb.append("=\"");
            sb.append(simpleTD.getFormat());
            sb.append("\"");
        }
        if (simpleTD.isSetOffset()) {
            sb.append(" ");
            sb.append(INSTANCE_TD_BASE_ATTR_OFFSET);
            sb.append("=\"");
            sb.append(simpleTD.getOffset());
            sb.append("\"");
        }
        if (simpleTD.isSetSize()) {
            sb.append(" ");
            sb.append(INSTANCE_TD_BASE_ATTR_SIZE);
            sb.append("=\"");
            sb.append(simpleTD.getSize());
            sb.append("\"");
        }
        sb.append("\n");
        list.add(sb.toString());
        EList arrayTDList = simpleTD.getArrayDescr();
        for (ArrayTD arrayTD : arrayTDList) {
            String[] arrayDoclets = this.convertToDoclets(arrayTD, START_METHOD_DOCLET_TAG, ARRAY_TD_TAG_NAME);
            int i = 0;
            while (i < arrayDoclets.length) {
                list.add(arrayDoclets[i]);
                ++i;
            }
        }
        BaseTDType baseTD = simpleTD.getSharedType();
        if (baseTD != null) {
            ExternalDecimalTD externalDecimalTD;
            String[] baseDoclets = null;
            if (baseTD instanceof StringTD) {
                StringTD stringTD = (StringTD)baseTD;
                baseDoclets = this.convertToDoclets(stringTD);
            } else if (baseTD instanceof ExternalDecimalTD) {
                externalDecimalTD = (ExternalDecimalTD)baseTD;
                baseDoclets = this.convertToDoclets(externalDecimalTD);
            } else if (baseTD instanceof UnicodeExternalDecimalTD) {
                externalDecimalTD = (UnicodeExternalDecimalTD)baseTD;
                baseDoclets = this.convertToDoclets((UnicodeExternalDecimalTD)externalDecimalTD);
            } else if (baseTD instanceof PackedDecimalTD) {
                baseDoclets = this.convertToDoclets((PackedDecimalTD)baseTD);
            } else if (baseTD instanceof IntegerTD) {
                baseDoclets = this.convertToDoclets((IntegerTD)baseTD);
            } else if (baseTD instanceof FloatTD) {
                FloatTD floatTD = (FloatTD)baseTD;
                baseDoclets = this.convertToDoclets(floatTD);
            } else {
                baseDoclets = baseTD instanceof BinaryTD ? this.convertToDoclets((BinaryTD)baseTD) : (baseTD instanceof AddressTD ? this.convertToDoclets((AddressTD)baseTD) : (baseTD instanceof DateTD ? this.convertToDoclets((DateTD)baseTD) : new String[]{}));
            }
            int i = 0;
            while (i < baseDoclets.length) {
                list.add(baseDoclets[i]);
                ++i;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] convertToDoclets(ArrayTD arrayTD, String docletStartTag, String arrayDocletTag) {
        StringBuilder sb = new StringBuilder(docletStartTag);
        sb.append(arrayDocletTag);
        if (arrayTD.isSetLowerBound()) {
            sb.append(" ");
            sb.append(ARRAY_TD_ATTR_LOWER_BOUND);
            sb.append("=\"");
            sb.append(arrayTD.getLowerBound());
            sb.append("\"");
        }
        if (arrayTD.isSetStride()) {
            if (arrayTD.isSetStrideInBit() && arrayTD.getStrideInBit().booleanValue() && !CodeGenUtils.isFormula((String)arrayTD.getStride())) {
                int stride = Integer.parseInt(arrayTD.getStride());
                int strideRemainder = stride % 8;
                stride /= 8;
                if (strideRemainder != 0) {
                    ++stride;
                }
                arrayTD.setStride(Integer.toString(stride));
                arrayTD.setStrideInBit(Boolean.FALSE);
                arrayTD.unsetStrideInBit();
            }
            sb.append(" ");
            sb.append(ARRAY_TD_ATTR_STRIDE);
            sb.append("=\"");
            sb.append(arrayTD.getStride());
            sb.append("\"");
        }
        if (arrayTD.isSetUpperBound()) {
            sb.append(" ");
            sb.append(ARRAY_TD_ATTR_UPPER_BOUND);
            sb.append("=\"");
            sb.append(arrayTD.getUpperBound());
            sb.append("\"");
        }
        sb.append("\n");
        return new String[]{sb.toString()};
    }

    public String[] convertToDoclets(StringTD stringTD) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(STRING_TD_TAG_NAME);
        if (stringTD.isSetCharacterSize()) {
            sb.append(" ");
            sb.append(STRING_TD_ATTR_CHARACTER_SIZE);
            sb.append("=\"");
            sb.append(Integer.toString(stringTD.getCharacterSize()));
            sb.append("\"");
        }
        if (stringTD.isSetCodepage()) {
            sb.append(" ");
            sb.append(STRING_TD_ATTR_CODEPAGE);
            sb.append("=\"");
            sb.append(stringTD.getCodepage());
            sb.append("\"");
        }
        if (stringTD.isSetDBCSOnly()) {
            sb.append(" ");
            sb.append(STRING_TD_ATTR_DBCSONLY);
            sb.append("=\"");
            sb.append(stringTD.getDBCSOnly().toString());
            sb.append("\"");
        }
        if (stringTD.isSetLengthEncoding()) {
            sb.append(" ");
            sb.append(STRING_TD_ATTR_LENGTH_ENCODING);
            sb.append("=\"");
            LengthEncodingValue lev = stringTD.getLengthEncoding();
            sb.append(lev.getName());
            sb.append("\"");
        }
        if (stringTD.isSetPaddingCharacter()) {
            sb.append(" ");
            sb.append(STRING_TD_ATTR_PADDING_CHARACTER);
            sb.append("=\"");
            sb.append(stringTD.getPaddingCharacter());
            sb.append("\"");
        }
        if (stringTD.isSetPrefixLength()) {
            sb.append(" ");
            sb.append(STRING_TD_ATTR_PREFIX_LENGTH);
            sb.append("=\"");
            sb.append(Integer.toString(stringTD.getPrefixLength()));
            sb.append("\"");
        }
        if (stringTD.isSetStringJustification()) {
            sb.append(" ");
            sb.append(STRING_TD_ATTR_STRING_JUSTIFICATION);
            sb.append("=\"");
            StringJustificationKind sjk = stringTD.getStringJustification();
            sb.append(sjk.getName());
            sb.append("\"");
        }
        sb.append("\n");
        list.add(sb.toString());
        Bi_DirectionStringTD bidiTD = stringTD.getBidiAttributes();
        if (bidiTD != null) {
            String[] bidiDoclets = this.convertToDoclets(bidiTD, START_METHOD_DOCLET_TAG, BIDI_STRING_TD_METHOD_TAG_NAME);
            int i = 0;
            while (i < bidiDoclets.length) {
                list.add(bidiDoclets[i]);
                ++i;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] convertToDoclets(Bi_DirectionStringTD bidiTD, String docletStartTag, String bidiDocletTag) {
        StringBuilder sb = new StringBuilder(docletStartTag);
        sb.append(bidiDocletTag);
        if (bidiTD.isSetNumeralShapes()) {
            sb.append(" ");
            sb.append(BIDI_STRING_TD_ATTR_NUMERAL_SHAPES);
            sb.append("=\"");
            NumeralShapes ns = bidiTD.getNumeralShapes();
            sb.append(ns.getName());
            sb.append("\"");
        }
        if (bidiTD.isSetOrientation()) {
            sb.append(" ");
            sb.append(BIDI_STRING_TD_ATTR_ORIENTATION);
            sb.append("=\"");
            Orientation orient = bidiTD.getOrientation();
            sb.append(orient.getName());
            sb.append("\"");
        }
        if (bidiTD.isSetSymmetric()) {
            sb.append(" ");
            sb.append(BIDI_STRING_TD_ATTR_SYMMETRIC);
            sb.append("=\"");
            sb.append(bidiTD.getSymmetric().toString());
            sb.append("\"");
        }
        if (bidiTD.isSetTextShape()) {
            sb.append(" ");
            sb.append(BIDI_STRING_TD_ATTR_TEXT_SHAPE);
            sb.append("=\"");
            TextShapes ts = bidiTD.getTextShape();
            sb.append(ts.getName());
            sb.append("\"");
        }
        if (bidiTD.isSetTextType()) {
            sb.append(" ");
            sb.append(BIDI_STRING_TD_ATTR_TEXT_TYPE);
            sb.append("=\"");
            TypeOfText tt = bidiTD.getTextType();
            sb.append(tt.getName());
            sb.append("\"");
        }
        sb.append("\n");
        return new String[]{sb.toString()};
    }

    public String[] convertToDoclets(ExternalDecimalTD extDecTD) {
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(EXTERNAL_DECIMAL_TD_TAG_NAME);
        if (extDecTD.isSetBigEndian()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_BIG_ENDIAN);
            sb.append("=\"");
            sb.append(extDecTD.getBigEndian().toString());
            sb.append("\"");
        }
        if (extDecTD.isSetSigned()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_SIGNED);
            sb.append("=\"");
            sb.append(extDecTD.getSigned().toString());
            sb.append("\"");
        }
        if (extDecTD.isSetVirtualDecimalPoint()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_VIRTUAL_DECIMAL_POINT);
            sb.append("=\"");
            sb.append(Integer.toString(extDecTD.getVirtualDecimalPoint()));
            sb.append("\"");
        }
        if (extDecTD.isSetExternalDecimalSign()) {
            sb.append(" ");
            sb.append(EXTERNAL_DECIMAL_TD_ATTR_EXTERNAL_DECIMAL_SIGN);
            sb.append("=\"");
            ExternalDecimalSignValue edsv = extDecTD.getExternalDecimalSign();
            sb.append(edsv.getName());
            sb.append("\"");
        }
        if (extDecTD.isSetSignFormat()) {
            sb.append(" ");
            sb.append(EXTERNAL_DECIMAL_TD_ATTR_SIGN_FORMAT);
            sb.append("=\"");
            SignFormatValue sfv = extDecTD.getSignFormat();
            sb.append(sfv.getName());
            sb.append("\"");
        }
        if (extDecTD.isSetHostCodepage()) {
            sb.append(" ");
            sb.append(EXTERNAL_DECIMAL_TD_ATTR_HOST_CODEPAGE);
            sb.append("=\"");
            sb.append(extDecTD.getHostCodepage());
            sb.append("\"");
        }
        sb.append("\n");
        return new String[]{sb.toString()};
    }

    public String[] convertToDoclets(UnicodeExternalDecimalTD extDecTD) {
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(UNICODE_EXTERNAL_DECIMAL_TD_TAG_NAME);
        if (extDecTD.isSetBigEndian()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_BIG_ENDIAN);
            sb.append("=\"");
            sb.append(extDecTD.getBigEndian().toString());
            sb.append("\"");
        }
        if (extDecTD.isSetSigned()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_SIGNED);
            sb.append("=\"");
            sb.append(extDecTD.getSigned().toString());
            sb.append("\"");
        }
        if (extDecTD.isSetVirtualDecimalPoint()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_VIRTUAL_DECIMAL_POINT);
            sb.append("=\"");
            sb.append(Integer.toString(extDecTD.getVirtualDecimalPoint()));
            sb.append("\"");
        }
        if (extDecTD.isSetSignFormat()) {
            sb.append(" ");
            sb.append(EXTERNAL_DECIMAL_TD_ATTR_SIGN_FORMAT);
            sb.append("=\"");
            SignFormatValue sfv = extDecTD.getSignFormat();
            sb.append(sfv.getName());
            sb.append("\"");
        }
        if (extDecTD.isSetEncoding()) {
            sb.append(" ");
            sb.append(UNICODE_EXTERNAL_DECIMAL_TD_ATTR_ENCODING);
            sb.append("=\"");
            UnicodeTransformationFormat utf = extDecTD.getEncoding();
            sb.append(utf.getName());
            sb.append("\"");
        }
        sb.append("\n");
        return new String[]{sb.toString()};
    }

    public String[] convertToDoclets(PackedDecimalTD packedDecTD) {
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(PACKED_DECIMAL_TD_TAG_NAME);
        if (packedDecTD.isSetBigEndian()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_BIG_ENDIAN);
            sb.append("=\"");
            sb.append(packedDecTD.getBigEndian().toString());
            sb.append("\"");
        }
        if (packedDecTD.isSetSigned()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_SIGNED);
            sb.append("=\"");
            sb.append(packedDecTD.getSigned().toString());
            sb.append("\"");
        }
        if (packedDecTD.isSetVirtualDecimalPoint()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_VIRTUAL_DECIMAL_POINT);
            sb.append("=\"");
            sb.append(Integer.toString(packedDecTD.getVirtualDecimalPoint()));
            sb.append("\"");
        }
        sb.append("\n");
        return new String[]{sb.toString()};
    }

    public String[] convertToDoclets(IntegerTD integerTD) {
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(INTEGER_TD_TAG_NAME);
        if (integerTD.isSetBigEndian()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_BIG_ENDIAN);
            sb.append("=\"");
            sb.append(integerTD.getBigEndian().toString());
            sb.append("\"");
        }
        if (integerTD.isSetSigned()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_SIGNED);
            sb.append("=\"");
            sb.append(integerTD.getSigned().toString());
            sb.append("\"");
        }
        if (integerTD.isSetVirtualDecimalPoint()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_VIRTUAL_DECIMAL_POINT);
            sb.append("=\"");
            sb.append(Integer.toString(integerTD.getVirtualDecimalPoint()));
            sb.append("\"");
        }
        if (integerTD.isSetSignCoding()) {
            sb.append(" ");
            sb.append(INTEGER_TD_ATTR_SIGN_CODING);
            sb.append("=\"");
            SignCodingValue scv = integerTD.getSignCoding();
            sb.append(scv.getName());
            sb.append("\"");
        }
        sb.append("\n");
        return new String[]{sb.toString()};
    }

    public String[] convertToDoclets(FloatTD floatTD) {
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(FLOAT_TD_TAG_NAME);
        if (floatTD.isSetBigEndian()) {
            sb.append(" ");
            sb.append(NUMBER_TD_ATTR_BIG_ENDIAN);
            sb.append("=\"");
            sb.append(floatTD.getBigEndian().toString());
            sb.append("\"");
        }
        if (floatTD.isSetFloatType()) {
            sb.append(" ");
            sb.append(FLOAT_TD_ATTR_FLOAT_TYPE);
            sb.append("=\"");
            FloatValue fv = floatTD.getFloatType();
            sb.append(fv.getName());
            sb.append("\"");
        }
        sb.append("\n");
        return new String[]{sb.toString()};
    }

    public String[] convertToDoclets(BinaryTD binaryTD) {
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(BINARY_TD_TAG_NAME);
        sb.append("\n");
        return new String[]{sb.toString()};
    }

    public String[] convertToDoclets(AddressTD addressTD) {
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(ADDRESS_TD_TAG_NAME);
        sb.append("\n");
        return new String[]{sb.toString()};
    }

    public String[] convertToDoclets(DateTD dateTD) {
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(DATE_TD_TAG_NAME);
        sb.append("\n");
        return new String[]{sb.toString()};
    }
}

