/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.annotations;

import com.ibm.etools.typedescriptor.AccessorValue;
import com.ibm.etools.typedescriptor.ExternalDecimalSignValue;
import com.ibm.etools.typedescriptor.FloatValue;
import com.ibm.etools.typedescriptor.LengthEncodingValue;
import com.ibm.etools.typedescriptor.NumeralShapes;
import com.ibm.etools.typedescriptor.Orientation;
import com.ibm.etools.typedescriptor.SignCodingValue;
import com.ibm.etools.typedescriptor.SignFormatValue;
import com.ibm.etools.typedescriptor.StringJustificationKind;
import com.ibm.etools.typedescriptor.TextShapes;
import com.ibm.etools.typedescriptor.TypeOfText;
import com.ibm.etools.typedescriptor.UnicodeTransformationFormat;
import com.ibm.record.writer.MessageResource;
import com.ibm.record.writer.internal.annotations.ValidationUtils;
import com.ibm.zcc.ws.rd.annotations.core.MethodTagData;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import java.util.Map;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.osgi.util.NLS;

public class TypeDescriptorMethodTagData
extends MethodTagData {
    private boolean beenValidatedOnce_ = false;

    public TypeDescriptorMethodTagData(String name, Map data, MethodDeclaration md) {
        super(name, data, md);
    }

    public TypeDescriptorMethodTagData(TagData td) {
        super(td);
    }

    public boolean beenValidatedOnce() {
        return this.beenValidatedOnce_;
    }

    protected void setValidated() {
        this.beenValidatedOnce_ = true;
    }

    public boolean isValid() {
        boolean isValid = true;
        this.beenValidatedOnce_ = true;
        String tagName = this.getName();
        if (tagName.equals("type-descriptor.aggregate-instance-td-method")) {
            isValid = this.validateAggregateTD();
        } else if (tagName.equals("type-descriptor.simple-instance-td")) {
            isValid = this.validateSimpleInstanceTD();
        } else if (tagName.equals("type-descriptor.array-td")) {
            isValid = ValidationUtils.validateArrayTD((TagData)this);
        } else if (tagName.equals("type-descriptor.string-td")) {
            isValid = this.validateStringTD();
        } else if (tagName.equals("type-descriptor.bi-direction-string-td")) {
            isValid = this.validateBidiTD();
        } else if (tagName.equals("type-descriptor.external-decimal-td")) {
            isValid = this.validateExternalDecimalTD();
        } else if (tagName.equals("type-descriptor.unicode-external-decimal-td")) {
            isValid = this.validateUnicodeExternalDecimalTD();
        } else if (tagName.equals("type-descriptor.packed-decimal-td")) {
            isValid = this.validatePackedDecimalTD();
        } else if (tagName.equals("type-descriptor.integer-td")) {
            isValid = this.validateIntegerTD();
        } else if (tagName.equals("type-descriptor.float-td")) {
            isValid = this.validateFloatTD();
        } else if (tagName.equals("type-descriptor.binary-td")) {
            isValid = this.validateBinaryTD();
        } else if (tagName.equals("type-descriptor.address-td")) {
            isValid = this.validateAddressTD();
        } else if (tagName.equals("type-descriptor.date-td")) {
            isValid = this.validateDateTD();
        }
        return isValid;
    }

    private boolean validateAggregateTD() {
        AccessorValue av;
        boolean isValid = true;
        String accessor = this.get("accessor");
        if (accessor != null && (av = AccessorValue.get((String)accessor)) == null) {
            this.validEnum(accessor, "accessor", ValidationUtils.getAccessorValueChoice());
            isValid = false;
        }
        return isValid;
    }

    private boolean validateSimpleInstanceTD() {
        String size;
        AccessorValue av;
        boolean isValid = true;
        String accessor = this.get("accessor");
        if (accessor != null && (av = AccessorValue.get((String)accessor)) == null) {
            this.validEnum(accessor, "accessor", ValidationUtils.getAccessorValueChoice());
            isValid = false;
        }
        if ((size = this.get("size")) != null) {
            isValid = isValid && ValidationUtils.validatePositiveInteger(size, "size", (TagData)this);
        }
        return isValid;
    }

    private boolean validateStringTD() {
        StringJustificationKind sjk;
        String justification;
        String prefixLength;
        LengthEncodingValue lev;
        String lengthEncoding;
        String dbcsOnly;
        String codePage;
        boolean isValid = true;
        String characterSize = this.get("characterSize");
        if (characterSize != null) {
            boolean bl = isValid = isValid && ValidationUtils.validatePositiveInteger(characterSize, "characterSize", (TagData)this);
        }
        if ((codePage = this.get("codepage")) != null) {
            boolean bl = isValid = isValid && ValidationUtils.validateCodepage(codePage, (TagData)this, "codepage");
        }
        if ((dbcsOnly = this.get("dBCSOnly")) != null && !this.validEnum(dbcsOnly, "dBCSOnly", ValidationUtils.getTrueFalseChoice())) {
            isValid = false;
        }
        if ((lengthEncoding = this.get("lengthEncoding")) != null && (lev = LengthEncodingValue.get((String)lengthEncoding)) == null) {
            this.validEnum(lengthEncoding, "lengthEncoding", ValidationUtils.getLengthEncodingValueChoice());
            isValid = false;
        }
        if ((prefixLength = this.get("prefixLength")) != null) {
            boolean bl = isValid = isValid && ValidationUtils.validatePositiveInteger(prefixLength, "prefixLength", (TagData)this);
        }
        if ((justification = this.get("stringJustification")) != null && (sjk = StringJustificationKind.get((String)justification)) == null) {
            this.validEnum(justification, "stringJustification", ValidationUtils.getStringJustificationKindChoice());
            isValid = false;
        }
        return isValid;
    }

    private boolean validateBidiTD() {
        TypeOfText tt;
        String typeOfText;
        TextShapes ts;
        String textShapes;
        String symmetric;
        Orientation orient;
        String orientation;
        NumeralShapes ns;
        boolean isValid = true;
        String numeralShapes = this.get("numeralShapes");
        if (numeralShapes != null && (ns = NumeralShapes.get((String)numeralShapes)) == null) {
            this.validEnum(numeralShapes, "numeralShapes", ValidationUtils.getNumeralShapesChoice());
            isValid = false;
        }
        if ((orientation = this.get("orientation")) != null && (orient = Orientation.get((String)orientation)) == null) {
            this.validEnum(orientation, "orientation", ValidationUtils.getOrientationChoice());
            isValid = false;
        }
        if ((symmetric = this.get("symmetric")) != null && !this.validEnum(symmetric, "symmetric", ValidationUtils.getTrueFalseChoice())) {
            isValid = false;
        }
        if ((textShapes = this.get("textShape")) != null && (ts = TextShapes.get((String)textShapes)) == null) {
            this.validEnum(textShapes, "textShape", ValidationUtils.getTextShapesChoice());
            isValid = false;
        }
        if ((typeOfText = this.get("orderingScheme")) != null && (tt = TypeOfText.get((String)typeOfText)) == null) {
            this.validEnum(typeOfText, "orderingScheme", ValidationUtils.getTypeOfTextChoice());
            isValid = false;
        }
        return isValid;
    }

    private boolean validateNumberTD() {
        String virtualDecimalPoint;
        String signed;
        boolean isValid = true;
        String bigEndian = this.get("bigEndian");
        if (bigEndian != null && !this.validEnum(bigEndian, "bigEndian", ValidationUtils.getTrueFalseChoice())) {
            isValid = false;
        }
        if ((signed = this.get("signed")) != null && !this.validEnum(signed, "signed", ValidationUtils.getTrueFalseChoice())) {
            isValid = false;
        }
        if ((virtualDecimalPoint = this.get("virtualDecimalPoint")) != null) {
            try {
                Integer.parseInt(virtualDecimalPoint);
            }
            catch (NumberFormatException numberFormatException) {
                this.addErr(NLS.bind((String)MessageResource.ERR_TAG_ATTR_INVALID_NUMERICAL_VALUE, (Object)"virtualDecimalPoint"));
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean validateExternalDecimalTD() {
        String hostCodepage;
        SignFormatValue sfv;
        String signFormat;
        ExternalDecimalSignValue edsv;
        boolean isValid = this.validateNumberTD();
        String externalDecimalSign = this.get("externalDecimalSign");
        if (externalDecimalSign != null && (edsv = ExternalDecimalSignValue.get((String)externalDecimalSign)) == null) {
            this.validEnum(externalDecimalSign, "externalDecimalSign", ValidationUtils.getExternalDecimalSignValueChoice());
            isValid = false;
        }
        if ((signFormat = this.get("signFormat")) != null && (sfv = SignFormatValue.get((String)signFormat)) == null) {
            this.validEnum(signFormat, "signFormat", ValidationUtils.getSignFormatValueChoice());
            isValid = false;
        }
        if ((hostCodepage = this.get("hostCodepage")) != null) {
            isValid = isValid && ValidationUtils.validateCodepage(hostCodepage, (TagData)this, "hostCodepage");
        }
        return isValid;
    }

    private boolean validateUnicodeExternalDecimalTD() {
        UnicodeTransformationFormat utf;
        String encoding;
        SignFormatValue sfv;
        boolean isValid = this.validateNumberTD();
        String signFormat = this.get("signFormat");
        if (signFormat != null && (sfv = SignFormatValue.get((String)signFormat)) == null) {
            this.validEnum(signFormat, "signFormat", ValidationUtils.getUnicodeSignFormatValueChoice());
            isValid = false;
        }
        if ((encoding = this.get("encoding")) != null && (utf = UnicodeTransformationFormat.get((String)encoding)) == null) {
            this.validEnum(encoding, "encoding", ValidationUtils.getUnicodeTransformationFormatChoice());
            isValid = false;
        }
        return isValid;
    }

    private boolean validatePackedDecimalTD() {
        boolean isValid = this.validateNumberTD();
        return isValid;
    }

    private boolean validateIntegerTD() {
        SignCodingValue scv;
        boolean isValid = this.validateNumberTD();
        String signCoding = this.get("signCoding");
        if (signCoding != null && (scv = SignCodingValue.get((String)signCoding)) == null) {
            this.validEnum(signCoding, "signCoding", ValidationUtils.getSignCodingValueChoice());
            isValid = false;
        }
        return isValid;
    }

    private boolean validateFloatTD() {
        FloatValue scv;
        String floatType;
        boolean isValid = true;
        String bigEndian = this.get("bigEndian");
        if (bigEndian != null && !this.validEnum(bigEndian, "bigEndian", ValidationUtils.getTrueFalseChoice())) {
            isValid = false;
        }
        if ((floatType = this.get("floatType")) != null && (scv = FloatValue.get((String)floatType)) == null) {
            this.validEnum(floatType, "floatType", ValidationUtils.getFloatValueChoice());
            isValid = false;
        }
        return isValid;
    }

    private boolean validateBinaryTD() {
        return true;
    }

    private boolean validateAddressTD() {
        return true;
    }

    private boolean validateDateTD() {
        return true;
    }
}

