/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.annotations;

import com.ibm.lang.common.writer.CodegenUtil;
import com.ibm.lang.common.writer.LogFacility;
import com.ibm.record.writer.MessageResource;
import com.ibm.record.writer.WriterPlugin;
import com.ibm.record.writer.internal.annotations.BeanAnnotationMethodTagData;
import com.ibm.record.writer.internal.annotations.BeanAnnotationTypeTagData;
import com.ibm.record.writer.internal.annotations.TypeDescriptorMethodTagData;
import com.ibm.record.writer.internal.annotations.TypeDescriptorTypeTagData;
import com.ibm.record.writer.internal.j2c.J2CRecordImplementationGenerationAdapter;
import com.ibm.zcc.ws.rd.annotations.core.AnnotationTagHandler;
import com.ibm.zcc.ws.rd.annotations.core.FieldTagData;
import com.ibm.zcc.ws.rd.annotations.core.IAnnotationProcessor;
import com.ibm.zcc.ws.rd.annotations.core.MethodTagData;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import com.ibm.zcc.ws.rd.annotations.core.TagProcessingException;
import com.ibm.zcc.ws.rd.annotations.core.TypeTagData;
import com.ibm.zcc.ws.rd.annotations.util.JavaSourceContainer;
import com.ibm.zcc.ws.rd.io.IResourceHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.osgi.util.NLS;

public class TDLangAnnotationHandler
implements AnnotationTagHandler {
    private ICompilationUnit cu_ = null;
    private IAnnotationProcessor ap_ = null;
    private HashMap<String, List<TagData>> propertyToTagDataMap_ = null;
    private ArrayList<TagData> typeTagDataList_ = null;
    private TypeDeclaration typeDecl_ = null;
    private boolean registered_ = false;

    public void beginBuild(IAnnotationProcessor ap, IProject project) throws TagProcessingException {
        this.ap_ = ap;
        if (!this.registered_) {
            ap.mapTypeTagToModel((AnnotationTagHandler)this, "type-descriptor.platform-compiler-info", TypeDescriptorTypeTagData.class);
            ap.mapTypeTagToModel((AnnotationTagHandler)this, "type-descriptor.aggregate-instance-td", TypeDescriptorTypeTagData.class);
            ap.mapTypeTagToModel((AnnotationTagHandler)this, "type-descriptor.array-td-type", TypeDescriptorTypeTagData.class);
            ap.mapTypeTagToModel((AnnotationTagHandler)this, "type-descriptor.type-bi-direction-string-td", TypeDescriptorTypeTagData.class);
            ap.mapTypeTagToModel((AnnotationTagHandler)this, "type-descriptor.multiple-output", BeanAnnotationTypeTagData.class);
            ap.mapTypeTagToModel((AnnotationTagHandler)this, "type-descriptor.CICSContainer", BeanAnnotationTypeTagData.class);
            ap.mapTypeTagToModel((AnnotationTagHandler)this, "type-descriptor.trim-whitespace", BeanAnnotationTypeTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.aggregate-instance-td-method", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.simple-instance-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.array-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.string-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.bi-direction-string-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.external-decimal-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.unicode-external-decimal-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.packed-decimal-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.integer-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.float-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.binary-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.address-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.date-td", TypeDescriptorMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.depending-on-control", BeanAnnotationMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.initial-value", BeanAnnotationMethodTagData.class);
            ap.mapMethodTagToModel((AnnotationTagHandler)this, "type-descriptor.restriction", BeanAnnotationMethodTagData.class);
            this.registered_ = true;
        }
    }

    public void endBuild(IProject project) throws TagProcessingException {
        this.ap_ = null;
    }

    public void beginResource(IResource res) throws TagProcessingException {
        if (res.getType() == 1) {
            this.cu_ = JavaCore.createCompilationUnitFrom((IFile)((IFile)res));
        }
        this.propertyToTagDataMap_ = new HashMap();
        this.typeTagDataList_ = new ArrayList();
    }

    public void endResource(IResource res) throws TagProcessingException {
        boolean errorFound = false;
        if (!this.typeTagDataList_.isEmpty()) {
            for (TagData tagData : this.typeTagDataList_) {
                if (tagData.isValid()) continue;
                errorFound = true;
            }
            for (Map.Entry entry : this.propertyToTagDataMap_.entrySet()) {
                List methodDataList = (List)entry.getValue();
                for (TagData methodElement : methodDataList) {
                    if (methodElement.isValid()) continue;
                    errorFound = true;
                }
            }
            if (!errorFound) {
                List<IResource> list = this.generateImplementation();
                for (IResource resource : list) {
                    try {
                        String className;
                        int index;
                        ICompilationUnit compUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
                        IJavaElement parent = compUnit.getParent();
                        String packageName = "";
                        if (parent instanceof IPackageFragment) {
                            packageName = ((IPackageFragment)parent).getElementName();
                        }
                        if ((index = (className = compUnit.getElementName()).lastIndexOf(".java")) != -1) {
                            className = className.substring(0, index);
                        }
                        String qualifiedName = String.valueOf(packageName) + "." + className;
                        JavaSourceContainer jsc = new JavaSourceContainer(qualifiedName, compUnit.getSource());
                        jsc.setNeedsRebuild(true);
                        IPackageFragmentRoot root = CodegenUtil.getSourcePackage((IJavaProject)compUnit.getJavaProject());
                        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(root.getPath());
                        jsc.setDestinationFolder(folder);
                        this.ap_.generateResource((IResourceHolder)jsc);
                    }
                    catch (JavaModelException exc) {
                        String message = NLS.bind((String)MessageResource.ERR_RETRIEVING_JAVA_SOURCE, (Object)resource.getLocation().toOSString());
                        Status status = new Status(4, WriterPlugin.getPluginID(), 0, message, (Throwable)exc);
                        LogFacility.logErrorMessage((IStatus)status);
                        TagProcessingException newExc = new TagProcessingException(message);
                        newExc.initCause((Throwable)exc);
                        throw newExc;
                    }
                }
            }
        }
        this.cu_ = null;
        this.typeDecl_ = null;
    }

    public void handleTag(MethodTagData methodTagData, IResource res) throws TagProcessingException {
        List<TagData> methodDataList;
        String methodName;
        String key = methodName = methodTagData.getMethodName();
        if (methodName.startsWith("get")) {
            key = methodName.substring(3);
        }
        if ((methodDataList = this.propertyToTagDataMap_.get(key)) == null) {
            methodDataList = new ArrayList<TagData>();
            this.propertyToTagDataMap_.put(key, methodDataList);
        }
        methodDataList.add((TagData)methodTagData);
    }

    public void handleTag(FieldTagData fieldTagData, IResource res) throws TagProcessingException {
    }

    public void handleTag(TypeTagData typeTagData, IResource res) throws TagProcessingException {
        this.typeTagDataList_.add((TagData)typeTagData);
        if (this.typeDecl_ == null) {
            this.typeDecl_ = typeTagData.getTypeDeclaration();
        }
    }

    private List<IResource> generateImplementation() throws TagProcessingException {
        List<IResource> modifiedResources = new ArrayList<IResource>();
        if (this.cu_ == null) {
            return modifiedResources;
        }
        if (this.cu_ != null && this.typeDecl_ != null && !this.typeTagDataList_.isEmpty()) {
            J2CRecordImplementationGenerationAdapter adaptor = new J2CRecordImplementationGenerationAdapter(this.cu_, this.typeDecl_, this.typeTagDataList_, this.propertyToTagDataMap_);
            modifiedResources = adaptor.generate();
        }
        return modifiedResources;
    }

    public void clean(IProject project) throws TagProcessingException {
        this.cu_ = null;
        this.ap_ = null;
        this.propertyToTagDataMap_ = null;
        this.typeTagDataList_ = null;
        this.typeDecl_ = null;
    }

    public void generatedResourceDeleted(IFile generatedFile, IResource parentResource) {
    }

    public List getInterrestedProjects(IProject project) {
        return Collections.EMPTY_LIST;
    }

    public boolean isInterrestedProject(IProject project) {
        return false;
    }
}

