/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.annotations;

import com.ibm.record.writer.MessageResource;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import com.ibm.zcc.ws.rd.annotations.core.TypeTagData;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.osgi.util.NLS;

public class BeanAnnotationTypeTagData
extends TypeTagData {
    private boolean beenValidatedOnce_ = false;

    public BeanAnnotationTypeTagData(String name, Map data, TypeDeclaration td) {
        super(name, data, td);
    }

    public BeanAnnotationTypeTagData(TagData td) {
        super(td);
    }

    public boolean beenValidatedOnce() {
        return this.beenValidatedOnce_;
    }

    protected void setValidated() {
        this.beenValidatedOnce_ = true;
    }

    public boolean isValid() {
        boolean isValid = true;
        this.beenValidatedOnce_ = true;
        String tagName = this.getName();
        if (tagName.equals("type-descriptor.multiple-output")) {
            isValid = this.validateMultipleOutput();
        } else if (tagName.equals("type-descriptor.child-class")) {
            isValid = this.validateChildClass();
        } else if (tagName.equals("type-descriptor.CICSContainer")) {
            isValid = this.validateCICSContainer();
        }
        return isValid;
    }

    private boolean validateMultipleOutput() {
        boolean isValid = true;
        String className = this.get("class-name");
        if (className != null) {
            isValid = this.findClassNamed(className);
        }
        return isValid;
    }

    private boolean validateChildClass() {
        boolean isValid = true;
        String className = this.get("class-name");
        if (className != null) {
            isValid = this.findClassNamed(className);
        }
        return isValid;
    }

    private boolean findClassNamed(String className) {
        boolean isValid = true;
        IProject project = this.getResource().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        boolean notFound = false;
        try {
            IType type = javaProject.findType(className);
            if (type == null) {
                notFound = true;
            }
        }
        catch (JavaModelException javaModelException) {
            notFound = true;
        }
        if (notFound) {
            this.addErr(NLS.bind((String)MessageResource.ERR_CLASS_NOT_FOUND, (Object)className, (Object)project.getName()));
            isValid = false;
        }
        return isValid;
    }

    private boolean validateCICSContainer() {
        boolean isValid = true;
        String className = this.get("class-name");
        if (className != null) {
            isValid = this.findClassNamed(className);
        }
        return isValid;
    }
}

