/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.writer.internal.annotations;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.lang.common.writer.CodegenUtil;
import com.ibm.lang.common.writer.Level88;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BeanAnnotationSerializer {
    public static final String BEAN_ANNOTATIONS_TAG_SET_NAME = "type-descriptor";
    public static final String START_TYPE_DOCLET_TAG = " * @type-descriptor.";
    public static final String START_METHOD_DOCLET_TAG = "\t * @type-descriptor.";
    public static final String DEPENDING_ON_TAG_NAME = "depending-on";
    public static final String DEPENDING_ON_ATTR_DEPENDENT_FIELD = "dependentField";
    public static final String DEPENDING_ON_CONTROL_TAG_NAME = "depending-on-control";
    public static final String DEPENDING_ON_CONTROL_ATTR_FIELD_NAME = "fieldName";
    public static final String DEPENDING_ON_CONTROL_ATTR_MAX_OCCURANCES = "maxOccurances";
    public static final String DEPENDING_ON_CONTROL_ATTR_VAL_FORMULA = "valFormula";
    public static final String INITIAL_VALUE_TAG_NAME = "initial-value";
    public static final String INITIAL_VALUE_ATTR_KIND = "kind";
    public static final String INITIAL_VALUE_ATTR_VALUE = "value";
    public static final String LEVEL88_TAG_NAME = "level88";
    public static final String LEVEL88_ATTR_NAME = "name";
    public static final String LEVEL88_ATTR_VALUE = "value";
    public static final String MESSAGE_BUFFER_TAG_NAME = "message-buffer";
    public static final String MULTIPLE_OUTPUT_TAG_NAME = "multiple-output";
    public static final String MULTIPLE_OUTPUT_ATTR_CLASS_NAME = "class-name";
    public static final String RECOGNITION_DESC_TAG_NAME = "recognition-desc";
    public static final String RECOGNITION_DESC_ATTR_PATTERN = "pattern";
    public static final String RESTRICTION_TAG_NAME = "restriction";
    public static final String RESTRICTION_ATTR_LOWER_BOUND = "lowerBound";
    public static final String RESTRICTION_ATTR_UPPER_BOUND = "upperBound";
    public static final String RESTRICTION_ATTR_MAX_LENGTH = "maxLength";
    public static final String CHILD_CLASS_TAG_NAME = "child-class";
    public static final String CHILD_CLASS_ATTR_CLASS_NAME = "class-name";
    public static final String CICS_CHANNEL_TAG_NAME = "CICSChannel";
    public static final String CICS_CHANNEL_ATTR_NAME = "channel-name";
    public static final String CICS_CONTAINER_TAG_NAME = "CICSContainer";
    public static final String CICS_CONTAINER_ATTR_CONTAINER_NAME = "container-name";
    public static final String CICS_CONTAINER_ATTR_CONTAINER_TYPE = "container-type";
    public static final String CICS_CONTAINER_ATTR_CONTAINER_TYPE_VALUE_BIT = "BIT";
    public static final String CICS_CONTAINER_ATTR_CONTAINER_TYPE_VALUE_CHAR = "CHAR";
    public static final String TRIM_WHITESPACE_TAG_NAME = "trim-whitespace";
    private Map<EStructuralFeature, List<String>> level88Map_ = new HashMap<EStructuralFeature, List<String>>();
    private Map<String, String> unsignedSchmeaTypesMap_ = new HashMap<String, String>();
    private IEnvironment environment_;

    private BeanAnnotationSerializer() {
        this.unsignedSchmeaTypesMap_.put("UnsignedLong", "18446744073709551615");
        this.unsignedSchmeaTypesMap_.put("UnsignedInt", "4294967295");
        this.unsignedSchmeaTypesMap_.put("UnsignedShort", "65535");
        this.unsignedSchmeaTypesMap_.put("UnsignedByte", "255");
    }

    public BeanAnnotationSerializer(IEnvironment environment) {
        this();
        this.environment_ = environment;
    }

    public String[] convertToDoclets(EStructuralFeature sf) throws BaseException {
        EAnnotation xsdAnnotations;
        ArrayList<String> list = new ArrayList<String>();
        EAnnotation extMetaData = sf.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        if (extMetaData != null) {
            String[] xsdDoclets = this.convertSchemaMetaDataToDoclets(sf);
            int i = 0;
            while (i < xsdDoclets.length) {
                list.add(xsdDoclets[i]);
                ++i;
            }
        }
        if ((xsdAnnotations = sf.getEAnnotation("http://www.wsadie.com/appinfo")) != null) {
            String[] xsdDoclets = this.convertSchemaAnnotationsToDoclets(sf);
            int i = 0;
            while (i < xsdDoclets.length) {
                list.add(xsdDoclets[i]);
                ++i;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private String[] convertSchemaMetaDataToDoclets(EStructuralFeature sf) {
        StringBuilder sb;
        String maxValue;
        EClassifier cf = sf.getEType();
        if (!(cf instanceof EDataType)) {
            return new String[0];
        }
        EDataType dataType = (EDataType)cf;
        int lengthFacet = ExtendedMetaData.INSTANCE.getLengthFacet(dataType);
        int maxLengthFacet = ExtendedMetaData.INSTANCE.getMaxLengthFacet(dataType);
        int effectiveLengthFacet = -1;
        effectiveLengthFacet = maxLengthFacet != -1 ? maxLengthFacet : lengthFacet;
        EDataType baseType = ExtendedMetaData.INSTANCE.getBaseType(dataType);
        String minInclusiveFacet = ExtendedMetaData.INSTANCE.getMinInclusiveFacet(dataType);
        String maxInclusiveFacet = ExtendedMetaData.INSTANCE.getMaxInclusiveFacet(dataType);
        if (baseType != null && (maxValue = this.unsignedSchmeaTypesMap_.get(baseType.getName())) != null) {
            if (minInclusiveFacet == null) {
                minInclusiveFacet = "0";
            }
            if (maxInclusiveFacet == null) {
                maxInclusiveFacet = maxValue;
            }
        }
        int totalDigitsFacet = ExtendedMetaData.INSTANCE.getTotalDigitsFacet(dataType);
        int fractionDigitsFacet = ExtendedMetaData.INSTANCE.getFractionDigitsFacet(dataType);
        if (totalDigitsFacet != -1) {
            sb = new StringBuilder();
            int i = 0;
            while (i < totalDigitsFacet) {
                sb.append("9");
                ++i;
            }
            BigDecimal bd = new BigDecimal(sb.toString());
            if (fractionDigitsFacet != -1) {
                bd = bd.movePointLeft(fractionDigitsFacet);
            }
            if (minInclusiveFacet == null) {
                minInclusiveFacet = "-" + bd.toString();
            }
            if (maxInclusiveFacet == null) {
                maxInclusiveFacet = bd.toString();
            }
        }
        if (effectiveLengthFacet == -1 && minInclusiveFacet == null && maxInclusiveFacet == null) {
            return new String[0];
        }
        sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(RESTRICTION_TAG_NAME);
        if (effectiveLengthFacet != -1) {
            sb.append(" ");
            sb.append(RESTRICTION_ATTR_MAX_LENGTH);
            sb.append("=\"");
            sb.append(Integer.toString(effectiveLengthFacet));
            sb.append("\"");
        }
        if (minInclusiveFacet != null) {
            sb.append(" ");
            sb.append(RESTRICTION_ATTR_LOWER_BOUND);
            sb.append("=\"");
            sb.append(minInclusiveFacet);
            sb.append("\"");
        }
        if (maxInclusiveFacet != null) {
            sb.append(" ");
            sb.append(RESTRICTION_ATTR_UPPER_BOUND);
            sb.append("=\"");
            sb.append(maxInclusiveFacet);
            sb.append("\"");
        }
        sb.append("\n");
        return new String[]{sb.toString()};
    }

    private String[] convertSchemaAnnotationsToDoclets(EStructuralFeature sf) throws BaseException {
        EAnnotation xsdAnnotations = sf.getEAnnotation("http://www.wsadie.com/appinfo");
        if (xsdAnnotations == null) {
            return new String[0];
        }
        String appInfoString = (String)xsdAnnotations.getDetails().get((Object)"appinfo");
        if (appInfoString == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        NodeList nodes = CodegenUtil.parseXMLFragment((String)appInfoString, (IEnvironment)this.environment_);
        if (nodes == null) {
            return new String[0];
        }
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (!(node instanceof Text) && node instanceof Element) {
                Element element = (Element)node;
                String tagName = element.getTagName();
                if ("initialValue".equals(tagName)) {
                    list.add(this.handleInitialValueElement(element));
                } else if ("messageBuffer".equals(tagName)) {
                    list.add(this.handleMessageBufferElement(element));
                } else if ("multipleOutput".equals(tagName)) {
                    list.add(this.handleMultipleOutputElement(element));
                } else if ("dependingOn".equals(tagName)) {
                    list.add(this.handleODOElement(element));
                } else if ("recognitionDesc".equals(tagName)) {
                    list.add(this.handleRecognitionDescElement(element));
                } else if (LEVEL88_TAG_NAME.equals(tagName)) {
                    list.add(this.handleLevel88Element(element, sf));
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private String handleLevel88Element(Element element, EStructuralFeature sf) {
        Level88 level88 = CodegenUtil.getLevel88Text((Element)element);
        String level88Text = level88.level88Value.replaceAll("\"", "&quot;");
        String name = level88.level88Name;
        if (level88Text == null || level88Text.equals("")) {
            return "";
        }
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(LEVEL88_TAG_NAME);
        sb.append(" ");
        sb.append(LEVEL88_ATTR_NAME);
        sb.append("=\"");
        sb.append(name);
        sb.append("\"");
        sb.append(" ");
        sb.append("value");
        sb.append("=\"");
        sb.append(level88Text);
        sb.append("\"");
        sb.append("\n");
        List<String> level88List = this.level88Map_.get(sf);
        if (level88List == null) {
            level88List = new ArrayList<String>();
            this.level88Map_.put(sf, level88List);
        }
        level88List.add(name);
        return sb.toString();
    }

    private String handleRecognitionDescElement(Element element) {
        String pattern = element.getAttribute(RECOGNITION_DESC_ATTR_PATTERN);
        if (pattern == null || pattern.equals("")) {
            return "";
        }
        pattern = pattern.replaceAll("\"", "&quot;");
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(RECOGNITION_DESC_TAG_NAME);
        sb.append(" ");
        sb.append(RECOGNITION_DESC_ATTR_PATTERN);
        sb.append("=\"");
        sb.append(pattern);
        sb.append("\"");
        sb.append("\n");
        return sb.toString();
    }

    private String handleODOElement(Element element) {
        String dependentField = CodegenUtil.getElementText((Element)element);
        if (dependentField == null || dependentField.equals("")) {
            return "";
        }
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(DEPENDING_ON_TAG_NAME);
        sb.append(" ");
        sb.append(DEPENDING_ON_ATTR_DEPENDENT_FIELD);
        sb.append("=\"");
        sb.append(dependentField);
        sb.append("\"");
        sb.append("\n");
        return sb.toString();
    }

    private String handleMultipleOutputElement(Element element) {
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(MULTIPLE_OUTPUT_TAG_NAME);
        sb.append("\n");
        return sb.toString();
    }

    private String handleMessageBufferElement(Element element) {
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(MESSAGE_BUFFER_TAG_NAME);
        sb.append("\n");
        return sb.toString();
    }

    private String handleInitialValueElement(Element element) {
        String kind = element.getAttribute(INITIAL_VALUE_ATTR_KIND);
        String value = element.getAttribute("value");
        if (kind == null || kind.equals("")) {
            return "";
        }
        StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
        sb.append(INITIAL_VALUE_TAG_NAME);
        sb.append(" ");
        sb.append(INITIAL_VALUE_ATTR_KIND);
        sb.append("=\"");
        sb.append(kind);
        sb.append("\"");
        if (value != null && !value.equals("")) {
            sb.append(" ");
            sb.append("value");
            sb.append("=\"");
            sb.append(value);
            sb.append("\"");
        }
        sb.append("\n");
        return sb.toString();
    }

    public String[] convertODODependentMapToDoclets(Map<String, String> ODODependentMap) {
        ArrayList<String> aList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : ODODependentMap.entrySet()) {
            String ctrlField = entry.getKey();
            String value = entry.getValue();
            int index = value.indexOf(58);
            if (index == -1) continue;
            String maxOccurs = value.substring(0, index);
            String valFormula = value.substring(index + 1);
            StringBuilder sb = new StringBuilder(START_METHOD_DOCLET_TAG);
            sb.append(DEPENDING_ON_CONTROL_TAG_NAME);
            sb.append(" ");
            sb.append(DEPENDING_ON_CONTROL_ATTR_FIELD_NAME);
            sb.append("=\"");
            sb.append(ctrlField);
            sb.append("\"");
            sb.append(" ");
            sb.append(DEPENDING_ON_CONTROL_ATTR_MAX_OCCURANCES);
            sb.append("=\"");
            sb.append(maxOccurs);
            sb.append("\"");
            sb.append(" ");
            sb.append(DEPENDING_ON_CONTROL_ATTR_VAL_FORMULA);
            sb.append("=\"");
            sb.append(valFormula);
            sb.append("\"");
            sb.append("\n");
            aList.add(sb.toString());
        }
        return aList.toArray(new String[aList.size()]);
    }

    public List<String> getLevel88sForFeature(EStructuralFeature sf) {
        return this.level88Map_.get(sf);
    }
}

