/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.rest.db2.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import java.util.Iterator;
import java.util.Map;

public class JsonSchemaUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = JsonSchemaUtil.class.getName();

    public static void cleanSchema(JsonObject json) {
        ZCeeUILogger.info((String)"Cleaning schema: {0}", (Object[])new Object[]{json});
        JsonSchemaUtil.clean(json);
        ZCeeUILogger.info((String)"Cleaned schema:  {0}", (Object[])new Object[]{json});
    }

    private static void clean(JsonObject json) {
        block16: {
            JsonElement type;
            block17: {
                if (json == null || (type = json.get("type")) == null) break block16;
                if (!type.isJsonArray()) break block17;
                JsonArray typeArray = type.getAsJsonArray();
                Iterator it = typeArray.iterator();
                while (it.hasNext()) {
                    JsonElement jsonElement = (JsonElement)it.next();
                    if (!jsonElement.isJsonPrimitive() || !jsonElement.getAsJsonPrimitive().isString() || !jsonElement.getAsJsonPrimitive().getAsString().equals("null")) continue;
                    it.remove();
                }
                if (typeArray.size() == 1) {
                    json.add("type", typeArray.get(0));
                }
                break block16;
            }
            switch (type.getAsString()) {
                case "object": {
                    JsonObject properties = json.getAsJsonObject("properties");
                    if (properties == null) break;
                    for (Map.Entry property : properties.entrySet()) {
                        JsonSchemaUtil.clean(((JsonElement)property.getValue()).getAsJsonObject());
                    }
                    break;
                }
                case "array": {
                    JsonElement itemsValue = json.get("items");
                    if (itemsValue instanceof JsonArray) {
                        JsonArray itemsArray = (JsonArray)itemsValue;
                        for (JsonElement item : itemsArray) {
                            JsonSchemaUtil.clean(item.getAsJsonObject());
                        }
                    } else {
                        JsonSchemaUtil.clean((JsonObject)itemsValue);
                    }
                    JsonElement additionalItemsValue = json.get("additionalItems");
                    if (!(additionalItemsValue instanceof JsonObject)) break;
                    JsonSchemaUtil.clean((JsonObject)additionalItemsValue);
                }
            }
        }
    }
}

