/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.rest.db2.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServicePropertiesValidator;
import com.ibm.zosconnect.ui.service.rest.db2.Db2Xlat;
import com.ibm.zosconnect.ui.service.rest.db2.util.JsonSchemaUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;

public class Db2PropertiesValidator
implements IServicePropertiesValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public final String className = this.getClass().getName();
    public static final String DB2_SERVICE_NAME = "db2ServiceName";
    public static final String DB2_SERVICE_VERSION = "db2ServiceVersion";
    public static final String COLLECTION_ID = "collectionId";
    public static final String REQUEST_SCHEMA_NAME = "requestSchemaFile";
    public static final String RESPONSE_SCHEMA_NAME = "responseSchemaFile";
    public static final String CONNECTION_REF_KEY = "connectionRef";
    public static final String PROVIDER = "provider";
    public static final String VERB = "verb";
    public static final String URI = "uri";
    public static final String RESPONSE_SCHEMA_DIRECTORY = "schemas/response/";
    public static final String REQUEST_SCHEMA_DIRECTORY = "schemas/request/";
    public static final Pattern SERVICE_VERSION_LEGAL_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9@#_$.-]");
    public static final Pattern SERVICE_NAME_LEGAL_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9@#_$-]");
    public static final Pattern COLLECTION_ID_LEGAL_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9@#_$]");

    public List<ServiceProjectValidationError> validateDefinitionProperty(IResource resource, String key, String value) {
        String methodName = "validateDefinitionProperty";
        ZCeeUILogger.entering((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{resource, key, value});
        ArrayList<ServiceProjectValidationError> result = new ArrayList<ServiceProjectValidationError>();
        if (value == null) {
            String msg = Xlat.error((String)"REQUIRED_SERVICE_PROPERTY_MISSING", (String[])new String[]{key});
            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
            ZCeeUILogger.exiting((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{result});
            return result;
        }
        ServiceProjectValidationError error = null;
        switch (key) {
            case "db2ServiceName": {
                String illegalCharacters = this.isPropertyValid(value, SERVICE_NAME_LEGAL_CHAR_PATTERN);
                if (value.isEmpty()) {
                    String msg = Xlat.error((String)"MUST_CONTAIN_1_CHARACTER", (String[])new String[]{Db2Xlat.label("SERVICEEDIT_DB2_SERVICE_NAME_LABEL")});
                    result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
                    break;
                }
                if (value.length() > 128) {
                    String msg = Xlat.error((String)"MUST_BE_LESS_THAN_CHARACTERS", (String[])new String[]{Db2Xlat.label("SERVICEEDIT_DB2_SERVICE_NAME_LABEL"), "129"});
                    error = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg);
                    error.getAttributes().put("key", Db2Xlat.label("SERVICEEDIT_DB2_SERVICE_NAME_LABEL"));
                    error.getAttributes().put("value", value);
                    result.add(error);
                    break;
                }
                if (illegalCharacters.isEmpty()) break;
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_HTTP_HEADERS_INVALID_CHAR", (String[])new String[]{Db2Xlat.label("SERVICEEDIT_DB2_SERVICE_NAME_LABEL"), illegalCharacters})));
                break;
            }
            case "db2ServiceVersion": {
                String illegalCharacters = this.isPropertyValid(value, SERVICE_VERSION_LEGAL_CHAR_PATTERN);
                if (value.length() > 64) {
                    String msg = Xlat.error((String)"MUST_BE_LESS_THAN_CHARACTERS", (String[])new String[]{Db2Xlat.label("SERVICEEDIT_DB2_SERVICE_VERSION_LABEL"), "65"});
                    error = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg);
                    error.getAttributes().put("key", Db2Xlat.label("SERVICEEDIT_DB2_SERVICE_VERSION_LABEL"));
                    error.getAttributes().put("value", value);
                    result.add(error);
                    break;
                }
                if (illegalCharacters.isEmpty()) break;
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_HTTP_HEADERS_INVALID_CHAR", (String[])new String[]{Db2Xlat.label("SERVICEEDIT_DB2_SERVICE_VERSION_LABEL"), illegalCharacters})));
                break;
            }
            case "collectionId": {
                String illegalCharacters = this.isPropertyValid(value, COLLECTION_ID_LEGAL_CHAR_PATTERN);
                if (value.isEmpty()) {
                    String msg = Xlat.error((String)"MUST_CONTAIN_1_CHARACTER", (String[])new String[]{Db2Xlat.label("SERVICEEDIT_COLLECTION_ID_LABEL")});
                    result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
                    break;
                }
                if (value.length() > 128) {
                    String msg = Xlat.error((String)"MUST_BE_LESS_THAN_CHARACTERS", (String[])new String[]{Db2Xlat.label("SERVICEEDIT_COLLECTION_ID_LABEL"), "129"});
                    error = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg);
                    error.getAttributes().put("key", Db2Xlat.label("SERVICEEDIT_COLLECTION_ID_LABEL"));
                    error.getAttributes().put("value", value);
                    result.add(error);
                    break;
                }
                if (illegalCharacters.isEmpty()) break;
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"CICS_HTTP_HEADERS_INVALID_CHAR", (String[])new String[]{Db2Xlat.label("SERVICEEDIT_COLLECTION_ID_LABEL"), illegalCharacters})));
                break;
            }
            case "requestSchemaFile": {
                result = this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_REQUEST_SCHEMA", true);
                break;
            }
            case "responseSchemaFile": {
                result = this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_RESPONSE_SCHEMA", false);
                break;
            }
            default: {
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"UNKNOWN_PROPERTY", (String[])new String[]{key})));
            }
            case "uri": 
            case "verb": 
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{result});
        return result;
    }

    public List<ServiceProjectValidationError> validateRequest(IResource resource, String value, int itemCount) {
        return this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_REQUEST_SCHEMA", true);
    }

    public List<ServiceProjectValidationError> validateResponse(IResource resource, String value, int itemCount) {
        return this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_RESPONSE_SCHEMA", false);
    }

    private List<ServiceProjectValidationError> validateRequestOrResponseFile(IResource resource, String filePath, String label, Boolean isRequest) {
        String methodName = "validateRequestOrResponseFile";
        ZCeeUILogger.entering((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{resource, filePath, label});
        ArrayList<ServiceProjectValidationError> result = new ArrayList<ServiceProjectValidationError>();
        if (filePath.isEmpty() || filePath.equals(RESPONSE_SCHEMA_DIRECTORY) || filePath.equals(REQUEST_SCHEMA_DIRECTORY)) {
            String msg = isRequest != false ? Db2Xlat.label("REQUEST_REQUIRED") : Db2Xlat.label("RESPONSE_REQUIRED");
            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
            ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
            return result;
        }
        IFile file = resource.getProject().getFile(filePath);
        if (!file.exists()) {
            String errMsgInsert = Xlat.error((String)"PROJECT_FILE_MISSING_ERROR", (String[])new String[]{filePath, resource.getProject().getName()});
            String errorMsg = Xlat.error((String)"PROPERTY_ERROR", (String[])new String[]{Db2Xlat.label(label), errMsgInsert});
            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, errorMsg));
            ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
            return result;
        }
        if (file.isReadOnly()) {
            String errMsgInsert = Xlat.error((String)"PROJECT_FILE_READ_ONLY_ERROR", (String[])new String[]{filePath, resource.getProject().getName()});
            String errorMsg = Xlat.error((String)"PROPERTY_ERROR", (String[])new String[]{Db2Xlat.label(label), errMsgInsert});
            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, errorMsg));
            ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
            return result;
        }
        ServiceProjectValidationError schemaParseError = this.parseSchemaFile(resource.getProject(), filePath);
        if (schemaParseError != null) {
            result.add(schemaParseError);
            return result;
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
        return result;
    }

    private String isPropertyValid(String value, Pattern regexPattern) {
        StringBuilder illegalCharacters = new StringBuilder();
        Matcher m = regexPattern.matcher(value);
        while (m.find()) {
            char illegalCharacter = value.charAt(m.start());
            illegalCharacters.append(illegalCharacter);
        }
        return illegalCharacters.toString();
    }

    private ServiceProjectValidationError parseSchemaFile(IProject project, String fileName) {
        String methodName = "parseSchemaFile";
        ZCeeUILogger.entering((String)this.className, (String)"parseSchemaFile", (Object[])new Object[0]);
        ServiceProjectValidationError error = null;
        String schemaFileName = String.valueOf(project.getLocation()) + File.separator + fileName;
        String projectName = project.getName();
        File schemaFile = new File(schemaFileName);
        try {
            Throwable throwable = null;
            Object var9_13 = null;
            try (BufferedReader br_schema = new BufferedReader(new FileReader(schemaFile));){
                Gson gsonObject = new Gson();
                JsonObject jsonRequest = (JsonObject)gsonObject.fromJson((Reader)br_schema, JsonObject.class);
                JsonSchemaUtil.cleanSchema(jsonRequest);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonSyntaxException jse) {
            ZCeeUILogger.error((Throwable)jse);
            String errorMessage = Db2Xlat.label("SCHEMA_ERROR", fileName, projectName);
            error = new ServiceProjectValidationError((IResource)project, ServiceProjectMarkerTypes.PROJECT_PROBLEM, errorMessage);
        }
        catch (FileNotFoundException fnfe) {
            ZCeeUILogger.error((Throwable)fnfe);
            String errorMessage = Db2Xlat.label("SCHEMA_FILE_NOT_FOUND_ERROR", fileName, projectName);
            error = new ServiceProjectValidationError((IResource)project, ServiceProjectMarkerTypes.PROJECT_PROBLEM, errorMessage);
        }
        catch (IOException ioe) {
            ZCeeUILogger.error((Throwable)ioe);
            String errorMessage = Db2Xlat.label("SCHEMA_IO_ERROR", fileName, projectName);
            error = new ServiceProjectValidationError((IResource)project, ServiceProjectMarkerTypes.PROJECT_PROBLEM, errorMessage);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"parseSchemaFile", (Object[])new Object[0]);
        return error;
    }

    public ServiceProjectValidationError validateConfigurationProperty(ServiceProjectController serviceController, IResource resource, String key, String value, boolean isRequired, String propertyType) {
        ServiceProjectValidationError result = null;
        if (isRequired && (value == null || value.isEmpty())) {
            return Db2PropertiesValidator.getMissingRequiredPropertyError(resource, key);
        }
        return result;
    }

    public ServiceProjectValidationError validateConfigurationProperty(ServiceProjectController serviceController, IMessageManager messageMgr, HashMap<String, Control> configurationControls, IResource resource, ServiceExtensionProperty extensionProperty, String value) {
        ServiceProjectValidationError result = null;
        boolean isRequired = extensionProperty.isRequired();
        String propertyType = extensionProperty.getPropertyType();
        String key = extensionProperty.getPropertyName();
        result = this.validateConfigurationProperty(serviceController, resource, key, value, isRequired, propertyType);
        return result;
    }

    private static ServiceProjectValidationError getMissingRequiredPropertyError(IResource resource, String key) {
        return new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"MISSING_REQUIRED_PROPERTY", (String[])new String[]{key}));
    }
}

