/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.rest.db2.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceModelController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceProjectController;
import com.ibm.zosconnect.ui.service.interfaces.IServiceOverviewComposite;
import com.ibm.zosconnect.ui.service.interfaces.IServiceProjectEditor;
import com.ibm.zosconnect.ui.service.rest.db2.Db2Xlat;
import com.ibm.zosconnect.ui.service.rest.db2.controllers.ImportDb2ServicesController;
import com.ibm.zosconnect.ui.service.rest.db2.impl.Db2PropertiesValidator;
import com.ibm.zosconnect.ui.service.rest.db2.util.JsonSchemaUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class Db2CompositeImpl
implements IServiceOverviewComposite {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String className = this.getClass().getName();
    private Combo requestSchema;
    private Combo responseSchema;
    private Text collectionId;
    private Text db2ServiceName;
    private Text db2ServiceVersion;
    private IServiceProjectEditor serviceProjectEditor;
    private static final String REQUEST_SCHEMA_FILE = "requestSchemaFile";
    private static final String RESPONSE_SCHEMA_FILE = "responseSchemaFile";
    private static final String REQUEST_SCHEMA_DIRECTORY = "schemas/request/";
    private static final String RESPONSE_SCHEMA_DIRECTORY = "schemas/response/";
    private static QualifiedName PROP_DB2_IMPORT_LOCAL_FILEPATH = new QualifiedName("com.ibm.zosconnect.ui", "db2.import.local.filepath");
    private static final String DECFLOAT_34_FORMAT = "DECFLOAT(34)";

    public List<String> getCustomActions() {
        ArrayList<String> listOfActions = new ArrayList<String>();
        listOfActions.add(Db2Xlat.label("SERVICEEDIT_ACTIONS_SCHEMAS"));
        return listOfActions;
    }

    public LinkedHashMap<Composite, String> getComposites(FormToolkit formToolkit, Composite parent, final IServiceProjectEditor serviceProjectEditor) {
        String methodName = "getComposites";
        ZCeeUILogger.entering((String)this.className, (String)"getComposites", (Object[])new Object[0]);
        LinkedHashMap<Composite, String> listOfComposites = new LinkedHashMap<Composite, String>();
        this.serviceProjectEditor = serviceProjectEditor;
        Composite composite = formToolkit.createComposite(parent, 0);
        GridLayout gd_composite = new GridLayoutBuilder().numColumns(3).verticalSpacing(7).horizontalSpacing(15).marginWidth(0).marginHeight(0).build();
        composite.setLayout((Layout)gd_composite);
        int inputFieldWidthHint = XSwt.getAverageCharWidth((Control)composite) * 55;
        Label lblDescription = formToolkit.createLabel(composite, Db2Xlat.label("SERVICEEDIT_DEFINE_DB2_DESCRIPTION"), 0);
        lblDescription.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        Button importDb2 = new Button(composite, 0);
        importDb2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        importDb2.setText(Db2Xlat.label("SERVICEEDIT_IMPORT_DB2"));
        importDb2.setToolTipText(Db2Xlat.label("SERVICEEDIT_IMPORT_DB2_TOOLTIP"));
        importDb2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDb2ServicesController importController = new ImportDb2ServicesController(serviceProjectEditor.getServiceProjectController().getProject(), serviceProjectEditor.getServiceProjectController());
                if (importController.openDialog() == 0) {
                    if (importController.getDb2NativeServiceDetail().getServiceCollectionID() != null) {
                        Db2CompositeImpl.this.collectionId.setText(importController.getDb2NativeServiceDetail().getServiceCollectionID());
                    }
                    Db2CompositeImpl.this.db2ServiceName.setText(importController.getDb2NativeServiceDetail().getServiceName());
                    if (importController.getDb2NativeServiceDetail().getVersion() != null) {
                        Db2CompositeImpl.this.db2ServiceVersion.setText(importController.getDb2NativeServiceDetail().getVersion());
                    }
                    Db2CompositeImpl.this.requestSchema.add("request-schema.json");
                    Db2CompositeImpl.this.requestSchema.select(Db2CompositeImpl.this.requestSchema.indexOf("request-schema.json"));
                    Db2CompositeImpl.this.responseSchema.add("response-schema.json");
                    Db2CompositeImpl.this.responseSchema.select(Db2CompositeImpl.this.responseSchema.indexOf("response-schema.json"));
                }
            }
        });
        formToolkit.adapt((Control)importDb2, true, true);
        formToolkit.createLabel(composite, Db2Xlat.label("SERVICEEDIT_COLLECTION_ID_LABEL") + Xlat.colon(), 0);
        this.collectionId = formToolkit.createText(composite, "", 2048);
        GridData gd_collectionId = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_collectionId.widthHint = inputFieldWidthHint;
        this.collectionId.setLayoutData((Object)gd_collectionId);
        this.collectionId.setMessage(Db2Xlat.label("SERVICEEDIT_COLLECTION_ID_PLACEHOLDER"));
        this.collectionId.setTextLimit(128);
        this.collectionId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String key = "collectionId";
                serviceProjectEditor.getServiceProjectController().getServiceModel().setValue(key, Db2CompositeImpl.this.collectionId.getText().trim());
                Db2CompositeImpl.this.setUri(serviceProjectEditor.getServiceProjectController().getServiceModel());
                List<ServiceProjectValidationError> errorValidation = new Db2PropertiesValidator().validateDefinitionProperty(serviceProjectEditor.getServiceProjectController().getServiceModel().getResource(), key, Db2CompositeImpl.this.collectionId.getText());
                if (errorValidation != null && !errorValidation.isEmpty()) {
                    serviceProjectEditor.getServiceProjectValidator().setControlToError(serviceProjectEditor.getMessageManager(), key, errorValidation.get(0), (Control)Db2CompositeImpl.this.collectionId);
                } else {
                    serviceProjectEditor.getServiceProjectValidator().resetControlToError(serviceProjectEditor.getMessageManager(), key, (Control)Db2CompositeImpl.this.collectionId);
                }
                serviceProjectEditor.setDirty(true);
            }
        });
        formToolkit.createLabel(composite, "");
        formToolkit.createLabel(composite, Db2Xlat.label("SERVICEEDIT_DB2_SERVICE_NAME_LABEL") + Xlat.colon(), 0);
        this.db2ServiceName = formToolkit.createText(composite, "", 2048);
        GridData gd_db2ServiceName = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_db2ServiceName.widthHint = inputFieldWidthHint;
        this.db2ServiceName.setLayoutData((Object)gd_db2ServiceName);
        this.db2ServiceName.setMessage(Db2Xlat.label("SERVICEEDIT_DB2_SERVICE_NAME_PLACEHOLDER"));
        this.db2ServiceName.setTextLimit(128);
        formToolkit.createLabel(composite, "");
        this.db2ServiceName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String key = "db2ServiceName";
                serviceProjectEditor.getServiceProjectController().getServiceModel().setValue(key, Db2CompositeImpl.this.db2ServiceName.getText().trim());
                Db2CompositeImpl.this.setUri(serviceProjectEditor.getServiceProjectController().getServiceModel());
                List<ServiceProjectValidationError> errorValidation = new Db2PropertiesValidator().validateDefinitionProperty(serviceProjectEditor.getServiceProjectController().getServiceModel().getResource(), key, Db2CompositeImpl.this.db2ServiceName.getText());
                if (errorValidation != null && !errorValidation.isEmpty()) {
                    serviceProjectEditor.getServiceProjectValidator().setControlToError(serviceProjectEditor.getMessageManager(), key, errorValidation.get(0), (Control)Db2CompositeImpl.this.db2ServiceName);
                } else {
                    serviceProjectEditor.getServiceProjectValidator().resetControlToError(serviceProjectEditor.getMessageManager(), key, (Control)Db2CompositeImpl.this.db2ServiceName);
                }
                serviceProjectEditor.setDirty(true);
            }
        });
        formToolkit.createLabel(composite, Db2Xlat.label("SERVICEEDIT_DB2_SERVICE_VERSION_LABEL") + Xlat.colon(), 0);
        this.db2ServiceVersion = formToolkit.createText(composite, "", 2048);
        GridData gd_db2ServiceVersion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_db2ServiceVersion.widthHint = inputFieldWidthHint;
        this.db2ServiceVersion.setLayoutData((Object)gd_db2ServiceVersion);
        this.db2ServiceVersion.setMessage(Db2Xlat.label("SERVICEEDIT_DB2_SERVICE_VERSION_PLACEHOLDER"));
        this.db2ServiceVersion.setTextLimit(64);
        this.db2ServiceVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String key = "db2ServiceVersion";
                serviceProjectEditor.getServiceProjectController().getServiceModel().setValue(key, Db2CompositeImpl.this.db2ServiceVersion.getText().trim());
                Db2CompositeImpl.this.setUri(serviceProjectEditor.getServiceProjectController().getServiceModel());
                List<ServiceProjectValidationError> errorValidation = new Db2PropertiesValidator().validateDefinitionProperty(serviceProjectEditor.getServiceProjectController().getServiceModel().getResource(), key, Db2CompositeImpl.this.db2ServiceVersion.getText());
                if (errorValidation != null && !errorValidation.isEmpty()) {
                    serviceProjectEditor.getServiceProjectValidator().setControlToError(serviceProjectEditor.getMessageManager(), key, errorValidation.get(0), (Control)Db2CompositeImpl.this.db2ServiceVersion);
                } else {
                    serviceProjectEditor.getServiceProjectValidator().resetControlToError(serviceProjectEditor.getMessageManager(), key, (Control)Db2CompositeImpl.this.db2ServiceVersion);
                }
                serviceProjectEditor.setDirty(true);
            }
        });
        formToolkit.createLabel(composite, "");
        Label requestSchemaLabel = formToolkit.createLabel(composite, Db2Xlat.label("SERVICEEDIT_LABEL_REQUEST_SCHEMA") + Xlat.colon(), 0);
        GridData gd_requestSchemaLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        requestSchemaLabel.setLayoutData((Object)gd_requestSchemaLabel);
        this.requestSchema = new Combo(composite, 8);
        this.updateComboOptions(this.requestSchema, serviceProjectEditor, REQUEST_SCHEMA_DIRECTORY, REQUEST_SCHEMA_FILE);
        GridData gd_request = new GridData(4, 4, false, false, 1, 1);
        this.requestSchema.setLayoutData((Object)gd_request);
        formToolkit.adapt((Control)this.requestSchema, true, true);
        formToolkit.paintBordersFor((Composite)this.requestSchema);
        List<ServiceProjectValidationError> validationErrorsReq = new Db2PropertiesValidator().validateRequest(serviceProjectEditor.getServiceProjectController().getServiceModel().getResource(), REQUEST_SCHEMA_DIRECTORY + this.requestSchema.getText(), this.requestSchema.getItemCount());
        if (validationErrorsReq != null && !validationErrorsReq.isEmpty()) {
            ServiceProjectValidationError firstError = validationErrorsReq.get(0);
            serviceProjectEditor.getServiceProjectValidator().setControlToError(serviceProjectEditor.getMessageManager(), REQUEST_SCHEMA_FILE, firstError, (Control)this.requestSchema);
        } else {
            serviceProjectEditor.getServiceProjectValidator().resetControlToError(serviceProjectEditor.getMessageManager(), REQUEST_SCHEMA_FILE, (Control)this.requestSchema);
        }
        this.requestSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!serviceProjectEditor.isLoading()) {
                    Db2CompositeImpl.this.validateRequestCombo();
                }
            }
        });
        final Button importRequestLocal = new Button(composite, 0);
        importRequestLocal.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        importRequestLocal.setText(Db2Xlat.label("SERVICEEDIT_BUTTON_IMPORT_LOCAL"));
        importRequestLocal.setToolTipText(Db2Xlat.label("SERVICEEDIT_BUTTON_IMPORT_LOCAL_REQUEST_TOOLTIP"));
        importRequestLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File destinationDirectory = serviceProjectEditor.getServiceProjectController().getServiceModel().getServiceProject().getLocation().append("schemas").append("request").toFile();
                Db2CompositeImpl.this.importLocalFile(importRequestLocal, serviceProjectEditor, destinationDirectory, Db2CompositeImpl.REQUEST_SCHEMA_FILE, Db2CompositeImpl.REQUEST_SCHEMA_DIRECTORY);
            }
        });
        formToolkit.adapt((Control)importRequestLocal, true, true);
        Label responseSchemaLabel = formToolkit.createLabel(composite, Db2Xlat.label("SERVICEEDIT_LABEL_RESPONSE_SCHEMA") + Xlat.colon(), 0);
        GridData gd_responseSchemaLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        responseSchemaLabel.setLayoutData((Object)gd_responseSchemaLabel);
        this.responseSchema = new Combo(composite, 8);
        this.updateComboOptions(this.responseSchema, serviceProjectEditor, RESPONSE_SCHEMA_DIRECTORY, RESPONSE_SCHEMA_FILE);
        GridData gd_response = new GridData(4, 4, false, false, 1, 1);
        this.responseSchema.setLayoutData((Object)gd_response);
        formToolkit.adapt((Control)this.responseSchema, true, true);
        formToolkit.paintBordersFor((Composite)this.responseSchema);
        List<ServiceProjectValidationError> validationErrorsResp = new Db2PropertiesValidator().validateResponse(serviceProjectEditor.getServiceProjectController().getServiceModel().getResource(), RESPONSE_SCHEMA_DIRECTORY + this.responseSchema.getText(), this.responseSchema.getItemCount());
        if (validationErrorsResp != null && !validationErrorsResp.isEmpty()) {
            ServiceProjectValidationError firstError = validationErrorsResp.get(0);
            serviceProjectEditor.getServiceProjectValidator().setControlToError(serviceProjectEditor.getMessageManager(), RESPONSE_SCHEMA_FILE, firstError, (Control)this.responseSchema);
        } else {
            serviceProjectEditor.getServiceProjectValidator().resetControlToError(serviceProjectEditor.getMessageManager(), RESPONSE_SCHEMA_FILE, (Control)this.responseSchema);
        }
        this.responseSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!serviceProjectEditor.isLoading()) {
                    Db2CompositeImpl.this.validateResponseCombo();
                }
            }
        });
        final Button importResponseLocal = new Button(composite, 0);
        importResponseLocal.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        importResponseLocal.setText(Db2Xlat.label("SERVICEEDIT_BUTTON_IMPORT_LOCAL"));
        importResponseLocal.setToolTipText(Db2Xlat.label("SERVICEEDIT_BUTTON_IMPORT_LOCAL_RESPONSE_TOOLTIP"));
        importResponseLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File destinationDirectory = serviceProjectEditor.getServiceProjectController().getServiceModel().getServiceProject().getLocation().append("schemas").append("response").toFile();
                Db2CompositeImpl.this.importLocalFile(importResponseLocal, serviceProjectEditor, destinationDirectory, Db2CompositeImpl.RESPONSE_SCHEMA_FILE, Db2CompositeImpl.RESPONSE_SCHEMA_DIRECTORY);
            }
        });
        formToolkit.adapt((Control)importResponseLocal, true, true);
        listOfComposites.put(composite, Db2Xlat.label("DEFINE_SECTION_TITLE"));
        ZCeeUILogger.exiting((String)this.className, (String)"getComposites", (Object[])new Object[]{listOfComposites});
        return listOfComposites;
    }

    public void refreshPage(Properties properties) {
        String methodName = "refreshPage";
        ZCeeUILogger.entering((String)this.className, (String)"refreshPage", (Object[])new Object[0]);
        for (Object keyObj : properties.keySet()) {
            String key;
            switch (key = (String)keyObj) {
                case "collectionId": {
                    this.collectionId.setText(properties.getProperty(key));
                    break;
                }
                case "db2ServiceName": {
                    this.db2ServiceName.setText(properties.getProperty(key));
                    break;
                }
                case "db2ServiceVersion": {
                    this.db2ServiceVersion.setText(properties.getProperty(key));
                    break;
                }
                case "requestSchemaFile": {
                    this.updateComboOptions(this.requestSchema, this.serviceProjectEditor, REQUEST_SCHEMA_DIRECTORY, REQUEST_SCHEMA_FILE);
                    this.validateRequestCombo();
                    break;
                }
                case "responseSchemaFile": {
                    this.updateComboOptions(this.responseSchema, this.serviceProjectEditor, RESPONSE_SCHEMA_DIRECTORY, RESPONSE_SCHEMA_FILE);
                    this.validateResponseCombo();
                }
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"refreshPage", (Object[])new Object[0]);
    }

    protected void importLocalFile(Button importButton, IServiceProjectEditor serviceProjectEditor, File destinationDirectory, String propertyKey, String propertyDirectory) {
        String methodName = "importLocalFile";
        ZCeeUILogger.entering((String)this.className, (String)"importLocalFile", (Object[])new Object[]{serviceProjectEditor, destinationDirectory});
        FileDialog dialog = new FileDialog(importButton.getShell(), 4100);
        dialog.setFilterExtensions(new String[]{"*.json", "*"});
        try {
            String prevPath = serviceProjectEditor.getProject().getWorkspace().getRoot().getPersistentProperty(PROP_DB2_IMPORT_LOCAL_FILEPATH);
            if (prevPath != null && !prevPath.isEmpty() && this.isPathValid(prevPath)) {
                dialog.setFilterPath(prevPath);
            } else {
                dialog.setFilterPath(serviceProjectEditor.getProject().getWorkspace().getRoot().getLocation().toString());
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((Throwable)e);
        }
        String pathName = dialog.open();
        if (pathName != null && !pathName.isEmpty()) {
            String path = pathName.substring(0, pathName.lastIndexOf(File.separator) + 1);
            try {
                serviceProjectEditor.getServiceProjectController().getProject().getWorkspace().getRoot().setPersistentProperty(PROP_DB2_IMPORT_LOCAL_FILEPATH, path);
            }
            catch (CoreException e2) {
                ZCeeUILogger.error((Throwable)e2);
            }
            String fileName = dialog.getFileName();
            String name = path + fileName;
            File sourceFile = new File(name);
            this.validateAndCopy(sourceFile, destinationDirectory, importButton, propertyKey, propertyDirectory);
            this.refreshWorkspaceFolder(serviceProjectEditor.getServiceProjectController());
        }
        ZCeeUILogger.exiting((String)this.className, (String)"importLocalFile", (Object[])new Object[0]);
    }

    private boolean isPathValid(String pathStr) {
        boolean retVal = false;
        Path path = new Path(pathStr);
        File folder = path.toFile();
        boolean folderWriteable = Files.isWritable(new File(pathStr).toPath());
        if (folder.exists() && folderWriteable) {
            retVal = true;
        }
        return retVal;
    }

    private void validateAndCopy(File sourceFile, File destinationDirectory, Button caller, String propertyKey, String propertyDirectory) {
        String methodName = "validateAndCopy";
        ZCeeUILogger.entering((String)this.className, (String)"validateAndCopy", (Object[])new Object[]{sourceFile, destinationDirectory, caller, propertyKey, propertyDirectory});
        try {
            File destinationFile = new File(destinationDirectory.getAbsolutePath() + File.separator + sourceFile.getName());
            if (!destinationFile.equals(sourceFile)) {
                if (destinationFile.exists()) {
                    this.cleanAndCopyJsonSchema(sourceFile, destinationFile, true);
                } else {
                    this.cleanAndCopyJsonSchema(sourceFile, destinationFile, false);
                }
                this.serviceProjectEditor.getServiceProjectController().getServiceModel().setValue(propertyKey, propertyDirectory + sourceFile.getName());
                this.serviceProjectEditor.setDirty(true);
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateAndCopy", (Object[])new Object[0]);
    }

    private void cleanAndCopyJsonSchema(File sourceFile, File destinationFile, boolean deleteOriginal) throws IOException, ZosConnectUIException {
        String methodName = "cleanJsonSchema";
        ZCeeUILogger.entering((String)this.className, (String)"cleanJsonSchema", (Object[])new Object[]{sourceFile, destinationFile});
        BufferedReader br = new BufferedReader(new FileReader(sourceFile));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)br, JsonObject.class);
            JsonSchemaUtil.cleanSchema(json);
            Gson gsonPretty = new GsonBuilder().setPrettyPrinting().create();
            if (gsonPretty.toJson((JsonElement)json).contains(DECFLOAT_34_FORMAT)) {
                throw new ZosConnectUIException(Db2Xlat.label("LOCAL_JSON_SCHEMA_UNTYPED_TO_DECFLOAT_ERROR"));
            }
            if (deleteOriginal) {
                destinationFile.delete();
            }
            Throwable throwable = null;
            Object var10_12 = null;
            try (FileWriter writer = new FileWriter(destinationFile);){
                gson.toJson((JsonElement)json, (Appendable)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException jpe) {
            ZCeeUILogger.error((Throwable)jpe);
            ZCeeErrorDialog.openError((Exception)((Object)new ZosConnectUIException(Db2Xlat.label("DB2_IMPORT_SCHEMA_ERROR", destinationFile.getName()))));
        }
        ZCeeUILogger.exiting((String)this.className, (String)"cleanJsonSchema", (Object[])new Object[0]);
    }

    private void refreshWorkspaceFolder(IServiceProjectController serviceProjectController) {
        String methodName = "refreshWorkspaceFolder";
        ZCeeUILogger.entering((String)this.className, (String)"refreshWorkspaceFolder", (Object[])new Object[]{serviceProjectController});
        try {
            serviceProjectController.getProject().refreshLocal(2, null);
        }
        catch (CoreException e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)((Object)e));
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"refreshWorkspaceFolder", (Object[])new Object[0]);
    }

    private void updateComboOptions(Combo combo, IServiceProjectEditor serviceProjectEditor, String comboDirectory, String key) {
        String methodName = "updateComboOptions";
        ZCeeUILogger.entering((String)this.className, (String)"updateComboOptions", (Object[])new Object[]{combo, serviceProjectEditor, comboDirectory, key});
        combo.removeAll();
        try {
            IResource[] iResourceArray = serviceProjectEditor.getServiceProjectController().getFolder(comboDirectory).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (!resource.getName().startsWith(".")) {
                    combo.add(resource.getName());
                }
                ++n2;
            }
            String schemaFile = serviceProjectEditor.getServiceProjectController().getServiceModel().getValue(key);
            if (schemaFile != null) {
                int index = Arrays.asList(combo.getItems()).indexOf(schemaFile.replace(comboDirectory, ""));
                if (index != -1) {
                    combo.select(index);
                } else {
                    combo.select(0);
                    if (!schemaFile.isEmpty()) {
                        String incorrectFileName = schemaFile.substring(schemaFile.lastIndexOf("/") + 1);
                        if (!Arrays.asList(combo.getItems()).contains(incorrectFileName)) {
                            combo.add(incorrectFileName);
                            combo.select(combo.indexOf(incorrectFileName));
                        } else {
                            this.forceEditorDirty();
                        }
                    }
                }
            } else {
                combo.select(0);
                if (combo.getItemCount() > 0) {
                    this.forceEditorDirty();
                }
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"updateComboOptions", (Object[])new Object[0]);
    }

    private void validateRequestCombo() {
        List<ServiceProjectValidationError> validationErrorsReq;
        String methodName = "validateRequestCombo";
        ZCeeUILogger.entering((String)this.className, (String)"validateRequestCombo", (Object[])new Object[0]);
        if (this.requestSchema.getSelectionIndex() != -1) {
            if (!this.serviceProjectEditor.getServiceProjectController().getServiceModel().getValue(REQUEST_SCHEMA_FILE).equals(REQUEST_SCHEMA_DIRECTORY + this.requestSchema.getItem(this.requestSchema.getSelectionIndex()))) {
                this.serviceProjectEditor.getServiceProjectController().getServiceModel().setValue(REQUEST_SCHEMA_FILE, REQUEST_SCHEMA_DIRECTORY + this.requestSchema.getItem(this.requestSchema.getSelectionIndex()));
                this.forceEditorDirty();
            }
        } else if (!this.serviceProjectEditor.getServiceProjectController().getServiceModel().getValue(REQUEST_SCHEMA_FILE).isEmpty()) {
            this.serviceProjectEditor.getServiceProjectController().getServiceModel().setValue(REQUEST_SCHEMA_FILE, "");
            this.forceEditorDirty();
        }
        if ((validationErrorsReq = new Db2PropertiesValidator().validateRequest(this.serviceProjectEditor.getServiceProjectController().getServiceModel().getResource(), REQUEST_SCHEMA_DIRECTORY + this.requestSchema.getText(), this.requestSchema.getItemCount())) != null && !validationErrorsReq.isEmpty()) {
            ServiceProjectValidationError firstError = validationErrorsReq.get(0);
            this.serviceProjectEditor.getServiceProjectValidator().setControlToError(this.serviceProjectEditor.getMessageManager(), REQUEST_SCHEMA_FILE, firstError, (Control)this.requestSchema);
        } else {
            this.serviceProjectEditor.getServiceProjectValidator().resetControlToError(this.serviceProjectEditor.getMessageManager(), REQUEST_SCHEMA_FILE, (Control)this.requestSchema);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateRequestCombo", (Object[])new Object[0]);
    }

    private void validateResponseCombo() {
        List<ServiceProjectValidationError> validationErrorsResp;
        String methodName = "validateResponseCombo";
        ZCeeUILogger.entering((String)this.className, (String)"validateResponseCombo", (Object[])new Object[0]);
        if (this.responseSchema.getSelectionIndex() != -1) {
            if (!this.serviceProjectEditor.getServiceProjectController().getServiceModel().getValue(RESPONSE_SCHEMA_FILE).equals(RESPONSE_SCHEMA_DIRECTORY + this.responseSchema.getItem(this.responseSchema.getSelectionIndex()))) {
                this.serviceProjectEditor.getServiceProjectController().getServiceModel().setValue(RESPONSE_SCHEMA_FILE, RESPONSE_SCHEMA_DIRECTORY + this.responseSchema.getItem(this.responseSchema.getSelectionIndex()));
                this.forceEditorDirty();
            }
        } else if (!this.serviceProjectEditor.getServiceProjectController().getServiceModel().getValue(RESPONSE_SCHEMA_FILE).isEmpty()) {
            this.serviceProjectEditor.getServiceProjectController().getServiceModel().setValue(RESPONSE_SCHEMA_FILE, "");
            this.forceEditorDirty();
        }
        if ((validationErrorsResp = new Db2PropertiesValidator().validateResponse(this.serviceProjectEditor.getServiceProjectController().getServiceModel().getResource(), RESPONSE_SCHEMA_DIRECTORY + this.responseSchema.getText(), this.requestSchema.getItemCount())) != null && !validationErrorsResp.isEmpty()) {
            ServiceProjectValidationError firstError = validationErrorsResp.get(0);
            this.serviceProjectEditor.getServiceProjectValidator().setControlToError(this.serviceProjectEditor.getMessageManager(), RESPONSE_SCHEMA_FILE, firstError, (Control)this.responseSchema);
        } else {
            this.serviceProjectEditor.getServiceProjectValidator().resetControlToError(this.serviceProjectEditor.getMessageManager(), RESPONSE_SCHEMA_FILE, (Control)this.responseSchema);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateResponseCombo", (Object[])new Object[0]);
    }

    private void setUri(IServiceModelController serviceModel) {
        String methodName = "setUri";
        ZCeeUILogger.entering((String)this.className, (String)"setUri", (Object[])new Object[]{serviceModel});
        StringBuilder uri = new StringBuilder("/services");
        String collection = this.collectionId.getText().trim();
        if (!collection.isEmpty()) {
            uri.append("/");
            uri.append(collection);
        }
        uri.append("/");
        uri.append(this.db2ServiceName.getText().trim());
        String db2Version = this.db2ServiceVersion.getText().trim();
        if (!db2Version.isEmpty()) {
            uri.append("/");
            uri.append(db2Version);
        }
        serviceModel.setValue("uri", uri.toString());
        ZCeeUILogger.exiting((String)this.className, (String)"setUri", (Object[])new Object[0]);
    }

    private void forceEditorDirty() {
        boolean tempLoading = this.serviceProjectEditor.isLoading();
        this.serviceProjectEditor.setLoading(false);
        this.serviceProjectEditor.setDirty(true);
        this.serviceProjectEditor.setLoading(tempLoading);
    }
}

