/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.rest.db2.dialogs;

import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionWidgetManager;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.IConnectionStateViewer;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.ConnectionStatus;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.service.rest.db2.Db2Xlat;
import com.ibm.zosconnect.ui.service.rest.db2.connections.categories.IDb2ServiceManagerConnection;
import com.ibm.zosconnect.ui.service.rest.db2.connections.models.Db2NativeService;
import com.ibm.zosconnect.ui.service.rest.db2.controllers.ImportDb2ServicesController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportDb2ServicesDialog
extends StatusDialog {
    private Composite compContents;
    private Composite mainComposite;
    private Composite compConnectionArea;
    private Label totalServices;
    private Label totalMatches;
    private Button importButton;
    private Table tableImportService;
    private TableColumn nameColumn;
    private TableColumn versionColumn;
    private TableColumn collectionColumn;
    private TableColumn descriptionColumn;
    private TableColumn uriColumn;
    private Button buttonUpdateServices;
    private Text stringMatch;
    private static final int LEFT_MARGIN = 2;
    private static final int RIGHT_MARGIN = 2;
    private static final int COMPOSITE_WIDTH = 1200;
    private int NUM_ROWS_DISPLAYED = 15;
    private ConnectionServiceListener connectionServiceListener;
    private IConnectable selectedConnectable;
    private ConnectionProfile selectedConnProfile;
    private IDb2ServiceManagerConnection db2Connection;
    private ConnectionWidgetManager connectionWidgetManager;
    private IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
    private List<Db2NativeService> db2Services;
    private List<Db2NativeService> displayedServices;
    private Db2NativeService selectedServiceToImport;
    private ImportDb2ServicesController Db2ServiceController;
    private Column lastSortedColumn;
    private String lastSearchedString = "";
    private boolean lastSortDirectionAscending = true;

    public ImportDb2ServicesDialog(Shell parentShell, ImportDb2ServicesController controller) {
        super(parentShell);
        this.Db2ServiceController = controller;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) throws CoreException {
        this.mainComposite = parent;
        this.mainComposite.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(this.mainComposite);
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compConnectionArea = new Composite(compDialogArea, 0);
        GridLayout gl_compConnectionArea = new GridLayout(2, false);
        gl_compConnectionArea.marginTop = 5;
        gl_compConnectionArea.marginLeft = 2;
        gl_compConnectionArea.marginRight = 2;
        gl_compConnectionArea.verticalSpacing = 10;
        this.compConnectionArea.setLayout((Layout)gl_compConnectionArea);
        GridData connGridData = new GridData(4, 4, false, false, 1, 1);
        connGridData.widthHint = 1200;
        this.compConnectionArea.setLayoutData((Object)connGridData);
        this.compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(3, false);
        gl_compContents.marginTop = 5;
        gl_compContents.marginLeft = 2;
        gl_compContents.marginRight = 2;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.widthHint = 1200;
        this.compContents.setLayoutData((Object)gridData);
        this.createConnectableArea(this.compConnectionArea);
        this.createStringMatchArea(this.compContents);
        this.createTableArea(this.compContents, this.db2Services);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compDialogArea, "com.ibm.zosconnect.ui.service.rest.db2.importsm");
        return compDialogArea;
    }

    private void createConnectableArea(Composite c) {
        Label l = new Label(c, 0);
        l.setText(Db2Xlat.label("DB2_CONNECTION_LABEL") + Xlat.colon());
        this.connectionWidgetManager = new ConnectionWidgetManager(this.connectionService, true);
        ConnectionStatus connectionStatus = new ConnectionStatus(c, 0, this.connectionWidgetManager.getConnectionStatusController());
        this.connectionWidgetManager.setConnectionStateViewer((IConnectionStateViewer)connectionStatus);
        this.connectionWidgetManager.setCurrentCategory("com.ibm.zosconnect.ui.service.rest.db2.connections.category.db2servicemanager");
    }

    private ConnectionServiceListener getConnectionServiceListener() {
        if (this.connectionServiceListener == null) {
            this.connectionServiceListener = new ConnectionServiceListener(){

                public void event(final ConnectionServiceListener.ConnectionServiceEvent event) {
                    if (event.getConnectionCategoryId().equals("com.ibm.zosconnect.ui.service.rest.db2.connections.category.db2servicemanager") && XSwt.isNotDisposed((Control)ImportDb2ServicesDialog.this.mainComposite)) {
                        ImportDb2ServicesDialog.this.mainComposite.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                                    Exception e = ((ConnectionServiceListener.ExceptionEvent)event).getException();
                                    ZCeeUILogger.error((Throwable)e);
                                    if (e instanceof AuthenticationException) {
                                        XSwt.dispose((Control)ImportDb2ServicesDialog.this.getShell());
                                    }
                                    (this).ImportDb2ServicesDialog.this.selectedConnProfile = null;
                                    ImportDb2ServicesDialog.this.updateBasedOnConnectable(event.getConnectable());
                                } else if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                                    (this).ImportDb2ServicesDialog.this.selectedConnProfile = event.getConnectionProfile();
                                    ImportDb2ServicesDialog.this.updateBasedOnConnectable(event.getConnectable());
                                } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                                    (this).ImportDb2ServicesDialog.this.selectedConnProfile = null;
                                    ImportDb2ServicesDialog.this.updateBasedOnConnectable(event.getConnectable());
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.connectionServiceListener;
    }

    private void updateBasedOnConnectable(IConnectable connectable) {
        ConnectionProfile connProfile = this.selectedConnProfile;
        try {
            if (connProfile != null) {
                if (!this.stringMatch.getText().equals("")) {
                    this.lastSearchedString = this.stringMatch.getText();
                }
                this.selectedConnectable = connectable;
                this.db2Connection = (IDb2ServiceManagerConnection)this.selectedConnectable.getConnection();
                if (this.db2Connection != null) {
                    this.db2Services = this.db2Connection.getServices();
                    this.displayedServices = this.db2Services;
                }
                XSwt.enable((Control[])new Control[]{this.stringMatch});
                this.stringMatch.setText(this.lastSearchedString);
                this.filterAndRefreshTable();
            } else {
                IConnectionState connectionState = this.connectionService.getConnectionState("com.ibm.zosconnect.ui.service.rest.db2.connections.category.db2servicemanager");
                if (connectionState instanceof ConnectedState && connectable != null && connectable.isConnected()) {
                    this.selectedConnectable = connectable;
                    this.db2Connection = (IDb2ServiceManagerConnection)this.selectedConnectable.getConnection();
                    if (this.db2Connection != null) {
                        this.db2Services = this.db2Connection.getServices();
                        this.displayedServices = this.db2Services;
                    }
                    XSwt.enable((Control[])new Control[]{this.stringMatch});
                    this.stringMatch.setText(this.lastSearchedString);
                    this.filterAndRefreshTable();
                } else {
                    this.lastSearchedString = this.stringMatch.getText();
                    this.disableTable();
                    XSwt.disable((Control[])new Control[]{this.stringMatch});
                    XSwt.disable((Control[])new Control[]{this.importButton});
                    this.stringMatch.setText("");
                    this.totalMatches.setText("");
                    this.selectedConnectable = null;
                    this.db2Services = null;
                    this.refreshTable(this.tableImportService, this.db2Services);
                }
            }
        }
        catch (ZosConnectUIException zce) {
            ZCeeUILogger.error((Throwable)zce);
            ZCeeErrorDialog.openError((Exception)((Object)zce));
        }
    }

    private void createStringMatchArea(Composite c) {
        this.stringMatch = new Text(c, 2048);
        XSwt.disable((Control[])new Control[]{this.stringMatch});
        GridData gd_stringMatch = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_stringMatch.widthHint = 200;
        this.stringMatch.setLayoutData((Object)gd_stringMatch);
        this.stringMatch.setMessage(Db2Xlat.label("SERVICEEDIT_SEARCH_PLACEHOLDER"));
        this.totalMatches = new Label(c, 0);
        GridData gd_totalMatches = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_totalMatches.widthHint = 400;
        this.totalMatches.setLayoutData((Object)gd_totalMatches);
        this.totalServices = new Label(c, 0);
        this.totalServices.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.totalServices.setVisible(true);
        this.stringMatch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ImportDb2ServicesDialog.this.filterAndRefreshTable();
            }
        });
    }

    private void filterAndRefreshTable() {
        if (this.stringMatch.getText().equals("")) {
            this.displayedServices = this.db2Services;
            this.totalMatches.setText("");
        } else {
            this.displayedServices = new ArrayList<Db2NativeService>();
            String input = this.stringMatch.getText().toLowerCase();
            for (Db2NativeService service : this.db2Services) {
                String description;
                String name = service.getServiceName().toLowerCase();
                String uri = service.getServiceURL().substring(service.getServiceURL().indexOf("/services")).toLowerCase();
                String version = service.getVersion() != null ? service.getVersion().toLowerCase() : "";
                String collectionId = service.getServiceCollectionID() != null ? service.getServiceCollectionID().toLowerCase() : "";
                String string = description = service.getServiceDescription() != null ? service.getServiceDescription().toLowerCase() : "";
                if (!name.contains(input) && !version.contains(input) && !collectionId.contains(input) && !description.contains(input) && !uri.contains(input)) continue;
                this.displayedServices.add(service);
            }
            this.totalMatches.setText(Db2Xlat.label("SERVICEEDIT_SEARCH_MATCHES", String.valueOf(this.displayedServices.size())));
        }
        if (this.displayedServices != null) {
            if (this.lastSortedColumn != null) {
                if (this.lastSortDirectionAscending) {
                    this.lastSortDirectionAscending = false;
                    this.sortListOfServices(this.lastSortedColumn);
                } else {
                    this.lastSortDirectionAscending = true;
                    this.sortListOfServices(this.lastSortedColumn);
                }
            } else {
                this.sortListOfServices(Column.VERSION);
                this.sortListOfServices(Column.NAME);
                this.sortListOfServices(Column.COLLECTION);
                this.lastSortedColumn = null;
            }
        }
    }

    private void disposeTable() {
        XSwt.dispose((TableColumn)this.nameColumn);
        XSwt.dispose((TableColumn)this.versionColumn);
        XSwt.dispose((TableColumn)this.collectionColumn);
        XSwt.dispose((TableColumn)this.descriptionColumn);
        XSwt.dispose((TableColumn)this.uriColumn);
        XSwt.dispose((Control)this.tableImportService);
        XSwt.dispose((Control)this.buttonUpdateServices);
    }

    private void createTableArea(final Composite c, List<Db2NativeService> displayedServices) {
        int tableHeight;
        this.disposeTable();
        GridData gridData = new GridData(4, 4, true, true, 3, 1);
        this.tableImportService = new Table(c, 68352);
        this.nameColumn = new TableColumn(this.tableImportService, 0);
        this.nameColumn.setText(Db2Xlat.label("IMPORT_SERVICE_TABLE_COL1"));
        this.versionColumn = new TableColumn(this.tableImportService, 0);
        this.versionColumn.setText(Db2Xlat.label("IMPORT_SERVICE_TABLE_COL2"));
        this.collectionColumn = new TableColumn(this.tableImportService, 0);
        this.collectionColumn.setText(Db2Xlat.label("IMPORT_SERVICE_TABLE_COL3"));
        this.descriptionColumn = new TableColumn(this.tableImportService, 0);
        this.descriptionColumn.setText(Db2Xlat.label("IMPORT_SERVICE_TABLE_COL4"));
        this.uriColumn = new TableColumn(this.tableImportService, 0);
        this.uriColumn.setText(Db2Xlat.label("IMPORT_SERVICE_TABLE_COL5"));
        this.tableImportService.setHeaderVisible(true);
        this.tableImportService.setLinesVisible(true);
        gridData.heightHint = tableHeight = this.tableImportService.getItemHeight() * this.NUM_ROWS_DISPLAYED + this.tableImportService.getHeaderHeight();
        this.tableImportService.setLayoutData((Object)gridData);
        this.tableImportService.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = c.getClientArea();
                int width = area.width - 2 - 2 - 2 * ImportDb2ServicesDialog.this.tableImportService.getBorderWidth() - 10;
                TableColumn[] tableColumns = ImportDb2ServicesDialog.this.tableImportService.getColumns();
                int i = 0;
                while (i < tableColumns.length) {
                    tableColumns[i].setWidth(width / tableColumns.length);
                    ++i;
                }
            }
        });
        Listener nameSortListener = new Listener(){

            public void handleEvent(Event e) {
                ImportDb2ServicesDialog.this.sortListOfServices(Column.NAME);
            }
        };
        Listener versionSortListener = new Listener(){

            public void handleEvent(Event e) {
                ImportDb2ServicesDialog.this.sortListOfServices(Column.VERSION);
            }
        };
        Listener collectionSortListener = new Listener(){

            public void handleEvent(Event e) {
                ImportDb2ServicesDialog.this.sortListOfServices(Column.COLLECTION);
            }
        };
        Listener descSortListener = new Listener(){

            public void handleEvent(Event e) {
                ImportDb2ServicesDialog.this.sortListOfServices(Column.DESCRIPTION);
            }
        };
        Listener uriSortListener = new Listener(){

            public void handleEvent(Event e) {
                ImportDb2ServicesDialog.this.sortListOfServices(Column.URI);
            }
        };
        this.nameColumn.addListener(13, nameSortListener);
        this.versionColumn.addListener(13, versionSortListener);
        this.collectionColumn.addListener(13, collectionSortListener);
        this.descriptionColumn.addListener(13, descSortListener);
        this.uriColumn.addListener(13, uriSortListener);
        this.tableImportService.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (ImportDb2ServicesDialog.this.importButton.isEnabled()) {
                    ImportDb2ServicesDialog.this.okPressed();
                }
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        this.tableImportService.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XSwt.enable((Control[])new Control[]{ImportDb2ServicesDialog.this.importButton});
            }
        });
        XSwt.layout((Composite)c, (boolean)true);
        XSwt.centerInWorkbench((Shell)this.getShell());
    }

    private void sortListOfServices(Column column) {
        String selectedItemServiceURI = this.tableImportService.getSelectionIndex() != -1 ? this.tableImportService.getSelection()[0].getText(4) : null;
        switch (column) {
            case NAME: {
                Comparator<Db2NativeService> nameComparator = new Comparator<Db2NativeService>(){

                    @Override
                    public int compare(Db2NativeService o1, Db2NativeService o2) {
                        return o1.getServiceName().toLowerCase().compareTo(o2.getServiceName().toLowerCase());
                    }
                };
                if (this.lastSortedColumn != null) {
                    if (this.lastSortedColumn == Column.NAME && this.lastSortDirectionAscending) {
                        nameComparator = Collections.reverseOrder(nameComparator);
                        this.lastSortDirectionAscending = false;
                    } else {
                        this.lastSortDirectionAscending = true;
                    }
                }
                this.tableImportService.setSortColumn(this.nameColumn);
                this.lastSortedColumn = Column.NAME;
                Collections.sort(this.displayedServices, nameComparator);
                break;
            }
            case VERSION: {
                Comparator<Db2NativeService> versionComparator = new Comparator<Db2NativeService>(){

                    @Override
                    public int compare(Db2NativeService o1, Db2NativeService o2) {
                        return o1.getVersion().toLowerCase().compareTo(o2.getVersion().toLowerCase());
                    }
                };
                if (this.lastSortedColumn != null) {
                    if (this.lastSortedColumn == Column.VERSION && this.lastSortDirectionAscending) {
                        versionComparator = Collections.reverseOrder(versionComparator);
                        this.lastSortDirectionAscending = false;
                    } else {
                        this.lastSortDirectionAscending = true;
                    }
                }
                this.tableImportService.setSortColumn(this.versionColumn);
                this.lastSortedColumn = Column.VERSION;
                Collections.sort(this.displayedServices, versionComparator);
                break;
            }
            case COLLECTION: {
                Comparator<Db2NativeService> collectionComparator = new Comparator<Db2NativeService>(){

                    @Override
                    public int compare(Db2NativeService o1, Db2NativeService o2) {
                        return o1.getServiceCollectionID().toLowerCase().compareTo(o2.getServiceCollectionID().toLowerCase());
                    }
                };
                if (this.lastSortedColumn != null) {
                    if (this.lastSortedColumn == Column.COLLECTION && this.lastSortDirectionAscending) {
                        collectionComparator = Collections.reverseOrder(collectionComparator);
                        this.lastSortDirectionAscending = false;
                    } else {
                        this.lastSortDirectionAscending = true;
                    }
                }
                this.tableImportService.setSortColumn(this.collectionColumn);
                this.lastSortedColumn = Column.COLLECTION;
                Collections.sort(this.displayedServices, collectionComparator);
                break;
            }
            case DESCRIPTION: {
                Comparator<Db2NativeService> descriptionComparator = new Comparator<Db2NativeService>(){

                    @Override
                    public int compare(Db2NativeService o1, Db2NativeService o2) {
                        return o1.getServiceDescription().toLowerCase().compareTo(o2.getServiceDescription().toLowerCase());
                    }
                };
                if (this.lastSortedColumn != null) {
                    if (this.lastSortedColumn == Column.DESCRIPTION && this.lastSortDirectionAscending) {
                        descriptionComparator = Collections.reverseOrder(descriptionComparator);
                        this.lastSortDirectionAscending = false;
                    } else {
                        this.lastSortDirectionAscending = true;
                    }
                }
                this.tableImportService.setSortColumn(this.descriptionColumn);
                this.lastSortedColumn = Column.DESCRIPTION;
                Collections.sort(this.displayedServices, descriptionComparator);
                break;
            }
            case URI: {
                Comparator<Db2NativeService> uriComparator = new Comparator<Db2NativeService>(){

                    @Override
                    public int compare(Db2NativeService o1, Db2NativeService o2) {
                        return o1.getServiceURL().substring(o1.getServiceURL().indexOf("/services")).toLowerCase().compareTo(o2.getServiceURL().substring(o2.getServiceURL().indexOf("/services")).toLowerCase());
                    }
                };
                if (this.lastSortedColumn != null) {
                    if (this.lastSortedColumn == Column.URI && this.lastSortDirectionAscending) {
                        uriComparator = Collections.reverseOrder(uriComparator);
                        this.lastSortDirectionAscending = false;
                    } else {
                        this.lastSortDirectionAscending = true;
                    }
                }
                this.tableImportService.setSortColumn(this.uriColumn);
                this.lastSortedColumn = Column.URI;
                Collections.sort(this.displayedServices, uriComparator);
                break;
            }
        }
        if (this.lastSortDirectionAscending) {
            this.refreshTable(this.tableImportService, this.displayedServices);
            this.tableImportService.setSortDirection(1024);
        } else {
            this.refreshTable(this.tableImportService, this.displayedServices);
            this.tableImportService.setSortDirection(128);
        }
        if (selectedItemServiceURI != null) {
            this.reselectService(selectedItemServiceURI);
        }
    }

    private void refreshTable(Table table, List<Db2NativeService> servicesToDisplay) {
        table.removeAll();
        if (this.selectedConnectable != null) {
            this.enableTable();
            if (this.db2Connection != null && servicesToDisplay != null) {
                for (Db2NativeService service : servicesToDisplay) {
                    TableItem tableItem = new TableItem(table, 0);
                    tableItem.setText(0, service.getServiceName());
                    tableItem.setText(1, service.getVersion());
                    tableItem.setText(2, service.getServiceCollectionID());
                    tableItem.setText(3, service.getServiceDescription());
                    tableItem.setText(4, service.getServiceURL().substring(service.getServiceURL().indexOf("/services")));
                }
            }
        } else {
            this.disableTable();
        }
    }

    private void disableTable() {
        this.totalServices.setVisible(false);
        this.tableImportService.setEnabled(false);
    }

    private void enableTable() {
        this.totalServices.setVisible(true);
        this.totalServices.setText(Db2Xlat.label("DB2_SERVICE_COUNT", String.valueOf(this.getNumberOfTotalServices())));
        this.tableImportService.setEnabled(true);
    }

    private void reselectService(String serviceURI) {
        for (Db2NativeService service : this.displayedServices) {
            if (!service.getServiceURL().substring(service.getServiceURL().indexOf("/services")).equals(serviceURI)) continue;
            TableItem selected = this.tableImportService.getItem(this.displayedServices.indexOf(service));
            this.tableImportService.setSelection(this.tableImportService.indexOf(selected));
            selected.setChecked(true);
            break;
        }
    }

    private int getNumberOfTotalServices() {
        if (this.db2Services != null) {
            return this.db2Services.size();
        }
        return 0;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackgroundMode(2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.importButton = this.getButton(0);
        this.importButton.setText(Db2Xlat.label("IMPORT_BUTTON_LABEL"));
        XSwt.disable((Control[])new Control[]{this.importButton});
        this.connectionService.addConnectionServiceListener(this.getConnectionServiceListener());
        IConnectable connectable = this.connectionService.getConnectable("com.ibm.zosconnect.ui.service.rest.db2.connections.category.db2servicemanager");
        this.updateBasedOnConnectable(connectable);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Db2Xlat.label("IMPORT_FROM_SERVICE_MANAGER_DIALOG_TITLE"));
    }

    protected void okPressed() {
        String selectedItemServiceName = this.tableImportService.getSelection()[0].getText(0);
        String selectedItemServiceVersion = this.tableImportService.getSelection()[0].getText(1);
        String selectedItemServiceCollection = this.tableImportService.getSelection()[0].getText(2);
        for (Db2NativeService service : this.db2Services) {
            if (!selectedItemServiceName.equals(service.getServiceName()) || !selectedItemServiceVersion.equals(service.getVersion()) || !selectedItemServiceCollection.equals(service.getServiceCollectionID())) continue;
            this.selectedServiceToImport = service;
            break;
        }
        if (this.db2Connection != null) {
            try {
                this.Db2ServiceController.setDb2NativeServiceDetail(this.db2Connection.getService(this.selectedServiceToImport));
                this.Db2ServiceController.createSchemaFiles();
                super.okPressed();
            }
            catch (ZosConnectUIException zce) {
                ZCeeUILogger.error((Throwable)zce);
                ZCeeErrorDialog.openError((Exception)((Object)zce));
            }
        }
    }

    public void create() {
        super.create();
        XSwt.centerInWorkbench((Shell)this.getShell());
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private static enum Column {
        NAME,
        VERSION,
        COLLECTION,
        DESCRIPTION,
        URI;

    }
}

