/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.rest.db2.controllers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceProjectController;
import com.ibm.zosconnect.ui.service.rest.db2.connections.models.Db2NativeServiceDetail;
import com.ibm.zosconnect.ui.service.rest.db2.dialogs.ImportDb2ServicesDialog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ImportDb2ServicesController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = ImportDb2ServicesController.class.getName();
    private IProject project;
    private IServiceProjectController serviceProjectController;
    private Db2NativeServiceDetail db2ServiceDetail;

    public ImportDb2ServicesController(IProject project, IServiceProjectController serviceProjectController) {
        this.project = project;
        this.serviceProjectController = serviceProjectController;
    }

    public int openDialog() {
        ZCeeUILogger.entering((String)TAG, (String)"openDialog(project={0})", (Object[])new Object[]{this.project});
        ImportDb2ServicesDialog dialog = new ImportDb2ServicesDialog(XSwt.getActiveShell(), this);
        ZCeeUILogger.exiting((String)TAG, (String)"openDialog(IProject)", (Object[])new Object[0]);
        return dialog.open();
    }

    public IProject getProject() {
        return this.project;
    }

    public void setDb2NativeServiceDetail(Db2NativeServiceDetail db2ServiceDetail) {
        this.db2ServiceDetail = db2ServiceDetail;
    }

    public Db2NativeServiceDetail getDb2NativeServiceDetail() {
        return this.db2ServiceDetail;
    }

    public void createSchemaFiles() {
        if (this.db2ServiceDetail.getRequestSchema() != null && this.db2ServiceDetail.getResponseSchema() != null && this.db2ServiceDetail.getServiceURL() != null) {
            String requestFileName = "request-schema.json";
            String responseFileName = "response-schema.json";
            String requestFilePath = "/schemas/request/";
            String responseFilePath = "/schemas/response/";
            File requestDestination = new File(String.valueOf(this.serviceProjectController.getServiceModel().getServiceProject().getLocation()) + File.separator + requestFilePath + requestFileName);
            File responseDestination = new File(String.valueOf(this.serviceProjectController.getServiceModel().getServiceProject().getLocation()) + File.separator + responseFilePath + responseFileName);
            try {
                this.writeSchemaToFile(this.db2ServiceDetail.getRequestSchema(), requestDestination);
                this.writeSchemaToFile(this.db2ServiceDetail.getResponseSchema(), responseDestination);
            }
            catch (ZosConnectUIException zce) {
                ZCeeUILogger.error((Throwable)zce);
                ZCeeErrorDialog.openError((Exception)((Object)zce));
            }
            if (this.db2ServiceDetail.getServiceCollectionID() != null) {
                this.serviceProjectController.getServiceModel().setValue("collectionId", this.db2ServiceDetail.getServiceCollectionID());
            } else {
                this.serviceProjectController.getServiceModel().setValue("collectionId", "");
            }
            this.serviceProjectController.getServiceModel().setValue("db2ServiceName", this.db2ServiceDetail.getServiceName());
            if (this.db2ServiceDetail.getVersion() != null) {
                this.serviceProjectController.getServiceModel().setValue("db2ServiceVersion", this.db2ServiceDetail.getVersion());
            } else {
                this.serviceProjectController.getServiceModel().setValue("db2ServiceVersion", "");
            }
            this.serviceProjectController.getServiceModel().setValue("requestSchemaFile", requestFileName);
            this.serviceProjectController.getServiceModel().setValue("responseSchemaFile", responseFileName);
            this.refreshWorkspaceFolder();
        }
    }

    private void writeSchemaToFile(JsonObject schema, File destination) throws ZosConnectUIException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileWriter writer = new FileWriter(destination);){
                gson.toJson((JsonElement)schema, (Appendable)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new ZosConnectUIException((Throwable)ioe);
        }
    }

    private void refreshWorkspaceFolder() {
        try {
            this.serviceProjectController.getProject().refreshLocal(2, null);
        }
        catch (CoreException ce) {
            ZCeeUILogger.error((Throwable)ce);
            ZCeeErrorDialog.openError((Exception)((Object)ce));
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }
}

