/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.rest.db2.connections.type;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.cics.core.comm.AbstractConnection;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.zosconnect.ui.common.connections.ZCeeHostnameVerifier;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.http.HttpStatusCodes;
import com.ibm.zosconnect.ui.service.rest.db2.Db2Xlat;
import com.ibm.zosconnect.ui.service.rest.db2.connections.categories.IDb2ServiceManagerConnection;
import com.ibm.zosconnect.ui.service.rest.db2.connections.models.Db2NativeService;
import com.ibm.zosconnect.ui.service.rest.db2.connections.models.Db2NativeServiceDetail;
import com.ibm.zosconnect.ui.service.rest.db2.impl.Db2UIException;
import com.ibm.zosconnect.ui.service.rest.db2.util.JsonSchemaUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class Db2ServiceManagerConnection
extends AbstractConnection
implements IDb2ServiceManagerConnection {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = Db2ServiceManagerConnection.class.getName();
    public static final String CONNECT_TIMEOUT_KEY = "CONNECT_TIMEOUT";
    public static final String READ_TIMEOUT_KEY = "READ_TIMEOUT";
    private static final Integer CONNECT_TIMEOUT_DEFAULT = 30000;
    private static final Integer READ_TIMEOUT_DEFAULT = 30000;
    private static final String HTTP_URI_PFX = "http://";
    private static final String HTTPS_URI_PFX = "https://";
    private static final String DB2_SERVICE_MANAGER = "DB2ServiceManager";
    private static final String DB2_SERVICE_DISCOVER = "DB2ServiceDiscover";
    private static final String DECFLOAT_34_FORMAT = "DECFLOAT(34)";
    private boolean connected = false;
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;
    private ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();
    private HttpURLConnection db2Connection;

    public void connect() throws ConnectionException {
        String methodName = "connect";
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"connect", (Object[])new Object[0]);
        try {
            this.connected = false;
            this.initSSLConfiguration();
            this.getServices();
            this.connected = true;
        }
        catch (ZosConnectUIException e) {
            ZCeeUILogger.error((Throwable)e);
            if (e.isCausedByCertificateException()) {
                throw new ConnectionException((Exception)((Object)e));
            }
            if (HttpStatusCodes.Unauthorized.equals(e.getHttpStatusCode())) {
                ZCeeErrorDialog.openError((Exception)((Object)e));
                throw new AuthenticationException(e.getExternalMessage());
            }
            ZCeeErrorDialog.openError((Exception)((Object)e));
            throw new ConnectionException(e.getExternalMessage(), (Throwable)e);
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
            throw new ConnectionException(e);
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"connect", (Object[])new Object[]{this.connected});
    }

    public void disconnect() throws ConnectionException {
        String methodName = "disconnect";
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"disconnect", (Object[])new Object[0]);
        this.connected = false;
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"disconnect", (Object[])new Object[0]);
    }

    public boolean isConnected() {
        String methodName = "isConnected";
        ZCeeUILogger.entering((String)this.getClass().getName(), (String)"isConnected", (Object[])new Object[0]);
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"isConnected", (Object[])new Object[]{this.connected});
        return this.connected;
    }

    public void initSSLConfiguration() throws IOException {
        String methodName = "initSSLConfiguration";
        ZCeeUILogger.entering((String)TAG, (String)"initSSLConfiguration", (Object[])new Object[0]);
        boolean enableExtraTLSProtocols = false;
        if (this.isClientCert()) {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost(), (CertificateDetails)this.getConfiguration().getCertificateDetails());
        } else {
            Object[] helper = ExplorerSecurityHelper.getSSLContext((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
            this.sslContext = (SSLContext)helper[0];
            enableExtraTLSProtocols = (Boolean)helper[1];
            this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
        }
        ZCeeUILogger.info((String)"protocol={0},enableExtraTLSProtocols={1}", (Object[])new Object[]{this.sslContext.getProtocol(), enableExtraTLSProtocols});
        ZCeeUILogger.exiting((String)TAG, (String)"initSSLConfiguration", (Object[])new Object[0]);
    }

    public boolean isClientCert() {
        return this.getConfiguration().getCertificateDetails() != null;
    }

    public String getName() {
        return this.getConfiguration().getName();
    }

    private void configureDb2Connection(String uri) throws ZosConnectUIException {
        String methodName = "configureDb2Connection";
        ZCeeUILogger.entering((String)TAG, (String)"configureDb2Connection", (Object[])new Object[]{uri});
        ConnectionConfiguration configuration = this.getConfiguration();
        try {
            CredentialsConfiguration credentials;
            URL url = null;
            if (configuration.getSecureHint()) {
                url = new URL(HTTPS_URI_PFX + configuration.getHost() + ":" + configuration.getPort() + uri);
                this.db2Connection = (HttpsURLConnection)url.openConnection();
                ((HttpsURLConnection)this.db2Connection).setSSLSocketFactory(this.sslSocketFactory);
                ((HttpsURLConnection)this.db2Connection).setHostnameVerifier((HostnameVerifier)new ZCeeHostnameVerifier());
            } else {
                url = new URL(HTTP_URI_PFX + configuration.getHost() + ":" + configuration.getPort() + uri);
                this.db2Connection = (HttpURLConnection)url.openConnection();
            }
            Integer connectTimeout = NumberUtils.toInt((String)configuration.getExtendedAttribute(CONNECT_TIMEOUT_KEY), (int)CONNECT_TIMEOUT_DEFAULT);
            this.db2Connection.setConnectTimeout(connectTimeout);
            Integer readTimeout = NumberUtils.toInt((String)configuration.getExtendedAttribute(READ_TIMEOUT_KEY), (int)READ_TIMEOUT_DEFAULT);
            this.db2Connection.setConnectTimeout(readTimeout);
            this.db2Connection.setRequestProperty("Content-Type", "application/json");
            this.db2Connection.setRequestProperty("Accept", "application/json");
            this.db2Connection.setDoInput(true);
            this.db2Connection.setDoOutput(true);
            this.db2Connection.setUseCaches(false);
            this.db2Connection.setRequestMethod("GET");
            if (!this.isClientCert() && !StringUtils.isBlank((CharSequence)configuration.getCredentialsID()) && (credentials = this.credentialsManager.findCredentialsConfigurationByID(configuration.getCredentialsID())) != null) {
                this.db2Connection.addRequestProperty("Authorization", "Basic " + new String(Base64.getEncoder().encode(new String(credentials.getUserID() + ":" + credentials.getPassword()).getBytes())));
            }
        }
        catch (IOException ioe) {
            throw new Db2UIException(ioe, Db2Xlat.label("DB2_CONNECTION_IO_EXCEPTION", this.getName()));
        }
        ZCeeUILogger.exiting((String)TAG, (String)"configureDb2Connection", (Object[])new Object[0]);
    }

    @Override
    public List<Db2NativeService> getServices() throws ZosConnectUIException {
        ArrayList<Db2NativeService> db2Services;
        block23: {
            String methodName = "getServices";
            ZCeeUILogger.entering((String)TAG, (String)"getServices", (Object[])new Object[0]);
            db2Services = new ArrayList<Db2NativeService>();
            this.configureDb2Connection("/services");
            try {
                this.db2Connection.connect();
                if (this.db2Connection.getResponseCode() == 200) {
                    Throwable throwable = null;
                    Object var4_8 = null;
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(this.db2Connection.getInputStream()));){
                        Gson gson = new Gson();
                        JsonObject responseJson = (JsonObject)gson.fromJson((Reader)br, JsonObject.class);
                        JsonArray services = responseJson.getAsJsonArray("DB2Services");
                        for (JsonElement service : services) {
                            Db2NativeService db2Service = (Db2NativeService)gson.fromJson(service, Db2NativeService.class);
                            if (db2Service.getServiceName() == null) {
                                throw new ZosConnectUIException(Db2Xlat.label("MISSING_DB2_SERVICE_NAME"));
                            }
                            if (db2Service.getServiceName().equals(DB2_SERVICE_MANAGER) || db2Service.getServiceName().equals(DB2_SERVICE_DISCOVER)) continue;
                            db2Services.add(db2Service);
                            ZCeeUILogger.info((String)"Db2 native REST service added to list. Name: {0} CollectionId: {1} Version: {2}", (Object[])new Object[]{db2Service.getServiceName(), db2Service.getServiceCollectionID(), db2Service.getVersion()});
                        }
                        break block23;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                Throwable throwable = null;
                Object var4_10 = null;
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(this.db2Connection.getErrorStream()));
                    try {
                        StringBuilder responseBody = new StringBuilder();
                        String line = br.readLine();
                        while (line != null) {
                            responseBody.append(line);
                            responseBody.append("\n");
                            line = br.readLine();
                        }
                        throw new Db2UIException(new ZosConnectUIException(responseBody.toString()), Db2Xlat.label("DB2_ERROR_MESSAGE", "" + this.db2Connection.getResponseCode()));
                    }
                    catch (Throwable throwable3) {
                        if (br != null) {
                            br.close();
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                throw new Db2UIException(ioe, Db2Xlat.label("DB2_CONNECTION_IO_EXCEPTION", this.getName()));
            }
        }
        ZCeeUILogger.exiting((String)TAG, (String)"getServices", (Object[])new Object[0]);
        return db2Services;
    }

    @Override
    public Db2NativeServiceDetail getService(Db2NativeService service) throws ZosConnectUIException {
        Db2NativeServiceDetail db2ServiceDetail;
        block23: {
            String methodName = "getService";
            ZCeeUILogger.entering((String)TAG, (String)"getService", (Object[])new Object[0]);
            db2ServiceDetail = null;
            this.configureDb2Connection(service.getServiceURL().substring(service.getServiceURL().indexOf("/services")));
            try {
                this.db2Connection.connect();
                if (this.db2Connection.getResponseCode() == 200) {
                    Throwable throwable = null;
                    Object var5_9 = null;
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(this.db2Connection.getInputStream()));){
                        Gson gson = new Gson();
                        JsonObject responseJson = (JsonObject)gson.fromJson((Reader)br, JsonObject.class);
                        JsonObject serviceObj = responseJson.getAsJsonObject(service.getServiceName());
                        db2ServiceDetail = (Db2NativeServiceDetail)gson.fromJson((JsonElement)serviceObj, Db2NativeServiceDetail.class);
                        JsonSchemaUtil.cleanSchema(db2ServiceDetail.getRequestSchema());
                        JsonSchemaUtil.cleanSchema(db2ServiceDetail.getResponseSchema());
                        break block23;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                Throwable throwable = null;
                Object var5_11 = null;
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(this.db2Connection.getErrorStream()));
                    try {
                        StringBuilder responseBody = new StringBuilder();
                        String line = br.readLine();
                        while (line != null) {
                            responseBody.append(line);
                            responseBody.append("\n");
                            line = br.readLine();
                        }
                        throw new Db2UIException(new ZosConnectUIException(responseBody.toString()), Db2Xlat.label("DB2_ERROR_MESSAGE", "" + this.db2Connection.getResponseCode()));
                    }
                    catch (Throwable throwable3) {
                        if (br != null) {
                            br.close();
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                throw new Db2UIException(ioe, Db2Xlat.label("DB2_CONNECTION_IO_EXCEPTION", this.getName()));
            }
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (gson.toJson((JsonElement)db2ServiceDetail.getRequestSchema()).contains(DECFLOAT_34_FORMAT)) {
            ZCeeUILogger.info((String)"Request JSON schema: {0}", (Object[])new Object[]{db2ServiceDetail.getRequestSchema()});
            throw new ZosConnectUIException(Db2Xlat.label("JSON_REQ_SCHEMA_UNTYPED_TO_DECFLOAT_ERROR"));
        }
        if (gson.toJson((JsonElement)db2ServiceDetail.getResponseSchema()).contains(DECFLOAT_34_FORMAT)) {
            ZCeeUILogger.info((String)"Response JSON schema: {0}", (Object[])new Object[]{db2ServiceDetail.getResponseSchema()});
            throw new ZosConnectUIException(Db2Xlat.label("JSON_RES_SCHEMA_UNTYPED_TO_DECFLOAT_ERROR"));
        }
        ZCeeUILogger.exiting((String)TAG, (String)"getService", (Object[])new Object[]{db2ServiceDetail});
        return db2ServiceDetail;
    }
}

