/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.rest.db2.connections.customizer;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.connections.AbstractConnectionCustomizer;
import com.ibm.cics.core.connections.IConnectionCustomizerListener;
import com.ibm.zosconnect.ui.common.preferences.ZosConnectPreferencesWrapper;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class Db2ServiceManagerConnectionCustomizer
extends AbstractConnectionCustomizer
implements ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ConnectionConfiguration configuration;
    private ZosConnectPreferencesWrapper prefWrapper = new ZosConnectPreferencesWrapper();
    private Text connectTimeout = null;
    private Text readTimeout = null;
    private FieldDecorationRegistry decorationRegistry = FieldDecorationRegistry.getDefault();
    private FieldDecoration errorFieldDecoration = this.decorationRegistry.getFieldDecoration("DEC_ERROR");
    private ControlDecoration connectTimeoutDecoration;
    private ControlDecoration readTimeoutDecoration;
    private Integer connectionTimeoutValue = 0;
    private Integer readTimeoutValue = 0;

    public void clear() {
        XSwt.setText((Text)this.connectTimeout, (String)String.valueOf(this.prefWrapper.getConnectTimeout()));
        XSwt.setText((Text)this.readTimeout, (String)String.valueOf(this.prefWrapper.getReadTimeout()));
    }

    public void createControl(Composite parent) {
        String readTimeoutAttVal;
        String connectionTimeoutAttVal;
        Composite body = new Composite(parent, 0);
        this.setGridLayout(body, 3, 5, 0, true, false);
        this.connectionTimeoutValue = this.configuration != null ? (StringUtils.isNumeric((CharSequence)(connectionTimeoutAttVal = this.configuration.getExtendedAttribute("CONNECT_TIMEOUT"))) ? Integer.valueOf(connectionTimeoutAttVal) : Integer.valueOf(this.prefWrapper.getConnectTimeout())) : Integer.valueOf(this.prefWrapper.getConnectTimeout());
        this.connectTimeout = this.createText(body, Xlat.label((String)"CONNECT_TIMEOUT") + Xlat.colon(), Xlat.description((String)"CONNECT_TIMEOUT"), Xlat.label((String)"UNIT_MILLISECONDS"), this.connectionTimeoutValue.toString(), this, this.decorationRegistry.getMaximumDecorationWidth(), 150);
        this.connectTimeoutDecoration = new ControlDecoration((Control)this.connectTimeout, 16512);
        this.connectTimeoutDecoration.setImage(this.errorFieldDecoration.getImage());
        this.connectTimeoutDecoration.hide();
        this.readTimeoutValue = this.configuration != null ? (StringUtils.isNumeric((CharSequence)(readTimeoutAttVal = this.configuration.getExtendedAttribute("READ_TIMEOUT"))) ? Integer.valueOf(readTimeoutAttVal) : Integer.valueOf(this.prefWrapper.getReadTimeout())) : Integer.valueOf(this.prefWrapper.getReadTimeout());
        this.readTimeout = this.createText(body, Xlat.label((String)"READ_TIMEOUT") + Xlat.colon(), Xlat.description((String)"READ_TIMEOUT"), Xlat.label((String)"UNIT_MILLISECONDS"), this.readTimeoutValue.toString(), this, this.decorationRegistry.getMaximumDecorationWidth(), 150);
        this.readTimeoutDecoration = new ControlDecoration((Control)this.readTimeout, 16512);
        this.readTimeoutDecoration.setImage(this.errorFieldDecoration.getImage());
        this.readTimeoutDecoration.hide();
    }

    public void performDefaults() {
        XSwt.setText((Text)this.connectTimeout, (String)String.valueOf(this.prefWrapper.getConnectTimeout()));
        XSwt.setText((Text)this.readTimeout, (String)String.valueOf(this.prefWrapper.getReadTimeout()));
    }

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        String readTimeoutVal;
        this.configuration = connectionConfiguration;
        String connectTimeoutVal = connectionConfiguration.getExtendedAttribute("CONNECT_TIMEOUT");
        if (!StringUtils.isBlank((CharSequence)connectTimeoutVal)) {
            XSwt.setText((Text)this.connectTimeout, (String)connectTimeoutVal);
        }
        if (!StringUtils.isBlank((CharSequence)(readTimeoutVal = connectionConfiguration.getExtendedAttribute("READ_TIMEOUT")))) {
            XSwt.setText((Text)this.readTimeout, (String)readTimeoutVal);
        }
    }

    public void updateCurrentConfiguration() {
        if (this.configuration == null) {
            return;
        }
        this.configuration.setExtendedAttribute("CONNECT_TIMEOUT", XSwt.getText((Text)this.connectTimeout));
        this.configuration.setExtendedAttribute("READ_TIMEOUT", XSwt.getText((Text)this.readTimeout));
    }

    public void modifyText(ModifyEvent event) {
        block3: {
            Object source;
            block2: {
                source = event.getSource();
                if (source != this.connectTimeout) break block2;
                for (IConnectionCustomizerListener listener : this.getListeners()) {
                    listener.propertyChanged("CONNECT_TIMEOUT", (Object)XSwt.getText((Text)this.connectTimeout));
                }
                break block3;
            }
            if (source != this.readTimeout) break block3;
            for (IConnectionCustomizerListener listener : this.getListeners()) {
                listener.propertyChanged("READ_TIMEOUT", (Object)XSwt.getText((Text)this.readTimeout));
            }
        }
    }

    public String validateEnteredData() {
        String message = null;
        this.connectTimeoutDecoration.setDescriptionText("");
        this.connectTimeoutDecoration.hide();
        this.readTimeoutDecoration.setDescriptionText("");
        this.readTimeoutDecoration.hide();
        if (StringUtils.isBlank(message) && !XSwt.isDisposed((Control)this.connectTimeout)) {
            try {
                this.connectionTimeoutValue = Integer.valueOf(this.connectTimeout.getText());
                if (this.connectionTimeoutValue < 0) {
                    message = Xlat.error((String)"INVALID_CONNECT_TIMEOUT_VALUE");
                    this.connectTimeoutDecoration.setDescriptionText(message);
                    this.connectTimeoutDecoration.show();
                }
            }
            catch (NumberFormatException e) {
                message = Xlat.error((String)"INVALID_CONNECT_TIMEOUT_VALUE");
                this.connectTimeoutDecoration.setDescriptionText(message);
                this.connectTimeoutDecoration.show();
            }
        }
        if (StringUtils.isBlank(message) && !XSwt.isDisposed((Control)this.readTimeout)) {
            try {
                this.readTimeoutValue = Integer.valueOf(this.readTimeout.getText());
                if (this.readTimeoutValue < 0) {
                    message = Xlat.error((String)"INVALID_READ_TIMEOUT_VALUE");
                    this.readTimeoutDecoration.setDescriptionText(message);
                    this.readTimeoutDecoration.show();
                }
            }
            catch (NumberFormatException e) {
                message = Xlat.error((String)"INVALID_READ_TIMEOUT_VALUE");
                this.readTimeoutDecoration.setDescriptionText(message);
                this.readTimeoutDecoration.show();
            }
        }
        return message;
    }

    private Text createText(Composite parent, String leadingLabel, String tooltip, String trailingLabel, String initialValue, ModifyListener modifyListener, int horizontalIndent, int widthHint) {
        Label label1 = new Label(parent, 0);
        label1.setText(leadingLabel);
        Text text = new Text(parent, 2052);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        GridData gridData = new GridData(768);
        gridData.widthHint = widthHint;
        gridData.horizontalIndent = horizontalIndent;
        text.setToolTipText(tooltip);
        if (trailingLabel != null && !trailingLabel.isEmpty()) {
            Label label2 = new Label(parent, 0);
            label2.setText(trailingLabel);
        }
        text.setLayoutData((Object)gridData);
        if (modifyListener != null) {
            text.addModifyListener(modifyListener);
        }
        return text;
    }

    private void setGridLayout(Composite composite, Integer numColumns, Integer marginHeight, Integer marginWidth, Boolean grabExcessVerticalSpace, Boolean expandHorizontal) {
        GridLayout layout = new GridLayout();
        if (numColumns != null) {
            layout.numColumns = numColumns;
        }
        if (marginHeight != null) {
            layout.marginHeight = marginHeight;
        }
        if (marginWidth != null) {
            layout.marginWidth = marginWidth;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        if (expandHorizontal.booleanValue()) {
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
        }
        if (grabExcessVerticalSpace != null) {
            data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        }
        composite.setLayoutData((Object)data);
    }
}

