/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.rest.db2.builder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.common.validation.ValidationUtil;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceBuilder;
import com.ibm.zosconnect.ui.service.rest.db2.Db2Xlat;
import com.ibm.zosconnect.ui.service.rest.db2.util.JsonSchemaUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class Db2BuilderImpl
implements IServiceBuilder {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String c = this.getClass().getName();
    private static final String SCHEMAS_FOLDER_NAME = "schemas";
    private static final String REQUEST_FOLDER_PATH = "schemas/request";
    private static final String RESPONSE_FOLDER_PATH = "schemas/response";
    private static final String REQUEST_SCHEMA_FILE = "requestSchemaFile";
    private static final String RESPONSE_SCHEMA_FILE = "responseSchemaFile";

    public void build(ServiceProjectController serviceProjectController) {
        String methodName = "build";
        ZCeeUILogger.entering((String)this.c, (String)"build", (Object[])new Object[0]);
        String requestFileName = serviceProjectController.getServiceModel().getValue(REQUEST_SCHEMA_FILE);
        String responseFileName = serviceProjectController.getServiceModel().getValue(RESPONSE_SCHEMA_FILE);
        IPath location = serviceProjectController.getServiceModel().getServiceProject().getLocation();
        this.parseSchemaFile(serviceProjectController, location, requestFileName);
        this.parseSchemaFile(serviceProjectController, location, responseFileName);
        try {
            serviceProjectController.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ZCeeUILogger.error((Throwable)ce);
        }
        ZCeeUILogger.exiting((String)this.c, (String)"build", (Object[])new Object[0]);
    }

    private void parseSchemaFile(ServiceProjectController serviceProjectController, IPath location, String schemaFileName) {
        String methodName = "parseSchemaFile";
        ZCeeUILogger.entering((String)this.c, (String)"parseSchemaFile", (Object[])new Object[0]);
        ServiceProjectValidationError error = null;
        IProject project = serviceProjectController.getProject();
        String schema = String.valueOf(location) + File.separator + schemaFileName;
        String projectName = project.getName();
        File schemaFile = new File(schema);
        try {
            Throwable throwable = null;
            Object var11_16 = null;
            try (BufferedReader br_schema = new BufferedReader(new FileReader(schemaFile));){
                Gson gsonObject = new Gson();
                JsonObject jsonRequest = (JsonObject)gsonObject.fromJson((Reader)br_schema, JsonObject.class);
                JsonSchemaUtil.cleanSchema(jsonRequest);
                this.writeSchemaToFile(jsonRequest, schemaFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonSyntaxException jse) {
            ZCeeUILogger.error((Throwable)jse);
            String errorMessage = Db2Xlat.label("SCHEMA_ERROR", schemaFileName, projectName);
            error = new ServiceProjectValidationError((IResource)project, ServiceProjectMarkerTypes.PROJECT_PROBLEM, errorMessage);
        }
        catch (FileNotFoundException fnfe) {
            ZCeeUILogger.error((Throwable)fnfe);
            String errorMessage = Db2Xlat.label("SCHEMA_FILE_NOT_FOUND_ERROR", schemaFileName, projectName);
            error = new ServiceProjectValidationError((IResource)project, ServiceProjectMarkerTypes.PROJECT_PROBLEM, errorMessage);
        }
        catch (IOException ioe) {
            ZCeeUILogger.error((Throwable)ioe);
            String errorMessage = Db2Xlat.label("SCHEMA_IO_ERROR", schemaFileName, projectName);
            error = new ServiceProjectValidationError((IResource)project, ServiceProjectMarkerTypes.PROJECT_PROBLEM, errorMessage);
        }
        if (error != null) {
            try {
                ValidationUtil.createMarker((String)error.getMarkerType(), (IResource)error.getResource(), (String)error.getBareMessage(), (Integer)error.getLineNumber(), (Integer)error.getColumnNumber(), (int)error.getSeverity(), (Map)error.getAttributes());
                ZCeeUILogger.info((String)"Created new error marker", (Object[])new Object[]{error.getMarkerType(), error.getResource(), error.getBareMessage(), error.getSeverity()});
            }
            catch (CoreException ce) {
                ZCeeUILogger.error((Throwable)ce);
            }
        }
        ZCeeUILogger.exiting((String)this.c, (String)"parseSchemaFile", (Object[])new Object[0]);
    }

    public Set<String> getNewProjectFolderNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.add(SCHEMAS_FOLDER_NAME);
        names.add(REQUEST_FOLDER_PATH);
        names.add(RESPONSE_FOLDER_PATH);
        return names;
    }

    private void writeSchemaToFile(JsonObject schema, File destination) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileWriter writer = new FileWriter(destination);){
            gson.toJson((JsonElement)schema, (Appendable)writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<IPath> getBuildOutputFolderPaths() {
        return new ArrayList<IPath>();
    }
}

