/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.http.HttpStatusCodes;
import com.sun.jersey.api.client.ClientHandlerException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.StringUtils;

public class ApiException
extends ZosConnectUIException {
    private int statusCode = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;
    private String reasonPhrase = null;
    private String operationId = null;
    private IConnection connection;

    public ApiException() {
    }

    public ApiException(Throwable throwable, IConnection connection) {
        super(throwable);
        this.connection = connection;
    }

    public ApiException(String message, IConnection connection) {
        super(message);
        this.connection = connection;
    }

    public ApiException(String message, Throwable throwable, String operationId, int statusCode, Map<String, List<String>> responseHeaders, String responseBody, String reasonPhrase, IConnection connection) {
        super(message, throwable);
        this.statusCode = statusCode;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.reasonPhrase = reasonPhrase;
        this.connection = connection;
        this.operationId = operationId;
    }

    public ApiException(String message, String operationId, int statusCode, Map<String, List<String>> responseHeaders, String responseBody, String reasonPhrase, IConnection connection) {
        this(message, null, operationId, statusCode, responseHeaders, responseBody, reasonPhrase, connection);
    }

    public ApiException(String message, Throwable throwable, String operationId, int statusCode, Map<String, List<String>> responseHeaders, IConnection connection) {
        this(message, throwable, operationId, statusCode, responseHeaders, null, null, connection);
    }

    public ApiException(String operationId, int statusCode, Map<String, List<String>> responseHeaders, String responseBody, String reasonPhrase, IConnection connection) {
        this(null, null, operationId, statusCode, responseHeaders, responseBody, reasonPhrase, connection);
    }

    public ApiException(String operationId, int statusCode, String message, IConnection connection) {
        super(message);
        this.statusCode = statusCode;
        this.connection = connection;
        this.operationId = operationId;
    }

    public ApiException(String operationId, int statusCode, String message, Map<String, List<String>> responseHeaders, String responseBody, String reasonPhrase, IConnection connection) {
        this(operationId, statusCode, message, connection);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.reasonPhrase = reasonPhrase;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public int getHttpStatusCode() {
        return this.statusCode;
    }

    public String getHttpReasonPhrase() {
        return this.reasonPhrase;
    }

    public String getHttpResponseBody() {
        return this.responseBody;
    }

    public boolean isCausedByConnectivityException() {
        boolean isConnectivityException = false;
        Throwable cause = this.getCause();
        if (cause instanceof ClientHandlerException && (cause.getCause() instanceof ConnectException || cause.getCause() instanceof SocketException || cause.getCause() instanceof UnknownHostException || cause.getCause() instanceof SocketTimeoutException)) {
            isConnectivityException = StringUtils.isBlank((CharSequence)this.responseBody);
        }
        return isConnectivityException;
    }

    public boolean isCausedBySecurityException() {
        Throwable cause = this.getCause();
        if (cause instanceof ClientHandlerException && (cause.getCause() instanceof SSLException || cause.getCause() instanceof GeneralSecurityException)) {
            return true;
        }
        return HttpStatusCodes.Unauthorized.equals(this.getHttpStatusCode());
    }

    public boolean isCausedByCertificateException() {
        Throwable cause = this.getCause();
        return cause instanceof ClientHandlerException && cause.getCause() instanceof SSLHandshakeException && cause.getCause().getCause() instanceof CertificateException;
    }

    public boolean isCausedByUnexpectedResponse() {
        Throwable cause = this.getCause();
        String statusCode = String.valueOf(this.getHttpStatusCode());
        if (StringUtils.startsWithAny((CharSequence)statusCode, (CharSequence[])new CharSequence[]{"4", "5"})) {
            return true;
        }
        return cause instanceof ClientHandlerException && this.responseBody != null;
    }

    public boolean isCausedByOpenBetaExpiration() {
        return this.getHttpResponseBody() != null && !this.responseBody.isEmpty() && this.getHttpResponseBody().contains("Open Beta Expired");
    }

    public String getExternalMessage() {
        String externalMsg = this.getMessage();
        String serverName = this.getServerNameWithHostAndPort();
        if (this.isCausedByConnectivityException()) {
            externalMsg = Xlat.error((String)"ZOSCONNECT_SERVER_CONNECTIVITY_ERROR_MESSAGE", (String[])new String[]{serverName});
        } else if (this.isCausedBySecurityException()) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(this.statusCode);
            if (!StringUtils.isEmpty((CharSequence)this.reasonPhrase)) {
                errorMsg.append(" ");
                errorMsg.append(this.reasonPhrase);
            }
            externalMsg = Xlat.error((String)"ZOSCONNECT_SERVER_SECURITY_ERROR_MESSAGE", (String[])new String[]{serverName, errorMsg.toString()});
        } else if (this.isCausedByUnexpectedResponse()) {
            if (this.isCausedByOpenBetaExpiration()) {
                externalMsg = Xlat.error((String)"ZOSCONNECT_SERVER_OPEN_BETA_EXPIRED", (String[])new String[]{serverName});
                return externalMsg;
            }
            String serverMsg = StringUtils.trim((String)this.getMessage());
            boolean is404 = this.statusCode == 404;
            boolean is405 = this.statusCode == 405;
            boolean isBAQMsg = StringUtils.startsWith((CharSequence)serverMsg, (CharSequence)"BAQ");
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(this.statusCode);
            if (!StringUtils.isEmpty((CharSequence)this.reasonPhrase)) {
                errorMsg.append(" ");
                errorMsg.append(this.reasonPhrase);
            }
            if (isBAQMsg) {
                serverMsg = StringUtils.removeEnd((String)serverMsg, (String)".");
                errorMsg.append(", ");
                errorMsg.append(serverMsg);
                externalMsg = Xlat.error((String)"ZOSCONNECT_SERVER_ERROR_MESSAGE", (String[])new String[]{serverName, errorMsg.toString()});
            } else {
                externalMsg = is404 || is405 ? Xlat.error((String)"OPERATION_NOT_AVAILABLE", (String[])new String[]{"\"" + this.operationId + "\"", serverName}) : Xlat.error((String)"ZOSCONNECT_SERVER_UNEXPECTED_ERROR_MESSAGE", (String[])new String[]{serverName, errorMsg.toString()});
            }
        }
        return externalMsg;
    }

    public String getServerNameWithHostAndPort() {
        if (this.connection == null || this.connection.getConfiguration() == null) {
            return "Default";
        }
        ConnectionConfiguration config = this.connection.getConfiguration();
        StringBuilder serverName = new StringBuilder();
        serverName.append("\"");
        serverName.append(config.getName());
        serverName.append("\" (");
        serverName.append(config.getHost());
        serverName.append(Xlat.colon());
        serverName.append(config.getPort());
        serverName.append(")");
        return serverName.toString();
    }
}

