/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.zosconnect.ui.common.connections.AdminApiConnectionUtil;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.http.HttpStatusCodes;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker.ApiException;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker.Pair;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker.StringUtil;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker.auth.ApiKeyAuth;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker.auth.Authentication;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker.auth.HttpBasicAuth;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.invoker.auth.OAuth;
import com.ibm.zosconnect.ui.swagger.clients.adminapi.model.Error;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class ApiClient {
    private Map<String, Client> hostMap = new HashMap<String, Client>();
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private boolean debugging = false;
    private String basePath = "http://localhost/zosConnect";
    private ObjectMapper mapper = new ObjectMapper();
    private Map<String, Authentication> authentications;
    private int statusCode;
    private Map<String, List<String>> responseHeaders;
    private DateFormat dateFormat;
    private IConnection connection;
    private Integer connectTimeout;
    private Integer readTimeout;
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private boolean isClientCert;

    public ApiClient() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.mapper.registerModule((Module)new JodaModule());
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.mapper.setDateFormat((DateFormat)this.dateFormat.clone());
        this.setUserAgent("Java-Swagger");
        this.authentications = new HashMap<String, Authentication>();
        if (!this.isClientCert) {
            this.authentications.put("basicAuth", new HttpBasicAuth());
        }
        this.authentications = new HashMap<String, Authentication>(this.authentications);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.mapper.setDateFormat((DateFormat)dateFormat.clone());
        return this;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = collectionFormat = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if (collectionFormat.equals("multi")) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if (collectionFormat.equals("csv")) {
            delimiter = ",";
        } else if (collectionFormat.equals("ssv")) {
            delimiter = " ";
        } else if (collectionFormat.equals("tsv")) {
            delimiter = "\t";
        } else if (collectionFormat.equals("pipes")) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public boolean isJsonMime(String mime) {
        return mime != null && mime.matches("(?i)application\\/json(;.*)?");
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        String[] stringArray = accepts;
        int n = accepts.length;
        int n2 = 0;
        while (n2 < n) {
            String accept = stringArray[n2];
            if (this.isJsonMime(accept)) {
                return accept;
            }
            ++n2;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        String[] stringArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            if (this.isJsonMime(contentType)) {
                return contentType;
            }
            ++n2;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return str;
        }
    }

    public Object serialize(Object obj, String contentType, Map<String, Object> formParams) throws ApiException {
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                if (param.getValue() instanceof File) {
                    File file = (File)param.getValue();
                    mp.bodyPart((BodyPart)new FileDataBodyPart(param.getKey(), file, MediaType.MULTIPART_FORM_DATA_TYPE));
                    continue;
                }
                mp.field(param.getKey(), (Object)this.parameterToString(param.getValue()), MediaType.MULTIPART_FORM_DATA_TYPE);
            }
            return mp;
        }
        if (contentType.startsWith("application/x-www-form-urlencoded")) {
            return this.getXWWWFormUrlencodedParams(formParams);
        }
        return obj;
    }

    private ClientResponse getAPIResponse(String operationId, String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames) throws ApiException {
        if (body != null && !formParams.isEmpty()) {
            throw new ApiException(operationId, 500, "Cannot have body and form params", this.connection);
        }
        this.updateParamsForAuth(authNames, queryParams, headerParams);
        Client client = this.getClient();
        StringBuilder b = new StringBuilder();
        b.append("?");
        if (queryParams != null) {
            for (Pair queryParam : queryParams) {
                if (queryParam.getName().isEmpty()) continue;
                b.append(this.escapeString(queryParam.getName()));
                b.append("=");
                b.append(this.escapeString(queryParam.getValue()));
                b.append("&");
            }
        }
        String querystring = b.substring(0, b.length() - 1);
        WebResource.Builder builder = accept == null ? client.resource(this.basePath + path + querystring).getRequestBuilder() : client.resource(this.basePath + path + querystring).accept(new String[]{accept});
        for (String key : headerParams.keySet()) {
            builder = (WebResource.Builder)builder.header(key, (Object)headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder = (WebResource.Builder)builder.header(key, (Object)this.defaultHeaderMap.get(key));
        }
        ClientResponse response = null;
        if ("GET".equals(method)) {
            response = (ClientResponse)builder.get(ClientResponse.class);
        } else if ("POST".equals(method)) {
            response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, this.serialize(body, contentType, formParams));
        } else if ("PUT".equals(method)) {
            response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, this.serialize(body, contentType, formParams));
        } else if ("DELETE".equals(method)) {
            response = (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, this.serialize(body, contentType, formParams));
        } else {
            throw new ApiException(operationId, 500, "unknown method type " + method, this.connection);
        }
        return response;
    }

    public <T> T invokeAPI(String operationId, String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, GenericType<T> returnType) throws ApiException {
        Object responseEntity;
        block12: {
            ZCeeUILogger.entering((String)this.getClass().getName(), (String)"invokeApi(operationId={0},path={1},method={2},queryParms={3},body={4},..,accept={5},contentType={6},...)", (Object[])new Object[]{operationId, path, method, queryParams, body, accept, contentType});
            Authenticator.setDefault(null);
            ClientResponse response = this.getAPIResponse(operationId, path, method, queryParams, body, headerParams, formParams, accept, contentType, authNames);
            this.statusCode = response.getStatusInfo().getStatusCode();
            this.responseHeaders = response.getHeaders();
            if (HttpStatusCodes.Unauthorized.equals(this.statusCode)) {
                this.setUsername(null);
                this.setPassword(null);
                ConnectionConfiguration connectionConfig = this.connection.getConfiguration();
                String credentialsID = connectionConfig.getCredentialsID();
                ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();
                CredentialsConfiguration credentialsConfig = credentialsManager.findCredentialsConfigurationByID(credentialsID);
                ZCeeUILogger.info((String)"Authentication failed so invalidating credential: {0}", (Object[])new Object[]{credentialsConfig.getName()});
                credentialsManager.invalidate(credentialsID);
                IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
                ConnectionProfile connectionProfile = connectionManager.getConnectionProfile(connectionConfig.getID());
                ZCeeUILogger.info((String)"Disconnecting all connections that use credential: {0}", (Object[])new Object[]{credentialsConfig.getName()});
                AdminApiConnectionUtil.disconnectAllWithSameCredential((ConnectionProfile)connectionProfile);
            }
            responseEntity = null;
            String responseBody = null;
            try {
                if (response.hasEntity()) {
                    response.bufferEntity();
                    responseBody = (String)response.getEntity(String.class);
                    response.getEntityInputStream().reset();
                    ZCeeUILogger.info((String)"responseBody={0}", (Object[])new Object[]{responseBody});
                }
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    if (returnType != null) {
                        String returnTypeName = returnType.getRawClass().getName();
                        if (response.hasEntity()) {
                            try {
                                responseEntity = response.getEntity(returnType);
                                ZCeeUILogger.info((String)"responseEntity={0}", (Object[])new Object[]{responseEntity});
                            }
                            catch (RuntimeException runtimeException) {
                                ZCeeUILogger.error((String)"failed to unmarshall response entity as type \"{0}\"", (Object[])new Object[]{returnTypeName});
                            }
                        } else {
                            ZCeeUILogger.error((String)"expected a response entity of type \"{0}\", but one was not received", (Object[])new Object[]{returnTypeName});
                        }
                    }
                    break block12;
                }
                Object message = null;
                try {
                    message = response.getStatusInfo().getStatusCode() + ", " + response.getStatusInfo().getReasonPhrase();
                    Error error = (Error)response.getEntity(Error.class);
                    String errorMessage = StringUtils.removeEnd((String)StringUtils.trimToEmpty((String)error.getErrorMessage()), (String)".");
                    String errorDetails = StringUtils.trimToEmpty((String)error.getErrorDetails());
                    message = StringUtils.join((Object[])new String[]{errorMessage, errorDetails}, (String)". ");
                }
                catch (RuntimeException runtimeException) {}
                throw new ApiException(operationId, response.getStatusInfo().getStatusCode(), (String)message, (Map<String, List<String>>)response.getHeaders(), responseBody, response.getStatusInfo().getReasonPhrase(), this.connection);
            }
            catch (Exception e) {
                throw new ApiException(e.getMessage(), e, operationId, response.getStatusInfo().getStatusCode(), (Map<String, List<String>>)response.getHeaders(), responseBody, response.getStatusInfo().getReasonPhrase(), this.connection);
            }
        }
        ZCeeUILogger.exiting((String)this.getClass().getName(), (String)"invokeApi()", (Object[])new Object[0]);
        return (T)responseEntity;
    }

    private void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams) {
        String[] stringArray = authNames;
        int n = authNames.length;
        int n2 = 0;
        while (n2 < n) {
            String authName = stringArray[n2];
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams);
            ++n2;
        }
    }

    private String getXWWWFormUrlencodedParams(Map<String, Object> formParams) {
        StringBuilder formParamBuilder = new StringBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            String valueStr = this.parameterToString(param.getValue());
            try {
                formParamBuilder.append(URLEncoder.encode(param.getKey(), "utf8")).append("=").append(URLEncoder.encode(valueStr, "utf8"));
                formParamBuilder.append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        String encodedFormParams = formParamBuilder.toString();
        if (encodedFormParams.endsWith("&")) {
            encodedFormParams = encodedFormParams.substring(0, encodedFormParams.length() - 1);
        }
        return encodedFormParams;
    }

    private Client getClient() throws ApiException {
        if (!this.hostMap.containsKey(this.basePath)) {
            DefaultClientConfig conf = new DefaultClientConfig();
            JacksonJsonProvider jsonProvider = new JacksonJsonProvider(this.mapper);
            conf.getSingletons().add(jsonProvider);
            URLConnectionClientHandler clientHandler = null;
            clientHandler = this.sslContext != null && this.sslSocketFactory != null ? new URLConnectionClientHandler(new HttpURLConnectionFactory(){

                public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                    HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
                    conn.setHostnameVerifier(ApiClient.this.hostnameVerifier);
                    conn.setSSLSocketFactory(ApiClient.this.sslSocketFactory);
                    return conn;
                }
            }) : new URLConnectionClientHandler();
            Client client = new Client((ClientHandler)clientHandler, (ClientConfig)conf);
            if (this.debugging) {
                client.addFilter((ClientFilter)new LoggingFilter());
            }
            this.hostMap.put(this.basePath, client);
        }
        Client client = this.hostMap.get(this.basePath);
        if (this.connectTimeout != null) {
            client.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout != null) {
            client.setReadTimeout(this.readTimeout);
        }
        return client;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IConnection connection) {
        this.connection = connection;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setIsClientCert(boolean isClientCert) {
        this.isClientCert = isClientCert;
    }
}

