/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.ibm.zosconnect.ui.swagger.libs.BigDecimalSerializer;
import com.ibm.zosconnect.ui.swagger.libs.BigIntegerSerializer;
import com.ibm.zosconnect.ui.swagger.libs.DoubleSerializer;
import io.swagger.util.DeserializationModule;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ObjectMapperFactory {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected static ObjectMapper createJson() {
        return ObjectMapperFactory.createJson(true, true);
    }

    protected static ObjectMapper createJson(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(null, includePathDeserializer, includeResponseDeserializer);
    }

    protected static ObjectMapper createYaml() {
        return ObjectMapperFactory.createYaml(true, true);
    }

    protected static ObjectMapper createYaml(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create((JsonFactory)new YAMLFactory(), includePathDeserializer, includeResponseDeserializer);
    }

    private static ObjectMapper create(JsonFactory jsonFactory, boolean includePathDeserializer, boolean includeResponseDeserializer) {
        ObjectMapper mapper = jsonFactory == null ? new ObjectMapper() : new ObjectMapper(jsonFactory);
        DeserializationModule deserializerModule = new DeserializationModule(includePathDeserializer, includeResponseDeserializer);
        mapper.registerModule((Module)deserializerModule);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        SimpleModule doubleModule = new SimpleModule("com.ibm.zosconnect.ui.swagger.libs.serializers.Double");
        doubleModule.addSerializer(Double.class, (JsonSerializer)new DoubleSerializer());
        mapper.registerModule((Module)doubleModule);
        SimpleModule bigDecModule = new SimpleModule("com.ibm.zosconnect.ui.swagger.libs.serializers.BigDecimal");
        bigDecModule.addSerializer(BigDecimal.class, (JsonSerializer)new BigDecimalSerializer());
        mapper.registerModule((Module)bigDecModule);
        SimpleModule bigIntModule = new SimpleModule("com.ibm.zosconnect.ui.swagger.libs.serializers.BigInteger");
        bigIntModule.addSerializer(BigInteger.class, (JsonSerializer)new BigIntegerSerializer());
        mapper.registerModule((Module)bigIntModule);
        return mapper;
    }
}

