/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.properties;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.AbstractProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BinaryProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBuilder {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger LOGGER = LoggerFactory.getLogger(PropertyBuilder.class);

    public static Property build(String type, String format, Map<PropertyId, Object> args) {
        Map<PropertyId, Object> fixedArgs;
        Map<PropertyId, Object> safeArgs;
        Processor processor = Processor.fromType(type, format);
        if (processor == null) {
            return null;
        }
        Map<Object, Object> map = safeArgs = args == null ? Collections.emptyMap() : args;
        if (format != null) {
            fixedArgs = new EnumMap(PropertyId.class);
            fixedArgs.putAll(safeArgs);
            fixedArgs.put(PropertyId.FORMAT, format);
        } else {
            fixedArgs = safeArgs;
        }
        return processor.build(fixedArgs);
    }

    public static Property merge(Property property, Map<PropertyId, Object> args) {
        Processor processor;
        if (args != null && !args.isEmpty() && (processor = Processor.fromProperty(property)) != null) {
            processor.merge(property, args);
        }
        return property;
    }

    public static Model toModel(Property property) {
        Processor processor = Processor.fromProperty(property);
        if (processor != null) {
            return processor.toModel(property);
        }
        return null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Processor {
        BOOLEAN(BooleanProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return BooleanProperty.isType((String)type, (String)format);
            }

            protected BooleanProperty create() {
                return new BooleanProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof BooleanProperty) {
                    BooleanProperty resolved = (BooleanProperty)property;
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault(null);
                        }
                    }
                }
                return property;
            }
        }
        ,
        BYTE_ARRAY(ByteArrayProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return ByteArrayProperty.isType((String)type, (String)format);
            }

            protected ByteArrayProperty create() {
                return new ByteArrayProperty();
            }
        }
        ,
        BINARY(BinaryProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return BinaryProperty.isType((String)type, (String)format);
            }

            protected BinaryProperty create() {
                return new BinaryProperty();
            }
        }
        ,
        INT(IntegerProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return IntegerProperty.isType((String)type, (String)format);
            }

            protected IntegerProperty create() {
                return new IntegerProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof IntegerProperty) {
                    IntegerProperty resolved = (IntegerProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault(null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    IntegerProperty resolved = (IntegerProperty)property;
                    ModelImpl model = this.createModel((Property)resolved);
                    Integer defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        LONG(LongProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return LongProperty.isType((String)type, (String)format);
            }

            protected LongProperty create() {
                return new LongProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof LongProperty) {
                    LongProperty resolved = (LongProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault(null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    LongProperty resolved = (LongProperty)property;
                    ModelImpl model = this.createModel((Property)resolved);
                    Long defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        FLOAT(FloatProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return FloatProperty.isType((String)type, (String)format);
            }

            protected FloatProperty create() {
                return new FloatProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof FloatProperty) {
                    FloatProperty resolved = (FloatProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault(null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    FloatProperty resolved = (FloatProperty)property;
                    ModelImpl model = this.createModel((Property)resolved);
                    Float defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        DOUBLE(DoubleProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return DoubleProperty.isType((String)type, (String)format);
            }

            protected DoubleProperty create() {
                return new DoubleProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof DoubleProperty) {
                    DoubleProperty resolved = (DoubleProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault(null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    DoubleProperty resolved = (DoubleProperty)property;
                    ModelImpl model = this.createModel((Property)resolved);
                    Double defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        INTEGER(BaseIntegerProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return BaseIntegerProperty.isType(type, format);
            }

            @Override
            protected BaseIntegerProperty create() {
                return new BaseIntegerProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof BaseIntegerProperty) {
                    BaseIntegerProperty resolved = (BaseIntegerProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((BigInteger)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    BaseIntegerProperty resolved = (BaseIntegerProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    BigInteger defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        DECIMAL(DecimalProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return DecimalProperty.isType(type, format);
            }

            @Override
            protected DecimalProperty create() {
                return new DecimalProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof DecimalProperty) {
                    DecimalProperty resolved = (DecimalProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((BigDecimal)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    DecimalProperty resolved = (DecimalProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    BigDecimal defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toPlainString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        FILE(FileProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return FileProperty.isType((String)type, (String)format);
            }

            protected FileProperty create() {
                return new FileProperty();
            }
        }
        ,
        REFERENCE(RefProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return RefProperty.isType((String)type, (String)format);
            }

            protected RefProperty create() {
                return new RefProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof RefProperty) {
                    RefProperty resolved = (RefProperty)property;
                    RefModel model = new RefModel(resolved.get$ref());
                    model.setDescription(resolved.getDescription());
                    return model;
                }
                return null;
            }
        }
        ,
        E_MAIL(EmailProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return EmailProperty.isType((String)type, (String)format);
            }

            protected EmailProperty create() {
                return new EmailProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof EmailProperty) {
                    this.mergeString((EmailProperty)property, args);
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    return this.createStringModel((StringProperty)property);
                }
                return null;
            }
        }
        ,
        UUID(UUIDProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return UUIDProperty.isType((String)type, (String)format);
            }

            protected UUIDProperty create() {
                return new UUIDProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof UUIDProperty) {
                    Object value;
                    UUIDProperty resolved = (UUIDProperty)property;
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        value = (String)PropertyId.DEFAULT.findValue(args);
                        property.setDefault((String)value);
                    }
                    if (args.containsKey((Object)PropertyId.MIN_LENGTH)) {
                        value = (Integer)PropertyId.MIN_LENGTH.findValue(args);
                        resolved.setMinLength((Integer)value);
                    }
                    if (args.containsKey((Object)PropertyId.MAX_LENGTH)) {
                        value = (Integer)PropertyId.MAX_LENGTH.findValue(args);
                        resolved.setMaxLength((Integer)value);
                    }
                    if (args.containsKey((Object)PropertyId.PATTERN)) {
                        value = (String)PropertyId.PATTERN.findValue(args);
                        resolved.setPattern((String)value);
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    UUIDProperty resolved = (UUIDProperty)property;
                    ModelImpl model = this.createModel((Property)resolved);
                    model.setDefaultValue(resolved.getDefault());
                    return model;
                }
                return null;
            }
        }
        ,
        OBJECT(ObjectProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return ObjectProperty.isType((String)type, (String)format);
            }

            protected ObjectProperty create() {
                return new ObjectProperty();
            }
        }
        ,
        ARRAY(ArrayProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return ArrayProperty.isType(type);
            }

            @Override
            protected ArrayProperty create() {
                return new ArrayProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof ArrayProperty) {
                    ArrayProperty resolved = (ArrayProperty)property;
                    ArrayModel model = new ArrayModel().items(resolved.getItems()).description(resolved.getDescription());
                    return model;
                }
                return null;
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof ArrayProperty) {
                    Object value;
                    ArrayProperty resolved = (ArrayProperty)property;
                    if (args.containsKey((Object)PropertyId.MIN_ITEMS)) {
                        value = (Integer)PropertyId.MIN_ITEMS.findValue(args);
                        resolved.setMinItems((Integer)value);
                    }
                    if (args.containsKey((Object)PropertyId.MAX_ITEMS)) {
                        value = (Integer)PropertyId.MAX_ITEMS.findValue(args);
                        resolved.setMaxItems((Integer)value);
                    }
                    if (args.containsKey((Object)PropertyId.UNIQUE_ITEMS)) {
                        value = (Boolean)PropertyId.UNIQUE_ITEMS.findValue(args);
                        resolved.setUniqueItems((Boolean)value);
                    }
                    if (args.containsKey((Object)PropertyId.COLLECTION_FORMAT)) {
                        value = (String)PropertyId.COLLECTION_FORMAT.findValue(args);
                        resolved.setCollectionFormat((String)value);
                    }
                }
                return property;
            }
        }
        ,
        MAP(MapProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return MapProperty.isType((String)type, (String)format);
            }

            protected MapProperty create() {
                return new MapProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof MapProperty) {
                    MapProperty resolved = (MapProperty)property;
                    return this.createModel(property).additionalProperties(resolved.getAdditionalProperties());
                }
                return null;
            }
        }
        ,
        STRING(StringProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return StringProperty.isType((String)type, (String)format);
            }

            protected StringProperty create() {
                return new StringProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof StringProperty) {
                    this.mergeString((StringProperty)property, args);
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    return this.createStringModel((StringProperty)property);
                }
                return null;
            }
        };

        private final Class<? extends Property> type;

        private Processor(Class<? extends Property> type) {
            this.type = type;
        }

        public static Processor fromType(String type, String format) {
            Processor[] processorArray = Processor.values();
            int n = processorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Processor item = processorArray[n2];
                if (item.isType(type, format)) {
                    return item;
                }
                ++n2;
            }
            LOGGER.debug("no property for " + type + ", " + format);
            return null;
        }

        public static Processor fromProperty(Property property) {
            Processor[] processorArray = Processor.values();
            int n = processorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Processor item = processorArray[n2];
                if (item.isType(property)) {
                    return item;
                }
                ++n2;
            }
            LOGGER.error("no property for " + (property == null ? "null" : property.getClass().getName()));
            return null;
        }

        protected abstract boolean isType(String var1, String var2);

        protected boolean isType(Property property) {
            return this.type.isInstance(property);
        }

        protected abstract Property create();

        protected <N extends AbstractNumericProperty> N mergeNumeric(N property, Map<PropertyId, Object> args) {
            Comparable<BigDecimal> value;
            if (args.containsKey((Object)PropertyId.MINIMUM)) {
                value = (BigDecimal)PropertyId.MINIMUM.findValue(args);
                property.setMinimum((BigDecimal)value);
            }
            if (args.containsKey((Object)PropertyId.MAXIMUM)) {
                value = (BigDecimal)PropertyId.MAXIMUM.findValue(args);
                property.setMaximum((BigDecimal)value);
            }
            if (args.containsKey((Object)PropertyId.EXCLUSIVE_MINIMUM)) {
                value = (Boolean)PropertyId.EXCLUSIVE_MINIMUM.findValue(args);
                property.setExclusiveMinimum((Boolean)value);
            }
            if (args.containsKey((Object)PropertyId.EXCLUSIVE_MAXIMUM)) {
                value = (Boolean)PropertyId.EXCLUSIVE_MAXIMUM.findValue(args);
                property.setExclusiveMaximum((Boolean)value);
            }
            return property;
        }

        protected <N extends StringProperty> N mergeString(N property, Map<PropertyId, Object> args) {
            Object value;
            if (args.containsKey((Object)PropertyId.DEFAULT)) {
                value = (String)PropertyId.DEFAULT.findValue(args);
                property.setDefault((String)value);
            }
            if (args.containsKey((Object)PropertyId.MIN_LENGTH)) {
                value = (Integer)PropertyId.MIN_LENGTH.findValue(args);
                property.setMinLength((Integer)value);
            }
            if (args.containsKey((Object)PropertyId.MAX_LENGTH)) {
                value = (Integer)PropertyId.MAX_LENGTH.findValue(args);
                property.setMaxLength((Integer)value);
            }
            if (args.containsKey((Object)PropertyId.PATTERN)) {
                value = (String)PropertyId.PATTERN.findValue(args);
                property.setPattern((String)value);
            }
            if (args.containsKey((Object)PropertyId.ENUM)) {
                value = (List)PropertyId.ENUM.findValue(args);
                property.setEnum((List)value);
            }
            return property;
        }

        protected ModelImpl createModel(Property property) {
            return new ModelImpl().type(property.getType()).format(property.getFormat()).description(property.getDescription());
        }

        protected ModelImpl createStringModel(StringProperty property) {
            ModelImpl model = this.createModel((Property)property);
            model.setDefaultValue(property.getDefault());
            return model;
        }

        public Property build(Map<PropertyId, Object> args) {
            return this.merge(this.create(), args);
        }

        public Property merge(Property property, Map<PropertyId, Object> args) {
            if (args.containsKey((Object)PropertyId.READ_ONLY)) {
                property.setReadOnly((Boolean)PropertyId.READ_ONLY.findValue(args));
            }
            if (property instanceof AbstractProperty) {
                List values;
                Object value;
                AbstractProperty resolved = (AbstractProperty)property;
                if (resolved.getFormat() == null) {
                    resolved.setFormat((String)PropertyId.FORMAT.findValue(args));
                }
                if (args.containsKey((Object)PropertyId.TITLE)) {
                    value = (String)PropertyId.TITLE.findValue(args);
                    resolved.setTitle((String)value);
                }
                if (args.containsKey((Object)PropertyId.DESCRIPTION)) {
                    value = (String)PropertyId.DESCRIPTION.findValue(args);
                    resolved.setDescription((String)value);
                }
                if (args.containsKey((Object)PropertyId.EXAMPLE)) {
                    value = (String)PropertyId.EXAMPLE.findValue(args);
                    resolved.setExample((String)value);
                }
                if (args.containsKey((Object)PropertyId.VENDOR_EXTENSIONS)) {
                    value = (Map)PropertyId.VENDOR_EXTENSIONS.findValue(args);
                    resolved.setVendorExtensionMap((Map)value);
                }
                if (args.containsKey((Object)PropertyId.ENUM) && (values = (List)PropertyId.ENUM.findValue(args)) != null) {
                    IntegerProperty p;
                    if (property instanceof IntegerProperty) {
                        p = (IntegerProperty)property;
                        for (String value2 : values) {
                            try {
                                p._enum(Integer.valueOf(Integer.parseInt(value2)));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (property instanceof LongProperty) {
                        p = (LongProperty)property;
                        for (String value2 : values) {
                            try {
                                p._enum(Long.valueOf(Long.parseLong(value2)));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (property instanceof DoubleProperty) {
                        p = (DoubleProperty)property;
                        for (String value2 : values) {
                            try {
                                p._enum(Double.valueOf(Double.parseDouble(value2)));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (property instanceof FloatProperty) {
                        p = (FloatProperty)property;
                        for (String value2 : values) {
                            try {
                                p._enum(Float.valueOf(Float.parseFloat(value2)));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (property instanceof DateProperty) {
                        p = (DateProperty)property;
                        for (String value2 : values) {
                            try {
                                p._enum(value2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (property instanceof DateTimeProperty) {
                        p = (DateTimeProperty)property;
                        for (String value2 : values) {
                            try {
                                p._enum(value2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (property instanceof UUIDProperty) {
                        p = (UUIDProperty)property;
                        for (String value2 : values) {
                            try {
                                p._enum(value2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            return property;
        }

        public Model toModel(Property property) {
            return this.createModel(property);
        }
    }

    public static enum PropertyId {
        ENUM("enum"),
        TITLE("title"),
        DESCRIPTION("description"),
        DEFAULT("default"),
        PATTERN("pattern"),
        DESCRIMINATOR("discriminator"),
        MIN_ITEMS("minItems"),
        MAX_ITEMS("maxItems"),
        MIN_PROPERTIES("minProperties"),
        MAX_PROPERTIES("maxProperties"),
        MIN_LENGTH("minLength"),
        MAX_LENGTH("maxLength"),
        MINIMUM("minimum"),
        MAXIMUM("maximum"),
        EXCLUSIVE_MINIMUM("exclusiveMinimum"),
        EXCLUSIVE_MAXIMUM("exclusiveMaximum"),
        UNIQUE_ITEMS("uniqueItems"),
        EXAMPLE("example"),
        TYPE("type"),
        FORMAT("format"),
        READ_ONLY("readOnly"),
        REQUIRED("required"),
        VENDOR_EXTENSIONS("vendorExtensions"),
        COLLECTION_FORMAT("collectionFormat");

        private String propertyName;

        private PropertyId(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public <T> T findValue(Map<PropertyId, Object> args) {
            Object value = args.get((Object)this);
            return (T)value;
        }
    }
}

