/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.domainui;

import com.ibm.msl.mapping.FunctionRefinement;
import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.api.domain.MappingDomain;
import com.ibm.msl.mapping.domain.ITypeHandler;
import com.ibm.msl.mapping.internal.ui.editor.MappingEditor;
import com.ibm.msl.mapping.ui.commands.UpdateFunctionPropertyCommand;
import com.ibm.msl.mapping.ui.environment.IMappingUIMessageProvider;
import com.ibm.msl.mapping.ui.help.MappingContextProvider;
import com.ibm.msl.mapping.ui.properties.AbstractMappingSection;
import com.ibm.msl.mapping.ui.properties.utils.ChangeHelper;
import com.ibm.msl.mapping.ui.properties.utils.StatusMarker;
import com.ibm.msl.mapping.ui.utils.Transform;
import com.ibm.msl.mapping.util.EclipseResourceUtils;
import com.ibm.msl.mapping.xml.node.XMLTypeNode;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingAnnotator;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingValidatorUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ZCeeAssignSection
extends AbstractMappingSection {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PROPERTY_VALUE = "value";
    protected Text fValueText;
    protected Button fOmitButton;
    protected ChangeHelper fControlChangeListener = new ChangeHelper(){

        public boolean validateChange(Event event) {
            return ZCeeAssignSection.this.validateSection();
        }

        public void textChanged(Control control) {
            if (control == ZCeeAssignSection.this.fValueText) {
                Transform transform = new Transform(ZCeeAssignSection.this.getDomainUI(), ZCeeAssignSection.this.getMapping());
                IMappingUIMessageProvider messageProvider = ZCeeAssignSection.this.getMappingMessageProvider();
                String label = messageProvider.getString("command.update.assign.value");
                String v = ZCeeAssignSection.this.fValueText.getText();
                FunctionRefinement func = (FunctionRefinement)transform.create();
                String value = (String)func.getProperties().get((Object)ZCeeAssignSection.PROPERTY_VALUE);
                String string = value = value == null ? new String() : value;
                if (v.equals(value)) {
                    return;
                }
                UpdateFunctionPropertyCommand command = new UpdateFunctionPropertyCommand(label, func, (Object)ZCeeAssignSection.PROPERTY_VALUE, (Object)v);
                ZCeeAssignSection.this.getCommandStack().execute((Command)command);
            }
        }

        public void selectionChanged(Control control) {
            if (control == ZCeeAssignSection.this.fOmitButton) {
                Mapping mapping = ZCeeAssignSection.this.getMapping();
                final MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
                if (output == null) {
                    return;
                }
                final boolean newVal = ZCeeAssignSection.this.fOmitButton.getSelection();
                Command command = new Command(){

                    public void execute() {
                        ZCeeMappingAnnotator.setOmitFromIterface((MappingDesignator)output, (boolean)newVal);
                    }

                    public boolean canExecute() {
                        return true;
                    }

                    public boolean canUndo() {
                        return false;
                    }
                };
                ZCeeAssignSection.this.getCommandStack().execute(command);
            }
        }
    };

    public void enableControls(boolean enable) {
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite composite = factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        GridData data = null;
        if (this.getDomainUI() == null) {
            return;
        }
        IMappingUIMessageProvider messageProvider = this.getMappingMessageProvider();
        String label = messageProvider.getString("section.assign.assign");
        factory.createCLabel(composite, label);
        StatusMarker marker = new StatusMarker(composite, 0);
        this.fValueText = factory.createText(composite, "");
        data = new GridData(4, 0x1000000, true, false, 1, 1);
        this.fValueText.setLayoutData((Object)data);
        this.fWidgetToStatusMarkerMap.put(this.fValueText, marker);
        this.fValueText.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.fValueText.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        });
        this.fOmitButton = factory.createButton(composite, Xlat.label((String)"MAPPING_BUTTON_OMIT_FROM_INTERFACE"), 32);
        this.fOmitButton.setToolTipText(Xlat.description((String)"TOOLTIP_OMIT_FROM_INTERFACE"));
        data = new GridData(16384, 0x1000000, false, false, 3, 1);
        this.fOmitButton.setLayoutData((Object)data);
        this.fControlChangeListener.startListeningTo((Control)this.fValueText);
        this.fControlChangeListener.startListeningTo((Control)this.fOmitButton);
        this.fControlChangeListener.startListeningForEnter((Control)this.fValueText);
    }

    public void refresh() {
        super.refresh();
        if (this.isDisposed((Widget)this.fValueText)) {
            return;
        }
        this.fControlChangeListener.startNonUserChange();
        try {
            Transform transform = new Transform(this.getDomainUI(), this.getMapping());
            if (transform.getKind() != 0) {
                return;
            }
            FunctionRefinement function = (FunctionRefinement)transform.create();
            EMap map = function.getProperties();
            String value = (String)map.get((Object)PROPERTY_VALUE);
            value = value == null ? "" : value;
            this.fValueText.setText(value);
            Mapping mapping = this.getMapping();
            MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)mapping.getOutputs());
            if (output != null) {
                boolean omit = ZCeeMappingAnnotator.getOmitFromInterface((MappingDesignator)output);
                this.fOmitButton.setSelection(omit);
            }
            this.validateSection();
        }
        finally {
            this.fControlChangeListener.finishNonUserChange();
        }
    }

    protected Mapping getMapping() {
        Object model = this.getModel();
        if (model instanceof Mapping) {
            return (Mapping)model;
        }
        return null;
    }

    protected boolean validateSection() {
        if (this.isDisposed((Widget)this.fValueText)) {
            return true;
        }
        String value = this.fValueText.getText();
        EObject type = this.getType();
        StatusMarker valueMarker = (StatusMarker)this.fWidgetToStatusMarkerMap.get(this.fValueText);
        IStatus status = null;
        boolean valid = true;
        if (value != null && type != null) {
            MappingEditor mappingEditor = this.getMappingEditor();
            MappingDomain mappingDomain = mappingEditor.getDomain();
            ITypeHandler typeHandler = mappingDomain.getTypeHandler();
            MappingRoot mappingRoot = mappingEditor.getMappingRoot();
            IFile mappingFile = EclipseResourceUtils.getMappingFile((MappingRoot)mappingRoot);
            boolean assignable = typeHandler.isAssignable(value, type);
            if (assignable) {
                ArrayList problems = new ArrayList();
                ZCeeMappingValidatorUtil.validateAssignValue((String)value, (XMLTypeNode)((XMLTypeNode)type), (Mapping)this.getMapping(), (IResource)mappingFile, problems);
                valid = problems.isEmpty();
                if (!valid) {
                    String message = ((MappingValidationProblem2)problems.get(0)).getMessage();
                    status = this.createErrorStatus(message);
                    XSwt.setForeground((Text)this.fValueText, (int)3);
                    XSwt.setTooltipText((Control)this.fValueText, (String)message);
                } else {
                    XSwt.setForeground((Text)this.fValueText, (int)21);
                    XSwt.setTooltipText((Control)this.fValueText, (String)this.fValueText.getText());
                }
            } else {
                XSwt.setTooltipText((Control)this.fValueText, (String)this.fValueText.getText());
            }
            valueMarker.setStatus(status);
        }
        return valid;
    }

    protected EObject getType() {
        Mapping m = this.getMapping();
        if (m == null) {
            return null;
        }
        EList outputs = m.getOutputs();
        if (outputs.size() == 0) {
            return null;
        }
        EObject eObject = ((MappingDesignator)outputs.get(0)).getObject();
        ITypeHandler handler = this.getMappingEditor().getDomain().getTypeHandler();
        if (handler.isNodeType(eObject)) {
            return eObject;
        }
        if (handler.isNode(eObject)) {
            return handler.getNodeType(eObject);
        }
        return null;
    }

    public void dispose() {
        if (!this.isDisposed((Widget)this.fValueText)) {
            this.fControlChangeListener.stopListeningTo((Control)this.fValueText);
        }
        if (!this.isDisposed((Widget)this.fOmitButton)) {
            this.fControlChangeListener.stopListeningTo((Control)this.fOmitButton);
        }
        super.dispose();
    }

    protected String getContextHelpId() {
        return MappingContextProvider.getDomainSpecificContextID((MappingRoot)this.getMappingRoot(), (String)"gdmSectionAssign");
    }

    protected void handleEditorSaveEvent() {
        if (!this.validateSection()) {
            Transform transform = new Transform(this.getDomainUI(), this.getMapping());
            FunctionRefinement func = (FunctionRefinement)transform.create();
            String value = (String)func.getProperties().get((Object)PROPERTY_VALUE);
            value = value == null ? new String() : value;
            XSwt.setText((Text)this.fValueText, (String)value);
        }
    }
}

