/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.domain.util;

import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingContainer;
import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.MoveRefinement;
import com.ibm.msl.mapping.RemoveRefinement;
import com.ibm.msl.mapping.SemanticRefinement;
import com.ibm.msl.mapping.TaskRefinement;
import com.ibm.msl.mapping.domain.ITypeHandler;
import com.ibm.msl.mapping.util.EclipseResourceUtils;
import com.ibm.msl.mapping.util.ModelUtils;
import com.ibm.msl.mapping.validators.AbstractCoreValidator;
import com.ibm.msl.mapping.validators.IValidationOptions;
import com.ibm.msl.mapping.validators.IValidationProblem;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ArrayUtilz;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.URIUtilz;
import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import com.ibm.zosconnect.ui.mapping.domain.util.ZCeeMappingAnalyzer;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingValidatorUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;

public class ZCeeMappingValidator
extends AbstractCoreValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ITypeHandler typeHandler;

    public ZCeeMappingValidator(ITypeHandler typeHandler) {
        this.typeHandler = typeHandler;
    }

    public boolean isAllowedPrimaryRefinement(MappingDesignator[] inputs, MappingDesignator[] outputs, SemanticRefinement primaryRefinement, MappingContainer parentMapping) {
        MappingDesignator input = (MappingDesignator)ArrayUtilz.getFirstElement((Object[])inputs);
        MappingDesignator output = (MappingDesignator)ArrayUtilz.getFirstElement((Object[])outputs);
        MappingRoot mappingRoot = ModelUtils.getMappingRoot((EObject)parentMapping);
        if (mappingRoot == null && input != null) {
            mappingRoot = ModelUtils.getMappingRoot((MappingDesignator)input);
        }
        if (mappingRoot == null && output != null) {
            mappingRoot = ModelUtils.getMappingRoot((MappingDesignator)output);
        }
        boolean inputNullable = ZCeeMappingUtil.isNullable((MappingDesignator)input);
        boolean outputHasRemovedParent = ZCeeMappingUtil.hasRemovedParent((MappingDesignator)output);
        boolean outputNullable = ZCeeMappingUtil.isNullable((MappingDesignator)output);
        if (input != null) {
            ModelUtils.getMappingForDesignator((MappingDesignator)input);
        } else if (output != null) {
            ModelUtils.getMappingForDesignator((MappingDesignator)output);
        }
        if (ZCeeMappingValidatorUtil.isSimpleToComplex((MappingDesignator)input, (MappingDesignator)output)) {
            return false;
        }
        if (ZCeeMappingValidatorUtil.isComplexToSimple((MappingDesignator)input, (MappingDesignator)output)) {
            return false;
        }
        if (ZCeeMappingValidatorUtil.isComplexToComplex((MappingDesignator)input, (MappingDesignator)output)) {
            return false;
        }
        if (ZCeeMappingUtil.isHttpInputDesignator((MappingDesignator)input) && ZCeeMappingValidatorUtil.isDesignatorPassedThrough((MappingRoot)mappingRoot, (MappingDesignator)input)) {
            return false;
        }
        if (ZCeeMappingUtil.isJsonInputFieldDesignator((MappingDesignator)input) && ZCeeMappingValidatorUtil.isDesignatorPassedThrough((MappingRoot)mappingRoot, (MappingDesignator)output)) {
            return false;
        }
        if (this.isInputOrOutputDesignatorAlreadyMapped(mappingRoot, input, output)) {
            return false;
        }
        if (ZCeeMappingUtil.isJsonInputBodyNode((MappingDesignator)input)) {
            return false;
        }
        if (ZCeeMappingUtil.isJsonOutputBodyNode((MappingDesignator)output)) {
            return false;
        }
        if (primaryRefinement instanceof MoveRefinement && outputHasRemovedParent) {
            return false;
        }
        if (primaryRefinement instanceof MoveRefinement && (inputNullable || outputNullable)) {
            return false;
        }
        return this.isAllowedPrimaryRefinement(input, output, primaryRefinement);
    }

    private boolean isAllowedPrimaryRefinement(MappingDesignator input, MappingDesignator output, SemanticRefinement primaryRefinement) {
        boolean retVal = false;
        boolean hasInput = input != null;
        boolean hasOutput = output != null;
        boolean inputNullable = ZCeeMappingUtil.isNullable((MappingDesignator)input);
        int inputArrayDepth = ZCeeMappingUtil.getArrayDepth((MappingDesignator)input);
        boolean outputNullable = ZCeeMappingUtil.isNullable((MappingDesignator)output);
        boolean outputRepeats = ZCeeMappingUtil.isRepeating((MappingDesignator)output);
        int outputArrayDepth = ZCeeMappingUtil.getArrayDepth((MappingDesignator)output);
        boolean outputHasMappedDescendant = ZCeeMappingUtil.hasMappedDescendant((MappingDesignator)output);
        boolean outputHasRemovedParent = ZCeeMappingUtil.hasRemovedParent((MappingDesignator)output);
        if (hasInput && hasOutput) {
            if (primaryRefinement instanceof MoveRefinement && !inputNullable && !outputNullable && !outputHasRemovedParent && inputArrayDepth == outputArrayDepth) {
                retVal = true;
            }
        } else if (!hasInput && hasOutput) {
            if (primaryRefinement instanceof TaskRefinement) {
                retVal = true;
            } else if (primaryRefinement instanceof RemoveRefinement) {
                if (!outputHasMappedDescendant && !outputHasRemovedParent) {
                    retVal = true;
                }
            } else if (!(!ModelUtils.isAssignRefinement((SemanticRefinement)primaryRefinement) || outputNullable || outputHasMappedDescendant || outputHasRemovedParent || outputRepeats)) {
                retVal = true;
            }
        } else if (hasInput && !hasOutput && primaryRefinement instanceof TaskRefinement) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isAllowedPrimaryRefinement(Mapping existingMapping, SemanticRefinement primaryRefinement) {
        MappingDesignator input = (MappingDesignator)ListUtilz.getFirstMember((List)existingMapping.getInputs());
        MappingDesignator output = (MappingDesignator)ListUtilz.getFirstMember((List)existingMapping.getOutputs());
        return this.isAllowedPrimaryRefinement(input, output, primaryRefinement);
    }

    public boolean isAllowedSecondaryRefinement(Mapping existingMapping, SemanticRefinement secondaryRefinement) {
        return false;
    }

    public boolean isInputOrOutputDesignatorAlreadyMapped(MappingRoot mappingRoot, MappingDesignator inputDesignator, MappingDesignator outputDesignator) {
        boolean retVal = false;
        if (inputDesignator == null && outputDesignator == null) {
            return false;
        }
        ZCeeMappingAnalyzer mappingAnalyzer = new ZCeeMappingAnalyzer((MappingContainer)mappingRoot, this.typeHandler);
        mappingAnalyzer.populate();
        if (!retVal && inputDesignator != null) {
            retVal = mappingAnalyzer.isDesignatorInvolvedInAMapping(inputDesignator);
        }
        if (!retVal && outputDesignator != null) {
            retVal = mappingAnalyzer.isDesignatorInvolvedInAMapping(outputDesignator);
        }
        return retVal;
    }

    public List<IValidationProblem> validateMappingObject(EObject object, IValidationOptions options) {
        ArrayList<IValidationProblem> problems = new ArrayList<IValidationProblem>();
        if (object instanceof Mapping) {
            Mapping mapping = (Mapping)object;
            MappingRoot mappingRoot = ModelUtils.getMappingRoot((EObject)mapping);
            IFile mappingFile = EclipseResourceUtils.getMappingFile((MappingRoot)mappingRoot);
            try {
                MappingValidationProblem2.deleteFileMarkers((IPath)mappingFile.getLocation(), (Mapping)mapping);
            }
            catch (CoreException e) {
                ZCeeUILogger.warn((String)"failed to delete problem markers for mapping object {0}", (Throwable)e, (Object[])new Object[]{URIUtilz.getEObjectURI((EObject)mapping)});
            }
            ArrayList zCeeProblems = new ArrayList();
            if (ModelUtils.hasMoveRefinement((Mapping)mapping)) {
                ZCeeMappingValidatorUtil.validateMoveMapping((Mapping)mapping, (IResource)mappingFile, zCeeProblems);
            } else if (ModelUtils.hasAssignRefinement((Mapping)mapping)) {
                ZCeeMappingValidatorUtil.validateAssignMapping((Mapping)mapping, (IResource)mappingFile, zCeeProblems);
            } else if (ZCeeMappingUtil.hasRemoveRefinement((Mapping)mapping)) {
                ZCeeMappingValidatorUtil.validateRemoveMapping((Mapping)mapping, (IResource)mappingFile, zCeeProblems);
            }
            problems.addAll(zCeeProblems);
            for (IValidationProblem problem : problems) {
                try {
                    ((MappingValidationProblem2)problem).createMarker();
                }
                catch (CoreException e) {
                    ZCeeUILogger.warn((String)"failed to create problem marker for mapping object {0}", (Throwable)e, (Object[])new Object[]{URIUtilz.getEObjectURI((EObject)mapping)});
                }
            }
        }
        return problems;
    }
}

