/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.domain.environment;

import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.util.EclipseResourceUtils;
import com.ibm.msl.mapping.util.ModelUtils;
import com.ibm.msl.mapping.validators.IValidationOptions;
import com.ibm.msl.mapping.validators.IValidationProblem;
import com.ibm.msl.mapping.xml.validation.EclipseGDMValidationManager;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ArrayUtilz;
import com.ibm.zosconnect.ui.mapping.domain.ZCeeMappingDomain;
import com.ibm.zosconnect.ui.mapping.domain.util.ZCeeMappingValidator;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;

public class ZCeeMappingValidationManager
extends EclipseGDMValidationManager {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public List<IValidationProblem> validateMappingObject(EObject object, IValidationOptions options) {
        MappingRoot mappingRoot = ModelUtils.getMappingRoot((EObject)object);
        ZCeeMappingDomain domain = (ZCeeMappingDomain)ModelUtils.getMappingDomain((MappingRoot)mappingRoot);
        ZCeeMappingValidator validator = (ZCeeMappingValidator)domain.getMappingDomainValidator();
        List<IValidationProblem> problems = validator.validateMappingObject(object, options);
        try {
            this.cleanUpMappingMarkers(mappingRoot);
        }
        catch (CoreException e) {
            ZCeeUILogger.warn((String)"failed to clean up mapping markers", (Throwable)e, (Object[])new Object[0]);
        }
        return problems;
    }

    public void cleanUpMappingMarkers(MappingRoot mappingRoot) throws CoreException {
        IFile mappingFile = EclipseResourceUtils.getMappingFile((MappingRoot)mappingRoot);
        Object[] markers = mappingFile.findMarkers("com.ibm.msl.mapping.mappingProblem", true, 2);
        if (ArrayUtilz.isEmpty((Object[])markers)) {
            return;
        }
        List mappingObjectUris = ZCeeMappingUtil.getAllSupportedMappingObjectUris((MappingRoot)mappingRoot);
        Object[] objectArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            Object marker = objectArray[n2];
            String markerObjectUri = marker.getAttribute("objectId", "");
            if (!StringUtils.isBlank((CharSequence)markerObjectUri) && !mappingObjectUris.contains(markerObjectUri)) {
                marker.delete();
            }
            ++n2;
        }
    }
}

