/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.commands;

import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.api.domain.MappingDomain;
import com.ibm.msl.mapping.internal.ui.editpart.MappingIOEditPart;
import com.ibm.msl.mapping.internal.ui.model.MappingIOType;
import com.ibm.msl.mapping.node.EObjectNode;
import com.ibm.msl.mapping.node.INodeFactory;
import com.ibm.msl.mapping.ui.editor.AbstractMappingEditor;
import com.ibm.msl.mapping.xml.node.XMLNodeFactory;
import com.ibm.zosconnect.api.mapping.annotations.ArrayFormat;
import com.ibm.zosconnect.api.mapping.annotations.ZosConnectMappingAnnotations;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveType;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.mapping.domain.util.ParameterWrapper;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.util.XSDSchemaBuildingTools;

public class ParameterCommand
extends Command {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private XSDFactory xsdFactory = XSDSchemaBuildingTools.getXSDFactory();

    public ParameterCommand() {
    }

    public ParameterCommand(String label) {
        super(label);
    }

    protected EObject getRealModel(MappingIOEditPart ioEP) {
        EObjectNode eNode = this.getFacadeModel(ioEP);
        if (eNode == null) {
            return null;
        }
        return eNode.getObject();
    }

    protected EObjectNode getFacadeModel(MappingIOEditPart ioEP) {
        if (ioEP == null) {
            return null;
        }
        EObject obj = ((MappingIOType)ioEP.getModel()).getModel();
        if (obj instanceof EObjectNode) {
            return (EObjectNode)obj;
        }
        return null;
    }

    public INodeFactory getNodeFactory(MappingIOEditPart editPart) {
        MappingDomain domain;
        Object ioType;
        INodeFactory factory = null;
        if (editPart != null && (ioType = editPart.getModel()) instanceof MappingIOType && (domain = ((MappingIOType)ioType).getDomain()) != null) {
            factory = domain.getNodeFactory();
        }
        if (factory == null) {
            ZCeeUILogger.error((Throwable)new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + "getNodeFactory"));
            factory = new XMLNodeFactory();
        }
        return factory;
    }

    protected ISelection getSelection(AbstractMappingEditor editor) {
        return this.getWorkbenchWindow(editor).getSelectionService().getSelection();
    }

    protected IWorkbenchWindow getWorkbenchWindow(AbstractMappingEditor editor) {
        if (editor == null) {
            return null;
        }
        if (editor.getSite() == null) {
            return null;
        }
        return editor.getSite().getWorkbenchWindow();
    }

    protected List<MappingDesignator> getDesignators(List<MappingIOEditPart> editParts) {
        ArrayList<MappingDesignator> designators = new ArrayList<MappingDesignator>();
        for (MappingIOEditPart element : editParts) {
            MappingDesignator designator = ((MappingIOType)element.getModel()).getDesignator();
            if (designator == null) continue;
            designators.add(designator);
        }
        return designators;
    }

    protected List<MappingDesignator> getDesignators(MappingIOEditPart editPart) {
        return this.getDesignators(Arrays.asList(editPart));
    }

    public ParameterWrapper createChildParameter(XSDComplexTypeDefinition complexType, String parameterName, JsonSchemaPrimitiveType parameterType, boolean required, boolean array, ArrayFormat arrayFormat) {
        XSDParticleContent particleContent;
        ParameterWrapper childParameter = new ParameterWrapper();
        XSDModelGroup modelGroup = null;
        XSDComplexTypeContent complexTypeContent = complexType.getContent();
        if (complexTypeContent instanceof XSDParticle && (particleContent = ((XSDParticle)complexTypeContent).getContent()) instanceof XSDModelGroup) {
            modelGroup = (XSDModelGroup)particleContent;
        }
        if (modelGroup == null) {
            XSDParticle particle = this.xsdFactory.createXSDParticle();
            modelGroup = this.xsdFactory.createXSDModelGroup();
            modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
            particle.setContent((XSDParticleContent)modelGroup);
            complexType.setContent((XSDComplexTypeContent)particle);
        }
        childParameter.setModelGroup(modelGroup);
        XSDElementDeclaration newElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        EList particles = modelGroup.getContents();
        HashSet<String> namesInUse = new HashSet<String>(particles.size());
        Iterator iter = particles.iterator();
        while (iter.hasNext()) {
            XSDParticleContent cont = ((XSDParticle)iter.next()).getContent();
            if (!(cont instanceof XSDElementDeclaration)) continue;
            namesInUse.add(((XSDElementDeclaration)cont).getName());
        }
        String elemName = this.ensureUniqueName(namesInUse, parameterName);
        newElement.setName(elemName);
        ZCeeMappingUtil.setXsdSimpleTypeFromJsonPrimitiveType((XSDElementDeclaration)newElement, (JsonSchemaPrimitiveType)parameterType);
        childParameter.setElement(newElement);
        childParameter.setType(newElement.getType());
        XSDParticle addedElementParticle = XSDFactory.eINSTANCE.createXSDParticle();
        addedElementParticle.setContent((XSDParticleContent)newElement);
        if (required) {
            addedElementParticle.setMinOccurs(1);
        } else {
            addedElementParticle.setMinOccurs(0);
        }
        if (array) {
            addedElementParticle.setMaxOccurs(-1);
        } else {
            addedElementParticle.setMaxOccurs(1);
        }
        childParameter.setParticle(addedElementParticle);
        modelGroup.getContents().add((Object)addedElementParticle);
        childParameter.setModelGroupIndex(modelGroup.getContents().indexOf((Object)addedElementParticle));
        if (array) {
            ZosConnectXsdUtil.setAppInfoAttVal((XSDElementDeclaration)newElement, (String)ZosConnectMappingAnnotations.ARRAY_FORMAT.value(), (String)arrayFormat.value(), (String)"http://www.ibm.com/zosConnect/2.0/mapping/TypeInfo");
        }
        return childParameter;
    }

    public String ensureUniqueName(Collection<String> namesInUse, String baseName) {
        int i = 1;
        Object testName = baseName;
        while (namesInUse.contains(testName)) {
            testName = baseName + i++;
        }
        return testName;
    }
}

