/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.commands;

import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.internal.ui.editor.MappingEditor;
import com.ibm.msl.mapping.internal.ui.editpart.MappingIOEditPart;
import com.ibm.msl.mapping.internal.ui.model.MappingIOType;
import com.ibm.msl.mapping.node.DataContentNode;
import com.ibm.msl.mapping.node.EObjectNode;
import com.ibm.msl.mapping.ui.editor.AbstractMappingEditor;
import com.ibm.msl.mapping.xml.node.XMLDataContentNode;
import com.ibm.msl.mapping.xml.node.XMLModelGroupNode;
import com.ibm.msl.mapping.xml.node.XMLTypeNode;
import com.ibm.msl.mapping.xml.ui.utils.UserDefinedItemUIHelper;
import com.ibm.zosconnect.ui.mapping.actions.MoveUpParameterActionDelegate;
import com.ibm.zosconnect.ui.mapping.commands.ParameterCommand;
import com.ibm.zosconnect.ui.mapping.domain.util.ParameterWrapper;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;

public class MoveUpParameterCommand
extends ParameterCommand {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AbstractMappingEditor abstractMappingEditor;
    private MappingIOEditPart mappingIOEditPart;
    private MoveUpParameterActionDelegate actionDelegate;

    public MoveUpParameterCommand(AbstractMappingEditor abstractMappingEditor, MappingIOEditPart mappingIOEditPart, MoveUpParameterActionDelegate actionDelegate) {
        super(actionDelegate.getActionName());
        this.abstractMappingEditor = abstractMappingEditor;
        this.mappingIOEditPart = mappingIOEditPart;
        this.actionDelegate = actionDelegate;
    }

    private MoveUpParameterCommand() {
    }

    private MoveUpParameterCommand(String label) {
        super(label);
    }

    public boolean canExecute() {
        boolean retVal = false;
        if (this.abstractMappingEditor != null && this.mappingIOEditPart != null) {
            retVal = true;
        }
        return retVal;
    }

    public void execute() {
        this.doMoveUpElement(this.mappingIOEditPart);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((MappingEditor)MoveUpParameterCommand.this.abstractMappingEditor).refreshEditorViews();
            }
        });
    }

    private void doMoveUpElement(MappingIOEditPart mappingIOEditPart) {
        XSDElementDeclaration selectedXsdEle = (XSDElementDeclaration)this.getRealModel(mappingIOEditPart);
        XSDParticle selXsdPart = (XSDParticle)selectedXsdEle.getContainer();
        XSDModelGroup selXsdGroup = (XSDModelGroup)selXsdPart.eContainer();
        EList selXsdGroupParts = selXsdGroup.getContents();
        int selXsdPartIndex = selXsdGroupParts.indexOf((Object)selXsdPart);
        ECollections.move((List)selXsdGroupParts, (int)(selXsdPartIndex - 1), (Object)selXsdPart);
        MappingIOType selMappingIoType = (MappingIOType)mappingIOEditPart.getModel();
        XMLDataContentNode selXmlDataContentNode = (XMLDataContentNode)selMappingIoType.getModel();
        XMLModelGroupNode selXmlGroupNode = (XMLModelGroupNode)selXmlDataContentNode.getParent();
        XMLTypeNode selXmlTypeNode = (XMLTypeNode)selXmlGroupNode.getParent();
        List selGroupContent = selXmlTypeNode.getDataContent();
        int selXmlTypeIndex = selXmlTypeNode.getDataContent().indexOf(selXmlDataContentNode);
        Collections.swap(selGroupContent, selXmlTypeIndex, selXmlTypeIndex - 1);
    }

    public boolean canUndo() {
        return false;
    }

    public void undo() {
    }

    public void undoMoveParameter(ParameterWrapper deletedParameter) {
        int insertIndex;
        XSDModelGroup modelGroup = deletedParameter.getModelGroup();
        XSDParticle particle = deletedParameter.getParticle();
        XMLModelGroupNode modelGroupNode = deletedParameter.getModelGroupNode();
        XMLTypeNode typeNode = deletedParameter.getTypeNode();
        XMLDataContentNode contentNode = deletedParameter.getContentNode();
        int modelGroupIndex = deletedParameter.getModelGroupIndex();
        int typeNodeIndex = deletedParameter.getTypeNodeIndex();
        if (modelGroup != null && particle != null) {
            EList modelGroupContents = modelGroup.getContents();
            insertIndex = modelGroupContents.isEmpty() ? 0 : modelGroupContents.size();
            insertIndex = Math.min(modelGroupIndex, insertIndex);
            modelGroupContents.add(insertIndex, particle);
        }
        if (modelGroupNode != null && contentNode != null) {
            List modelGroupNodeContent = modelGroupNode.getContent();
            insertIndex = modelGroupNodeContent.isEmpty() ? 0 : modelGroupNodeContent.size();
            insertIndex = Math.min(modelGroupIndex, insertIndex);
            modelGroupNodeContent.add(insertIndex, contentNode);
        }
        if (contentNode != null) {
            contentNode.setParent((EObjectNode)modelGroupNode);
        }
        if (typeNode != null && contentNode != null) {
            List typeNodeDataContent = typeNode.getDataContent();
            insertIndex = typeNodeDataContent.isEmpty() ? 0 : typeNodeDataContent.size();
            insertIndex = Math.min(typeNodeIndex, insertIndex);
            typeNodeDataContent.add(insertIndex, contentNode);
        }
        for (MappingDesignator designator : deletedParameter.getMapped()) {
            designator.setObject((EObject)contentNode);
        }
        UserDefinedItemUIHelper.refreshUserDefinedEditPart((DataContentNode)contentNode);
    }
}

