/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.commands;

import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.internal.ui.editor.MappingEditor;
import com.ibm.msl.mapping.internal.ui.editpart.MappingIOEditPart;
import com.ibm.msl.mapping.internal.ui.model.MappingIOType;
import com.ibm.msl.mapping.node.DataContentNode;
import com.ibm.msl.mapping.ui.editor.AbstractMappingEditor;
import com.ibm.msl.mapping.xml.node.XMLDataContentNode;
import com.ibm.msl.mapping.xml.ui.utils.UserDefinedItemUIHelper;
import com.ibm.zosconnect.api.mapping.annotations.ArrayFormat;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveType;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.mapping.actions.EditParameterActionDelegate;
import com.ibm.zosconnect.ui.mapping.actions.ParameterActionModel;
import com.ibm.zosconnect.ui.mapping.commands.ParameterCommand;
import com.ibm.zosconnect.ui.mapping.domain.util.ParameterWrapper;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;

public class EditParameterCommand
extends ParameterCommand {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AbstractMappingEditor abstractMappingEditor;
    private MappingIOEditPart mappingIOEditPart;
    private ParameterActionModel actionModel;
    private ParameterWrapper editedParameter;

    public EditParameterCommand(AbstractMappingEditor abstractMappingEditor, MappingIOEditPart mappingIOEditPart, EditParameterActionDelegate actionDelegate, ParameterActionModel actionModel) {
        super(actionDelegate.getActionName());
        this.abstractMappingEditor = abstractMappingEditor;
        this.mappingIOEditPart = mappingIOEditPart;
        this.actionModel = actionModel;
    }

    private EditParameterCommand() {
    }

    private EditParameterCommand(String label) {
        super(label);
    }

    public boolean canExecute() {
        boolean retVal = false;
        if (this.abstractMappingEditor != null && this.mappingIOEditPart != null) {
            retVal = true;
        }
        return retVal;
    }

    public void execute() {
        this.doEditParameter();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((MappingEditor)EditParameterCommand.this.abstractMappingEditor).refreshEditorViews();
            }
        });
    }

    private void doEditParameter() {
        this.editedParameter = new ParameterWrapper();
        XSDElementDeclaration selectedEle = (XSDElementDeclaration)this.getRealModel(this.mappingIOEditPart);
        this.editedParameter.setElement(selectedEle);
        this.editedParameter.setElementName(selectedEle.getName());
        selectedEle.setName(this.actionModel.getParameterName());
        XSDParticle selectedElePart = null;
        if (selectedEle.eContainer() instanceof XSDParticle) {
            selectedElePart = (XSDParticle)selectedEle.eContainer();
            this.editedParameter.setParticle(selectedElePart);
            this.editedParameter.setMinOccurs(selectedElePart.getMinOccurs());
            this.editedParameter.setMaxOccurs(selectedElePart.getMaxOccurs());
            this.editedParameter.setType(selectedEle.getType());
            this.editedParameter.setJsonType(OpenApi2xUtil.getJsonPrimitiveTypeFromXsdSimpleType((XSDElementDeclaration)selectedEle));
            this.editedParameter.setArrayFormat(ZosConnectXsdUtil.getArrayFormatAppInfo((XSDElementDeclaration)selectedEle));
            if (this.actionModel.isRequired()) {
                selectedElePart.setMinOccurs(1);
            } else {
                selectedElePart.setMinOccurs(0);
            }
            if (this.actionModel.isArray()) {
                selectedElePart.setMaxOccurs(-1);
            } else {
                selectedElePart.setMaxOccurs(1);
            }
            ZCeeMappingUtil.setXsdSimpleTypeFromJsonPrimitiveType((XSDElementDeclaration)selectedEle, (JsonSchemaPrimitiveType)this.actionModel.getParameterType());
            ZosConnectXsdUtil.setArrayFormatAppInfo((XSDElementDeclaration)selectedEle, (ArrayFormat)this.actionModel.getArrayFormat());
        }
        MappingIOType ioEditPartType = (MappingIOType)this.mappingIOEditPart.getModel();
        XMLDataContentNode ioEditPartContentNode = (XMLDataContentNode)ioEditPartType.getModel();
        ioEditPartContentNode.setDisplayName(this.actionModel.getParameterName());
        if (this.actionModel.isRequired()) {
            ioEditPartContentNode.setMinOccurs(1);
        } else {
            ioEditPartContentNode.setMinOccurs(0);
        }
        if (this.actionModel.isArray()) {
            ioEditPartContentNode.setMaxOccurs(-1);
        } else {
            ioEditPartContentNode.setMaxOccurs(1);
        }
        this.editedParameter.setContentNode(ioEditPartContentNode);
        this.editedParameter.setTypeNode(ioEditPartContentNode.getXSDType());
        ZCeeMappingUtil.setXmlTypeFromJsonPrimitiveType((XMLDataContentNode)ioEditPartContentNode, (JsonSchemaPrimitiveType)this.actionModel.getParameterType());
        List<MappingDesignator> selectedDesignators = this.getDesignators(this.mappingIOEditPart);
        if (ListUtilz.notEmpty(selectedDesignators)) {
            MappingDesignator selectedDesignator = (MappingDesignator)ListUtilz.getFirstMember(selectedDesignators);
            ZCeeMappingUtil.updateMappingAnnotations((MappingDesignator)selectedDesignator);
        }
        UserDefinedItemUIHelper.refreshUserDefinedEditPart((DataContentNode)ioEditPartContentNode);
    }

    public boolean canUndo() {
        boolean retVal = false;
        if (this.editedParameter != null) {
            retVal = true;
        }
        return retVal;
    }

    public void undo() {
        this.undoEditParameter();
        this.abstractMappingEditor.refreshEditorViews();
    }

    private void undoEditParameter() {
        XSDElementDeclaration element = this.editedParameter.getElement();
        element.setName(this.editedParameter.getElementName());
        XSDParticle particle = this.editedParameter.getParticle();
        XMLDataContentNode contentNode = this.editedParameter.getContentNode();
        particle.setMinOccurs(this.editedParameter.getMinOccurs());
        particle.setMaxOccurs(this.editedParameter.getMaxOccurs());
        ZCeeMappingUtil.setXsdSimpleTypeFromJsonPrimitiveType((XSDElementDeclaration)element, (JsonSchemaPrimitiveType)this.editedParameter.getJsonType());
        ZosConnectXsdUtil.setArrayFormatAppInfo((XSDElementDeclaration)element, (ArrayFormat)this.editedParameter.getArrayFormat());
        contentNode.setDisplayName(this.editedParameter.getElementName());
        contentNode.setMinOccurs(this.editedParameter.getMinOccurs());
        contentNode.setMaxOccurs(this.editedParameter.getMaxOccurs());
        ZCeeMappingUtil.setXmlTypeFromJsonPrimitiveType((XMLDataContentNode)contentNode, (JsonSchemaPrimitiveType)this.editedParameter.getJsonType());
        List<MappingDesignator> selectedDesignators = this.getDesignators(this.mappingIOEditPart);
        if (ListUtilz.notEmpty(selectedDesignators)) {
            MappingDesignator selectedDesignator = (MappingDesignator)ListUtilz.getFirstMember(selectedDesignators);
            ZCeeMappingUtil.updateMappingAnnotations((MappingDesignator)selectedDesignator);
        }
        this.editedParameter = null;
        UserDefinedItemUIHelper.refreshUserDefinedEditPart((DataContentNode)contentNode);
    }
}

