/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.commands;

import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.internal.ui.editor.MappingEditor;
import com.ibm.msl.mapping.internal.ui.editpart.MappingIOEditPart;
import com.ibm.msl.mapping.internal.ui.model.MappingIOType;
import com.ibm.msl.mapping.internal.ui.model.connections.MappingConnectionType;
import com.ibm.msl.mapping.node.DataContentNode;
import com.ibm.msl.mapping.node.EObjectNode;
import com.ibm.msl.mapping.ui.editor.AbstractMappingEditor;
import com.ibm.msl.mapping.util.ModelUtils;
import com.ibm.msl.mapping.xml.node.XMLDataContentNode;
import com.ibm.msl.mapping.xml.node.XMLModelGroupNode;
import com.ibm.msl.mapping.xml.node.XMLTypeNode;
import com.ibm.msl.mapping.xml.ui.utils.UserDefinedItemUIHelper;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.mapping.actions.DeleteParameterActionDelegate;
import com.ibm.zosconnect.ui.mapping.commands.ParameterCommand;
import com.ibm.zosconnect.ui.mapping.domain.util.ParameterWrapper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;

public class DeleteParameterCommand
extends ParameterCommand {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AbstractMappingEditor abstractMappingEditor;
    private List<MappingIOEditPart> mappingIOEditParts;
    private List<ParameterWrapper> deletedParameters;
    private DeleteParameterActionDelegate actionDelegate;

    public DeleteParameterCommand(AbstractMappingEditor abstractMappingEditor, List<MappingIOEditPart> mappingIOEditParts, DeleteParameterActionDelegate actionDelegate) {
        super(actionDelegate.getActionName());
        this.abstractMappingEditor = abstractMappingEditor;
        this.mappingIOEditParts = mappingIOEditParts;
        this.actionDelegate = actionDelegate;
        this.deletedParameters = new ArrayList<ParameterWrapper>();
    }

    private DeleteParameterCommand() {
    }

    private DeleteParameterCommand(String label) {
        super(label);
    }

    public boolean canExecute() {
        boolean retVal = false;
        if (this.abstractMappingEditor != null && ListUtilz.notEmpty(this.mappingIOEditParts)) {
            retVal = true;
        }
        return retVal;
    }

    public void execute() {
        for (MappingIOEditPart mappingIOEditPart : this.mappingIOEditParts) {
            this.doDeleteElement(mappingIOEditPart);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((MappingEditor)DeleteParameterCommand.this.abstractMappingEditor).refreshEditorViews();
            }
        });
    }

    private void doDeleteElement(MappingIOEditPart mappingIOEditPart) {
        ParameterWrapper deletedParameter = new ParameterWrapper();
        XSDElementDeclaration selectedEle = (XSDElementDeclaration)this.getRealModel(mappingIOEditPart);
        XSDParticle selectedElePart = null;
        XSDModelGroup selectedGroup = null;
        int selectedGroupIndex = 0;
        int selectedTypeIndex = 0;
        if (selectedEle.eContainer() instanceof XSDParticle && (selectedElePart = (XSDParticle)selectedEle.eContainer()).eContainer() instanceof XSDModelGroup) {
            selectedGroup = (XSDModelGroup)selectedElePart.eContainer();
            selectedGroupIndex = selectedGroup.getContents().indexOf((Object)selectedElePart);
            selectedGroup.getContents().remove((Object)selectedElePart);
        }
        deletedParameter.setElement(selectedEle);
        deletedParameter.setParticle(selectedElePart);
        deletedParameter.setModelGroup(selectedGroup);
        deletedParameter.setModelGroupIndex(selectedGroupIndex);
        deletedParameter.setType(selectedEle.getType());
        MappingIOType ioEditPartType = (MappingIOType)mappingIOEditPart.getModel();
        XMLDataContentNode ioEditPartContentNode = (XMLDataContentNode)ioEditPartType.getModel();
        XMLModelGroupNode ioEditPartGroupNode = (XMLModelGroupNode)ioEditPartContentNode.getParent();
        XMLTypeNode ioEditPartGroupTypeNode = (XMLTypeNode)ioEditPartGroupNode.getParent();
        selectedTypeIndex = ioEditPartGroupTypeNode.getDataContent().indexOf(ioEditPartContentNode);
        ioEditPartGroupTypeNode.getDataContent().remove(ioEditPartContentNode);
        deletedParameter.setContentNode(ioEditPartContentNode);
        deletedParameter.setModelGroupNode(ioEditPartGroupNode);
        deletedParameter.setTypeNode(ioEditPartGroupTypeNode);
        deletedParameter.setTypeNodeIndex(selectedTypeIndex);
        MappingIOType mappingIOType = (MappingIOType)mappingIOEditPart.getModel();
        if (mappingIOType != null) {
            MappingDesignator designator;
            for (MappingConnectionType connection : mappingIOType.getSourceConnections()) {
                designator = connection.getMappingModel();
                if (designator == null || designator.getObject() != ioEditPartContentNode) continue;
                designator.setRefName(ModelUtils.getRefName((MappingDesignator)designator));
                deletedParameter.getMapped().add(designator);
                designator.setObject(null);
                break;
            }
            for (MappingConnectionType connection : mappingIOType.getTargetConnections()) {
                designator = connection.getMappingModel();
                if (designator == null || designator.getObject() != ioEditPartContentNode) continue;
                designator.setRefName(ModelUtils.getRefName((MappingDesignator)designator));
                deletedParameter.getMapped().add(designator);
                designator.setObject(null);
                break;
            }
        }
        this.deletedParameters.add(deletedParameter);
    }

    public boolean canUndo() {
        boolean retVal = false;
        if (ListUtilz.notEmpty(this.deletedParameters)) {
            retVal = true;
        }
        return retVal;
    }

    public void undo() {
        ArrayList<ParameterWrapper> deletedOK = new ArrayList<ParameterWrapper>();
        for (ParameterWrapper deletedElement : this.deletedParameters) {
            this.undoDeleteParameter(deletedElement);
            deletedOK.add(deletedElement);
        }
        this.deletedParameters.removeAll(deletedOK);
        ((MappingEditor)this.abstractMappingEditor).refreshEditorViews();
    }

    public void undoDeleteParameter(ParameterWrapper deletedParameter) {
        int insertIndex;
        XSDModelGroup modelGroup = deletedParameter.getModelGroup();
        XSDParticle particle = deletedParameter.getParticle();
        XMLModelGroupNode modelGroupNode = deletedParameter.getModelGroupNode();
        XMLTypeNode typeNode = deletedParameter.getTypeNode();
        XMLDataContentNode contentNode = deletedParameter.getContentNode();
        int modelGroupIndex = deletedParameter.getModelGroupIndex();
        int typeNodeIndex = deletedParameter.getTypeNodeIndex();
        if (modelGroup != null && particle != null) {
            EList modelGroupContents = modelGroup.getContents();
            insertIndex = modelGroupContents.isEmpty() ? 0 : modelGroupContents.size();
            insertIndex = Math.min(modelGroupIndex, insertIndex);
            modelGroupContents.add(insertIndex, particle);
        }
        if (modelGroupNode != null && contentNode != null) {
            List modelGroupNodeContent = modelGroupNode.getContent();
            insertIndex = modelGroupNodeContent.isEmpty() ? 0 : modelGroupNodeContent.size();
            insertIndex = Math.min(modelGroupIndex, insertIndex);
            modelGroupNodeContent.add(insertIndex, contentNode);
        }
        if (contentNode != null) {
            contentNode.setParent((EObjectNode)modelGroupNode);
        }
        if (typeNode != null && contentNode != null) {
            List typeNodeDataContent = typeNode.getDataContent();
            insertIndex = typeNodeDataContent.isEmpty() ? 0 : typeNodeDataContent.size();
            insertIndex = Math.min(typeNodeIndex, insertIndex);
            typeNodeDataContent.add(insertIndex, contentNode);
        }
        for (MappingDesignator designator : deletedParameter.getMapped()) {
            designator.setObject((EObject)contentNode);
        }
        UserDefinedItemUIHelper.refreshUserDefinedEditPart((DataContentNode)contentNode);
    }
}

