/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.commands;

import com.ibm.msl.mapping.internal.ui.editor.MappingEditor;
import com.ibm.msl.mapping.internal.ui.editpart.MappingIOEditPart;
import com.ibm.msl.mapping.internal.ui.model.MappingIOType;
import com.ibm.msl.mapping.node.DataContentNode;
import com.ibm.msl.mapping.node.EObjectNode;
import com.ibm.msl.mapping.node.INodeFactory;
import com.ibm.msl.mapping.ui.editor.AbstractMappingEditor;
import com.ibm.msl.mapping.xml.node.XMLDataContentNode;
import com.ibm.msl.mapping.xml.node.XMLModelGroupNode;
import com.ibm.msl.mapping.xml.node.XMLTypeNode;
import com.ibm.msl.mapping.xml.ui.utils.UserDefinedItemUIHelper;
import com.ibm.zosconnect.ui.mapping.actions.AddParameterActionDelegate;
import com.ibm.zosconnect.ui.mapping.actions.ParameterActionModel;
import com.ibm.zosconnect.ui.mapping.commands.ParameterCommand;
import com.ibm.zosconnect.ui.mapping.domain.util.ParameterWrapper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;

public class AddParameterCommand
extends ParameterCommand {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AbstractMappingEditor abstractMappingEditor;
    private MappingIOEditPart mappingIOEditPart;
    private ParameterActionModel actionModel;
    private ParameterWrapper addedParameter;

    public AddParameterCommand(AbstractMappingEditor abstractMappingEditor, MappingIOEditPart mappingIOEditPart, AddParameterActionDelegate actionDelegate, ParameterActionModel actionModel) {
        super(actionDelegate.getActionName());
        this.abstractMappingEditor = abstractMappingEditor;
        this.mappingIOEditPart = mappingIOEditPart;
        this.actionModel = actionModel;
    }

    private AddParameterCommand() {
    }

    private AddParameterCommand(String label) {
        super(label);
    }

    public boolean canExecute() {
        boolean retVal = false;
        if (this.mappingIOEditPart != null && this.abstractMappingEditor != null) {
            retVal = true;
        }
        return retVal;
    }

    public void execute() {
        this.doAddParameter();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((MappingEditor)AddParameterCommand.this.abstractMappingEditor).refreshEditorViews();
            }
        });
    }

    private void doAddParameter() {
        XSDElementDeclaration selectedEle = (XSDElementDeclaration)this.getRealModel(this.mappingIOEditPart);
        XSDComplexTypeDefinition compType = (XSDComplexTypeDefinition)selectedEle.getType();
        this.addedParameter = this.createChildParameter(compType, this.actionModel.getParameterName(), this.actionModel.getParameterType(), this.actionModel.isRequired(), this.actionModel.isArray(), this.actionModel.getArrayFormat());
        MappingIOType ioEditPartType = (MappingIOType)this.mappingIOEditPart.getModel();
        XMLDataContentNode ioEditPartContentNode = (XMLDataContentNode)ioEditPartType.getModel();
        XMLTypeNode ioEditPartContentTypeNode = (XMLTypeNode)ioEditPartContentNode.getType();
        XMLModelGroupNode ioEditPartGroupNode = (XMLModelGroupNode)ioEditPartContentNode.getContent().get(0);
        this.addedParameter.setTypeNode(ioEditPartContentTypeNode);
        this.addedParameter.setModelGroupNode(ioEditPartGroupNode);
        INodeFactory factory = this.getNodeFactory(this.mappingIOEditPart);
        DataContentNode addedNode = factory.createDataContentNode((EObject)this.addedParameter.getElement(), 5);
        if (this.actionModel.isRequired()) {
            addedNode.setMinOccurs(1);
            addedNode.setRequired(true);
        } else {
            addedNode.setMinOccurs(0);
            addedNode.setRequired(false);
        }
        if (this.actionModel.isArray()) {
            addedNode.setMaxOccurs(-1);
        } else {
            addedNode.setMaxOccurs(1);
        }
        addedNode.setRepeatable(false);
        this.addedParameter.setContentNode((XMLDataContentNode)addedNode);
        ioEditPartGroupNode.getContent().add(ioEditPartContentNode);
        addedNode.setParent((EObjectNode)ioEditPartGroupNode);
        ioEditPartContentTypeNode.getDataContent().add(addedNode);
        UserDefinedItemUIHelper.refreshUserDefinedEditPart((DataContentNode)addedNode);
    }

    public boolean canUndo() {
        boolean retVal = false;
        if (this.addedParameter != null) {
            retVal = true;
        }
        return retVal;
    }

    public void undo() {
        this.undoAddParameter();
        this.abstractMappingEditor.refreshEditorViews();
    }

    private void undoAddParameter() {
        XSDModelGroup modelGroup = this.addedParameter.getModelGroup();
        XSDParticle particle = this.addedParameter.getParticle();
        XMLModelGroupNode modelGroupNode = this.addedParameter.getModelGroupNode();
        XMLTypeNode typeNode = this.addedParameter.getTypeNode();
        XMLDataContentNode contentNode = this.addedParameter.getContentNode();
        if (modelGroup != null && particle != null) {
            modelGroup.getContents().remove((Object)particle);
        }
        if (modelGroup != null && contentNode != null) {
            modelGroupNode.getContent().remove(contentNode);
        }
        if (typeNode != null && contentNode != null) {
            typeNode.getDataContent().remove(contentNode);
        }
        if (contentNode != null) {
            contentNode.setParent(null);
        }
        this.addedParameter = null;
    }
}

