/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.actions.overrides;

import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.api.validation.MappingValidationManager;
import com.ibm.msl.mapping.internal.ui.editpart.MappingIOEditPart;
import com.ibm.msl.mapping.internal.ui.model.MappingIOType;
import com.ibm.msl.mapping.node.EObjectNode;
import com.ibm.msl.mapping.xml.ui.actions.DeleteActionDelegate;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.mapping.domain.environment.ZCeeMappingValidationManager;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public class DeleteActionOverrideDelegate
extends DeleteActionDelegate {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<String> httpContextTags = new ArrayList<String>();
    private List<String> httpContextTypes;

    public DeleteActionOverrideDelegate() {
        this.httpContextTags.add("Headers");
        this.httpContextTags.add("QueryParameters");
        this.httpContextTags.add("PathParameters");
        this.httpContextTags.add("Body");
        this.httpContextTags.add("HTTPRequest");
        this.httpContextTypes = new ArrayList<String>();
        this.httpContextTypes.add("HeadersType");
        this.httpContextTypes.add("QueryParametersType");
        this.httpContextTypes.add("PathParametersType");
        this.httpContextTypes.add("BodyType");
        this.httpContextTypes.add("HTTPRequestType");
    }

    public void run() {
        super.run();
        MappingRoot mappingRoot = this.getEditor().getMappingRoot();
        MappingValidationManager validationManager = ZCeeMappingUtil.getMappingValidationManager((MappingRoot)mappingRoot);
        if (validationManager instanceof ZCeeMappingValidationManager) {
            try {
                ((ZCeeMappingValidationManager)validationManager).cleanUpMappingMarkers(mappingRoot);
            }
            catch (CoreException e) {
                ZCeeUILogger.warn((String)"failed to clean up mapping markers", (Throwable)e, (Object[])new Object[0]);
            }
        }
    }

    public boolean isEnabled() {
        boolean retVal = super.isEnabled();
        if (retVal) {
            if (this.isHttpContextSection()) {
                retVal = false;
            } else if (this.isHttpContextElement()) {
                retVal = false;
            } else if (ZosConnectXsdUtil.hasJsonInputTns((XSDElementDeclaration)this.getElementOfSelectedIoEditPart())) {
                retVal = false;
            } else if (ZosConnectXsdUtil.hasJsonOutputTns((XSDElementDeclaration)this.getElementOfSelectedIoEditPart())) {
                retVal = false;
            }
        }
        return retVal;
    }

    private boolean isHttpContextSection() {
        EObject parentRealModel;
        boolean retVal = false;
        MappingIOEditPart selectedIOEditPart = this.getSelectedIOEditPart();
        if (selectedIOEditPart != null && (parentRealModel = this.getRealModel(selectedIOEditPart)) instanceof XSDElementDeclaration) {
            XSDComplexTypeDefinition xsdEleCompType;
            XSDTypeDefinition xsdEleType;
            XSDElementDeclaration xsdEle = (XSDElementDeclaration)parentRealModel;
            if (this.httpContextTags.contains((xsdEle = xsdEle.getResolvedElementDeclaration()).getName()) && (xsdEleType = xsdEle.getTypeDefinition()) instanceof XSDComplexTypeDefinition && this.httpContextTypes.contains((xsdEleCompType = (XSDComplexTypeDefinition)xsdEleType).getName())) {
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean isHttpContextElement() {
        MappingIOEditPart parentIOEditPart;
        EObject parentRealModel;
        boolean retVal = false;
        MappingIOEditPart selectedIOEditPart = this.getSelectedIOEditPart();
        if (selectedIOEditPart != null && selectedIOEditPart.getParent() instanceof MappingIOEditPart && (parentRealModel = this.getRealModel(parentIOEditPart = (MappingIOEditPart)selectedIOEditPart.getParent())) instanceof XSDElementDeclaration) {
            XSDComplexTypeDefinition xsdEleCompType;
            XSDTypeDefinition xsdEleType;
            XSDElementDeclaration xsdEle = (XSDElementDeclaration)parentRealModel;
            if (this.httpContextTags.contains((xsdEle = xsdEle.getResolvedElementDeclaration()).getName()) && (xsdEleType = xsdEle.getTypeDefinition()) instanceof XSDComplexTypeDefinition && this.httpContextTypes.contains((xsdEleCompType = (XSDComplexTypeDefinition)xsdEleType).getName())) {
                retVal = true;
            }
        }
        return retVal;
    }

    protected MappingIOEditPart getSelectedIOEditPart() {
        IStructuredSelection selection;
        if (this.getSelection() instanceof IStructuredSelection && !(selection = (IStructuredSelection)this.getSelection()).isEmpty() && selection.getFirstElement() instanceof MappingIOEditPart) {
            return (MappingIOEditPart)selection.getFirstElement();
        }
        return null;
    }

    protected EObject getRealModel(MappingIOEditPart mappingIOEditPart) {
        EObjectNode eNode = this.getFacadeModel(mappingIOEditPart);
        if (eNode == null) {
            return null;
        }
        return eNode.getObject();
    }

    protected EObjectNode getFacadeModel(MappingIOEditPart mappingIOEditPart) {
        if (mappingIOEditPart == null) {
            return null;
        }
        EObject obj = ((MappingIOType)mappingIOEditPart.getModel()).getModel();
        if (obj instanceof EObjectNode) {
            return (EObjectNode)obj;
        }
        return null;
    }

    protected XSDElementDeclaration getElementOfSelectedIoEditPart() {
        EObject realModel;
        XSDElementDeclaration retVal = null;
        MappingIOEditPart selectedIOEditPart = this.getSelectedIOEditPart();
        if (selectedIOEditPart != null && (realModel = this.getRealModel(selectedIOEditPart)) instanceof XSDElementDeclaration) {
            retVal = (XSDElementDeclaration)realModel;
            retVal = retVal.getResolvedElementDeclaration();
        }
        return retVal;
    }
}

