/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.actions.impl;

import com.ibm.msl.mapping.Mapping;
import com.ibm.msl.mapping.MappingDesignator;
import com.ibm.msl.mapping.MappingRoot;
import com.ibm.msl.mapping.api.validation.MappingValidator;
import com.ibm.msl.mapping.internal.ui.editpart.MappingIOEditPart;
import com.ibm.msl.mapping.internal.ui.editpart.TransformEditPart;
import com.ibm.msl.mapping.internal.ui.editpart.connections.MappingConnectionEditPart;
import com.ibm.msl.mapping.internal.ui.utils.PassthroughUIUtils;
import com.ibm.msl.mapping.ui.commands.CommandData;
import com.ibm.msl.mapping.ui.editor.AbstractMappingEditor;
import com.ibm.msl.mapping.util.ModelUtils;
import com.ibm.msl.mapping.xml.ui.actions.MapAssignActionDelegate;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.mapping.commands.CustomCreateTransformCommand;
import com.ibm.zosconnect.ui.mapping.domain.util.ZCeeMappingValidator;
import com.ibm.zosconnect.ui.mapping.util.ZCeeDesignatorGroup;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingAnnotator;
import com.ibm.zosconnect.ui.mapping.util.ZCeeMappingUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ZCeeMapAssignActionDelegate
extends MapAssignActionDelegate {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected Command getCommand() {
        CompoundCommand cmdSet = new CompoundCommand();
        super.getCommand();
        List outputs = new ArrayList();
        if (this.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            outputs = this.getOutputDesignators(selection);
        }
        Mapping parentMapping = this.getEditor().getCurrentMap();
        Mapping passthroughMapping = PassthroughUIUtils.getPassthroughMapping(outputs);
        if (passthroughMapping != null) {
            parentMapping = passthroughMapping;
        }
        for (MappingDesignator output : outputs) {
            ZCeeMappingAnnotator.applyInlineXsdAnnotations((MappingDesignator)output);
            if (!ZCeeMappingAnnotator.isSetOmitFromIterface((MappingDesignator)output)) {
                ZCeeMappingAnnotator.setOmitFromIterface((MappingDesignator)output, (boolean)true);
            }
            ArrayList<MappingDesignator> outputList = new ArrayList<MappingDesignator>();
            outputList.add(output);
            cmdSet.add((Command)new CustomCreateTransformCommand(new ArrayList<MappingDesignator>(), outputList, parentMapping, null, CommandData.create((AbstractMappingEditor)this.getEditor()), "http://www.ibm.com/2008/ccl/Mapping/assign"));
        }
        return cmdSet;
    }

    protected boolean canMap(List sources, List targets) {
        MappingRoot mappingRoot = this.getEditor().getMappingRoot();
        if (mappingRoot == null || ListUtilz.isEmpty((List)sources) && ListUtilz.isEmpty((List)targets)) {
            return false;
        }
        MappingValidator mappingValidator = ModelUtils.getMappingDomain((MappingRoot)mappingRoot).getMappingDomainValidator();
        if (!(mappingValidator instanceof ZCeeMappingValidator)) {
            return super.canMap(sources, targets);
        }
        ZCeeMappingValidator validator = (ZCeeMappingValidator)mappingValidator;
        List inputs = new ArrayList();
        List outputs = new ArrayList();
        if (this.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            inputs = this.getInputDesignators(selection);
            outputs = this.getOutputDesignators(selection);
        }
        if (ListUtilz.isEmpty(inputs) && ListUtilz.size(outputs) >= 1) {
            boolean mapped = false;
            Iterator outputsIt = outputs.iterator();
            while (!mapped && outputsIt.hasNext()) {
                MappingDesignator output = (MappingDesignator)outputsIt.next();
                mapped = validator.isInputOrOutputDesignatorAlreadyMapped(mappingRoot, null, output);
            }
            if (mapped) {
                return false;
            }
            boolean removed = false;
            outputsIt = outputs.iterator();
            while (!removed && outputsIt.hasNext()) {
                MappingDesignator output = (MappingDesignator)outputsIt.next();
                removed = ZCeeMappingUtil.hasRemovedParent((MappingDesignator)output);
            }
            if (removed) {
                return false;
            }
            boolean nullable = false;
            outputsIt = outputs.iterator();
            while (!nullable && outputsIt.hasNext()) {
                MappingDesignator output = (MappingDesignator)outputsIt.next();
                nullable = ZCeeMappingUtil.isNullable((MappingDesignator)output);
            }
            if (nullable) {
                return false;
            }
            boolean valid = true;
            outputsIt = outputs.iterator();
            while (valid && outputsIt.hasNext()) {
                MappingDesignator output = (MappingDesignator)outputsIt.next();
                boolean bl = valid = !ZCeeMappingUtil.isRepeating((MappingDesignator)output) && !ZCeeMappingUtil.isComplexNode((MappingDesignator)output) && (ZCeeMappingUtil.isDesignatorInGroup((MappingDesignator)output, (ZCeeDesignatorGroup[])new ZCeeDesignatorGroup[]{ZCeeDesignatorGroup.INPUT_BODY}) || ZCeeMappingUtil.isDesignatorInGroup((MappingDesignator)output, (ZCeeDesignatorGroup[])new ZCeeDesignatorGroup[]{ZCeeDesignatorGroup.OUTPUT_BODY}) || ZCeeMappingUtil.isDesignatorInGroup((MappingDesignator)output, (ZCeeDesignatorGroup[])new ZCeeDesignatorGroup[]{ZCeeDesignatorGroup.OUTPUT_HEADER}));
            }
            if (valid) {
                return true;
            }
        }
        return false;
    }

    public void run() {
        MappingIOEditPart saveSelectedIoEP = null;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection stucturedSelection = (IStructuredSelection)selection;
            Iterator selections = stucturedSelection.iterator();
            while (selections.hasNext() && saveSelectedIoEP == null) {
                Object nextSelection = selections.next();
                if (!(nextSelection instanceof MappingIOEditPart)) continue;
                saveSelectedIoEP = (MappingIOEditPart)nextSelection;
                break;
            }
        }
        super.run();
        final MappingIOEditPart selectedIoEP = saveSelectedIoEP;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet", null, 2);
                    if (selectedIoEP == null) {
                        return;
                    }
                    MappingConnectionEditPart connEditPart = (MappingConnectionEditPart)selectedIoEP.getTargetConnections().get(0);
                    TransformEditPart transformEditPart = (TransformEditPart)connEditPart.getSource();
                    ZCeeMapAssignActionDelegate.this.getEditor().select((Object)transformEditPart);
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                }
            }
        });
    }
}

