/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.actions.dialogs;

import com.ibm.msl.mapping.internal.ui.CommonUIMessages;
import com.ibm.zosconnect.api.mapping.annotations.ArrayFormat;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveType;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.mapping.actions.AddParameterActionDelegate;
import com.ibm.zosconnect.ui.mapping.actions.ParameterActionDelegate;
import com.ibm.zosconnect.ui.mapping.actions.ParameterActionModel;
import com.ibm.zosconnect.ui.mapping.actions.impl.AddHttpHeaderActionDelegate;
import com.ibm.zosconnect.ui.mapping.actions.impl.AddQueryParameterActionDelegate;
import com.ibm.zosconnect.ui.mapping.actions.impl.EditHttpHeaderActionDelegate;
import com.ibm.zosconnect.ui.mapping.actions.impl.EditQueryParameterActionDelegate;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ParameterDialog
extends StatusDialog
implements SelectionListener,
ModifyListener,
FocusListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite container;
    private Label lblParameterName;
    private Text txtParameterName;
    private Label lblParameterType;
    private TableCombo cmbParameterType;
    private TableItem[] cmbParameterTypeRows;
    private Label lblArrayType;
    private TableCombo cmbArrayType;
    private TableItem[] cmbArrayTypeRows;
    private Label lblArrayFormat;
    private TableCombo cmbArrayFormat;
    private TableItem[] cmbArrayFormatRows;
    private Label lblRequired;
    private Button btnCheckButton;
    private ParameterActionDelegate actionDelegate;
    private ParameterActionModel actionModel;
    private boolean canEditParameterName;
    private boolean canEditRequired;
    private String origParameterNameValue = "";
    private String origParameterTypeValue = "";
    private String origArrayTypeValue = "";
    private String origArrayFormatValue = "";
    private boolean origRequiredValue;

    public ParameterDialog(Shell parentShell, ParameterActionDelegate actionDelegate, ParameterActionModel actionModel, boolean canEditParameterName, boolean canEditRequired) {
        super(parentShell);
        this.actionDelegate = actionDelegate;
        this.actionModel = actionModel;
        this.canEditParameterName = canEditParameterName;
        this.canEditRequired = canEditRequired;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(actionDelegate.getActionName());
        this.setHelpAvailable(true);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.container = (Composite)super.createDialogArea(parent);
        this.container.setBackground(this.formToolkit.getColors().getBackground());
        this.container.setLayout((Layout)new GridLayout(2, false));
        int inputWidthHint = 50 * XSwt.getAverageCharWidth((Control)this.container);
        this.lblParameterName = new Label(this.container, 0);
        this.lblParameterName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.lblParameterName.setText(Xlat.label((String)"MAPPING_PARAM_NAME") + Xlat.colon());
        this.txtParameterName = new Text(this.container, 2048);
        GridData gd_txtParameterName = new GridData(4, 0x1000000, true, true);
        gd_txtParameterName.widthHint = inputWidthHint;
        this.txtParameterName.setLayoutData((Object)gd_txtParameterName);
        this.origParameterNameValue = this.actionModel.getParameterName();
        this.txtParameterName.setText(this.origParameterNameValue);
        if (!this.canEditParameterName) {
            this.txtParameterName.setEnabled(false);
        } else {
            this.txtParameterName.addModifyListener((ModifyListener)this);
        }
        this.lblParameterType = new Label(this.container, 0);
        this.lblParameterType.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.lblParameterType.setText(Xlat.label((String)"MAPPING_PARAM_TYPE") + Xlat.colon());
        this.cmbParameterType = new TableCombo(this.container, 2056);
        GridData gd_cmbParameterType = new GridData(4, 4, true, false);
        gd_cmbParameterType.widthHint = inputWidthHint;
        this.cmbParameterType.setLayoutData((Object)gd_cmbParameterType);
        this.cmbParameterType.setShowTableHeader(false);
        this.cmbParameterType.setShowTableLines(false);
        this.cmbParameterType.setDisplayColumnIndex(0);
        this.cmbParameterType.defineColumns(1);
        this.cmbParameterTypeRows = new TableItem[5];
        this.cmbParameterTypeRows[0] = new TableItem(this.cmbParameterType.getTable(), 0);
        this.cmbParameterTypeRows[0].setText(new String[]{JsonSchemaPrimitiveType.STRING.value()});
        this.cmbParameterTypeRows[1] = new TableItem(this.cmbParameterType.getTable(), 0);
        this.cmbParameterTypeRows[1].setText(new String[]{JsonSchemaPrimitiveType.INTEGER.value()});
        this.cmbParameterTypeRows[2] = new TableItem(this.cmbParameterType.getTable(), 0);
        this.cmbParameterTypeRows[2].setText(new String[]{JsonSchemaPrimitiveType.BOOLEAN.value()});
        this.cmbParameterTypeRows[3] = new TableItem(this.cmbParameterType.getTable(), 0);
        this.cmbParameterTypeRows[3].setText(new String[]{JsonSchemaPrimitiveType.NUMBER.value()});
        this.cmbParameterTypeRows[4] = new TableItem(this.cmbParameterType.getTable(), 0);
        this.cmbParameterTypeRows[4].setText(new String[]{JsonSchemaPrimitiveType.ARRAY.value()});
        this.origParameterTypeValue = this.actionModel.isArray() ? JsonSchemaPrimitiveType.ARRAY.value() : this.actionModel.getParameterType().value();
        this.cmbParameterType.setText(this.origParameterTypeValue);
        this.cmbParameterType.clearSelection();
        this.cmbParameterType.addSelectionListener((SelectionListener)this);
        this.cmbParameterType.addModifyListener((ModifyListener)this);
        this.cmbParameterType.addFocusListener((FocusListener)this);
        this.lblArrayType = new Label(this.container, 0);
        this.lblArrayType.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.lblArrayType.setText(Xlat.label((String)"MAPPING_PARAM_ARRAY_TYPE") + Xlat.colon());
        this.cmbArrayType = new TableCombo(this.container, 2056);
        GridData gd_cmbArrayType = new GridData(4, 4, true, false);
        gd_cmbArrayType.widthHint = inputWidthHint;
        this.cmbArrayType.setLayoutData((Object)gd_cmbArrayType);
        this.cmbArrayType.setShowTableHeader(false);
        this.cmbArrayType.setShowTableLines(false);
        this.cmbArrayType.setDisplayColumnIndex(0);
        this.cmbArrayType.defineColumns(1);
        this.cmbArrayTypeRows = new TableItem[4];
        this.cmbArrayTypeRows[0] = new TableItem(this.cmbArrayType.getTable(), 0);
        this.cmbArrayTypeRows[0].setText(new String[]{JsonSchemaPrimitiveType.STRING.value()});
        this.cmbArrayTypeRows[1] = new TableItem(this.cmbArrayType.getTable(), 0);
        this.cmbArrayTypeRows[1].setText(new String[]{JsonSchemaPrimitiveType.INTEGER.value()});
        this.cmbArrayTypeRows[2] = new TableItem(this.cmbArrayType.getTable(), 0);
        this.cmbArrayTypeRows[2].setText(new String[]{JsonSchemaPrimitiveType.BOOLEAN.value()});
        this.cmbArrayTypeRows[3] = new TableItem(this.cmbArrayType.getTable(), 0);
        this.cmbArrayTypeRows[3].setText(new String[]{JsonSchemaPrimitiveType.NUMBER.value()});
        if (this.actionModel.isArray()) {
            this.origArrayTypeValue = this.actionModel.getParameterType().value();
            XSwt.setText((TableCombo)this.cmbArrayType, (String)this.origArrayTypeValue);
        } else {
            this.cmbArrayType.select(0);
        }
        this.cmbArrayType.clearSelection();
        this.cmbArrayType.addSelectionListener((SelectionListener)this);
        this.cmbArrayType.addModifyListener((ModifyListener)this);
        this.cmbArrayType.addFocusListener((FocusListener)this);
        this.lblArrayFormat = new Label(this.container, 0);
        this.lblArrayFormat.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.lblArrayFormat.setText(Xlat.label((String)"MAPPING_PARAM_ARRAY_FORMAT") + Xlat.colon());
        this.cmbArrayFormat = new TableCombo(this.container, 2056);
        GridData gd_cmbArrayFormat = new GridData(4, 4, true, false);
        gd_cmbArrayFormat.widthHint = inputWidthHint;
        this.cmbArrayFormat.setLayoutData((Object)gd_cmbArrayFormat);
        this.cmbArrayFormat.setShowTableLines(true);
        this.cmbArrayFormat.setDisplayColumnIndex(0);
        this.cmbArrayFormat.defineColumns(2);
        List<ArrayFormat> supportedArrayFormats = this.actionModel.getSupportedArrayFormats();
        this.cmbArrayFormatRows = new TableItem[supportedArrayFormats.size()];
        int cmbArrayFormatRowNdx = 0;
        if (supportedArrayFormats.contains(ArrayFormat.CSV)) {
            this.cmbArrayFormatRows[cmbArrayFormatRowNdx] = new TableItem(this.cmbArrayFormat.getTable(), 0);
            this.cmbArrayFormatRows[cmbArrayFormatRowNdx].setText(new String[]{ArrayFormat.CSV.value(), Xlat.description((String)"ARRAY_FORMAT_CSV_DESC")});
            ++cmbArrayFormatRowNdx;
        }
        if (supportedArrayFormats.contains(ArrayFormat.SSV)) {
            this.cmbArrayFormatRows[cmbArrayFormatRowNdx] = new TableItem(this.cmbArrayFormat.getTable(), 0);
            this.cmbArrayFormatRows[cmbArrayFormatRowNdx].setText(new String[]{ArrayFormat.SSV.value(), Xlat.description((String)"ARRAY_FORMAT_SSV_DESC")});
            ++cmbArrayFormatRowNdx;
        }
        if (supportedArrayFormats.contains(ArrayFormat.TSV)) {
            this.cmbArrayFormatRows[cmbArrayFormatRowNdx] = new TableItem(this.cmbArrayFormat.getTable(), 0);
            this.cmbArrayFormatRows[cmbArrayFormatRowNdx].setText(new String[]{ArrayFormat.TSV.value(), Xlat.description((String)"ARRAY_FORMAT_TSV_DESC")});
            ++cmbArrayFormatRowNdx;
        }
        if (supportedArrayFormats.contains(ArrayFormat.PIPES)) {
            this.cmbArrayFormatRows[cmbArrayFormatRowNdx] = new TableItem(this.cmbArrayFormat.getTable(), 0);
            this.cmbArrayFormatRows[cmbArrayFormatRowNdx].setText(new String[]{ArrayFormat.PIPES.value(), Xlat.description((String)"ARRAY_FORMAT_PIPES_DESC")});
            ++cmbArrayFormatRowNdx;
        }
        if (supportedArrayFormats.contains(ArrayFormat.MULTI)) {
            this.cmbArrayFormatRows[cmbArrayFormatRowNdx] = new TableItem(this.cmbArrayFormat.getTable(), 0);
            this.cmbArrayFormatRows[cmbArrayFormatRowNdx].setText(new String[]{ArrayFormat.MULTI.value(), Xlat.description((String)"ARRAY_FORMAT_MULTI_DESC")});
            ++cmbArrayFormatRowNdx;
        }
        if (this.actionModel.isArray()) {
            this.origArrayFormatValue = this.actionModel.getArrayFormat().value();
            XSwt.setText((TableCombo)this.cmbArrayFormat, (String)this.origArrayFormatValue);
        } else {
            this.cmbArrayFormat.select(0);
        }
        this.cmbArrayFormat.clearSelection();
        this.cmbArrayFormat.addSelectionListener((SelectionListener)this);
        this.cmbArrayFormat.addModifyListener((ModifyListener)this);
        this.cmbArrayFormat.addFocusListener((FocusListener)this);
        this.lblRequired = new Label(this.container, 0);
        this.lblRequired.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblRequired.setText(Xlat.label((String)"MAPPING_PARAM_REQUIRED") + Xlat.colon());
        this.btnCheckButton = new Button(this.container, 32);
        GridData gd_btnCheckButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.btnCheckButton.setLayoutData((Object)gd_btnCheckButton);
        this.origRequiredValue = this.actionModel.isRequired();
        this.btnCheckButton.setSelection(this.origRequiredValue);
        this.btnCheckButton.addSelectionListener((SelectionListener)this);
        if (!this.canEditRequired) {
            XSwt.disable((Control[])new Control[]{this.btnCheckButton});
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "com.ibm.zosconnect.ui.mapping.definingandmappinghttpparameters");
        return this.container;
    }

    private void updateStatusAndPack(IStatus status) {
        this.updateStatus(status);
        XSwt.pack((Control)this.getShell());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button btnOK = this.getButton(0);
        if (status.isOK() && this.valuesChanged()) {
            XSwt.enable((Control[])new Control[]{btnOK});
        } else {
            XSwt.disable((Control[])new Control[]{btnOK});
        }
    }

    private boolean valuesChanged() {
        boolean changed = false;
        if (!(!(this.actionDelegate instanceof AddParameterActionDelegate) && StringUtils.equals((CharSequence)this.origParameterNameValue, (CharSequence)XSwt.getText((Text)this.txtParameterName)) && StringUtils.equals((CharSequence)this.origParameterTypeValue, (CharSequence)XSwt.getText((TableCombo)this.cmbParameterType)) && StringUtils.equals((CharSequence)this.origArrayTypeValue, (CharSequence)XSwt.getText((TableCombo)this.cmbArrayType)) && StringUtils.equals((CharSequence)this.origArrayFormatValue, (CharSequence)XSwt.getText((TableCombo)this.cmbArrayFormat)) && this.origRequiredValue == XSwt.getSelection((Button)this.btnCheckButton))) {
            changed = true;
        }
        return changed;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.validate();
    }

    public void widgetSelected(SelectionEvent event) {
        this.validate();
    }

    public void modifyText(ModifyEvent event) {
        this.validate();
    }

    public void validate() {
        this.updateTypeCombos();
        this.updateStatusAndPack(this.validateParameterName());
    }

    public void updateTypeCombos() {
        JsonSchemaPrimitiveType parameterType = JsonSchemaPrimitiveType.fromValue((String)XSwt.getTrimSelection((TableCombo)this.cmbParameterType));
        if (parameterType == JsonSchemaPrimitiveType.ARRAY) {
            XSwt.enable((TableCombo)this.cmbArrayType);
            XSwt.enable((TableCombo)this.cmbArrayFormat);
            if (XSwt.emptySelection((TableCombo)this.cmbArrayType)) {
                XSwt.selectFirst((TableCombo)this.cmbArrayType);
                XSwt.selectFirst((TableCombo)this.cmbArrayFormat);
            }
        } else {
            XSwt.clearSelection((TableCombo)this.cmbArrayType);
            XSwt.clearSelection((TableCombo)this.cmbArrayFormat);
            XSwt.disable((TableCombo)this.cmbArrayType);
            XSwt.disable((TableCombo)this.cmbArrayFormat);
        }
    }

    public IStatus validateParameterName() {
        IStatus status = Status.OK_STATUS;
        String parameterName = XSwt.getText((Text)this.txtParameterName);
        if (!XMLTypeValidator.INSTANCE.validateNCName(parameterName, null, null)) {
            String message = MessageFormat.format(CommonUIMessages.UserDefinedEditpart_Error_BadName, parameterName);
            status = new Status(4, "com.ibm.zosconnect.ui.mapping", message);
        } else if (this.actionModel.getSiblingParameterNames().contains(parameterName)) {
            String message = "";
            if (this.actionDelegate instanceof AddHttpHeaderActionDelegate || this.actionDelegate instanceof EditHttpHeaderActionDelegate) {
                message = Xlat.error((String)"DUPLICATE_HTTP_HEADER_NAME", (String[])new String[]{parameterName});
            } else if (this.actionDelegate instanceof AddQueryParameterActionDelegate || this.actionDelegate instanceof EditQueryParameterActionDelegate) {
                message = Xlat.error((String)"DUPLICATE_QUERY_PARAMETER_NAME", (String[])new String[]{parameterName});
            }
            status = new Status(4, "com.ibm.zosconnect.ui.mapping", message);
        }
        return status;
    }

    protected void okPressed() {
        this.actionModel.setParameterName(XSwt.getTrimText((Text)this.txtParameterName));
        JsonSchemaPrimitiveType parameterType = JsonSchemaPrimitiveType.fromValue((String)XSwt.getTrimSelection((TableCombo)this.cmbParameterType));
        if (parameterType == JsonSchemaPrimitiveType.ARRAY) {
            this.actionModel.setArray(true);
            JsonSchemaPrimitiveType arrayType = JsonSchemaPrimitiveType.fromValue((String)XSwt.getTrimSelection((TableCombo)this.cmbArrayType));
            this.actionModel.setParameterType(arrayType);
            ArrayFormat arrayFormat = ArrayFormat.fromValue((String)XSwt.getTrimSelection((TableCombo)this.cmbArrayFormat));
            this.actionModel.setArrayFormat(arrayFormat);
        } else {
            this.actionModel.setParameterType(parameterType);
            this.actionModel.setArray(false);
            this.actionModel.setArrayFormat(null);
        }
        this.actionModel.setRequired(XSwt.getSelection((Button)this.btnCheckButton));
        super.okPressed();
    }

    public void create() {
        int heightHint;
        super.create();
        ((GridData)this.cmbParameterType.getLayoutData()).heightHint = heightHint = XSwt.getHeight((Control)this.txtParameterName);
        ((GridData)this.cmbArrayType.getLayoutData()).heightHint = heightHint;
        ((GridData)this.cmbArrayFormat.getLayoutData()).heightHint = heightHint;
        XSwt.layout((Composite)this.container, (boolean)true);
        this.validate();
        XSwt.focus((Control)this.txtParameterName);
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        Object source = event.getSource();
        if (source instanceof TableCombo) {
            ((TableCombo)source).clearSelection();
        }
    }
}

