/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.mapping.actions;

import com.ibm.msl.mapping.internal.ui.editpart.MappingIOEditPart;
import com.ibm.msl.mapping.xml.util.XSDUtils;
import com.ibm.zosconnect.api.mapping.annotations.ArrayFormat;
import com.ibm.zosconnect.api.mapping.jsd.JsonSchemaPrimitiveType;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.common.util.xsd.ZosConnectXsdUtil;
import com.ibm.zosconnect.ui.mapping.actions.ParameterActionDelegate;
import com.ibm.zosconnect.ui.mapping.actions.ParameterActionModel;
import com.ibm.zosconnect.ui.mapping.actions.dialogs.ParameterDialog;
import com.ibm.zosconnect.ui.mapping.commands.EditParameterCommand;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public abstract class EditParameterActionDelegate
extends ParameterActionDelegate {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public String getInitialParameterName() {
        String retVal = this.getElementNameOfSelectedIoEditPart();
        if (StringUtils.isBlank((CharSequence)retVal)) {
            retVal = "";
        }
        return retVal;
    }

    public JsonSchemaPrimitiveType getInitialParameterType() {
        JsonSchemaPrimitiveType retVal = JsonSchemaPrimitiveType.STRING;
        XSDElementDeclaration selectedElement = this.getElementOfSelectedIoEditPart();
        if (selectedElement != null) {
            retVal = OpenApi2xUtil.getJsonPrimitiveTypeFromXsdSimpleType((XSDElementDeclaration)selectedElement);
        }
        return retVal;
    }

    public boolean getInitialRequired() {
        boolean retVal = false;
        XSDElementDeclaration selectedElement = this.getElementOfSelectedIoEditPart();
        retVal = XSDUtils.isRequired((EObject)selectedElement);
        return retVal;
    }

    public boolean getInitialArray() {
        return ZosConnectXsdUtil.isArrayElement((XSDElementDeclaration)this.getElementOfSelectedIoEditPart());
    }

    public ArrayFormat getInitialArrayFormat() {
        return ZosConnectXsdUtil.getArrayFormatAppInfo((XSDElementDeclaration)this.getElementOfSelectedIoEditPart());
    }

    public boolean isEnabled() {
        MappingIOEditPart parentIOEditPart;
        EObject parentRealModel;
        boolean retVal = false;
        MappingIOEditPart selectedIOEditPart = this.getSelectedIOEditPart();
        if (selectedIOEditPart != null && selectedIOEditPart.getParent() instanceof MappingIOEditPart && (parentRealModel = this.getRealModel(parentIOEditPart = (MappingIOEditPart)selectedIOEditPart.getParent())) instanceof XSDElementDeclaration) {
            XSDComplexTypeDefinition xsdEleCompType;
            XSDTypeDefinition xsdEleType;
            XSDElementDeclaration xsdEle = (XSDElementDeclaration)parentRealModel;
            xsdEle = xsdEle.getResolvedElementDeclaration();
            if (StringUtils.equals((CharSequence)this.getEnabledTagName(), (CharSequence)xsdEle.getName()) && (xsdEleType = xsdEle.getTypeDefinition()) instanceof XSDComplexTypeDefinition && StringUtils.equals((CharSequence)(xsdEleCompType = (XSDComplexTypeDefinition)xsdEleType).getName(), (CharSequence)this.getEnabledTypeName()) && StringUtils.startsWithAny((CharSequence)xsdEleCompType.getTargetNamespace(), (CharSequence[])this.getEnabledTypeTnsPfx())) {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public Command getCommand() {
        CompoundCommand cmdSet = new CompoundCommand();
        ParameterActionModel actionModel = new ParameterActionModel();
        actionModel.setParameterName(this.getInitialParameterName());
        actionModel.setParameterType(this.getInitialParameterType());
        actionModel.setArray(this.getInitialArray());
        actionModel.setArrayFormat(this.getInitialArrayFormat());
        actionModel.setRequired(this.getInitialRequired());
        actionModel.setSiblingParameterNames(this.getSibilingElementNamesOfSelectedIoEditPart());
        actionModel.setSupportedArrayFormats(this.getSupportedArrayFormats());
        ParameterDialog dialog = new ParameterDialog(XSwt.getActiveShell(), this, actionModel, this.canEditParameterName(), this.canEditRequired());
        if (dialog.open() == 0) {
            cmdSet.add((Command)new EditParameterCommand(this.getEditor(), this.getSelectedIOEditPart(), this, actionModel));
        }
        return cmdSet;
    }

    public List<ArrayFormat> getSupportedArrayFormats() {
        ArrayList<ArrayFormat> retVal = new ArrayList<ArrayFormat>();
        retVal.add(ArrayFormat.CSV);
        retVal.add(ArrayFormat.SSV);
        retVal.add(ArrayFormat.TSV);
        retVal.add(ArrayFormat.PIPES);
        retVal.add(ArrayFormat.MULTI);
        return retVal;
    }

    public abstract boolean canEditParameterName();

    public abstract boolean canEditRequired();
}

