/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.wizards;

import com.ibm.propertygroup.ui.datastores.DynamicPropStore;
import com.ibm.propertygroup.ui.listener.IPropertyUIChangeListener;
import com.ibm.propertygroup.ui.listener.IPropertyUIStatusChangedListener;
import com.ibm.propertygroup.ui.listener.PropertyUIChangeEvent;
import com.ibm.propertygroup.ui.listener.PropertyUIStatusChangedEvent;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizard;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardPage;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class MessageBundleWizardDynamicPage
extends MessageBundleWizardPage
implements IPropertyUIChangeListener,
IPropertyUIStatusChangedListener {
    protected DynamicPropStore dgStore_;

    public MessageBundleWizardDynamicPage(String name) {
        super(name);
    }

    public MessageBundleWizardDynamicPage(String name, PropertyUIMessageBundle newBundle) {
        super(name, newBundle);
    }

    @Override
    public void propertyUIChange(PropertyUIChangeEvent evt) {
        if (evt.getSource() instanceof PropertyUIWidget) {
            this.isModified(true);
            this.FirstOpens_ = false;
            PropertyUIWidget widget = (PropertyUIWidget)evt.getSource();
            int status = widget.getStatus();
            if (status != 4) {
                this.setPageComplete(this.determinePageCompletion());
            } else {
                this.setMessage(null);
                this.setErrorMessage(widget.getErrorMessage());
                this.setPageComplete(false);
            }
        }
    }

    @Override
    public void propertyUIStatusChanged(PropertyUIStatusChangedEvent evt) {
        if (evt.getSource() instanceof PropertyUIWidget) {
            IStatus status = evt.getStatus();
            if (status != null) {
                String errMsg = status.getMessage();
                int severity = status.getSeverity();
                if (severity == 4) {
                    this.setMessage(null);
                    this.setErrorMessage(errMsg);
                    this.setPageComplete(false);
                } else {
                    this.setPageComplete(this.determinePageCompletion());
                    if (severity != 0) {
                        if (this.getErrorMessage() != null) {
                            this.setErrorMessage(null);
                        }
                        this.setMessage(errMsg, 2);
                    }
                }
            } else {
                this.setPageComplete(this.determinePageCompletion());
            }
        }
    }

    public ArrayList<PropertyUIWidget> getUIWidgets() {
        return null;
    }

    public boolean determinePageCompletion() {
        this.hasMessage_ = false;
        boolean valid = this.validateWidgets(this.getUIWidgets(), true);
        if (valid) {
            this.cleanMessage();
        }
        return valid;
    }

    public boolean validateWidgets(ArrayList<PropertyUIWidget> widgets, boolean setMessage) {
        if (widgets == null) {
            return true;
        }
        String warning = null;
        int i = 0;
        while (i < widgets.size()) {
            PropertyUIWidget widget = widgets.get(i);
            int status = widget.getStatus();
            switch (status) {
                case 4: {
                    if (setMessage) {
                        this.setMessage(null);
                        this.setErrorMessage(widget.getErrorMessage());
                    }
                    return false;
                }
                case 1: 
                case 2: {
                    if (!setMessage || warning != null) break;
                    warning = widget.getErrorMessage();
                    break;
                }
            }
            ++i;
        }
        if (warning != null) {
            this.setMessage(warning, 2);
            this.hasMessage_ = true;
        }
        return true;
    }

    @Override
    public void setFocusToWidget() {
        ArrayList<PropertyUIWidget> widgets = this.getUIWidgets();
        if (widgets != null) {
            int i = 0;
            while (i < widgets.size()) {
                PropertyUIWidget widget = widgets.get(i);
                if (widget.setFocus()) break;
                ++i;
            }
        }
    }

    public DynamicPropStore getDynamicPropStore(boolean create) {
        AbstractUIPlugin plugin;
        IWizard wizard;
        if (this.dgStore_ == null && create && (wizard = this.getWizard()) instanceof MessageBundleWizard && (plugin = ((MessageBundleWizard)wizard).getDataPersistPlugin()) != null) {
            this.dgStore_ = this.createDynamicPropStore(plugin);
        }
        return this.dgStore_;
    }

    protected DynamicPropStore createDynamicPropStore(AbstractUIPlugin plugin) {
        return new DynamicPropStore(plugin);
    }

    public void setDynamicGenStore(DynamicPropStore newStore) {
        this.dgStore_ = newStore;
    }

    public void saveToStore(IProgressMonitor monitor) {
    }
}

