/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.utilities;

import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIFactoryInfo;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIHelper;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetCheckBox;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetPropertyGroup;
import com.ibm.propertygroup.ui.listener.IPropertyUIChangeListener;
import com.ibm.propertygroup.ui.listener.IPropertyUIListener;
import com.ibm.propertygroup.ui.listener.IPropertyUIStatusChangedListener;
import com.ibm.propertygroup.ui.listener.PropertyUIChangeEvent;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUINestedLayoutInfoWrapper;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import com.ibm.propertygroup.ui.widgets.PropertyUIScrollableComposite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class PropertyUIComposite
implements IPropertyUIChangeListener,
IPropertyChangeListener {
    private ArrayList<PropertyUIWidget> widgets_;
    private Composite composite_;
    private IPropertyGroup properties_;
    private Button advancedButton_ = null;
    private Label advancedButtonLabel_ = null;
    private ExpandableComposite expandableComposite_;
    private Hashtable<String, ArrayList<EventListener>> listeners_ = new Hashtable(3);
    private Composite primaryComposite_;
    private Composite advancedComposite_;
    private Composite blankComposite_;
    private boolean needToUpdatePrimaryComposite_ = false;
    private boolean needToUpdateAdvancedComposite_ = false;
    private PropertyUIFactoryInfo uiInfo_ = new PropertyUIFactoryInfo();
    private boolean redrawingComposite_ = false;
    private boolean showingAdvanced_ = false;
    private PropertyUIFactory factory_;
    private Hashtable<IPropertyGroup, Integer> propertyGroupLevelMapping_ = new Hashtable();
    private Font italicFont_;
    private PropertyUIComposite parentUIComposite_;
    private boolean isDisposed_ = false;

    public PropertyUIComposite(IPropertyGroup properties) {
        this.properties_ = properties;
    }

    public ArrayList<PropertyUIWidget> getUIWidgets() {
        return this.widgets_;
    }

    public PropertyUIWidget getUIWidget(IPropertyDescriptor ipd) {
        if (this.widgets_ != null && ipd != null) {
            int i = 0;
            while (i < this.widgets_.size()) {
                PropertyUIWidget widget = this.widgets_.get(i);
                if (ipd.equals(widget.getProperty())) {
                    return widget;
                }
                ++i;
            }
        }
        return null;
    }

    public PropertyUIWidget getUIWidget(String propertyName) {
        IPropertyDescriptor property;
        if (this.properties_ != null && propertyName != null && (property = PropertyUtil.getProperty(this.properties_, propertyName)) != null) {
            return this.getUIWidget(property);
        }
        return null;
    }

    public Composite getComposite() {
        return this.composite_;
    }

    public IPropertyGroup getPropertyGroup() {
        return this.properties_;
    }

    public void dispose() {
        if (!this.isDisposed_) {
            int i;
            if (this.widgets_ != null) {
                i = 0;
                while (i < this.widgets_.size()) {
                    this.widgets_.get(i).dispose();
                    ++i;
                }
                this.widgets_.clear();
                this.updateParentWidgetList();
            }
            this.removeListenerFromPropertyGroups(this.properties_);
            this.composite_.dispose();
            if (this.italicFont_ != null) {
                this.italicFont_.dispose();
            }
            if (this.uiInfo_.nestedLayoutInfo_ != null && !this.uiInfo_.nestedLayoutInfo_.isEmpty()) {
                i = 0;
                while (i < this.uiInfo_.nestedLayoutInfo_.size()) {
                    this.uiInfo_.nestedLayoutInfo_.get(i).dispose();
                    ++i;
                }
            }
            this.properties_ = null;
            this.isDisposed_ = true;
        }
    }

    public boolean setPropertyGroup(IPropertyGroup newPropertyGroup) {
        if (newPropertyGroup == null || newPropertyGroup.getProperties().length != this.properties_.getProperties().length) {
            return false;
        }
        if (newPropertyGroup.equals(this.properties_)) {
            return true;
        }
        ArrayList<IPropertyDescriptor> props = new ArrayList<IPropertyDescriptor>();
        int i = 0;
        while (i < this.widgets_.size()) {
            PropertyUIWidget widget = this.widgets_.get(i);
            String name = widget.getProperty().getName();
            IPropertyDescriptor prop = PropertyUtil.getProperty(newPropertyGroup, name);
            if (prop == null) {
                return false;
            }
            props.add(prop);
            ++i;
        }
        i = 0;
        while (i < this.widgets_.size()) {
            this.widgets_.get(i).setProperty((IPropertyDescriptor)props.get(i));
            ++i;
        }
        this.removeListenerFromPropertyGroups(this.properties_);
        this.properties_ = newPropertyGroup;
        this.addListenerToPropertyGroups(this.properties_, 0);
        return true;
    }

    public void addPropertyUIListener(String type, IPropertyUIListener listener) {
        if (this.widgets_ == null) {
            return;
        }
        int i = 0;
        while (i < this.widgets_.size()) {
            PropertyUIWidget widget = this.widgets_.get(i);
            widget.addPropertyUIListener(type, listener);
            ++i;
        }
        this.reserveListener(type, listener);
    }

    public void removePropertyUIListener(String type, IPropertyUIListener listener) {
        if (this.widgets_ == null) {
            return;
        }
        int i = 0;
        while (i < this.widgets_.size()) {
            PropertyUIWidget widget = this.widgets_.get(i);
            widget.removePropertyUIListener(type, listener);
            ++i;
        }
        this.removeListener(type, listener);
    }

    public void addPropertyUIChangeListener(IPropertyUIChangeListener listener) {
        if (this.widgets_ == null) {
            return;
        }
        boolean listenerReserved = false;
        int i = 0;
        while (i < this.widgets_.size()) {
            PropertyUIWidget widget = this.widgets_.get(i);
            widget.addPropertyUIChangeListener(listener);
            if (listener instanceof IPropertyUIStatusChangedListener) {
                widget.addPropertyUIStatusChangedListener((IPropertyUIStatusChangedListener)((Object)listener));
                if (!listenerReserved) {
                    this.reserveListener("PROPERTY_UI_STATUS_CHANGE_LISTENER", listener);
                    listenerReserved = true;
                }
            }
            ++i;
        }
        this.reserveListener("PROPERTY_UI_CHANGE_LISTENER", listener);
    }

    public void removePropertyUIChangeListener(IPropertyUIChangeListener listener) {
        if (this.widgets_ == null) {
            return;
        }
        int i = 0;
        while (i < this.widgets_.size()) {
            PropertyUIWidget widget = this.widgets_.get(i);
            widget.removePropertyUIChangeListener(listener);
            if (listener instanceof IPropertyUIStatusChangedListener) {
                widget.removePropertyUIStatusChangedListener((IPropertyUIStatusChangedListener)((Object)listener));
            }
            ++i;
        }
        this.removeListener("PROPERTY_UI_CHANGE_LISTENER", listener);
    }

    public void addPropertyUIStatusChangedListener(IPropertyUIStatusChangedListener listener) {
        if (this.widgets_ == null) {
            return;
        }
        int i = 0;
        while (i < this.widgets_.size()) {
            PropertyUIWidget widget = this.widgets_.get(i);
            widget.addPropertyUIStatusChangedListener(listener);
            ++i;
        }
        this.reserveListener("PROPERTY_UI_STATUS_CHANGE_LISTENER", listener);
    }

    public void removePropertyUIStatusChangedListener(IPropertyUIStatusChangedListener listener) {
        if (this.widgets_ == null) {
            return;
        }
        int i = 0;
        while (i < this.widgets_.size()) {
            PropertyUIWidget widget = this.widgets_.get(i);
            widget.removePropertyUIStatusChangedListener(listener);
            ++i;
        }
        this.removeListener("PROPERTY_UI_STATUS_CHANGE_LISTENER", listener);
    }

    public Button getAdvancedButton() {
        return this.advancedButton_;
    }

    public ExpandableComposite getExpandableComposite() {
        return this.expandableComposite_;
    }

    public void showAdvancedProperties(boolean showAdvanced) {
        if (this.advancedButton_ != null) {
            this.showingAdvanced_ = showAdvanced;
        } else if (this.expandableComposite_ != null) {
            this.expandableComposite_.setExpanded(showAdvanced);
        } else {
            return;
        }
        this.handleAdvanced();
    }

    @Override
    public void propertyUIChange(PropertyUIChangeEvent evt) {
        PropertyUIWidget widget;
        int status;
        if (evt.getSource() instanceof PropertyUIWidget && (status = (widget = (PropertyUIWidget)evt.getSource()).getStatus()) != 4) {
            int i = 0;
            while (i < this.widgets_.size()) {
                String widgetValue;
                PropertyUIWidget uiWidget = this.widgets_.get(i);
                if (uiWidget.getStatus() != 0 && this.widgets_.get(i) != widget && (widgetValue = uiWidget.getWidgetValue()) != null) {
                    String value = uiWidget.getValueAsString();
                    if ((widgetValue.length() >= 1 || value != null) && uiWidget.isEnabled()) {
                        uiWidget.setValue(widgetValue);
                        if (uiWidget.getStatus() == 4) break;
                    }
                }
                ++i;
            }
        }
    }

    public void propertyChange(final PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof IPropertyDescriptor) || !PropertyHelper.isPropertyGroup((IPropertyDescriptor)((IPropertyDescriptor)source))) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.handlePropertyChange(evt);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PropertyUIComposite.this.handlePropertyChange(evt);
                }
            });
        }
    }

    protected void handlePropertyChange(PropertyChangeEvent evt) {
        final IPropertyGroup properties = (IPropertyGroup)evt.getSource();
        final int propertyChangeType = evt.getPropertyChangeType();
        final Object newValue = evt.getNewValue();
        final Object oldValue = evt.getOldValue();
        final int level = this.propertyGroupLevelMapping_.get(properties);
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!PropertyUIComposite.this.needUpdateComposite(propertyChangeType, newValue, oldValue)) {
                    PropertyUIComposite.this.updateListener(newValue, oldValue, level);
                    return;
                }
                Composite uiContainer = null;
                PropertyUIFactory factory = PropertyUIComposite.this.getPropertyUIFactory();
                boolean needToLayout = false;
                boolean redrawComposite = false;
                boolean[] status = null;
                if (!((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.showAll_) {
                    status = PropertyUIHelper.instance().checkExpertInPropertyGroup(PropertyUIComposite.this.properties_, false);
                    if (status[0]) {
                        IPropertyUIWidgetFactory uiFactory;
                        PropertyUIComposite.this.needToUpdatePrimaryComposite(status[1]);
                        if (((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.showingAdvancedStyle_ == 0) {
                            if (PropertyUIComposite.this.advancedButton_ == null) {
                                uiFactory = factory.getUIFactory();
                                Control[] handlers = factory.createShowingAdvancedPropertiesHandler(uiFactory, PropertyUIComposite.this.composite_);
                                PropertyUIComposite.this.setAdvancedButton((Button)handlers[0]);
                                PropertyUIComposite.this.setAdvancedButtonLabel((Label)handlers[1]);
                                ((GridData)((PropertyUIComposite)PropertyUIComposite.this).primaryComposite_.getLayoutData()).grabExcessVerticalSpace = false;
                            }
                        } else if (PropertyUIComposite.this.expandableComposite_ == null) {
                            uiFactory = factory.getUIFactory();
                            Control[] handler = factory.createShowingAdvancedPropertiesHandler(uiFactory, PropertyUIComposite.this.composite_);
                            PropertyUIComposite.this.setExpandableComposite((ExpandableComposite)handler[0]);
                            ((GridData)((PropertyUIComposite)PropertyUIComposite.this).primaryComposite_.getLayoutData()).grabExcessVerticalSpace = false;
                        }
                    } else if (PropertyUIComposite.this.advancedButton_ != null) {
                        PropertyUIComposite.this.advancedButton_.getParent().dispose();
                        PropertyUIComposite.this.advancedButton_ = null;
                        PropertyUIComposite.this.needToUpdatePrimaryComposite(false);
                        needToLayout = true;
                        ((GridData)((PropertyUIComposite)PropertyUIComposite.this).primaryComposite_.getLayoutData()).verticalAlignment = 4;
                        ((GridData)((PropertyUIComposite)PropertyUIComposite.this).primaryComposite_.getLayoutData()).grabExcessVerticalSpace = true;
                    } else if (PropertyUIComposite.this.expandableComposite_ != null) {
                        PropertyUIComposite.this.expandableComposite_.dispose();
                        PropertyUIComposite.this.expandableComposite_ = null;
                        PropertyUIComposite.this.needToUpdatePrimaryComposite(false);
                        PropertyUIComposite.this.cleanWidgets(PropertyUIComposite.this.widgets_);
                        needToLayout = true;
                        ((GridData)((PropertyUIComposite)PropertyUIComposite.this).primaryComposite_.getLayoutData()).verticalAlignment = 4;
                        ((GridData)((PropertyUIComposite)PropertyUIComposite.this).primaryComposite_.getLayoutData()).grabExcessVerticalSpace = true;
                    }
                }
                if (!((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.showAll_ && (redrawComposite = PropertyUIComposite.this.checkRedrawStyle(properties, propertyChangeType, newValue, oldValue)) || PropertyUIComposite.this.needRedrawForEmptyPropertyGroup(properties, propertyChangeType, newValue, oldValue)) {
                    PropertyUIComposite.this.needToUpdatePrimaryComposite(true);
                    PropertyUIComposite.this.needToUpdateAdvancedComposite_ = true;
                    PropertyUIComposite.this.redrawComposite(PropertyUIComposite.this.isShowingAll());
                } else {
                    switch (propertyChangeType) {
                        case 6: {
                            int colNo;
                            IPropertyDescriptor newProperty = (IPropertyDescriptor)newValue;
                            UIPositionInfo info = null;
                            IPropertyDescriptor[] props = new IPropertyDescriptor[]{newProperty};
                            if (PropertyUtil.isAdvancedPropertyDescriptor(newProperty) && !PropertyUIComposite.this.isShowingAll()) {
                                PropertyUIComposite.this.composite_.layout();
                                break;
                            }
                            if (properties.equals(PropertyUIComposite.this.properties_)) {
                                info = new UIPositionInfo();
                                boolean isPropertyGroup = PropertyHelper.isPropertyGroup((IPropertyDescriptor)newProperty);
                                if (PropertyUtil.isAdvancedPropertyDescriptor(newProperty)) {
                                    if (!PropertyUIComposite.this.primaryComposite_.equals(PropertyUIComposite.this.advancedComposite_) && PropertyUIComposite.this.advancedComposite_ != null && !PropertyUIComposite.this.advancedComposite_.isDisposed()) {
                                        if (((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.rootGroupingStyle_ != 0) {
                                            if (!isPropertyGroup) {
                                                Control[] children = PropertyUIComposite.this.advancedComposite_.getChildren();
                                                int i = 0;
                                                while (i < children.length) {
                                                    if (children[i] instanceof ExpandableComposite && children[i].getData() == null) {
                                                        info.container_ = (Composite)((ExpandableComposite)children[i]).getClient();
                                                        break;
                                                    }
                                                    ++i;
                                                }
                                                if (info.container_ == null) {
                                                    info.container_ = (Composite)factory.createPropertyGroupSection(PropertyUIComposite.this.advancedComposite_, PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_ADVANCED_PROPERTIES, null, factory.calculateMaxRowLength(properties, 4, true, true), false).getClient();
                                                }
                                            } else {
                                                info.container_ = (Composite)factory.createPropertyGroupSection(PropertyUIComposite.this.advancedComposite_, newProperty.getDisplayName(), newProperty.getName(), factory.calculateMaxRowLength((IPropertyGroup)newProperty, 4), false).getClient();
                                                props = ((IPropertyGroup)newProperty).getProperties();
                                            }
                                        } else {
                                            info.container_ = PropertyUIComposite.this.advancedComposite_;
                                        }
                                    } else if (isPropertyGroup && (((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.rootGroupingStyle_ == 2 || ((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.rootGroupingStyle_ == 3)) {
                                        info.container_ = (Composite)factory.createPropertyGroupSection(PropertyUIComposite.this.primaryComposite_, newProperty.getDisplayName(), newProperty.getName(), factory.calculateMaxRowLength((IPropertyGroup)newProperty, 2), true).getClient();
                                        props = ((IPropertyGroup)newProperty).getProperties();
                                    } else {
                                        info.container_ = PropertyUIComposite.this.primaryComposite_;
                                    }
                                } else if (isPropertyGroup && (((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.rootGroupingStyle_ == 2 || ((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.rootGroupingStyle_ == 3)) {
                                    info.container_ = (Composite)factory.createPropertyGroupSection(PropertyUIComposite.this.primaryComposite_, newProperty.getDisplayName(), newProperty.getName(), factory.calculateMaxRowLength((IPropertyGroup)newProperty, 2), true).getClient();
                                    props = ((IPropertyGroup)newProperty).getProperties();
                                } else {
                                    info.container_ = PropertyUIComposite.this.primaryComposite_;
                                }
                                info.endUIPosition_ = info.container_.getChildren().length - 1;
                                info.endWidgetIndex_ = PropertyUIComposite.this.widgets_.size() - 1;
                            } else {
                                info = PropertyUIComposite.this.getPropertyDescriptorUIPosition(properties, 0);
                            }
                            if (info.container_ == null) break;
                            uiContainer = info.container_;
                            int type = PropertyUIComposite.this.getShowingStyle();
                            GridLayout layout = (GridLayout)uiContainer.getLayout();
                            int newColNo = colNo = layout.numColumns;
                            newColNo = PropertyHelper.isPropertyGroup((IPropertyDescriptor)newProperty) ? factory.calculateMaxRowLength((IPropertyGroup)newProperty, type) : factory.calculateMaxRowLength(newProperty, type);
                            if (newColNo > colNo) {
                                colNo = newColNo;
                            }
                            factory.setNestedLevel(level);
                            if (info.endUIPosition_ > -1) {
                                PropertyUIComposite.this.generatePropertiesUI(factory, uiContainer, info.endWidgetIndex_, uiContainer.getChildren()[info.endUIPosition_], false, colNo, props);
                                break;
                            }
                            PropertyUIComposite.this.generatePropertiesUI(factory, uiContainer, info.endWidgetIndex_, null, false, colNo, props);
                            break;
                        }
                        case 9: {
                            UIPositionInfo info = PropertyUIComposite.this.propertyArrayRemoveProperties((IPropertyDescriptor[])oldValue, true, level);
                            uiContainer = info.container_;
                            break;
                        }
                        case 7: {
                            IPropertyDescriptor oldProperty = (IPropertyDescriptor)oldValue;
                            if (!PropertyHelper.isPropertyGroup((IPropertyDescriptor)oldProperty)) {
                                UIPositionInfo pInfo = PropertyUIComposite.this.getPropertyDescriptorUIPosition(oldProperty, 0);
                                if (pInfo.container_ == null) break;
                                UIPositionInfo gInfo = PropertyUIComposite.this.getPropertyDescriptorUIPosition(properties, 0);
                                gInfo.startUIPosition_ = Math.min(gInfo.startUIPosition_, pInfo.startUIPosition_);
                                gInfo.endUIPosition_ = Math.max(gInfo.endUIPosition_, pInfo.endUIPosition_);
                                gInfo.startWidgetIndex_ = Math.min(gInfo.startWidgetIndex_, pInfo.startWidgetIndex_);
                                gInfo.endWidgetIndex_ = Math.max(gInfo.endWidgetIndex_, pInfo.endWidgetIndex_);
                                int startIndex = pInfo.startUIPosition_;
                                int endIndex = pInfo.endUIPosition_;
                                if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)oldProperty)) {
                                    PropertyUIComposite.this.getPropertyGroupSeparators(pInfo, gInfo.endUIPosition_, level);
                                    startIndex = pInfo.startUIPosition_;
                                    endIndex = pInfo.endUIPosition_;
                                }
                                uiContainer = pInfo.container_;
                                Control[] removingControls = uiContainer.getChildren();
                                int i = startIndex;
                                while (i <= endIndex) {
                                    removingControls[i].dispose();
                                    ++i;
                                }
                                startIndex = pInfo.startWidgetIndex_;
                                endIndex = pInfo.endWidgetIndex_;
                                i = startIndex;
                                while (i <= endIndex) {
                                    ((PropertyUIWidget)PropertyUIComposite.this.widgets_.get(i)).dispose();
                                    PropertyUIComposite.this.widgets_.remove(i);
                                    --i;
                                    --endIndex;
                                    ++i;
                                }
                                break;
                            }
                            PropertyUINestedLayoutInfoWrapper wrapper = PropertyUIComposite.this.getNestedLayoutInfoWrapper((IPropertyGroup)oldValue);
                            if (wrapper != null) {
                                uiContainer = wrapper.getLayoutContainer();
                                wrapper.removeNestedLayoutArea();
                                ((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.nestedLayoutInfo_.remove(wrapper);
                                break;
                            }
                            UIPositionInfo info = PropertyUIComposite.this.propertyArrayRemoveProperties(((IPropertyGroup)oldValue).getProperties(), true, level);
                            uiContainer = info.container_;
                            break;
                        }
                        case 8: {
                            UIPositionInfo info = PropertyUIComposite.this.propertyArrayRemoveProperties((IPropertyDescriptor[])oldValue, false, level);
                            uiContainer = info.container_;
                            PropertyUIComposite.this.propertyGroupGenerateProperties(uiContainer, info, (IPropertyDescriptor[])newValue, properties);
                        }
                    }
                    PropertyUIComposite.this.updateParentWidgetList();
                    if (uiContainer != null) {
                        Composite parent = uiContainer;
                        while (parent != null) {
                            Control[] children = parent.getChildren();
                            if (children.length >= 1 || uiContainer.equals(PropertyUIComposite.this.primaryComposite_)) break;
                            parent = parent.getParent();
                            uiContainer.dispose();
                            uiContainer = parent;
                            if (!(parent instanceof Section)) continue;
                            parent = parent.getParent();
                            uiContainer.dispose();
                            uiContainer = parent;
                        }
                        PropertyUIComposite.this.relayoutParents(parent, true);
                    } else if (needToLayout) {
                        PropertyUIComposite.this.relayoutParents(PropertyUIComposite.this.composite_, false);
                    }
                    if (!((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.showAll_ && status != null && status[0] && PropertyUIComposite.this.primaryComposite_ != null) {
                        GridData gd = (GridData)PropertyUIComposite.this.primaryComposite_.getLayoutData();
                        gd.grabExcessVerticalSpace = PropertyUIHelper.instance().containsExpandableProperties(PropertyUIComposite.this.properties_, ((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.rootGroupingStyle_ != 2 && ((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.rootGroupingStyle_ != 3);
                    }
                }
                PropertyUIComposite.this.updateListener(newValue, oldValue, level);
                if (((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.rootGroupingStyle_ != 0 && redrawComposite) {
                    Integer value;
                    Object pg = properties;
                    IPropertyGroup parent = null;
                    while (pg != null) {
                        IPropertyDescriptor ipd = pg.getParent();
                        if (PropertyUIComposite.this.properties_.equals(ipd)) {
                            parent = pg;
                            break;
                        }
                        pg = ipd != null && PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd) ? (IPropertyGroup)ipd : null;
                    }
                    if (parent != null && (value = (Integer)PropertyUIComposite.this.propertyGroupLevelMapping_.get(parent)) != null) {
                        int level2 = value;
                        int newLevel = 1;
                        if (PropertyUtil.isAdvancedPropertyGroup(parent) || ((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.rootGroupingStyle_ == 2 || ((PropertyUIComposite)PropertyUIComposite.this).uiInfo_.rootGroupingStyle_ == 3) {
                            newLevel = 0;
                        }
                        if (level2 != newLevel) {
                            PropertyUIComposite.this.updateProeprtyGroupLevel(parent, newLevel);
                        }
                    }
                }
            }
        });
        ArrayList<EventListener> uiChangeListeners = this.listeners_.get("PROPERTY_UI_STATUS_CHANGE_LISTENER");
        if (uiChangeListeners != null && !uiChangeListeners.isEmpty()) {
            PropertyUIWidgetPG pgWidget = new PropertyUIWidgetPG(properties, this.getPropertyUIFactory().getUIFactory());
            int i = 0;
            while (i < uiChangeListeners.size()) {
                pgWidget.addPropertyUIChangeListener((IPropertyUIChangeListener)uiChangeListeners.get(i));
                ++i;
            }
            pgWidget.firePropertyGroupUIChange(oldValue, newValue);
            i = 0;
            while (i < uiChangeListeners.size()) {
                pgWidget.removePropertyUIChangeListener((IPropertyUIChangeListener)uiChangeListeners.get(i));
                ++i;
            }
            pgWidget.dispose();
        }
    }

    protected void updateProeprtyGroupLevel(IPropertyGroup pg, int level) {
        this.propertyGroupLevelMapping_.put(pg, new Integer(level));
        IPropertyDescriptor[] propList = pg.getProperties();
        int i = 0;
        while (i < propList.length) {
            IPropertyDescriptor ipd = propList[i];
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
                this.updateProeprtyGroupLevel((IPropertyGroup)ipd, level + 1);
            }
            ++i;
        }
    }

    public Composite getPrimaryArea() {
        return this.primaryComposite_;
    }

    public Composite getAdvancedArea() {
        return this.advancedComposite_;
    }

    public boolean isShowingAll() {
        if (this.uiInfo_.showingAdvancedStyle_ == 0) {
            if (this.advancedButton_ != null) {
                return this.showingAdvanced_;
            }
            return true;
        }
        if (this.expandableComposite_ != null) {
            return this.expandableComposite_.isExpanded();
        }
        return true;
    }

    public int getRootGroupingStyle() {
        return this.uiInfo_.rootGroupingStyle_;
    }

    public ArrayList<PropertyUINestedLayoutInfoWrapper> getNestedLayoutInfo() {
        return this.uiInfo_.nestedLayoutInfo_;
    }

    public void setParentUIComposite(PropertyUIComposite parent) {
        this.parentUIComposite_ = parent;
    }

    public void addNestedLayoutInfo(PropertyUINestedLayoutInfoWrapper wrapper) {
        if (this.uiInfo_.nestedLayoutInfo_ == null) {
            this.uiInfo_.nestedLayoutInfo_ = new ArrayList();
        }
        if (this.uiInfo_.nestedLayoutInfo_.indexOf(wrapper) == -1) {
            this.uiInfo_.nestedLayoutInfo_.add(wrapper);
        }
    }

    void setUIWidgets(ArrayList<PropertyUIWidget> newWidgets) {
        this.widgets_ = newWidgets;
        if (this.widgets_ == null) {
            return;
        }
        int i = 0;
        while (i < this.widgets_.size()) {
            PropertyUIWidget widget = this.widgets_.get(i);
            widget.addPropertyUIChangeListener(this);
            ++i;
        }
        this.reserveListener("PROPERTY_UI_CHANGE_LISTENER", this);
        this.addListenerToPropertyGroups(this.properties_, 0);
    }

    void setComposite(Composite newComposite) {
        this.composite_ = newComposite;
    }

    void setPropertyFactoryUIInfo(PropertyUIFactoryInfo newInfo) {
        this.uiInfo_.copyData(newInfo);
    }

    void setPropertyUIFactory(PropertyUIFactory factory) {
        this.factory_ = factory;
    }

    void setAdvancedButton(Button button) {
        if (button == null) {
            return;
        }
        if (this.advancedButton_ != null) {
            this.advancedButton_.dispose();
        }
        this.advancedButton_ = button;
        this.showingAdvanced_ = false;
        this.advancedButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PropertyUIComposite.this.handleAdvanced();
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    void setExpandableComposite(ExpandableComposite expandableComposite) {
        if (expandableComposite == null) {
            return;
        }
        if (this.expandableComposite_ != null && !this.expandableComposite_.isDisposed()) {
            this.expandableComposite_.dispose();
        }
        this.expandableComposite_ = expandableComposite;
        this.expandableComposite_.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                PropertyUIComposite.this.handleAdvanced();
            }
        });
    }

    void setAdvancedButtonLabel(Label label) {
        this.advancedButtonLabel_ = label;
    }

    void setPrimaryComposite(Composite newComp) {
        this.primaryComposite_ = newComp;
    }

    void setAdvancedComposite(Composite newComp) {
        this.advancedComposite_ = newComp;
    }

    void needToUpdatePrimaryComposite(boolean newValue) {
        this.needToUpdatePrimaryComposite_ = newValue;
    }

    private void handleAdvanced() {
        boolean showAll;
        if (this.advancedButton_ != null) {
            boolean bl = showAll = !this.isShowingAll();
            if (showAll) {
                this.advancedButton_.setText(new StringBuffer(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_HIDE).append(" ").append(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_ADVANCED).toString());
            } else {
                int status = this.checkExpertWidgets();
                if (status == 4) {
                    this.advancedButtonLabel_.setVisible(true);
                    this.advancedButton_.setSelection(true);
                    return;
                }
                this.advancedButtonLabel_.setVisible(false);
                this.advancedButton_.setText(new StringBuffer(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_ADVANCED).append(" ").append(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_SHOW).toString());
            }
            this.needToUpdateAdvancedComposite_ = true;
        } else if (this.expandableComposite_ != null) {
            showAll = this.expandableComposite_.isExpanded();
            if (showAll) {
                this.expandableComposite_.setText(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_HIDE_ADVANCED);
                this.needToUpdateAdvancedComposite_ = this.advancedComposite_ == null || this.advancedComposite_.isDisposed() || this.advancedComposite_.getChildren().length < 1 || !this.advancedComposite_.equals(this.expandableComposite_.getClient());
            } else {
                Label textClient = (Label)this.expandableComposite_.getTextClient();
                int status = this.checkExpertWidgets();
                if (status == 4) {
                    this.expandableComposite_.setExpanded(true);
                    textClient.setVisible(true);
                    return;
                }
                textClient.setVisible(false);
                this.expandableComposite_.setText(PropertyUIMessages.PROPERTY_UI_WIDGETS_BUTTON_SHOW_ADVANCED);
                this.needToUpdateAdvancedComposite_ = true;
            }
        } else {
            return;
        }
        this.showingAdvanced_ = showAll;
        this.redrawComposite(showAll);
    }

    private void redrawComposite(boolean showAll) {
        if (this.redrawingComposite_) {
            return;
        }
        this.redrawingComposite_ = true;
        PropertyUIFactory factory = this.getPropertyUIFactory();
        this.factory_.setNestedLevel(0);
        IPropertyUIWidgetFactory uiFactory = factory.getUIFactory();
        if (showAll) {
            if (this.primaryComposite_ != null) {
                Object widgets;
                if (this.needToUpdatePrimaryComposite_) {
                    widgets = this.primaryComposite_.getChildren();
                    int i = 0;
                    while (i < ((Control[])widgets).length) {
                        widgets[i].dispose();
                        ++i;
                    }
                }
                if (this.needToUpdateAdvancedComposite_) {
                    this.disposeAdvancedArea(showAll);
                    int colNo = factory.calculateMaxRowLength(this.properties_, 4);
                    if (colNo != 0) {
                        if (this.uiInfo_.showingAdvancedStyle_ == 0) {
                            this.advancedComposite_ = uiFactory.createComposite(this.composite_, 0);
                        } else {
                            this.advancedComposite_ = uiFactory.createComposite((Composite)this.expandableComposite_, 0);
                            this.advancedComposite_.setFont(this.expandableComposite_.getParent().getFont());
                            this.expandableComposite_.setClient((Control)this.advancedComposite_);
                        }
                        if (this.uiInfo_.rootGroupingStyle_ != 0) {
                            colNo = 1;
                        }
                        GridLayout layout = new GridLayout();
                        layout.marginHeight = 3;
                        layout.marginWidth = 3;
                        layout.numColumns = colNo;
                        this.advancedComposite_.setLayout((Layout)layout);
                        factory.inheritLayoutData(this.primaryComposite_, this.advancedComposite_);
                        GridData gd = new GridData(768);
                        if (PropertyUIHelper.instance().containsExpandableExpertProperties(this.properties_, this.uiInfo_.rootGroupingStyle_ != 1 && this.uiInfo_.rootGroupingStyle_ != 2 && this.uiInfo_.rootGroupingStyle_ != 3)) {
                            gd = new GridData(1808);
                        }
                        this.advancedComposite_.setLayoutData((Object)gd);
                    }
                }
                if (this.needToUpdatePrimaryComposite_) {
                    ArrayList<PropertyUIWidget> widgets2;
                    GridLayout layout = (GridLayout)this.primaryComposite_.getLayout();
                    if (this.needToUpdateAdvancedComposite_) {
                        int i = 0;
                        while (i < this.widgets_.size()) {
                            this.widgets_.get(i).dispose();
                            ++i;
                        }
                        this.widgets_.clear();
                        layout.numColumns = this.calculateMaxRowLength(factory, this.properties_);
                        this.widgets_.addAll(factory.generateWidgets(this.primaryComposite_, this.advancedComposite_, this.properties_, 6));
                        widgets2 = this.widgets_;
                    } else {
                        layout.numColumns = factory.calculateMaxRowLength(this.properties_, 2);
                        widgets2 = factory.generateWidgets(this.primaryComposite_, null, this.properties_, 2);
                        this.widgets_.addAll(widgets2);
                    }
                    this.addListeners(widgets2);
                    int i = 0;
                    while (i < widgets2.size()) {
                        this.changeWidgetLabelFont(widgets2.get(i));
                        ++i;
                    }
                } else if (this.needToUpdateAdvancedComposite_ && this.advancedComposite_ != null) {
                    widgets = factory.generateWidgets(null, this.advancedComposite_, this.properties_, 4);
                    this.addListeners((ArrayList<PropertyUIWidget>)widgets);
                    int i = 0;
                    while (i < ((ArrayList)widgets).size()) {
                        this.widgets_.add((PropertyUIWidget)((ArrayList)widgets).get(i));
                        ++i;
                    }
                }
            }
        } else if (this.primaryComposite_ != null) {
            if (this.advancedComposite_ != null && this.needToUpdateAdvancedComposite_) {
                this.disposeAdvancedArea(showAll);
            }
            if (this.needToUpdatePrimaryComposite_) {
                int i;
                Control[] children = this.primaryComposite_.getChildren();
                int i2 = 0;
                while (i2 < children.length) {
                    children[i2].dispose();
                    ++i2;
                }
                GridLayout layout = (GridLayout)this.primaryComposite_.getLayout();
                layout.numColumns = factory.calculateMaxRowLength(this.properties_, 2);
                ArrayList<PropertyUIWidget> widgets = factory.generateWidgets(this.primaryComposite_, null, this.properties_, 2);
                this.addListeners(widgets);
                if (this.needToUpdateAdvancedComposite_) {
                    i = 0;
                    while (i < this.widgets_.size()) {
                        this.widgets_.get(i).dispose();
                        ++i;
                    }
                    this.widgets_.clear();
                }
                i = 0;
                while (i < widgets.size()) {
                    this.widgets_.add(widgets.get(i));
                    ++i;
                }
            }
        }
        this.cleanWidgets(this.widgets_);
        if (this.primaryComposite_ != null && this.needToUpdatePrimaryComposite_) {
            GridData gd = (GridData)this.primaryComposite_.getLayoutData();
            gd.grabExcessVerticalSpace = PropertyUIHelper.instance().containsExpandableProperties(this.properties_, this.uiInfo_.rootGroupingStyle_ != 2 && this.uiInfo_.rootGroupingStyle_ != 3);
            this.primaryComposite_.layout();
        }
        if (this.composite_ != null) {
            Composite container = this.composite_;
            while (container != null) {
                container.layout();
                Point p = container.computeSize(-1, -1);
                container.setSize(p.x, p.y);
                Composite parent = container.getParent();
                if (parent != null && parent instanceof ScrolledComposite) {
                    if (!((ScrolledComposite)parent).getContent().equals(container)) break;
                    if (parent instanceof SharedScrolledComposite) {
                        ((SharedScrolledComposite)parent).reflow(true);
                        break;
                    }
                    ((ScrolledComposite)parent).setMinSize(p);
                    break;
                }
                container = parent;
            }
        }
        this.updateParentWidgetList();
        this.redrawingComposite_ = false;
    }

    protected void updatePrimaryArea(boolean showAdvanced) {
        if (showAdvanced) {
            ExpandableComposite container = this.getPropertyUIFactory().createExpandableArea(this.composite_, "Primary properties", 2, true);
            container.moveAbove((Control)this.primaryComposite_);
            this.primaryComposite_.setParent((Composite)container);
            container.setClient((Control)this.primaryComposite_);
        } else {
            Composite container = this.primaryComposite_.getParent();
            this.primaryComposite_.setParent(this.composite_);
            this.primaryComposite_.moveAbove((Control)container);
            this.primaryComposite_.setVisible(true);
            container.dispose();
        }
    }

    protected void updateParentWidgetList() {
        ArrayList<PropertyUIWidget> globalWidgets;
        if (this.parentUIComposite_ != null && !(globalWidgets = this.parentUIComposite_.getUIWidgets()).isEmpty()) {
            ArrayList<PropertyUIWidget> newWidgets = new ArrayList<PropertyUIWidget>();
            int i = 0;
            while (i < this.widgets_.size()) {
                PropertyUIWidget widget = this.widgets_.get(i);
                if (globalWidgets.indexOf(widget) == -1) {
                    newWidgets.add(widget);
                }
                ++i;
            }
            int index = -1;
            int i2 = 0;
            while (i2 < globalWidgets.size()) {
                PropertyUIWidget widget = globalWidgets.get(i2);
                IPropertyDescriptor parentPD = widget.getProperty().getParent();
                if (parentPD != null && parentPD.equals(this.properties_)) {
                    if (index == -1) {
                        index = i2;
                    }
                    globalWidgets.remove(i2--);
                } else if (widget.isDisposed()) {
                    globalWidgets.remove(i2--);
                }
                ++i2;
            }
            if (index == -1) {
                index = globalWidgets.size();
            }
            i2 = 0;
            while (i2 < this.widgets_.size()) {
                globalWidgets.add(index++, this.widgets_.get(i2));
                ++i2;
            }
            if (!newWidgets.isEmpty()) {
                this.parentUIComposite_.addListeners(newWidgets);
            }
            this.parentUIComposite_.updateParentWidgetList();
        }
    }

    protected void removeWidgetFromList(PropertyUIWidget widget) {
        this.widgets_.remove(widget);
        if (this.parentUIComposite_ != null) {
            this.parentUIComposite_.removeWidgetFromList(widget);
        }
    }

    protected void removeWidgetsFromList(ArrayList<PropertyUIWidget> widgets) {
        this.widgets_.removeAll(widgets);
        if (this.parentUIComposite_ != null) {
            this.parentUIComposite_.removeWidgetsFromList(widgets);
        }
    }

    int calculateMaxRowLength(PropertyUIFactory factory, IPropertyGroup properties) {
        PropertyUIHelper helper = PropertyUIHelper.instance();
        int no = helper.getNumberOfProperties(properties, false, 0);
        if (no < 1) {
            return 0;
        }
        int maxLength = 0;
        IPropertyDescriptor[] children = properties.getProperties();
        int i = 0;
        while (i < children.length) {
            IPropertyDescriptor ipd = children[i];
            int curRowLength = 0;
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
                if ("com.ibm.propertygroup.ui.PropertyUINestedLayoutID".equals(ipd.getID())) {
                    curRowLength = 1;
                } else if (this.uiInfo_.nestedGroupStyle_ == 1) {
                    no = helper.getNumberOfProperties((IPropertyGroup)ipd, false, 0);
                    if (no > 0) {
                        curRowLength = factory.calculateMaxRowLength((IPropertyGroup)ipd, 6);
                    }
                } else {
                    curRowLength = factory.needToPeelPropertyGroup(properties) ? factory.calculateMaxRowLength((IPropertyGroup)ipd, 6) : 1;
                }
            } else {
                curRowLength = factory.calculateMaxRowLength(ipd, 6);
            }
            maxLength = Math.max(maxLength, curRowLength);
            ++i;
        }
        return maxLength;
    }

    private void reserveListener(String type, EventListener listener) {
        ArrayList<EventListener> list = this.listeners_.get(type);
        if (list == null) {
            list = new ArrayList(3);
            this.listeners_.put(type, list);
        }
        if (list.indexOf(listener) == -1) {
            list.add(listener);
        }
    }

    private void removeListener(String type, EventListener listener) {
        ArrayList<EventListener> list = this.listeners_.get(type);
        if (list != null) {
            list.remove(listener);
        }
    }

    protected void addListeners(ArrayList<PropertyUIWidget> widgets) {
        if (widgets == null) {
            return;
        }
        int i = 0;
        while (i < widgets.size()) {
            PropertyUIWidget widget = widgets.get(i);
            Enumeration<String> enumeration = this.listeners_.keys();
            while (enumeration.hasMoreElements()) {
                String type = enumeration.nextElement();
                ArrayList<EventListener> list = this.listeners_.get(type);
                int j = 0;
                while (j < list.size()) {
                    widget.addPropertyUIListener(type, list.get(j));
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void addListeners(PropertyUIWidget widget) {
        if (widget == null) {
            return;
        }
        Enumeration<String> enumeration = this.listeners_.keys();
        while (enumeration.hasMoreElements()) {
            String type = enumeration.nextElement();
            ArrayList<EventListener> list = this.listeners_.get(type);
            int j = 0;
            while (j < list.size()) {
                widget.addPropertyUIListener(type, list.get(j));
                ++j;
            }
        }
    }

    private void cleanWidgets(ArrayList<PropertyUIWidget> widgets) {
        if (widgets == null) {
            return;
        }
        int i = 0;
        while (i < widgets.size()) {
            PropertyUIWidget widget = widgets.get(i);
            Control[] controls = widget.getUIControls();
            int j = 0;
            while (j < controls.length) {
                if (controls[j].isDisposed()) {
                    widget.dispose();
                    widgets.remove(i);
                    --i;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void addListenerToPropertyGroups(IPropertyGroup properties, int level) {
        PropertyUIFactory factory;
        IPropertyDescriptor[] propList = properties.getProperties();
        if (properties == this.properties_ && level == 0 && propList.length == 1 && (factory = this.getPropertyUIFactory()).needToPeelPropertyGroup(properties)) {
            --level;
        }
        if (this.propertyGroupLevelMapping_.get(properties) == null) {
            properties.addPropertyChangeListener((IPropertyChangeListener)this);
            this.propertyGroupLevelMapping_.put(properties, new Integer(level));
        }
        int i = 0;
        while (i < propList.length) {
            IPropertyDescriptor ipd = propList[i];
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd) && !"com.ibm.propertygroup.ui.PropertyUINestedLayoutID".equals(ipd.getID())) {
                if (level == 0 && this.uiInfo_.rootGroupingStyle_ != 0 && (PropertyUtil.isAdvancedPropertyGroup((IPropertyGroup)ipd) || this.uiInfo_.rootGroupingStyle_ == 2 || this.uiInfo_.rootGroupingStyle_ == 3)) {
                    --level;
                }
                this.addListenerToPropertyGroups((IPropertyGroup)ipd, level + 1);
            }
            ++i;
        }
    }

    private void removeListenerFromPropertyGroups(IPropertyGroup properties) {
        IPropertyDescriptor[] propList = properties.getProperties();
        properties.removePropertyChangeListener((IPropertyChangeListener)this);
        this.propertyGroupLevelMapping_.remove(properties);
        int i = 0;
        while (i < propList.length) {
            IPropertyDescriptor ipd = propList[i];
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
                this.removeListenerFromPropertyGroups((IPropertyGroup)ipd);
            }
            ++i;
        }
    }

    private void relayoutParents(Composite comp, boolean changeColumnNo) {
        if (comp == null || comp.isDisposed()) {
            return;
        }
        if (changeColumnNo) {
            this.changeColumnNumber(comp);
        }
        comp.layout();
        Composite parent = comp.getParent();
        if (parent != null) {
            if (parent instanceof PropertyUIScrollableComposite) {
                ((PropertyUIScrollableComposite)parent).reflow(true);
            } else if (parent instanceof ScrolledComposite) {
                Point p = comp.computeSize(-1, -1);
                comp.setSize(p.x, p.y);
                ((ScrolledComposite)parent).setMinSize(p);
                parent.layout();
            } else {
                this.relayoutParents(parent, false);
            }
        }
    }

    private UIPositionInfo propertyArrayRemoveProperties(IPropertyDescriptor[] properties, boolean removeSeparators, int level) {
        if ((properties = this.removeNestedLayoutProperties(properties)) != null) {
            UIPositionInfo info = this.getPropertyDescriptorUIPosition(properties, 0);
            Composite container = info.container_;
            if (container != null) {
                Control[] removingControls = container.getChildren();
                this.getPropertyGroupSeparators(info, this.getShowingPropertyDescriptor(properties));
                int startIndex = info.startUIPosition_;
                int endIndex = info.endUIPosition_;
                this.getPropertyGroupSeparators(info, info.endUIPosition_ + 2, level);
                if (removeSeparators) {
                    startIndex = info.startUIPosition_;
                    endIndex = info.endUIPosition_;
                } else {
                    info.startUIPosition_ = startIndex;
                    info.endUIPosition_ = endIndex;
                }
                int i = info.startUIPosition_;
                while (i <= info.endUIPosition_) {
                    removingControls[i].dispose();
                    ++i;
                }
                endIndex = info.endWidgetIndex_;
                i = info.startWidgetIndex_;
                while (i <= endIndex) {
                    this.widgets_.get(i).dispose();
                    this.widgets_.remove(i);
                    --endIndex;
                    --i;
                    ++i;
                }
            }
            return info;
        }
        return new UIPositionInfo();
    }

    private IPropertyDescriptor[] removeNestedLayoutProperties(IPropertyDescriptor[] properties) {
        if (this.uiInfo_.nestedLayoutInfo_ == null || this.uiInfo_.nestedLayoutInfo_.isEmpty()) {
            return properties;
        }
        ArrayList<IPropertyDescriptor> newList = new ArrayList<IPropertyDescriptor>();
        int i = 0;
        while (i < properties.length) {
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i])) {
                PropertyUINestedLayoutInfoWrapper found = this.getNestedLayoutInfoWrapper((IPropertyGroup)properties[i]);
                if (found != null) {
                    found.removeNestedLayoutArea();
                    this.uiInfo_.nestedLayoutInfo_.remove(found);
                }
            } else {
                newList.add(properties[i]);
            }
            ++i;
        }
        if (!newList.isEmpty()) {
            IPropertyDescriptor[] ipds = new IPropertyDescriptor[newList.size()];
            newList.toArray(ipds);
            return ipds;
        }
        return null;
    }

    private PropertyUINestedLayoutInfoWrapper getNestedLayoutInfoWrapper(IPropertyGroup pg) {
        if (!"com.ibm.propertygroup.ui.PropertyUINestedLayoutID".equals(pg.getID())) {
            return null;
        }
        if (this.uiInfo_.nestedLayoutInfo_ == null || this.uiInfo_.nestedLayoutInfo_.isEmpty()) {
            return null;
        }
        int j = 0;
        while (j < this.uiInfo_.nestedLayoutInfo_.size()) {
            PropertyUINestedLayoutInfoWrapper wrapper = this.uiInfo_.nestedLayoutInfo_.get(j);
            if (wrapper.samePropertyGroup(pg)) {
                return wrapper;
            }
            ++j;
        }
        return null;
    }

    private void propertyGroupGenerateProperties(Composite parent, UIPositionInfo info, IPropertyDescriptor[] properties, IPropertyGroup group) {
        if (parent == null || properties == null || properties.length < 1) {
            return;
        }
        PropertyUIFactory factory = this.getPropertyUIFactory();
        GridLayout layout = (GridLayout)parent.getLayout();
        int colNo = layout.numColumns;
        int type = this.getShowingStyle();
        int newColNo = this.uiInfo_.nestedGroupStyle_ == 0 ? 1 : factory.calculateMaxRowLength(group, type);
        if (newColNo > colNo) {
            colNo = newColNo;
        }
        if (parent.getChildren().length < 1) {
            layout.numColumns = colNo;
        }
        int position = info.startWidgetIndex_;
        Control baseControl = null;
        Control[] controls = parent.getChildren();
        if (info.startUIPosition_ < controls.length) {
            baseControl = controls[info.startUIPosition_];
        }
        factory.setNestedLevel(this.propertyGroupLevelMapping_.get(group));
        this.generatePropertiesUI(factory, parent, position, baseControl, true, colNo, properties);
    }

    private void getPropertyGroupSeparators(UIPositionInfo info, IPropertyDescriptor property) {
        int level = this.checkNestedPropertyGroupLevel(property);
        if (level > 0 && info.startUIPosition_ > 0) {
            Composite container = info.container_;
            Control[] removingControls = container.getChildren();
            int startIndex = info.startUIPosition_;
            int i = 0;
            while (i < level) {
                Control control;
                if ((control = removingControls[--startIndex]) instanceof Composite) {
                    Object data = control.getData();
                    if (data != null && data.equals("PropertyGroupSeparatorWidget") && control.getParent().equals(container)) {
                        --info.startUIPosition_;
                    } else {
                        if (i == 0) break;
                        ++info.startUIPosition_;
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private int checkNestedPropertyGroupLevel(IPropertyDescriptor property) {
        int level = 0;
        if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)property)) {
            IPropertyDescriptor ipd = this.getShowingPropertyDescriptor(((IPropertyGroup)property).getProperties());
            if (ipd != null && PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
                level = this.checkNestedPropertyGroupLevel(ipd);
            }
            ++level;
        }
        return level;
    }

    private IPropertyDescriptor getShowingPropertyDescriptor(IPropertyDescriptor[] properties) {
        int i = 0;
        while (i < properties.length) {
            if (!(PropertyUtil.isHiddenPropertyDescriptor(properties[i]) || !this.isShowingAll() && PropertyUtil.isAdvancedPropertyDescriptor(properties[i]))) {
                return properties[i];
            }
            ++i;
        }
        return null;
    }

    private void changeColumnNumber(Composite parent) {
        ArrayList<PropertyUIWidget> uiWidgets = new ArrayList<PropertyUIWidget>(6);
        int i = 0;
        while (i < this.widgets_.size()) {
            PropertyUIWidget widget = this.widgets_.get(i);
            Composite container = widget.getWidgetContainer();
            if (container.equals(parent)) {
                uiWidgets.add(widget);
            }
            ++i;
        }
        int maxLength = 0;
        int i2 = 0;
        while (i2 < uiWidgets.size()) {
            IPropertyDescriptor ipd = ((PropertyUIWidget)uiWidgets.get(i2)).getProperty();
            int curRowLength = 0;
            if (!PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
                curRowLength = this.getPropertyUIFactory().calculateMaxRowLength(ipd, 6);
            }
            maxLength = Math.max(maxLength, curRowLength);
            ++i2;
        }
        GridLayout layout = (GridLayout)parent.getLayout();
        if (maxLength != layout.numColumns && maxLength > 0) {
            layout.numColumns = maxLength;
            int i3 = 0;
            while (i3 < uiWidgets.size()) {
                PropertyUIWidget widget = (PropertyUIWidget)uiWidgets.get(i3);
                widget.changeColumnNumber(maxLength);
                ++i3;
            }
            Control[] controls = parent.getChildren();
            int i4 = 0;
            while (i4 < controls.length) {
                Object data = controls[i4].getData();
                if (data != null) {
                    GridData gd = (GridData)controls[i4].getLayoutData();
                    if (data.equals("PropertyGroupSeparatorWidget")) {
                        gd.horizontalSpan = maxLength;
                        gd.grabExcessHorizontalSpace = maxLength <= 2;
                    } else if (data.equals("PropertyUINestedLayoutWidget")) {
                        gd.horizontalSpan = maxLength;
                    } else if (controls[i4] instanceof Section) {
                        gd.horizontalSpan = maxLength;
                    }
                }
                ++i4;
            }
        }
    }

    private PropertyUIFactory getPropertyUIFactory() {
        if (this.factory_ == null) {
            this.factory_ = PropertyUIFactory.instance();
        }
        this.factory_.setPropertyUIFactoryInfo(this.uiInfo_);
        return this.factory_;
    }

    private void generatePropertiesUI(PropertyUIFactory factory, Composite parent, int position, Control baseControl, boolean moveAbove, int colNo, IPropertyDescriptor[] properties) {
        IPropertyDescriptor cParent;
        ArrayList<PropertyUIWidget> generatedWidgets = new ArrayList<PropertyUIWidget>();
        Object baseWidget = null;
        if (baseControl != null) {
            baseWidget = baseControl;
        } else if (position > -1 && position < this.widgets_.size()) {
            baseWidget = this.widgets_.get(position);
        }
        int style = this.getShowingStyle();
        ArrayList<Object> movingWidgets = new ArrayList<Object>(6);
        boolean isPropertyGroup = false;
        if (!PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[0]) && position > -1 && position < this.widgets_.size() && !(cParent = properties[0].getParent()).equals(this.properties_)) {
            IPropertyDescriptor pParent = this.widgets_.get(position).getProperty().getParent();
            int level = 0;
            while (pParent != null) {
                if (pParent.equals(cParent)) break;
                ++level;
                pParent = pParent.getParent();
            }
            if (level != 0 && cParent.equals(pParent)) {
                isPropertyGroup = true;
            }
        }
        int i = 0;
        while (i < properties.length) {
            int beforeGenerating = parent.getChildren().length;
            ArrayList<PropertyUIWidget> widgets = factory.generatePropertyDescriptorUI(parent, properties[i], colNo, true, style, isPropertyGroup);
            if (widgets != null && widgets.size() >= 1) {
                isPropertyGroup = PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i]);
                boolean addListener = true;
                int j = 0;
                while (j < widgets.size()) {
                    PropertyUIWidget widget = widgets.get(j);
                    if (widget != null) {
                        if (moveAbove) {
                            this.widgets_.add(position, widget);
                        } else {
                            this.widgets_.add(position + 1, widget);
                        }
                        ++position;
                        if (addListener) {
                            generatedWidgets.add(widget);
                        }
                        this.changeWidgetLabelFont(widget);
                    }
                    ++j;
                }
                movingWidgets.clear();
                Control[] controls = parent.getChildren();
                int j2 = beforeGenerating;
                while (j2 < controls.length) {
                    movingWidgets.add(controls[j2]);
                    ++j2;
                }
                this.moveUIWidgets(movingWidgets, baseWidget, moveAbove);
            }
            ++i;
        }
        this.addListeners(generatedWidgets);
    }

    protected void changeWidgetLabelFont(PropertyUIWidget widget) {
        Control[] controls;
        if (PropertyUtil.isExpert(widget.getProperty()) && (controls = widget.getUIControls()) != null && controls.length > 0) {
            Control[] labels;
            Composite container;
            Composite parent = container = controls[0].getParent();
            boolean onPrimary = false;
            while (parent != null && !onPrimary) {
                if (parent.equals(this.primaryComposite_)) {
                    onPrimary = true;
                }
                parent = parent.getParent();
            }
            if (onPrimary && (labels = widget.getWidgetLabelControls()) != null) {
                int i = 0;
                while (i < labels.length) {
                    Button button;
                    String text;
                    if (this.italicFont_ == null) {
                        this.italicFont_ = labels[i].getFont();
                        FontData newFontData = this.italicFont_.getFontData()[0];
                        newFontData.setStyle(2);
                        this.italicFont_ = new Font((Device)labels[i].getDisplay(), newFontData);
                    }
                    labels[i].setFont(this.italicFont_);
                    if (widget instanceof PropertyUIWidgetCheckBox && (text = (button = ((PropertyUIWidgetCheckBox)widget).getCheckBox()).getText()) != null && text.length() > 0) {
                        button.setText(new StringBuffer(button.getText()).append(" ").toString());
                    }
                    ++i;
                }
            }
        }
    }

    void moveUIWidgets(ArrayList<Object> uiObjects, Object baseObject, boolean moveAbove) {
        if (uiObjects == null || uiObjects.size() < 1 || baseObject == null) {
            return;
        }
        Control baseControl = null;
        if (baseObject instanceof PropertyUIWidget) {
            Control[] controls = ((PropertyUIWidget)baseObject).getUIFirstLevelControls();
            if (controls != null && controls.length > 0) {
                baseControl = moveAbove ? controls[0] : controls[controls.length - 1];
            }
        } else if (baseObject instanceof Control) {
            baseControl = (Control)baseObject;
        }
        if (baseControl == null) {
            return;
        }
        if (moveAbove) {
            int i = 0;
            while (i < uiObjects.size()) {
                Object uiObject = uiObjects.get(i);
                if (uiObject instanceof PropertyUIWidget) {
                    ((PropertyUIWidget)uiObject).moveWidget(baseControl, moveAbove);
                } else if (uiObject instanceof Control) {
                    ((Control)uiObject).moveAbove(baseControl);
                }
                ++i;
            }
        } else {
            int i = uiObjects.size() - 1;
            while (i >= 0) {
                Object uiObject = uiObjects.get(i);
                if (uiObject instanceof PropertyUIWidget) {
                    ((PropertyUIWidget)uiObject).moveWidget(baseControl, moveAbove);
                } else if (uiObject instanceof Control) {
                    ((Control)uiObject).moveBelow(baseControl);
                }
                --i;
            }
        }
    }

    private int[] getPropertyDescriptorUIWidgetIndex(IPropertyDescriptor property) {
        int[] index = new int[]{-1, -1};
        if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)property)) {
            return this.getPropertyArrayUIWidgetIndex(((IPropertyGroup)property).getProperties());
        }
        int i = 0;
        while (i < this.widgets_.size()) {
            PropertyUIWidget widget = this.widgets_.get(i);
            if (property.equals(widget.getProperty()) && !widget.disposed_) {
                index[0] = index[1] = i;
                return index;
            }
            ++i;
        }
        return index;
    }

    private int[] getPropertyArrayUIWidgetIndex(IPropertyDescriptor[] properties) {
        int[] index = new int[]{-1, -1};
        int i = 0;
        while (i < properties.length) {
            IPropertyDescriptor ipd = properties[i];
            int[] idx = PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd) ? this.getPropertyArrayUIWidgetIndex(((IPropertyGroup)ipd).getProperties()) : this.getPropertyDescriptorUIWidgetIndex(ipd);
            if (index[0] == -1 && idx[0] != -1) {
                index[0] = idx[0];
            }
            if (idx[1] != -1 && idx[1] > index[1]) {
                index[1] = idx[1];
            }
            ++i;
        }
        return index;
    }

    private UIPositionInfo getPropertyDescriptorUIPosition(Object descriptor, int start) {
        UIPositionInfo info = new UIPositionInfo();
        int[] position = new int[]{-1, -1};
        Composite container = null;
        IPropertyDescriptor[] properties = null;
        if (descriptor instanceof IPropertyDescriptor) {
            position = this.getPropertyDescriptorUIWidgetIndex((IPropertyDescriptor)descriptor);
            properties = PropertyHelper.isPropertyGroup((IPropertyDescriptor)((IPropertyDescriptor)descriptor)) ? ((IPropertyGroup)descriptor).getProperties() : new IPropertyDescriptor[]{(IPropertyDescriptor)descriptor};
        } else if (descriptor instanceof IPropertyDescriptor[]) {
            position = this.getPropertyArrayUIWidgetIndex((IPropertyDescriptor[])descriptor);
            properties = (IPropertyDescriptor[])descriptor;
        }
        info.startWidgetIndex_ = position[0];
        info.endWidgetIndex_ = position[1];
        if (position[0] != -1) {
            Composite ce;
            Composite cs;
            if (this.uiInfo_.nestedGroupStyle_ == 0) {
                cs = this.getPropertyContainer(this.widgets_.get(position[0]), properties);
                ce = this.getPropertyContainer(this.widgets_.get(position[1]), properties);
            } else {
                cs = this.widgets_.get(position[0]).getWidgetContainer();
                ce = this.widgets_.get(position[1]).getWidgetContainer();
            }
            container = this.getPropertyGroupContainer(cs, ce);
            ArrayList<Control> uiControls = new ArrayList<Control>(6);
            Control[] controls = container.getChildren();
            Control[] generatedControls = this.widgets_.get(position[0]).getUIControlsOnComposite(container);
            uiControls.addAll(Arrays.asList(generatedControls));
            if (position[0] != position[1]) {
                generatedControls = this.widgets_.get(position[1]).getUIControlsOnComposite(container);
                uiControls.addAll(Arrays.asList(generatedControls));
            }
            position[1] = -1;
            position[0] = -1;
            int i = start;
            while (i < controls.length && uiControls.size() > 0) {
                int index = uiControls.indexOf(controls[i]);
                if (index != -1) {
                    if (position[0] == -1) {
                        position[0] = position[1] = i;
                    } else {
                        position[0] = Math.min(position[0], i);
                        position[1] = Math.max(position[1], i);
                    }
                    uiControls.remove(index);
                }
                ++i;
            }
        }
        info.startUIPosition_ = position[0];
        info.endUIPosition_ = position[1];
        info.container_ = container;
        return info;
    }

    private Composite getPropertyGroupContainer(Composite startPositionContainer, Composite endPositionContainer) {
        if (startPositionContainer == endPositionContainer) {
            return endPositionContainer;
        }
        Composite sParent = startPositionContainer;
        while (sParent != null) {
            Composite eParent = endPositionContainer;
            while (eParent != null) {
                if (sParent == eParent) {
                    return eParent;
                }
                eParent = eParent.getParent();
            }
            sParent = sParent.getParent();
        }
        return endPositionContainer;
    }

    private Composite getPropertyContainer(PropertyUIWidget widget, IPropertyDescriptor[] properties) {
        Composite composite = widget.getWidgetContainer();
        IPropertyDescriptor ipd = widget.getProperty();
        int level = -1;
        int i = 0;
        while (i < properties.length) {
            level = PropertyUIHelper.instance().getPropertyNestedLevel(properties[i], ipd, 0);
            if (level > -1) break;
            ++i;
        }
        while (level > 0 && composite != null) {
            composite = composite.getParent();
            --level;
        }
        return composite;
    }

    private void getPropertyGroupSeparators(UIPositionInfo info, int maxPosition, int level) {
        Control control;
        Object data;
        Control control2;
        Composite container = info.container_;
        Control[] removingControls = container.getChildren();
        int startIndex = info.startUIPosition_--;
        int indentValue = -1;
        if (startIndex > 0 && (control2 = removingControls[startIndex - 1]) instanceof Composite && (data = control2.getData()) != null && data.equals("PropertyGroupSeparatorWidget") && control2.getParent().equals(container)) {
            indentValue = ((GridData)control2.getLayoutData()).horizontalIndent;
        }
        if (indentValue == -1 && this.uiInfo_.nestedGroupStyle_ == 1 && !this.uiInfo_.genSeparatorForNoDNamePG_ && level > -1) {
            indentValue = this.uiInfo_.indent_ * (level - 1);
        }
        int endIndex = info.endUIPosition_ + 1;
        if (indentValue != -1 && endIndex < maxPosition && endIndex < removingControls.length && (control = removingControls[endIndex]) instanceof Label) {
            Object data2 = control.getData();
            int indentTemp = ((GridData)control.getLayoutData()).horizontalIndent;
            if (data2 != null && data2.equals("PropertyGroupSeparatorWidget") && indentValue == indentTemp) {
                ++info.endUIPosition_;
            }
        }
    }

    private int getShowingStyle() {
        if (this.advancedButton_ == null && this.expandableComposite_ == null) {
            if (this.uiInfo_.showAll_) {
                return 6;
            }
            return 2;
        }
        if (!this.isShowingAll()) {
            return 2;
        }
        return 6;
    }

    private boolean checkRedrawStyle(IPropertyGroup properties, int propertyChangeType, Object newValue, Object oldValue) {
        switch (propertyChangeType) {
            case 6: {
                int gno = PropertyUIHelper.instance().getNumberOfProperties(properties, false, 0);
                int pno = PropertyUIHelper.instance().getNumberOfProperties((IPropertyDescriptor)newValue, false);
                return gno == pno && pno != 0;
            }
            case 9: {
                IPropertyDescriptor parent = properties.getParent();
                if (parent == null || parent.equals(this.properties_) || !PropertyHelper.isPropertyGroup((IPropertyDescriptor)parent)) {
                    return false;
                }
                int gno = PropertyUIHelper.instance().getNumberOfProperties((IPropertyGroup)parent, false, 0);
                int pno = PropertyUIHelper.instance().getNumberOfProperties((IPropertyDescriptor[])oldValue, false);
                return gno == 0 && pno != 0;
            }
            case 7: {
                int gno = PropertyUIHelper.instance().getNumberOfProperties(properties, false, 0);
                int pno = PropertyUIHelper.instance().getNumberOfProperties((IPropertyDescriptor)oldValue, false);
                return gno == 0 && (pno != 0 || PropertyUIHelper.instance().getNumberOfProperties(properties, true, 0) < 1);
            }
            case 8: {
                int nno = PropertyUIHelper.instance().getNumberOfProperties((IPropertyDescriptor[])newValue, false);
                int ono = PropertyUIHelper.instance().getNumberOfProperties((IPropertyDescriptor[])oldValue, false);
                return (nno != 0 || ono != 0) && (nno == 0 || ono == 0);
            }
        }
        return false;
    }

    private boolean needRedrawForEmptyPropertyGroup(IPropertyGroup pg, int pcType, Object newValue, Object oldValue) {
        PropertyUIHelper helper = PropertyUIHelper.instance();
        switch (pcType) {
            case 6: {
                IPropertyDescriptor[] properties;
                if (newValue instanceof IPropertyDescriptor[]) {
                    IPropertyDescriptor[] properties2 = pg.getProperties();
                    IPropertyDescriptor[] newProperties = (IPropertyDescriptor[])newValue;
                    int no = 0;
                    if (helper.getNumberOfProperties(properties2, true) != helper.getNumberOfProperties(newProperties, true)) break;
                    int i = 0;
                    while (i < properties2.length) {
                        if (!PropertyUtil.isHidden(properties2[i])) {
                            int j = 0;
                            while (j < newProperties.length) {
                                if (!PropertyUtil.isHidden(newProperties[j]) && newProperties[j].equals(properties2[i])) {
                                    ++no;
                                    break;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    if (no != properties2.length) break;
                    return true;
                }
                if (!(newValue instanceof IPropertyDescriptor) || helper.getNumberOfProperties(properties = pg.getProperties(), true) != 1) break;
                int i = 0;
                while (i < properties.length) {
                    if (!PropertyUtil.isHidden(properties[i]) && properties[i].equals(newValue)) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
            case 8: {
                if (oldValue != null && (!(oldValue instanceof IPropertyDescriptor[]) || helper.getNumberOfProperties((IPropertyDescriptor[])oldValue, true) >= 1)) break;
                return newValue != null && (!(newValue instanceof IPropertyDescriptor[]) || helper.getNumberOfProperties((IPropertyDescriptor[])newValue, true) >= 1);
            }
        }
        return false;
    }

    private boolean needUpdateComposite(int pcType, Object newValue, Object oldValue) {
        PropertyUIHelper helper = PropertyUIHelper.instance();
        switch (pcType) {
            case 6: {
                if (helper.getNumberOfProperties((IPropertyDescriptor)newValue, true) >= 1) break;
                return false;
            }
            case 9: {
                if (helper.getNumberOfProperties((IPropertyDescriptor[])oldValue, true) >= 1) break;
                return false;
            }
            case 7: {
                if (helper.getNumberOfProperties((IPropertyDescriptor)oldValue, true) >= 1) break;
                return false;
            }
            case 8: {
                if (helper.getNumberOfProperties((IPropertyDescriptor[])newValue, true) >= 1 || helper.getNumberOfProperties((IPropertyDescriptor[])oldValue, true) >= 1) break;
                return false;
            }
        }
        return true;
    }

    private void updateListener(Object newValue, Object oldValue, int level) {
        int i;
        IPropertyDescriptor[] properties;
        if (newValue != null) {
            if (newValue instanceof IPropertyDescriptor) {
                if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)((IPropertyDescriptor)newValue)) && !"com.ibm.propertygroup.ui.PropertyUINestedLayoutID".equals(((IPropertyDescriptor)newValue).getID())) {
                    this.addListenerToPropertyGroups((IPropertyGroup)newValue, level + 1);
                }
            } else if (newValue instanceof IPropertyDescriptor[]) {
                properties = (IPropertyDescriptor[])newValue;
                i = 0;
                while (i < properties.length) {
                    if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i]) && !"com.ibm.propertygroup.ui.PropertyUINestedLayoutID".equals(properties[i].getID())) {
                        this.addListenerToPropertyGroups((IPropertyGroup)properties[i], level + 1);
                    }
                    ++i;
                }
            }
        }
        if (oldValue != null) {
            if (oldValue instanceof IPropertyDescriptor) {
                if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)((IPropertyDescriptor)oldValue))) {
                    this.removeListenerFromPropertyGroups((IPropertyGroup)oldValue);
                }
            } else if (oldValue instanceof IPropertyDescriptor[]) {
                properties = (IPropertyDescriptor[])oldValue;
                i = 0;
                while (i < properties.length) {
                    if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i])) {
                        this.removeListenerFromPropertyGroups((IPropertyGroup)properties[i]);
                    }
                    ++i;
                }
            }
        }
    }

    private int checkExpertWidgets() {
        int status = 0;
        int i = 0;
        while (i < this.widgets_.size()) {
            PropertyUIWidget widget = this.widgets_.get(i);
            if (PropertyUtil.isExpert(widget.getProperty()) && widget.getStatus() == 4) {
                status = 4;
                break;
            }
            ++i;
        }
        return status;
    }

    private void disposeAdvancedArea(boolean showAll) {
        if (this.advancedComposite_ != null) {
            this.advancedComposite_.dispose();
            this.advancedComposite_ = null;
        }
        if (this.uiInfo_.showingAdvancedStyle_ == 1 && this.expandableComposite_ != null && this.expandableComposite_.getClient() != null) {
            if (this.blankComposite_ == null || this.blankComposite_.isDisposed()) {
                this.blankComposite_ = this.factory_.getUIFactory().createComposite((Composite)this.expandableComposite_, 0);
            }
            this.expandableComposite_.setClient((Control)this.blankComposite_);
        }
    }

    public class PropertyUIWidgetPG
    extends PropertyUIWidgetPropertyGroup {
        public PropertyUIWidgetPG(IPropertyGroup pro, IPropertyUIWidgetFactory factory) {
            super(pro, factory);
        }

        @Override
        public void changeColumnNumber(int newNumber) {
        }

        @Override
        public void createControl(Composite parent) {
        }

        @Override
        public Control getDefaultFocusControl() {
            return null;
        }

        @Override
        public Control[] getUIControls() {
            return null;
        }

        @Override
        public String getWidgetValue() {
            return null;
        }

        @Override
        public void setWidgetValue(String newValue) {
        }

        @Override
        public void update() {
        }

        @Override
        public void update(int propertyChangeType) {
        }

        public void firePropertyGroupUIChange(Object oldValue, Object newValue) {
            this.eventSender_.firePropertyUIChange(oldValue, newValue);
        }
    }

    private class UIPositionInfo {
        int startWidgetIndex_ = -1;
        int endWidgetIndex_ = -1;
        int startUIPosition_ = -1;
        int endUIPosition_ = -1;
        Composite container_ = null;

        private UIPositionInfo() {
        }
    }
}

