/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.wizards;

import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.ITableProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.common.SchemaTypeProperty;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.wizards.TablePropertyInputWizard_PropertiesPage;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class TablePropertyInputWizard
extends Wizard
implements INewWizard {
    protected TablePropertyInputWizard_PropertiesPage propertiesPage_;
    protected ISingleValuedProperty[] properties_;
    protected BasePropertyGroup propertiesWrapper_;
    protected Map propertyChangedInfo_;
    protected int type_ = 0;
    protected int modificationType_ = 0;
    protected Object[] pgContext_ = null;

    public TablePropertyInputWizard(ISingleValuedProperty[] properties, ITableProperty.ColumnDescriptor[] columns, Object[] context) throws CoreException, CloneNotSupportedException {
        this.setNeedsProgressMonitor(true);
        this.properties_ = properties;
        this.propertiesWrapper_ = new BasePropertyGroup("PropertiesWrapper", "", "");
        this.propertiesWrapper_.setPropertyGroupContext(context);
        int i = 0;
        while (i < properties.length) {
            ISingleValuedProperty isvp = (ISingleValuedProperty)properties[i].clone();
            String id = isvp.getID();
            String columnID = columns[i].getID();
            if ((id == null || id.length() < 1 || id.equals("DEFAULT_PROPERTY_IDENTIFIER")) && columnID != null && columnID.length() > 0 && !columnID.equals("DEFAULT_PROPERTY_IDENTIFIER")) {
                isvp.assignID(columns[i].getID());
            }
            this.propertiesWrapper_.addProperty((IPropertyDescriptor)isvp);
            ++i;
        }
        this.propertyChangedInfo_ = new HashMap(3);
    }

    public TablePropertyInputWizard(ISingleValuedProperty[] properties, ITableProperty.ColumnDescriptor[] columns, int type, Object[] context) throws CoreException, CloneNotSupportedException {
        this.setNeedsProgressMonitor(true);
        this.setShowingType(type);
        this.properties_ = properties;
        this.propertiesWrapper_ = new BasePropertyGroup("PropertiesWrapper", "", "");
        this.propertiesWrapper_.setPropertyGroupContext(context);
        this.pgContext_ = context;
        int i = 0;
        while (i < properties.length) {
            ISingleValuedProperty isvp = null;
            isvp = (ISingleValuedProperty)properties[i].clone();
            String id = isvp.getID();
            String columnID = columns[i].getID();
            if ((id == null || id.length() < 1 || id.equals("DEFAULT_PROPERTY_IDENTIFIER")) && columnID != null && columnID.length() > 0 && !columnID.equals("DEFAULT_PROPERTY_IDENTIFIER")) {
                isvp.assignID(columns[i].getID());
            }
            this.propertiesWrapper_.addProperty((IPropertyDescriptor)isvp);
            ++i;
        }
        this.propertyChangedInfo_ = new HashMap(3);
    }

    public void addPages() {
        this.propertiesPage_ = new TablePropertyInputWizard_PropertiesPage("com.ibm.propertygroup.ui.wizards.TablePropertyModificationWizard_PropertiesPage");
        this.propertiesPage_.setTitle(PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_TABLEPROPERTYMODIFICATION);
        this.propertiesPage_.setDescription(PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_TABLEPROPERTYMODIFICATION_DESC);
        this.addPage((IWizardPage)this.propertiesPage_);
    }

    public boolean performFinish() {
        if (this.propertiesPage_.isModified()) {
            int i = 0;
            while (i < this.properties_.length) {
                String name = this.properties_[i].getName();
                ISingleValuedProperty ipd = (ISingleValuedProperty)PropertyUtil.getProperty((IPropertyGroup)this.propertiesWrapper_, name);
                if (ipd != null) {
                    boolean needSetValue = false;
                    PropertyChangedInfo info = (PropertyChangedInfo)this.propertyChangedInfo_.get(ipd);
                    if (info != null) {
                        needSetValue = true;
                    }
                    if (needSetValue) {
                        try {
                            if (info != null) {
                                info.ipd_ = this.properties_[i];
                                info.oldValue_ = this.properties_[i].getValue();
                            }
                            this.properties_[i].setValue(ipd.getValue());
                            if (ipd instanceof SchemaTypeProperty) {
                                ((SchemaTypeProperty)this.properties_[i]).setLocation(((SchemaTypeProperty)ipd).getLocation());
                                ((SchemaTypeProperty)this.properties_[i]).setType(((SchemaTypeProperty)ipd).isType());
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                ++i;
            }
            this.pgContext_ = this.propertiesWrapper_.getPropertyGroupContext();
        }
        return true;
    }

    public void init(IWorkbench desktop, IStructuredSelection selection) {
        this.setWindowTitle(PropertyUIMessages.PROPERTY_UI_WIZARDS_WIN_TITLE_TABLEPROPERTYMODIFICATION);
    }

    public PropertyChangedInfo[] getPropertyChangedInfo() {
        PropertyChangedInfo[] info = new PropertyChangedInfo[this.propertyChangedInfo_.size()];
        this.propertyChangedInfo_.values().toArray(info);
        return info;
    }

    public void setShowingType(int newType) {
        this.type_ = newType;
    }

    protected void propertyIsModified(IPropertyDescriptor ipd, int status, String message, Object value) {
        PropertyChangedInfo info = (PropertyChangedInfo)this.propertyChangedInfo_.get(ipd);
        if (info != null) {
            info.status_ = status;
            info.message_ = message;
            info.value_ = value;
        } else {
            this.propertyChangedInfo_.put(ipd, new PropertyChangedInfo(ipd, status, message, value));
        }
    }

    protected boolean checkSameValues(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return true;
        }
        if (oldValue != null && oldValue.equals(newValue)) {
            return true;
        }
        return newValue != null && newValue.equals(oldValue);
    }

    public void setModificationType(int newType) {
        this.modificationType_ = newType;
    }

    public int getModificationType() {
        return this.modificationType_;
    }

    public Object[] getPgContext() {
        return this.pgContext_;
    }

    public class PropertyChangedInfo {
        public IPropertyDescriptor ipd_;
        public String message_;
        public int status_;
        public Object value_;
        public Object oldValue_;

        public PropertyChangedInfo(IPropertyDescriptor ipd, int status, String message, Object value) {
            this.ipd_ = ipd;
            this.message_ = message;
            this.status_ = status;
            this.value_ = value;
        }
    }
}

