/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.wizards;

import com.ibm.propertygroup.ui.internal.wizards.PropertyUIWizardBasePage;
import com.ibm.propertygroup.ui.listener.IPropertyUIChangeListener;
import com.ibm.propertygroup.ui.listener.IPropertyUIStatusChangedListener;
import com.ibm.propertygroup.ui.listener.PropertyUIChangeEvent;
import com.ibm.propertygroup.ui.listener.PropertyUIStatusChangedEvent;
import com.ibm.propertygroup.ui.utilities.PropertyUIComposite;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;

public abstract class PropertyUIWizardDynamicPage
extends PropertyUIWizardBasePage
implements IPropertyUIChangeListener,
IPropertyUIStatusChangedListener {
    protected PropertyUIComposite uiComposite_;

    public PropertyUIWizardDynamicPage(String name) {
        super(name);
    }

    @Override
    public void propertyUIChange(PropertyUIChangeEvent evt) {
        if (evt.getSource() instanceof PropertyUIWidget) {
            PropertyUIWidget widget = (PropertyUIWidget)evt.getSource();
            int status = widget.getStatus();
            if (status != 4) {
                this.setPageComplete(this.determinePageCompletion());
            } else {
                this.setErrorMessage(widget.getErrorMessage());
                this.setPageComplete(false);
            }
            this.isModified(true);
        }
    }

    @Override
    public void propertyUIStatusChanged(PropertyUIStatusChangedEvent evt) {
        if (evt.getSource() instanceof PropertyUIWidget) {
            IStatus status = evt.getStatus();
            if (status != null) {
                String errMsg = status.getMessage();
                int severity = status.getSeverity();
                if (severity == 4) {
                    this.setErrorMessage(errMsg);
                    this.setPageComplete(false);
                } else {
                    this.setPageComplete(this.determinePageCompletion());
                    if (severity != 0) {
                        if (this.getErrorMessage() != null) {
                            this.setErrorMessage(null);
                        }
                        this.setMessage(errMsg, 2);
                    }
                }
            } else {
                this.setPageComplete(this.determinePageCompletion());
            }
        }
    }

    public boolean determinePageCompletion() {
        this.hasMessage_ = false;
        boolean valid = this.validateWidgets(this.getUIWidgets(), true);
        if (valid) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            if (!this.hasMessage_ && this.getMessage() != null) {
                this.setMessage(null);
            }
        }
        return valid;
    }

    public boolean validateWidgets(ArrayList widgets, boolean setMessage) {
        if (widgets == null) {
            return true;
        }
        int i = 0;
        while (i < widgets.size()) {
            PropertyUIWidget widget = (PropertyUIWidget)widgets.get(i);
            int status = widget.getStatus();
            switch (status) {
                case 4: {
                    if (setMessage) {
                        this.setErrorMessage(widget.getErrorMessage());
                    }
                    return false;
                }
                case 2: {
                    if (this.hasMessage_ || !setMessage) break;
                    this.setMessage(widget.getErrorMessage(), 2);
                    this.hasMessage_ = true;
                    break;
                }
                case 1: {
                    if (this.hasMessage_ || !setMessage) break;
                    this.setMessage(widget.getErrorMessage(), 1);
                    this.hasMessage_ = true;
                    break;
                }
            }
            ++i;
        }
        return true;
    }

    public void dispose() {
        super.dispose();
        if (this.uiComposite_ != null) {
            this.uiComposite_.dispose();
        }
    }

    @Override
    public void setFocusToWidget() {
        ArrayList widgets = this.getUIWidgets();
        if (widgets == null) {
            return;
        }
        int i = 0;
        while (i < widgets.size()) {
            PropertyUIWidget widget = (PropertyUIWidget)widgets.get(i);
            if (widget.setFocus()) break;
            ++i;
        }
    }

    public ArrayList getUIWidgets() {
        if (this.uiComposite_ != null) {
            return this.uiComposite_.getUIWidgets();
        }
        return null;
    }
}

